/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.xml.BufferedStringValue;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.TargetImportHandler;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SysViewImportHandler
extends TargetImportHandler {
    private final Stack stack = new Stack();
    private QName currentPropName;
    private int currentPropType = 0;
    private ArrayList currentPropValues = new ArrayList();
    private BufferedStringValue currentPropValue;

    SysViewImportHandler(Importer importer) {
        super(importer);
    }

    private void processNode(ImportState state, boolean start, boolean end) throws SAXException {
        if (!start && !end) {
            return;
        }
        QName[] mixinNames = null;
        if (state.mixinNames != null) {
            mixinNames = state.mixinNames.toArray(new QName[state.mixinNames.size()]);
        }
        NodeId id = null;
        if (state.uuid != null) {
            id = NodeId.valueOf(state.uuid);
        }
        NodeInfo node = new NodeInfo(state.nodeName, state.nodeTypeName, mixinNames, id);
        try {
            if (start) {
                this.importer.startNode(node, state.props);
                Iterator iter = state.props.iterator();
                while (iter.hasNext()) {
                    PropInfo pi = (PropInfo)iter.next();
                    pi.dispose();
                }
            }
            if (end) {
                this.importer.endNode(node);
            }
        }
        catch (RepositoryException re) {
            throw new SAXException((Exception)((Object)re));
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://www.jcp.org/jcr/sv/1.0".equals(namespaceURI)) {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid namespace for element in system view xml document: " + namespaceURI));
        }
        if ("node".equals(localName)) {
            String name = atts.getValue("sv:name");
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:node"));
            }
            if (!this.stack.isEmpty()) {
                ImportState current = (ImportState)this.stack.peek();
                if (!current.started) {
                    this.processNode(current, true, false);
                    current.started = true;
                }
            }
            ImportState state = new ImportState();
            try {
                state.nodeName = NameFormat.parse((String)name, (NamespaceResolver)this.nsContext);
            }
            catch (IllegalNameException ine) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)ine));
            }
            catch (UnknownPrefixException upe) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal node name: " + name, (Throwable)upe));
            }
            this.stack.push(state);
        } else if ("property".equals(localName)) {
            this.currentPropValues.clear();
            String name = atts.getValue("sv:name");
            if (name == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:name attribute of element sv:property"));
            }
            try {
                this.currentPropName = NameFormat.parse((String)name, (NamespaceResolver)this.nsContext);
            }
            catch (IllegalNameException ine) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)ine));
            }
            catch (UnknownPrefixException upe) {
                throw new SAXException((Exception)new InvalidSerializedDataException("illegal property name: " + name, (Throwable)upe));
            }
            String type = atts.getValue("sv:type");
            if (type == null) {
                throw new SAXException((Exception)new InvalidSerializedDataException("missing mandatory sv:type attribute of element sv:property"));
            }
            this.currentPropType = PropertyType.valueFromName((String)type);
        } else if ("value".equals(localName)) {
            this.currentPropValue = new BufferedStringValue(this.nsContext);
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("unexpected element found in system view xml document: " + localName));
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currentPropValue != null) {
            try {
                this.currentPropValue.append(ch, start, length);
            }
            catch (IOException ioe) {
                throw new SAXException("error while processing property value", ioe);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        ImportState state = (ImportState)this.stack.peek();
        if ("node".equals(localName)) {
            if (!state.started) {
                this.processNode(state, true, true);
                state.started = true;
            } else {
                this.processNode(state, false, true);
            }
            this.stack.pop();
        } else if ("property".equals(localName)) {
            if (this.currentPropName.equals((Object)QName.JCR_PRIMARYTYPE)) {
                BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(0);
                String s = null;
                try {
                    s = val.retrieve();
                    state.nodeTypeName = NameFormat.parse((String)s, (NamespaceResolver)this.nsContext);
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
                catch (IllegalNameException ine) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)ine));
                }
                catch (UnknownPrefixException upe) {
                    throw new SAXException((Exception)new InvalidSerializedDataException("illegal node type name: " + s, (Throwable)upe));
                }
            } else if (this.currentPropName.equals((Object)QName.JCR_MIXINTYPES)) {
                if (state.mixinNames == null) {
                    state.mixinNames = new ArrayList(this.currentPropValues.size());
                }
                for (int i = 0; i < this.currentPropValues.size(); ++i) {
                    BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(i);
                    String s = null;
                    try {
                        s = val.retrieve();
                        QName mixin = NameFormat.parse((String)s, (NamespaceResolver)this.nsContext);
                        state.mixinNames.add(mixin);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new SAXException("error while retrieving value", ioe);
                    }
                    catch (IllegalNameException ine) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)ine));
                    }
                    catch (UnknownPrefixException upe) {
                        throw new SAXException((Exception)new InvalidSerializedDataException("illegal mixin type name: " + s, (Throwable)upe));
                    }
                }
            } else if (this.currentPropName.equals((Object)QName.JCR_UUID)) {
                BufferedStringValue val = (BufferedStringValue)this.currentPropValues.get(0);
                try {
                    state.uuid = val.retrieve();
                }
                catch (IOException ioe) {
                    throw new SAXException("error while retrieving value", ioe);
                }
            } else {
                PropInfo prop = new PropInfo(this.currentPropName, this.currentPropType, this.currentPropValues.toArray(new TextValue[this.currentPropValues.size()]));
                state.props.add(prop);
            }
            this.currentPropValues.clear();
        } else if ("value".equals(localName)) {
            this.currentPropValues.add(this.currentPropValue);
            this.currentPropValue = null;
        } else {
            throw new SAXException((Exception)new InvalidSerializedDataException("invalid element in system view xml document: " + localName));
        }
    }

    class ImportState {
        QName nodeName;
        QName nodeTypeName;
        ArrayList mixinNames;
        String uuid;
        ArrayList props = new ArrayList();
        boolean started = false;

        ImportState() {
        }
    }
}

