/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mc.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSResource
extends BaseResource {
    private URL url;
    private VirtualFile file;
    private long lastRead = -1L;

    public VFSResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.url = url;
    }

    public VFSResource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    protected VirtualFile getFile() {
        if (this.file == null) {
            try {
                this.file = VFS.getCachedFile((URL)this.url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.file;
    }

    public URL getURL() throws IOException {
        try {
            return this.url != null ? this.url : this.getFile().toURL();
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public boolean hasURL() {
        return true;
    }

    public boolean isDirectory() {
        try {
            return !this.getFile().isLeaf();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<Resource> listResources() {
        try {
            List children = this.getFile().getChildren();
            if (children == null || children.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Resource> resources = new ArrayList<Resource>(children.size());
            for (VirtualFile child : children) {
                resources.add((Resource)new VFSResource(child));
            }
            return resources;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastModified() {
        try {
            return this.getFile().getLastModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public InputStream getInputStream() throws IOException {
        this.lastRead = System.currentTimeMillis();
        return this.getFile().openStream();
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    public int hashCode() {
        return this.toURL().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VFSResource)) {
            return false;
        }
        VFSResource other = (VFSResource)((Object)VFSResource.class.cast(obj));
        return this.toURL().equals(other.toURL());
    }

    public String toString() {
        return "[VFSResource = " + this.toURL() + "]";
    }

    protected URL toURL() {
        try {
            return this.getURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

