/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mc.io;

import java.net.MalformedURLException;
import java.net.URL;
import org.drools.io.Resource;
import org.drools.io.impl.ResourceProviderImpl;
import org.drools.mc.io.VFSResource;
import org.drools.util.StringUtils;

public class VFSResourceProvider
extends ResourceProviderImpl {
    private static URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(StringUtils.cleanPath((String)originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    public Resource newUrlResource(URL url) {
        return new VFSResource(url);
    }

    public Resource newUrlResource(String path) {
        try {
            URL url = VFSResourceProvider.getCleanedUrl(new URL(path), path);
            return new VFSResource(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

