/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.login.FSPostLoginException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.liberty.LibertyManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FSPostLogin {
    private String federationPage = null;
    private String consentPage = null;
    private String errorPage = null;
    private static IDFFMetaManager metaManager = null;
    private boolean isIDP = false;
    private String providerRole = null;
    private String entityID = null;
    private String realm = null;

    public void doPostLogin(HttpServletRequest request, HttpServletResponse response) {
        String returnURL;
        String metaAlias;
        block23: {
            metaAlias = request.getParameter("metaAlias");
            String sso = request.getParameter("sso");
            String lrURL = request.getParameter("RelayState");
            String showFederatePage = request.getParameter("federate");
            returnURL = null;
            if (metaAlias == null) {
                metaAlias = FSServiceUtils.getMetaAlias(request);
                String rqst = request.getRequestURL().toString() + '?' + request.getQueryString();
                lrURL = FSPostLogin.getValueFromURL(rqst, "RelayState");
                sso = FSPostLogin.getValueFromURL(rqst, "sso");
                FSSessionManager sessMgr = FSSessionManager.getInstance(metaAlias);
                String relayStateURL = sessMgr.getRelayState(lrURL);
                if (relayStateURL != null) {
                    sessMgr.removeRelayState(lrURL);
                    lrURL = relayStateURL;
                }
            }
            try {
                this.setMetaInfo(metaAlias, request);
            }
            catch (FSPostLoginException fsexp) {
                this.sendResponse(request, response, this.errorPage);
            }
            if (lrURL == null || lrURL.length() <= 0) {
                lrURL = LibertyManager.getHomeURL(this.realm, this.entityID, this.providerRole);
            }
            if (sso != null && sso.length() > 0 && sso.equalsIgnoreCase("true") || this.isIDP) {
                try {
                    Set cotSet = LibertyManager.getListOfCOTs(this.realm, this.entityID, this.providerRole);
                    if (cotSet != null && !cotSet.isEmpty()) {
                        if (cotSet.size() <= 1) {
                            String cotSelected = (String)cotSet.iterator().next();
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSPostLogin::doPostLogin single cot present is " + cotSelected);
                            }
                            returnURL = this.doConsentToIntro(metaAlias, lrURL, cotSelected);
                        } else {
                            returnURL = this.consentPage + '?' + "metaAlias" + '=' + metaAlias + '&' + "RelayState" + '=' + URLEncDec.encode((String)lrURL);
                        }
                        break block23;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: No COTS configured. redirecting to lrurl " + lrURL);
                    }
                    returnURL = lrURL;
                }
                catch (FSPostLoginException fsexp) {
                    this.sendResponse(request, response, this.errorPage);
                }
            } else if (showFederatePage != null && !showFederatePage.equalsIgnoreCase("false")) {
                String providerID = LibertyManager.getEntityID(metaAlias);
                String univId = LibertyManager.getUser(request);
                if (univId == null) {
                    String gotoUrl = request.getRequestURL() + '?' + '&' + request.getQueryString();
                    String preLoginURL = LibertyManager.getLoginURL(request);
                    this.sendResponse(request, response, preLoginURL + "&goto=" + URLEncDec.encode((String)gotoUrl));
                    return;
                }
                Set providerSet = LibertyManager.getProvidersToFederate(this.realm, providerID, this.providerRole, univId);
                if (providerSet != null && providerSet.size() != 0 && this.federationPage != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: Found provider(s) to federated with " + providerSet);
                    }
                    returnURL = this.federationPage + '?' + "metaAlias" + '=' + metaAlias + '&' + "RelayState" + '=' + URLEncDec.encode((String)lrURL);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: No provider(s) to federated with or federationPage null. Redirecting to LRURL " + lrURL);
                    }
                    returnURL = lrURL;
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPostLogin::doPostLogin. No cotkey or Federatekey found");
                }
                returnURL = lrURL;
            }
        }
        this.setTokenListenerAndSessionInfo(request, metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPostLogin::doPostLogin return url " + returnURL);
        }
        this.sendResponse(request, response, returnURL);
    }

    private void setTokenListenerAndSessionInfo(HttpServletRequest request, String metaAlias) {
        Object ssoToken = null;
        String sessionID = null;
        String userID = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            ssoToken = sessionProvider.getSession(request);
            sessionID = sessionProvider.getSessionID(ssoToken);
            userID = sessionProvider.getPrincipalName(ssoToken);
            sessionProvider.addListener(ssoToken, new FSTokenListener(metaAlias));
        }
        catch (SessionException ssoExp) {
            FSUtils.debug.error("FSPostLogin::setTokenListenerAndSessionInfo Failed during trying to add token Listener:", (Throwable)((Object)ssoExp));
            return;
        }
        FSSessionManager sessionManager = FSSessionManager.getInstance(metaAlias);
        FSSession session = sessionManager.getSession(userID, sessionID);
        if (session == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPostLogin::setTokenListenerAndSessionInfo. No existing session found for user " + userID + " And SessionID: " + sessionID + " Creating a new Session");
            }
            FSSession newSession = new FSSession(sessionID);
            sessionManager.addSession(userID, newSession);
        }
    }

    private void sendResponse(HttpServletRequest request, HttpServletResponse response, String returnURL) {
        try {
            FSUtils.forwardRequest(request, response, returnURL);
        }
        catch (Exception exp) {
            FSUtils.debug.error("FSPreLogin:: sendError Error during sending error page");
        }
    }

    public String doConsentToIntro(HttpServletRequest request) throws FSPostLoginException {
        String metaAlias = request.getParameter("metaAlias");
        String targetURL = request.getParameter("RelayState");
        String cotSelected = request.getParameter("cotkey");
        return this.doConsentToIntro(metaAlias, targetURL, cotSelected);
    }

    private void setMetaInfo(String metaAlias, HttpServletRequest request) throws FSPostLoginException {
        BaseConfigType hostedConfig;
        if (metaManager != null) {
            hostedConfig = null;
            try {
                String hostedProviderRole = metaManager.getProviderRoleByMetaAlias(metaAlias);
                String hostedEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
                this.realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
                if (hostedProviderRole != null && hostedProviderRole.equals("IDP")) {
                    this.isIDP = true;
                    hostedConfig = metaManager.getIDPDescriptorConfig(this.realm, hostedEntityId);
                } else if (hostedProviderRole != null && hostedProviderRole.equalsIgnoreCase("SP")) {
                    hostedConfig = metaManager.getSPDescriptorConfig(this.realm, hostedEntityId);
                }
            }
            catch (IDFFMetaException ie) {
                FSUtils.debug.error("FSPostLogin::setMetaInfo: exception:", (Throwable)((Object)ie));
            }
        } else {
            FSUtils.debug.error("FSPostLogin::setMetaInfo could not get alliane manager handle Cannot proceed so throwing error page");
            throw new FSPostLoginException("FSPostLogin:: could not get meta manager handle.");
        }
        this.consentPage = FSServiceUtils.getConsentPageURL(request, hostedConfig);
        this.federationPage = FSServiceUtils.getDoFederatePageURL(request, hostedConfig);
        this.errorPage = FSServiceUtils.getErrorPageURL(request, hostedConfig, metaAlias);
    }

    private String doConsentToIntro(String metaAlias, String targetURL, String cotSelected) throws FSPostLoginException {
        String entityID = null;
        String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
        String tldURL = null;
        try {
            CircleOfTrustManager cotManager;
            CircleOfTrustDescriptor cotDesc;
            if (metaManager != null) {
                entityID = metaManager.getEntityIDByMetaAlias(metaAlias);
            }
            if ((cotDesc = (cotManager = new CircleOfTrustManager()).getCircleOfTrust(realm, cotSelected)) != null && cotDesc.getCircleOfTrustStatus().equalsIgnoreCase("active")) {
                tldURL = cotDesc.getIDFFWriterServiceURL();
            }
        }
        catch (IDFFMetaException metaExp) {
            FSUtils.debug.error("FSPostLogin::doConsentToIntro in cot managment expextion:", (Throwable)((Object)metaExp));
            tldURL = null;
        }
        catch (COTException meta2Exp) {
            FSUtils.debug.error("FSPostLogin::doConsentToIntro in cot managment expextion:", (Throwable)((Object)meta2Exp));
            tldURL = null;
        }
        String redirectURL = targetURL;
        if (tldURL != null && entityID != null) {
            redirectURL = tldURL + '?' + "RelayState" + '=' + URLEncDec.encode((String)targetURL) + '&' + "_liberty_idp" + '=' + URLEncDec.encode((String)entityID);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPostLogin::doConsentToIntro return url" + redirectURL);
        }
        return redirectURL;
    }

    public String doFederation(HttpServletRequest request, HttpServletResponse response) throws FSPostLoginException {
        String metaAlias = request.getParameter("metaAlias");
        String LRURL = request.getParameter("RelayState");
        String selectedProvider = request.getParameter("selectedprovider");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPostLogin::doFederation metaAlias " + metaAlias);
            FSUtils.debug.message("FSPostLogin::doFederation lrurl " + LRURL);
            FSUtils.debug.message("FSPostLogin::doFederation selected provider" + selectedProvider);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String hn = headerNames.nextElement().toString();
            String hv = request.getHeader(hn);
            headerMap.put(hn, hv);
        }
        FSLoginHelper plh = new FSLoginHelper(request);
        Map retMap = new HashMap();
        String authLevel = null;
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            authLevel = (String)httpSession.getAttribute("authlevel");
        }
        try {
            retMap = plh.createAuthnRequest(headerMap, LRURL, authLevel, metaAlias, selectedProvider, true);
        }
        catch (FSLoginHelperException fsLoginExp) {
            FSUtils.debug.error("FSPostLogin::doFederate in exception ", (Throwable)((Object)fsLoginExp));
            throw new FSPostLoginException("FSPostLogin::doFederate exception " + fsLoginExp.getMessage());
        }
        Map retHeaderMap = (Map)retMap.get("headerKey");
        Iterator hdrNames = retHeaderMap.keySet().iterator();
        while (hdrNames.hasNext()) {
            String name = hdrNames.next().toString();
            String value = (String)retHeaderMap.get(name);
            response.addHeader(name, value);
        }
        String urlKey = (String)retMap.get("urlKey");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSPostLogin::doFederation returning with " + urlKey);
        }
        return urlKey;
    }

    private static String getValueFromURL(String reqURLStr, String name) {
        String returnStr = null;
        int iIndex = 0;
        if (reqURLStr != null && (iIndex = reqURLStr.lastIndexOf(name)) != -1) {
            int endOfString;
            iIndex = iIndex + name.length() + 1;
            String newStr = reqURLStr.substring(iIndex);
            byte[] strInBytes = newStr.getBytes();
            int len = newStr.length();
            for (endOfString = 0; endOfString < len && strInBytes[endOfString] != 47 && strInBytes[endOfString] != 63; ++endOfString) {
            }
            returnStr = newStr.substring(0, endOfString);
        }
        return returnStr;
    }

    static {
        metaManager = FSUtils.getIDFFMetaManager();
    }
}

