/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSRemoteException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAssertionManagerIF;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.shared.encode.Base64;
import java.util.List;

public class FSAssertionManagerImpl
implements FSAssertionManagerIF {
    protected static boolean isLocal;

    public void checkForLocal() {
        isLocal = true;
    }

    public String getAssertion(String metaAlias, String artifact, String destID) throws FSRemoteException {
        try {
            FSAssertionManager assertionManager = FSAssertionManager.getInstance(metaAlias);
            FSAssertion a = (FSAssertion)assertionManager.getAssertion(new FSAssertionArtifact(artifact), SAMLUtils.byteArrayToString(Base64.decode((String)destID)));
            if (a == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManagerImpl: Unable to get assertion from Artifact: " + artifact);
                }
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManagerImpl: Assertion got from assertionManager.getAssertion: " + a.toXMLString(true, true));
            }
            return a.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new FSRemoteException(e.getMessage());
        }
    }

    public String getDestIdForArtifact(String metaAlias, String artifact) throws FSRemoteException {
        try {
            FSAssertionManager assertionManager = FSAssertionManager.getInstance(metaAlias);
            String destID = assertionManager.getDestIdForArtifact(new FSAssertionArtifact(artifact));
            if (destID == null && FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManagerImpl: Unable to get destination ID from remote : ");
            }
            return destID;
        }
        catch (Exception e) {
            throw new FSRemoteException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserExists(String userDN, String metaAlias) throws FSRemoteException {
        try {
            FSSessionManager sessionMgr;
            FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(metaAlias);
            synchronized (fSSessionManager) {
                FSUtils.debug.message("About to call getSessionList");
                List sessionList = sessionMgr.getSessionList(userDN);
                if (sessionList == null) {
                    FSUtils.debug.message("AMC:isUserExists:List is empty");
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:isUserExists: List is not empty User found: " + userDN);
                }
                return true;
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AMC.isUserExists:", (Throwable)e);
            }
            throw new FSRemoteException(e.getMessage());
        }
    }

    public String getErrorStatus(String metaAlias, String artifact) throws FSRemoteException {
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManagerImpl.getErrStatus(" + metaAlias + ", " + artifact);
            }
            FSAssertionArtifact aa = new FSAssertionArtifact(artifact);
            Status s = FSAssertionManager.getInstance(metaAlias).getErrorStatus(aa);
            if (null != s) {
                return s.toString(true, true);
            }
        }
        catch (FSMsgException e) {
            FSUtils.debug.error("getErrStatus: FSMsgException:" + e.getMessage());
            throw new FSRemoteException(e.getMessage());
        }
        catch (FSException e) {
            FSUtils.debug.error("getErrStatus: FSException:" + e.getMessage());
            throw new FSRemoteException(e.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("getErrStatus: returning null");
        }
        return null;
    }
}

