/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.common.SystemConfigurationException;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.key.KeyUtil;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSSOAPReceiver
extends HttpServlet {
    private static MessageFactory msgFactory = null;
    private static FSSOAPService soapService;
    private static final String MESSAGE = "message";
    private static final String USERID = "userID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        soapService = FSSOAPService.getInstance();
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException ex) {
            FSUtils.debug.error("FSSOAPReceiver:Unable to get message factory", (Throwable)ex);
            throw new ServletException(ex.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FSUtils.debug.message("FSSOAPReceiver.doPost: Called");
        FSUtils.checkHTTPRequestLength(request);
        try {
            MimeHeaders mimeHeaders = SAMLUtils.getMimeHeaders(request);
            ServletInputStream sInputStream = request.getInputStream();
            SOAPMessage soapMessage = msgFactory.createMessage(mimeHeaders, (InputStream)sInputStream);
            this.onMessage(request, response, soapMessage);
            return;
        }
        catch (SOAPException se) {
            throw new ServletException((Throwable)se);
        }
    }

    /*
     * Exception decompiling
     */
    public void onMessage(HttpServletRequest request, HttpServletResponse response, SOAPMessage message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ProviderDescriptorType getRemoteProviderDescriptor(String hostedProviderRole, String remoteEntityId, String realm) {
        try {
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager == null) {
                FSUtils.debug.message("Unable to get meta manager");
                return null;
            }
            ProviderDescriptorType remoteDesc = null;
            remoteDesc = hostedProviderRole.equalsIgnoreCase("SP") ? metaManager.getIDPDescriptor(realm, remoteEntityId) : metaManager.getSPDescriptor(realm, remoteEntityId);
            return remoteDesc;
        }
        catch (IDFFMetaException eam) {
            FSUtils.debug.error("Unable to find Hosted Provider.Cannot process request:", (Throwable)((Object)eam));
            return null;
        }
    }

    private FSNameRegistrationResponse handleRegistrationRequest(Element elt, SOAPMessage msg, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String hostedRole, String realm, String hostedEntityId, String providerAlias, HttpServletRequest request, HttpServletResponse response) {
        try {
            ProviderDescriptorType remoteDesc;
            FSNameRegistrationRequest regisRequest = new FSNameRegistrationRequest(elt);
            String remoteEntityId = regisRequest.getProviderId();
            boolean isIDP = false;
            if (hostedRole.equalsIgnoreCase("SP")) {
                isIDP = true;
            }
            if ((remoteDesc = this.getRemoteProviderDescriptor(hostedRole, remoteEntityId, realm)) == null) {
                return null;
            }
            X509Certificate cert = KeyUtil.getVerificationCert(remoteDesc, remoteEntityId, isIDP);
            if (!FSServiceUtils.isSigningOn() || this.verifyRequestSignature(elt, msg, cert)) {
                FSUtils.debug.message("Registration Signature successfully passed");
                IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
                if (metaManager.isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                    FSServiceManager instService = FSServiceManager.getInstance();
                    if (instService != null) {
                        FSNameRegistrationHandler regisHandler = new FSNameRegistrationHandler();
                        regisHandler.setHostedDescriptor(hostedProviderDesc);
                        regisHandler.setHostedDescriptorConfig(hostedConfig);
                        regisHandler.setHostedEntityId(hostedEntityId);
                        regisHandler.setHostedProviderRole(hostedRole);
                        regisHandler.setMetaAlias(providerAlias);
                        regisHandler.setRealm(realm);
                        regisHandler.setRemoteDescriptor(remoteDesc);
                        regisHandler.setRemoteEntityId(remoteEntityId);
                        FSNameRegistrationResponse regisResponse = regisHandler.processSOAPRegistrationRequest(request, response, regisRequest);
                        return regisResponse;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process registration request");
                    }
                    return null;
                }
                FSUtils.debug.error("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Registration Signature failed verification");
            return null;
        }
        catch (Exception se) {
            FSUtils.debug.error("FSNameRegistrationHandler.doPost.doGet:Exception occured ", (Throwable)se);
            return null;
        }
    }

    private boolean handleTerminationRequest(Element elt, SOAPMessage terminationMsg, HttpServletRequest request, HttpServletResponse response) {
        try {
            String providerAlias = FSServiceUtils.getMetaAlias(request);
            if (providerAlias == null || providerAlias.length() < 1) {
                FSUtils.debug.error("Unable to retrieve alias, Hosted Provider.Cannot process  the termination request");
                return false;
            }
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            if (metaManager == null) {
                FSUtils.debug.error("Unable to get meta manager");
                return false;
            }
            String realm = IDFFMetaUtils.getRealmByMetaAlias(providerAlias);
            FSFederationTerminationNotification terminationRequest = new FSFederationTerminationNotification(elt);
            ProviderDescriptorType hostedProviderDesc = null;
            String remoteEntityId = terminationRequest.getProviderId();
            ProviderDescriptorType remoteDesc = null;
            String hostedRole = null;
            String hostedEntityId = null;
            BaseConfigType hostedConfig = null;
            try {
                hostedRole = metaManager.getProviderRoleByMetaAlias(providerAlias);
                hostedEntityId = metaManager.getEntityIDByMetaAlias(providerAlias);
                if (hostedRole == null) {
                    return false;
                }
                if (hostedRole.equalsIgnoreCase("IDP")) {
                    hostedProviderDesc = metaManager.getIDPDescriptor(realm, hostedEntityId);
                    hostedConfig = metaManager.getIDPDescriptorConfig(realm, hostedEntityId);
                    remoteDesc = metaManager.getSPDescriptor(realm, remoteEntityId);
                } else if (hostedRole.equalsIgnoreCase("SP")) {
                    hostedProviderDesc = metaManager.getSPDescriptor(realm, hostedEntityId);
                    hostedConfig = metaManager.getSPDescriptorConfig(realm, hostedEntityId);
                    remoteDesc = metaManager.getIDPDescriptor(realm, remoteEntityId);
                }
                if (hostedProviderDesc == null) {
                    return false;
                }
                if (remoteDesc == null) {
                    return false;
                }
            }
            catch (IDFFMetaException eam) {
                FSUtils.debug.error("Unable to find Hosted Provider. Cannot process request:", (Throwable)((Object)eam));
                return false;
            }
            X509Certificate cert = KeyUtil.getVerificationCert(remoteDesc, remoteEntityId, true);
            if (!FSServiceUtils.isSigningOn() || this.verifyRequestSignature(elt, terminationMsg, cert)) {
                FSUtils.debug.message("Termination Signature successfully verified");
                if (metaManager.isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                    FSServiceManager instService = FSServiceManager.getInstance();
                    if (instService != null) {
                        FSFedTerminationHandler terminationHandler = instService.getFedTerminationHandler(terminationRequest, hostedConfig, realm, hostedEntityId, hostedRole, providerAlias, remoteEntityId);
                        if (terminationHandler != null) {
                            terminationHandler.setHostedDescriptor(hostedProviderDesc);
                            terminationHandler.setHostedDescriptorConfig(hostedConfig);
                            terminationHandler.setRealm(realm);
                            terminationHandler.setHostedEntityId(hostedEntityId);
                            terminationHandler.setMetaAlias(providerAlias);
                            terminationHandler.setHostedProviderRole(hostedRole);
                            terminationHandler.setRemoteEntityId(remoteEntityId);
                            terminationHandler.setRemoteDescriptor(remoteDesc);
                            boolean bProcessStatus = terminationHandler.processSOAPTerminationRequest(request, response, terminationRequest);
                            return bProcessStatus;
                        }
                        FSUtils.debug.error("Unable to get Termination Handler");
                        return false;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    }
                    return false;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return false;
            }
            FSUtils.debug.message("Termination Signature failed verification");
            return false;
        }
        catch (Exception se) {
            FSUtils.debug.error("FSSOAPService::handleTerminationRequest failed ", (Throwable)se);
            return false;
        }
    }

    private Map handleLogoutRequest(Element elt, FSLogoutNotification logoutRequest, SOAPMessage msgLogout, HttpServletRequest request, HttpServletResponse response, ProviderDescriptorType hostedProviderDesc, BaseConfigType hostedConfig, String providerAlias, String realm, String hostedEntityId, String hostedRole) {
        try {
            String remoteEntityId = logoutRequest.getProviderId();
            ProviderDescriptorType remoteDesc = this.getRemoteProviderDescriptor(hostedRole, remoteEntityId, realm);
            if (remoteDesc == null) {
                return null;
            }
            boolean isIDP = false;
            if (hostedRole.equalsIgnoreCase("SP")) {
                isIDP = true;
            }
            X509Certificate remoteCert = KeyUtil.getVerificationCert(remoteDesc, remoteEntityId, isIDP);
            if (!FSServiceUtils.isSigningOn() || this.verifyRequestSignature(elt, msgLogout, remoteCert)) {
                IDFFMetaManager metaManager;
                FSUtils.debug.message("Logout Signature successfully verified");
                if (providerAlias == null || providerAlias.length() < 1) {
                    FSUtils.debug.message("Unable to retrieve alias, Hosted Provider Cannot process logout request");
                    return null;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: Completed forming request FSLogoutNotification");
                }
                if ((metaManager = FSUtils.getIDFFMetaManager()).isTrustedProvider(realm, hostedEntityId, remoteEntityId)) {
                    FSServiceManager instService;
                    FederationSPAdapter spAdapter;
                    String userID = FSLogoutUtil.getUserFromRequest(logoutRequest, realm, hostedEntityId, hostedRole, hostedConfig, providerAlias);
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest found user Id = " + userID);
                    }
                    if (hostedRole != null && hostedRole.equalsIgnoreCase("SP") && (spAdapter = FSServiceUtils.getSPAdapter(hostedEntityId, hostedConfig)) != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver, call preSingleLogoutProcess, IDP/SOAP");
                        }
                        try {
                            spAdapter.preSingleLogoutProcess(hostedEntityId, request, response, userID, logoutRequest, null, "http://projectliberty.org/profiles/slo-idp-soap");
                        }
                        catch (Exception e) {
                            FSUtils.debug.error("preSingleLogoutProcess.IDP/SOAP", (Throwable)e);
                        }
                    }
                    if (!this.isUserExists(userID, providerAlias)) {
                        List platformList;
                        block36: {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: User does not exist locally. Finding remotely");
                            }
                            platformList = null;
                            try {
                                platformList = SystemConfigurationUtil.getServerList();
                            }
                            catch (SystemConfigurationException se) {
                                if (!FSUtils.debug.messageEnabled()) break block36;
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: Couldn't find remote server:", (Throwable)((Object)se));
                            }
                        }
                        if (platformList == null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestplatformList is null");
                            }
                            return null;
                        }
                        Iterator iter = platformList.iterator();
                        while (iter.hasNext()) {
                            FSAssertionManagerClient amc;
                            String remoteServerURL = (String)iter.next();
                            StringBuffer tmpremoteURL = new StringBuffer(remoteServerURL);
                            tmpremoteURL.append(SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor"));
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestremoteServerURL = " + remoteServerURL + " and self serverUrl =" + FSServiceUtils.getBaseURL());
                            }
                            if (FSServiceUtils.getBaseURL().equalsIgnoreCase(remoteServerURL.toString()) || !(amc = new FSAssertionManagerClient(providerAlias, this.getFullServiceURL(remoteServerURL))).isUserExists(userID)) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestuser found here =" + remoteServerURL);
                            }
                            StringBuffer remoteURL = new StringBuffer();
                            remoteURL.append(remoteServerURL.toString()).append(SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor")).append("/SOAPReceiver").append("/").append("metaAlias").append(providerAlias);
                            FSSOAPService instSOAP = FSSOAPService.getInstance();
                            SOAPMessage retSOAPMessage = null;
                            if (instSOAP != null) {
                                try {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Forward logout request to " + remoteURL.toString());
                                    }
                                    if ((retSOAPMessage = instSOAP.sendMessage(msgLogout, remoteURL.toString())) != null) {
                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                        map.put(MESSAGE, retSOAPMessage);
                                        if (userID != null) {
                                            map.put(USERID, userID);
                                        }
                                        return map;
                                    }
                                    return null;
                                }
                                catch (SOAPException e) {
                                    FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request", (Throwable)e);
                                    return null;
                                }
                            }
                            return null;
                        }
                    }
                    if ((instService = FSServiceManager.getInstance()) != null) {
                        FSPreLogoutHandler logoutHandler = instService.getPreLogoutHandler();
                        if (logoutHandler != null) {
                            logoutHandler.setHostedDescriptor(hostedProviderDesc);
                            logoutHandler.setHostedDescriptorConfig(hostedConfig);
                            logoutHandler.setHostedEntityId(hostedEntityId);
                            logoutHandler.setHostedProviderRole(hostedRole);
                            logoutHandler.setMetaAlias(providerAlias);
                            logoutHandler.setRealm(realm);
                            logoutHandler.setRemoteDescriptor(remoteDesc);
                            logoutHandler.setRemoteEntityId(remoteEntityId);
                            logoutHandler.setLogoutRequest(logoutRequest);
                            FSLogoutStatus bProcessStatus = logoutHandler.processSingleLogoutRequest(logoutRequest);
                            if (bProcessStatus.getStatus().equalsIgnoreCase("samlp:Success")) {
                                MessageFactory factory = MessageFactory.newInstance();
                                SOAPMessage successSOAP = factory.createMessage();
                                if (successSOAP != null) {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    map.put(MESSAGE, successSOAP);
                                    if (userID != null) {
                                        map.put(USERID, userID);
                                    }
                                    return map;
                                }
                                return null;
                            }
                            if (bProcessStatus.getStatus().equalsIgnoreCase("lib:Unsupported")) {
                                SOAPMessage retSOAPMessage = soapService.formSOAPError("Server", "cannotProcessRequest", null);
                                if (retSOAPMessage != null) {
                                    HashMap<String, Object> map = new HashMap<String, Object>();
                                    map.put(MESSAGE, retSOAPMessage);
                                    if (userID != null) {
                                        map.put(USERID, userID);
                                    }
                                    return map;
                                }
                                return null;
                            }
                            return null;
                        }
                        FSUtils.debug.error("Unable to get PreLogoutHandler");
                        FSUtils.debug.error("Cannot process request");
                        return null;
                    }
                    FSUtils.debug.message("FSServiceManager instance isnull. Cannot process logout request");
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.error("Logout Signature failed verification");
            return null;
        }
        catch (Exception se) {
            FSUtils.debug.error("FSSOAPService::handleLogoutRequest failed", (Throwable)se);
            return null;
        }
    }

    private void handleLECPRequest(HttpServletRequest request, HttpServletResponse response, FSAuthnRequest authnRequest) {
        FSUtils.debug.message("FSSOAPReceiver.handleLECPRequest: Called");
        try {
            String metaAlias = FSServiceUtils.getMetaAlias(request);
            String realm = IDFFMetaUtils.getRealmByMetaAlias(metaAlias);
            IDFFMetaManager metaManager = FSUtils.getIDFFMetaManager();
            String hostedEntityId = metaManager.getEntityIDByMetaAlias(metaAlias);
            FSSessionManager sessionService = FSSessionManager.getInstance(metaAlias);
            sessionService.setAuthnRequest(authnRequest.getRequestID(), authnRequest);
            FSServiceManager sm = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler handler = sm.getLECPProfileHandler(request, response, authnRequest, realm);
            handler.setMetaAlias(metaAlias);
            handler.setHostedEntityId(hostedEntityId);
            handler.setHostedDescriptor(metaManager.getIDPDescriptor(realm, hostedEntityId));
            handler.setHostedDescriptorConfig(metaManager.getIDPDescriptorConfig(realm, hostedEntityId));
            handler.setRealm(realm);
            handler.processLECPAuthnRequest(authnRequest);
        }
        catch (Exception se) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured ", (Throwable)se);
            return;
        }
    }

    protected boolean verifyRequestSignature(Element elt, SOAPMessage msg, X509Certificate cert) {
        FSUtils.debug.message("FSSOAPReceiver::verifyRequestSignature: Called");
        try {
            if (cert == null) {
                FSUtils.debug.error("FSSOAPReceiver.verifyRequestSignature: couldn't obtain this site's cert.");
                throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSOAPReceiver::verifyRequestSignature: Provider's cert is found. \nxmlString to be verified: " + XMLUtils.print((Node)elt));
            }
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
            return manager.verifyXMLSignature(doc, cert);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSOPAReceiver::verifyRequestSignature  Exception occured while verifying signature:", (Throwable)e);
            return false;
        }
    }

    protected SOAPMessage signResponse(SOAPMessage msg, String idAttrName, String id, BaseConfigType hostedConfig) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSSOAPReceiver::Entered signResponse::");
        String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(hostedConfig, "signingCertAlias");
        if (certAlias == null || certAlias.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSOAPReceiver.signResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("signResponse::Provider's certAlias is found: " + certAlias);
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        Document doc = (Document)FSServiceUtils.createSOAPDOM(msg);
        String xpath = "//*[local-name()='ProviderID']";
        manager.signXML(doc, certAlias, SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.xmlSigAlgorithm"), idAttrName, id, false, xpath);
        return FSServiceUtils.convertDOMToSOAP(doc);
    }

    private void returnSOAPMessage(SOAPMessage msg, HttpServletResponse response) {
        try {
            if (msg != null) {
                SAMLUtils.setMimeHeaders(msg.getMimeHeaders(), response);
                ServletOutputStream servletoutputstream = response.getOutputStream();
                msg.writeTo((OutputStream)servletoutputstream);
                servletoutputstream.flush();
                return;
            }
            response.flushBuffer();
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::", (Throwable)e);
            return;
        }
    }

    private void returnTerminationStatus(HttpServletResponse response) {
        try {
            response.setStatus(204);
            response.flushBuffer();
            return;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSOAPReceiver.returnFedTerminationStatus: Exception::", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserExists(String userDN, String providerAlias) {
        try {
            FSSessionManager sessionMgr;
            FSSessionManager fSSessionManager = sessionMgr = FSSessionManager.getInstance(providerAlias);
            synchronized (fSSessionManager) {
                FSUtils.debug.message("About to call getSessionList");
                List sessionList = sessionMgr.getSessionList(userDN);
                if (sessionList == null) {
                    FSUtils.debug.message("SOAPReceiver:isUserExists:List is empty");
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("SOAPReceiver:isUserExists: List is not empty. User found: " + userDN);
                }
                return true;
            }
        }
        catch (Exception e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("SOAPReceiver.isUserExists:", (Throwable)e);
            }
            return false;
        }
    }

    private String getFullServiceURL(String shortUrl) {
        String result;
        block3: {
            result = null;
            String SERVICE_NAMING = "fsassertionmanager";
            try {
                URL u = new URL(shortUrl);
                URL weburl = SystemConfigurationUtil.getServiceURL(SERVICE_NAMING, u.getProtocol(), u.getHost(), u.getPort(), u.getPath());
                result = weburl.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + result);
                }
            }
            catch (Exception e) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)e);
            }
        }
        return result;
    }
}

