/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.logout;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSLogoutResponse;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.plugins.FederationSPAdapter;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSReturnSessionManager;
import com.sun.identity.federation.services.logout.FSSingleLogoutHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.liberty.ws.meta.jaxb.ProviderDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSPreLogoutHandler {
    protected HttpServletResponse response = null;
    protected HttpServletRequest request = null;
    protected String locale = null;
    protected Object ssoToken = null;
    protected String userID = null;
    protected IDFFMetaManager metaManager = null;
    protected ProviderDescriptorType hostedDescriptor = null;
    protected BaseConfigType hostedConfig = null;
    protected String currentEntityId = "";
    protected boolean isCurrentProviderIDPRole = false;
    protected FSLogoutNotification reqLogout = null;
    protected boolean isWMLAgent = false;
    protected static String LOGOUT_DONE_URL = null;
    protected static String COMMON_ERROR_URL = null;
    protected ProviderDescriptorType remoteDescriptor = null;
    protected String remoteEntityID = "";
    protected String realm = null;
    protected String hostedEntityId = "";
    protected String hostedRole = null;
    protected String metaAlias = null;
    protected String relayState = null;

    public FSPreLogoutHandler() {
        FSUtils.debug.message("FSPreLogoutHandler::FSPreLogoutHandler Constructor");
        this.metaManager = FSUtils.getIDFFMetaManager();
    }

    protected void setLogoutURL() {
        LOGOUT_DONE_URL = FSServiceUtils.getLogoutDonePageURL(this.request, this.hostedConfig, this.metaAlias);
        COMMON_ERROR_URL = FSServiceUtils.getErrorPageURL(this.request, this.hostedConfig, this.metaAlias);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("LOGOUT_DONE_URL : " + LOGOUT_DONE_URL + "\nCOMMON_ERROR_URL : " + COMMON_ERROR_URL);
        }
    }

    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    public void setHostedDescriptor(ProviderDescriptorType hostedProviderDesc) {
        this.hostedDescriptor = hostedProviderDesc;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setHostedEntityId(String hostedEntityId) {
        this.hostedEntityId = hostedEntityId;
    }

    public void setHostedDescriptorConfig(BaseConfigType hostedConfig) {
        this.hostedConfig = hostedConfig;
    }

    public void setMetaAlias(String metaAlias) {
        this.metaAlias = metaAlias;
    }

    public void setHostedProviderRole(String hostedRole) {
        this.hostedRole = hostedRole;
    }

    public void setRemoteEntityId(String remoteEntityId) {
        this.remoteEntityID = remoteEntityId;
    }

    public void setRemoteDescriptor(ProviderDescriptorType remoteDesc) {
        this.remoteDescriptor = remoteDesc;
    }

    public void setLogoutRequest(FSLogoutNotification reqLogout) {
        this.reqLogout = reqLogout;
    }

    public FSLogoutStatus handleSingleLogout(HttpServletRequest request, HttpServletResponse response, Object ssoToken, String sourceCheck) {
        this.request = request;
        this.setLogoutURL();
        FSUtils.debug.message("Entered FSPreLogoutHandler::handleSingleLogout");
        try {
            this.response = response;
            this.ssoToken = ssoToken;
            this.userID = SessionManager.getProvider().getPrincipalName(ssoToken);
            String acceptString = request.getHeader("Accept");
            if (acceptString != null && acceptString.indexOf("text/vnd.wap.wml") != -1) {
                this.isWMLAgent = true;
            }
            FSSessionManager sMgr = FSSessionManager.getInstance(this.metaAlias);
            FSSession session = sMgr.getSession(ssoToken);
            String sessionIndex = null;
            List partners = null;
            if (session != null) {
                sessionIndex = session.getSessionIndex();
                partners = session.getSessionPartners();
            }
            if (FSUtils.debug.messageEnabled() && partners != null && partners.size() != 0) {
                Iterator iter = partners.iterator();
                while (iter.hasNext()) {
                    FSSessionPartner partner = (FSSessionPartner)iter.next();
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("PARTNER:" + partner.getPartner());
                }
            }
            if (FSLogoutUtil.liveConnectionsExist(this.userID, this.metaAlias)) {
                HashMap providerMap = FSLogoutUtil.getCurrentProvider(this.userID, this.metaAlias, ssoToken);
                if (providerMap != null) {
                    FSSessionPartner currentSessionProvider = (FSSessionPartner)providerMap.get("PartnerSession");
                    sessionIndex = (String)providerMap.get("SessionIndex");
                    if (currentSessionProvider != null) {
                        FSUtils.debug.message("creating IDP handler");
                        FSSingleLogoutHandler handlerObj = new FSSingleLogoutHandler();
                        handlerObj.setHostedDescriptor(this.hostedDescriptor);
                        handlerObj.setHostedDescriptorConfig(this.hostedConfig);
                        handlerObj.setRealm(this.realm);
                        handlerObj.setHostedEntityId(this.hostedEntityId);
                        handlerObj.setHostedProviderRole(this.hostedRole);
                        handlerObj.setMetaAlias(this.metaAlias);
                        handlerObj.setRelayState(this.relayState);
                        return handlerObj.handleSingleLogout(response, request, currentSessionProvider, this.userID, sessionIndex, this.isWMLAgent, ssoToken);
                    }
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("No more providers, nothing to broadcast \ndestroy user session call destroyPrincipalSession");
                }
                FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, sessionIndex, request, response);
                FSLogoutUtil.destroyLocalSession(ssoToken, request, response);
                this.returnToPostLogout("samlp:Success");
                return new FSLogoutStatus("samlp:Success");
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("No live connections, destroy user session call destroyPrincipalSession. source=" + sourceCheck);
            }
            FSLogoutResponse logoutResponse = null;
            FederationSPAdapter spAdapter = null;
            if (this.hostedRole != null && this.hostedRole.equalsIgnoreCase("SP") && sourceCheck.equals("remote") && (spAdapter = FSServiceUtils.getSPAdapter(this.hostedEntityId, this.hostedConfig)) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogoutHandler, call preSingleLogoutProcess, SP/HTTP");
                }
                try {
                    logoutResponse = FSLogoutResponse.parseURLEncodedRequest(request);
                    this.relayState = logoutResponse.getRelayState();
                    spAdapter.preSingleLogoutProcess(this.hostedEntityId, request, response, this.userID, null, logoutResponse, "http://projectliberty.org/profiles/slo-sp-http");
                }
                catch (Exception e) {
                    FSUtils.debug.error("preSingleLogoutProcess.SP/HTTP", (Throwable)e);
                }
            }
            FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, sessionIndex, request, response);
            if (SessionManager.getProvider().isValid(ssoToken)) {
                FSLogoutUtil.destroyLocalSession(ssoToken, request, response);
            }
            if (this.hostedRole != null && this.hostedRole.equalsIgnoreCase("SP") && sourceCheck.equals("remote") && spAdapter != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogoutHandler, call postSingleLogoutProcess, SP/HTTP");
                }
                try {
                    spAdapter.postSingleLogoutSuccess(this.hostedEntityId, request, response, this.userID, null, logoutResponse, "http://projectliberty.org/profiles/slo-sp-http");
                }
                catch (Exception e) {
                    FSUtils.debug.error("postSingleLogoutSuccess.SP/HTTP:", (Throwable)e);
                }
            }
            this.returnToPostLogout("samlp:Success");
            return new FSLogoutStatus("samlp:Success");
        }
        catch (SessionException e) {
            FSUtils.debug.error("SessionException in liveConnectionsExist So destroy self and exit");
            FSLogoutUtil.destroyPrincipalSession(this.userID, this.metaAlias, null, request, response);
            this.returnToPostLogout("samlp:Success");
            return new FSLogoutStatus("samlp:Success");
        }
    }

    public FSLogoutStatus processHttpSingleLogoutRequest(HttpServletRequest request, HttpServletResponse response, Object ssoToken) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSPrelogoutHandler::processSingleLogoutRequest HTTP Redirect");
        }
        this.request = request;
        this.locale = FSServiceUtils.getLocale(request);
        this.setLogoutURL();
        this.response = response;
        this.ssoToken = ssoToken;
        FSSessionManager sMgr = FSSessionManager.getInstance(this.metaAlias);
        FSSession session = sMgr.getSession(ssoToken);
        String sessionIndex = session.getSessionIndex();
        try {
            if (session != null && session.getOneTime()) {
                this.userID = SessionManager.getProvider().getPrincipalName(ssoToken);
                FSUtils.debug.message("FSPH:processSingleLogout: Onetime case");
            } else {
                this.userID = FSLogoutUtil.getUserFromRequest(this.reqLogout, this.realm, this.hostedEntityId, this.hostedRole, this.hostedConfig, this.metaAlias);
            }
        }
        catch (SessionException se) {
            FSUtils.debug.error("processSingleLogoutRequest", (Throwable)((Object)se));
            this.userID = null;
        }
        if (this.userID == null) {
            FSUtils.debug.message("FSPrelogoutHandler::User Not found");
            FSLogoutUtil.returnToSource(response, this.remoteDescriptor, "samlp:Responder", COMMON_ERROR_URL, this.reqLogout.getMinorVersion(), this.hostedConfig, this.hostedEntityId, this.userID);
            return new FSLogoutStatus("samlp:Responder");
        }
        String acceptString = request.getHeader("Accept");
        if (acceptString != null && acceptString.indexOf("text/vnd.wap.wml") != -1) {
            this.isWMLAgent = true;
        }
        String relayState = this.reqLogout.getRelayState();
        FSLogoutUtil.cleanSessionMapPartnerList(this.userID, this.remoteEntityID, this.metaAlias, session);
        FSUtils.debug.message("FSPrelogoutHandler::calling getCurrentProvider");
        boolean bHasAnyOtherProvider = false;
        HashMap providerMap = new HashMap();
        FSSessionPartner sessionPartner = null;
        providerMap = FSLogoutUtil.getCurrentProvider(this.userID, this.metaAlias, ssoToken);
        if (providerMap != null) {
            sessionPartner = (FSSessionPartner)providerMap.get("PartnerSession");
            sessionIndex = (String)providerMap.get("SessionIndex");
            if (sessionPartner != null) {
                bHasAnyOtherProvider = true;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("bHasAnyOtherProvider = " + bHasAnyOtherProvider);
                }
                this.currentEntityId = sessionPartner.getPartner();
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("bHasAnyOtherProvider other than source : " + bHasAnyOtherProvider);
        }
        FSUtils.debug.message("FSPreLogout::creating FSSingleLogoutHandler");
        FSSingleLogoutHandler handlerObj = new FSSingleLogoutHandler();
        handlerObj.setHostedDescriptor(this.hostedDescriptor);
        handlerObj.setHostedDescriptorConfig(this.hostedConfig);
        handlerObj.setRealm(this.realm);
        handlerObj.setHostedEntityId(this.hostedEntityId);
        handlerObj.setHostedProviderRole(this.hostedRole);
        handlerObj.setMetaAlias(this.metaAlias);
        handlerObj.setSingleLogoutProtocol("http://projectliberty.org/profiles/slo-sp-http");
        return handlerObj.processHttpSingleLogoutRequest(response, request, this.reqLogout, sessionPartner, this.userID, this.remoteEntityID, sessionIndex, this.isWMLAgent, relayState, this.hostedRole.equals("SP") ? "IDP" : "SP");
    }

    public FSLogoutStatus processSingleLogoutRequest(FSLogoutNotification reqLogout) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSPreLogoutHandler:: processSingleLogoutRequest SOAP Profile");
        }
        this.userID = FSLogoutUtil.getUserFromRequest(reqLogout, this.realm, this.hostedEntityId, this.hostedRole, this.hostedConfig, this.metaAlias);
        if (this.userID == null) {
            FSUtils.debug.error("User does not exist. Invalid request");
            return new FSLogoutStatus("samlp:Requester");
        }
        FSSessionManager sessionManager = FSSessionManager.getInstance(this.metaAlias);
        String sessionIndex = reqLogout.getSessionIndex();
        FSSession session = sessionManager.getSession(sessionManager.getSessionList(this.userID), sessionIndex);
        FSLogoutUtil.cleanSessionMapPartnerList(this.userID, this.remoteEntityID, this.metaAlias, session);
        boolean bHasAnyOtherProvider = false;
        HashMap providerMap = new HashMap();
        FSSessionPartner sessionPartner = null;
        providerMap = FSLogoutUtil.getCurrentProvider(this.userID, this.metaAlias, this.ssoToken);
        if (providerMap != null) {
            sessionPartner = (FSSessionPartner)providerMap.get("PartnerSession");
            sessionIndex = (String)providerMap.get("SessionIndex");
            if (sessionPartner != null) {
                bHasAnyOtherProvider = true;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("bHasAnyOtherProvider = " + bHasAnyOtherProvider);
                }
                this.currentEntityId = sessionPartner.getPartner();
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("bHasAnyOtherProvider other than source : " + bHasAnyOtherProvider);
        }
        FSUtils.debug.message("creating FSSingleLogoutHandler");
        FSSingleLogoutHandler handlerObj = new FSSingleLogoutHandler();
        handlerObj.setHostedDescriptor(this.hostedDescriptor);
        handlerObj.setHostedDescriptorConfig(this.hostedConfig);
        handlerObj.setRealm(this.realm);
        handlerObj.setHostedEntityId(this.hostedEntityId);
        handlerObj.setHostedProviderRole(this.hostedRole);
        handlerObj.setMetaAlias(this.metaAlias);
        handlerObj.setSingleLogoutProtocol("http://projectliberty.org/profiles/slo-sp-soap");
        return handlerObj.processSingleLogoutRequest(reqLogout, sessionPartner, this.userID, this.remoteEntityID, sessionIndex, this.isWMLAgent, this.hostedRole.equals("SP") ? "IDP" : "SP");
    }

    private void returnToPostLogout(String logoutStatus) {
        FSUtils.debug.message("Entered FSPreLogoutHandler::returnToPostLogout");
        boolean error = false;
        boolean logoutSuccess = true;
        if (!logoutStatus.equals("samlp:Success")) {
            logoutSuccess = false;
        }
        boolean multiProtocolInvoked = false;
        boolean toInvokeMultiProtocol = false;
        if (MultiProtocolUtils.isMultipleProtocolSession(this.request, "idff") && this.hostedRole.equalsIgnoreCase("IDP") && !MultiProtocolUtils.isMultiProtocolRelayState(this.relayState)) {
            toInvokeMultiProtocol = true;
        }
        try {
            String returnProviderId = "";
            String relayState = "";
            String gLogoutStatus = "";
            String inResponseTo = "";
            String retURL = null;
            FSLogoutResponse responseLogout = new FSLogoutResponse();
            FSReturnSessionManager mngInst = FSReturnSessionManager.getInstance(this.metaAlias);
            HashMap providerMap = new HashMap();
            if (mngInst != null) {
                providerMap = mngInst.getUserProviderInfo(this.userID);
            }
            if (providerMap == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Return URL based on local postlogout URL\nNo Source in ReturnMAP : rs=" + this.relayState);
                }
                if (toInvokeMultiProtocol) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSPreLogHandler.retToPostLogout: call MP HTTP, status=" + logoutStatus);
                    }
                    multiProtocolInvoked = true;
                    int retStatus = this.handleMultiProtocolLogout(logoutStatus, null);
                    if (retStatus == 3) {
                        return;
                    }
                    if (retStatus == 2 || retStatus == 1) {
                        logoutSuccess = false;
                    }
                }
                if (this.relayState == null || this.relayState.length() == 0) {
                    FSServiceUtils.returnLocallyAfterOperation(this.response, LOGOUT_DONE_URL, logoutSuccess, "logoutSuccess", "logoutFailure");
                } else {
                    FSServiceUtils.returnLocallyAfterOperation(this.response, this.relayState, logoutSuccess, "logoutSuccess", "logoutFailure");
                }
                return;
            }
            returnProviderId = (String)providerMap.get("Provider");
            ProviderDescriptorType descriptor = null;
            descriptor = this.hostedRole.equalsIgnoreCase("IDP") ? this.metaManager.getSPDescriptor(this.realm, returnProviderId) : this.metaManager.getIDPDescriptor(this.realm, returnProviderId);
            retURL = descriptor.getSingleLogoutServiceReturnURL();
            relayState = (String)providerMap.get("RelayState");
            gLogoutStatus = (String)providerMap.get("logoutStatus");
            inResponseTo = (String)providerMap.get("responseTo");
            mngInst.removeUserProviderInfo(this.userID);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Deleted " + this.userID + " from return list");
            }
            responseLogout.setResponseTo(inResponseTo);
            responseLogout.setRelayState(relayState);
            responseLogout.setProviderId(this.hostedEntityId);
            responseLogout.setStatus(gLogoutStatus);
            if (gLogoutStatus != null) {
                responseLogout.setStatus(logoutStatus);
            }
            responseLogout.setID("logout-sig-ID");
            responseLogout.setMinorVersion(FSServiceUtils.getMinorVersion(descriptor.getProtocolSupportEnumeration()));
            if (toInvokeMultiProtocol) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSPreLogHandler.retToPostLogout: call MP HTTP, response=" + responseLogout.toXMLString());
                }
                multiProtocolInvoked = true;
                int retStatus = this.handleMultiProtocolLogout(logoutStatus, responseLogout.toXMLString(true, true));
                if (retStatus == 3) {
                    return;
                }
                if (retStatus == 2 || retStatus == 1) {
                    logoutSuccess = false;
                    responseLogout.setStatus("samlp:Responder");
                }
            }
            String urlEncodedResponse = responseLogout.toURLEncodedQueryString();
            if (FSServiceUtils.isSigningOn()) {
                String certAlias = IDFFMetaUtils.getFirstAttributeValueFromConfig(this.hostedConfig, "signingCertAlias");
                if (certAlias == null || certAlias.length() == 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSBrowserArtifactConsumerHandler:: signSAMLRequest:couldn't obtain this site's cert alias.");
                    }
                    throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
                }
                urlEncodedResponse = FSSignatureUtil.signAndReturnQueryString(urlEncodedResponse, certAlias);
            }
            StringBuffer redirectURL = new StringBuffer();
            redirectURL.append(retURL);
            if (retURL.indexOf(63) == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append(urlEncodedResponse);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response to be sent (3) : " + redirectURL.toString());
            }
            this.response.sendRedirect(redirectURL.toString());
            return;
        }
        catch (IOException e) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect.processing completed:", (Throwable)e);
            error = true;
        }
        catch (IDFFMetaException e) {
            FSUtils.debug.error("Unable to get LRURL. No location to redirect processing completed:", (Throwable)((Object)e));
            error = true;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSPreLogoutHandler::General exception thrown :", (Throwable)e);
            error = true;
        }
        if (error) {
            String[] data = new String[]{FSUtils.bundle.getString("logout-redirect-failed")};
            LogUtil.error(Level.INFO, "LOGOUT_REDIRECT_FAILED", data);
            logoutSuccess = false;
        }
        if (toInvokeMultiProtocol && !multiProtocolInvoked) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSPreLogHandler.retToPostLogout: call MP HTTP, error=" + error);
            }
            multiProtocolInvoked = true;
            int retStatus = this.handleMultiProtocolLogout(logoutStatus, null);
            if (retStatus == 3) {
                return;
            }
            if (retStatus == 2 || retStatus == 1) {
                logoutSuccess = false;
            }
        }
        FSServiceUtils.returnLocallyAfterOperation(this.response, LOGOUT_DONE_URL, logoutSuccess, "logoutSuccess", "logoutFailure");
    }

    private int handleMultiProtocolLogout(String status, String responseXML) {
        int currentStatus = 2;
        if (status != null && status.equals("samlp:Success")) {
            currentStatus = 0;
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(this.ssoToken);
        int retStatus = 0;
        try {
            String finalRelayState;
            String requestXML = this.reqLogout == null ? null : this.reqLogout.toXMLString(true, true);
            boolean isSOAPProfile = true;
            String[] propVals = SessionManager.getProvider().getProperty(this.ssoToken, "isSOAPProfile");
            if (propVals != null && propVals.length != 0 && propVals[0].equals("false")) {
                isSOAPProfile = false;
            }
            if ((finalRelayState = this.relayState) == null || finalRelayState.length() == 0) {
                finalRelayState = LOGOUT_DONE_URL;
            }
            retStatus = SingleLogoutManager.getInstance().doIDPSingleLogout(set, this.userID, this.request, this.response, isSOAPProfile, true, "idff", this.realm, this.hostedEntityId, this.remoteEntityID, finalRelayState, requestXML, responseXML, currentStatus);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSSLOHandler.doIDPProfile: MP/SOAP", (Throwable)e);
            retStatus = 2;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSLOHandler.doIDPSoapProfile: return status = " + retStatus);
        }
        return retStatus;
    }
}

