/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.RequestedService;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Query {
    private String id = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private List requestedService = null;

    public Query(ResourceID resourceID, List RequestedService2) {
        this.resourceID = resourceID;
        this.requestedService = RequestedService2;
    }

    public Query(EncryptedResourceID resourceID, List RequestedService2) {
        this.encryptResID = resourceID;
        this.requestedService = RequestedService2;
    }

    public Query(Element root) throws DiscoveryException {
        String nameSpaceURI;
        if (root == null) {
            DiscoUtils.debug.message("Query(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = root.getLocalName();
        if (nodeName == null || !nodeName.equals("Query") || (nameSpaceURI = root.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Query(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = root.getAttribute("id");
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("Query(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("ResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Query(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                this.resourceID = new ResourceID((Element)child);
                continue;
            }
            if (nodeName.equals("EncryptedResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Query(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                this.encryptResID = new EncryptedResourceID((Element)child);
                continue;
            }
            if (nodeName.equals("RequestedServiceType")) {
                if (this.requestedService == null) {
                    this.requestedService = new ArrayList();
                }
                this.requestedService.add(new RequestedService((Element)child));
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Query(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.resourceID == null && this.encryptResID == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Query(Element): missing ResourceID or EncryptedResourceID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceIDGroup"));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID value) {
        this.encryptResID = value;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public List getRequestedServiceType() {
        return this.requestedService;
    }

    public void setRequestedServiceType(List requestedService) {
        this.requestedService = requestedService;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<Query xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.resourceID != null) {
            sb.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            sb.append(this.encryptResID.toString());
        }
        if (this.requestedService != null && !this.requestedService.isEmpty()) {
            Iterator iter = this.requestedService.iterator();
            while (iter.hasNext()) {
                sb.append(((RequestedService)iter.next()).toString());
            }
        }
        sb.append("</Query>");
        return sb.toString();
    }
}

