/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceOffering {
    private String entryID = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private ServiceInstance serviceInstance = null;
    private List options = null;
    private String abs = null;

    public ResourceOffering(ResourceID resourceID, ServiceInstance serviceInstance) {
        this.resourceID = resourceID;
        this.serviceInstance = serviceInstance;
    }

    public ResourceOffering(EncryptedResourceID resourceID, ServiceInstance serviceInstance) {
        this.encryptResID = resourceID;
        this.serviceInstance = serviceInstance;
    }

    public ResourceOffering(Element elem) throws DiscoveryException {
        if (elem == null) {
            DiscoUtils.debug.message("ResourceOffering(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = null;
        String nameSpaceURI = null;
        nodeName = elem.getLocalName();
        if (nodeName == null || !nodeName.equals("ResourceOffering") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("ResourceOffering(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.entryID = elem.getAttribute("entryID");
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("ResourceOffering(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("ResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                try {
                    this.resourceID = new ResourceID((Element)child);
                }
                catch (DiscoveryException de) {
                    DiscoUtils.debug.error("ResourceOffering(Element):", (Throwable)((Object)de));
                }
                continue;
            }
            if (nodeName.equals("EncryptedResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                this.encryptResID = new EncryptedResourceID((Element)child);
                continue;
            }
            if (nodeName.equals("ServiceInstance")) {
                if (this.serviceInstance != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): Included more than one ServiceInstance.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.serviceInstance = new ServiceInstance((Element)child);
                continue;
            }
            if (nodeName.equals("Options")) {
                if (this.options != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): Included more than one Options.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.options = DiscoUtils.parseOptions((Element)child);
                continue;
            }
            if (nodeName.equals("Abstract")) {
                if (this.abs != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("ResourceOffering(Element): Included more than one Abstract.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.abs = XMLUtils.getElementValue((Element)((Element)child));
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("ResourceOffering(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
    }

    public List getOptions() {
        return this.options;
    }

    public void setOptions(List options) {
        this.options = options;
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID resourceID) {
        this.encryptResID = resourceID;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public String getEntryID() {
        return this.entryID;
    }

    public void setEntryID(String value) {
        this.entryID = value;
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstance;
    }

    public void setServiceInstance(ServiceInstance value) {
        this.serviceInstance = value;
    }

    public String getAbstract() {
        return this.abs;
    }

    public void setAbstract(String value) {
        this.abs = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<ResourceOffering xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.entryID != null && this.entryID.length() != 0) {
            sb.append(" entryID=\"").append(this.entryID).append("\"");
        }
        sb.append(">");
        if (this.resourceID != null) {
            sb.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            sb.append(this.encryptResID.toString());
        }
        if (this.serviceInstance != null) {
            sb.append(this.serviceInstance.toString());
        }
        if (this.options != null) {
            sb.append("<Options>");
            if (!this.options.isEmpty()) {
                Iterator iter = this.options.iterator();
                String option = null;
                while (iter.hasNext()) {
                    option = (String)iter.next();
                    if (option == null || option.length() == 0) continue;
                    sb.append("<Option>").append(option).append("</Option>");
                }
            }
            sb.append("</Options>");
        }
        if (this.abs != null && this.abs.length() != 0) {
            sb.append("<Abstract>").append(this.abs).append("</Abstract>");
        }
        sb.append("</ResourceOffering>");
        return sb.toString();
    }
}

