/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;

public class Default64ResourceIDMapper
implements ResourceIDMapper {
    private static Debug debug = Debug.getInstance((String)"libDisco");

    public String getResourceID(String providerID, String userID) {
        if (userID == null) {
            debug.error("Default64ResourceIDMapper.getResourceID:null userID");
            return null;
        }
        if (providerID == null || providerID.length() == 0) {
            debug.error("Default64ResourceIDMapper.getResourceID:null providerID.");
            return null;
        }
        byte[] byteResult = SAMLUtils.stringToByteArray(userID);
        String result = null;
        try {
            result = Base64.encode((byte[])byteResult).trim();
        }
        catch (Exception e) {
            debug.error("Default64ResourceIDMapper.getResourceID:", (Throwable)e);
            return null;
        }
        String urlEncoded = null;
        urlEncoded = providerID.endsWith("/") ? providerID + URLEncDec.encode((String)result) : providerID + "/" + URLEncDec.encode((String)result);
        return urlEncoded;
    }

    public String getUserID(String providerID, String resourceID) {
        return this.getUserID(providerID, resourceID, null);
    }

    public String getUserID(String providerID, String resourceID, Message message) {
        String result = null;
        if (resourceID == null || resourceID.equals("urn:liberty:isf:implied-resource")) {
            if (debug.messageEnabled()) {
                debug.message("Default64ResourceIDMapper.getUserID: used implied resource.");
            }
            if (message == null) {
                debug.error("Default64ResourceIDMapper.getUserID:null message");
                return null;
            }
            SecurityAssertion assertion = message.getAssertion();
            if (assertion == null) {
                debug.error("Default64ResourceIDMapper.getUserID:null assertion");
                return null;
            }
            Subject subject = assertion.getBearerSubject();
            if (subject == null) {
                debug.error("Default64ResourceIDMapper.getUserID:not Bearer Token");
                return null;
            }
            NameIdentifier ni = subject.getNameIdentifier();
            if (ni == null) {
                debug.error("Default64ResourceIDMapper.getUserID:no NameIdentifier");
                return null;
            }
            return ni.getName();
        }
        if (providerID == null || providerID.length() == 0) {
            debug.error("Default64ResourceIDMapper.getUserID:null providerID.");
            return null;
        }
        if (!resourceID.startsWith(providerID)) {
            debug.error("Default64ResourceIDMapper.getUserID:resourceID not startsWith providerID:" + providerID);
            return null;
        }
        String urlDecoded = null;
        urlDecoded = providerID.endsWith("/") ? URLEncDec.decode((String)resourceID.substring(providerID.length())) : URLEncDec.decode((String)resourceID.substring((providerID + "/").length()));
        try {
            result = SAMLUtils.byteArrayToString(Base64.decode((String)urlDecoded));
        }
        catch (Exception e) {
            debug.error("Default64ResourceIDMapper.getUserID:", (Throwable)e);
            return null;
        }
        return result;
    }
}

