/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;

public class DefaultHexResourceIDMapper
implements ResourceIDMapper {
    private static Debug debug = Debug.getInstance((String)"libDisco");

    public String getResourceID(String providerID, String userID) {
        if (userID == null) {
            debug.error("DefaultHexResourceIDMapper.getResourceID:null userID");
            return null;
        }
        if (providerID == null || providerID.length() == 0) {
            debug.error("DefaultHexResourceIDMapper.getResourceID:null providerID.");
            return null;
        }
        if (providerID.endsWith("/")) {
            return providerID + SAMLUtils.byteArrayToHexString(SAMLUtils.stringToByteArray(userID));
        }
        return providerID + "/" + SAMLUtils.byteArrayToHexString(SAMLUtils.stringToByteArray(userID));
    }

    public String getUserID(String providerID, String resourceID) {
        return this.getUserID(providerID, resourceID, null);
    }

    public String getUserID(String providerID, String resourceID, Message message) {
        if (resourceID == null || resourceID.equals("urn:liberty:isf:implied-resource")) {
            if (debug.messageEnabled()) {
                debug.message("DefaultHexResourceIDMapper.getUserID: used implied resource.");
            }
            if (message == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:null message");
                return null;
            }
            SecurityAssertion assertion = message.getAssertion();
            if (assertion == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:no assertion");
                return null;
            }
            Subject subject = assertion.getBearerSubject();
            if (subject == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:not Bearer Token");
                return null;
            }
            NameIdentifier ni = subject.getNameIdentifier();
            if (ni == null) {
                debug.error("DefaultHexResourceIDMapper.getUserID:no NameIdentifier");
                return null;
            }
            return ni.getName();
        }
        if (providerID == null || providerID.length() == 0) {
            debug.error("DefaultHexResourceIDMapper.getUserID:null providerID");
            return null;
        }
        if (!resourceID.startsWith(providerID)) {
            debug.error("DefaultHexResourceIDMapper.getUserID:resourceID not startsWith providerID:" + providerID);
            return null;
        }
        if (providerID.endsWith("/")) {
            return SAMLUtils.byteArrayToString(SAMLUtils.hexStringToByteArray(resourceID.substring(providerID.length())));
        }
        return SAMLUtils.byteArrayToString(SAMLUtils.hexStringToByteArray(resourceID.substring((providerID + "/").length())));
    }
}

