/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTModify;
import com.sun.identity.liberty.ws.dst.DSTModifyResponse;
import com.sun.identity.liberty.ws.dst.DSTQuery;
import com.sun.identity.liberty.ws.dst.DSTQueryResponse;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.liberty.ws.interaction.InteractionException;
import com.sun.identity.liberty.ws.interaction.InteractionManager;
import com.sun.identity.liberty.ws.interaction.InteractionRedirectException;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerClient;
import com.sun.identity.liberty.ws.soapbinding.Client;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.ServiceInstanceUpdateHeader;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Element;

public class DSTClient {
    private String resourceID = null;
    private EncryptedResourceID encryptedResourceID = null;
    private String soapURI = null;
    private String certAlias = null;
    private SecurityAssertion assertion = null;
    private BinarySecurityToken token = null;
    private boolean isEncryptedResourceID = false;
    private int securityProfile = 0;
    private String soapAction = null;
    private String serviceType = null;
    private HttpServletRequest httpRequest = null;
    private HttpServletResponse httpResponse = null;
    private boolean clientAuthEnabled = false;
    private String providerID = null;
    private ServiceInstanceUpdateHeader serviceInstanceUpdateHeader = null;
    private String wsfVersion = Utils.getDefaultWSFVersion();

    public DSTClient(String soapURI, String providerID) {
        this.soapURI = soapURI;
        this.providerID = providerID;
        this.securityProfile = 0;
    }

    public DSTClient(SecurityAssertion assertion, String soapURI, String providerID) {
        this.assertion = assertion;
        this.soapURI = soapURI;
        this.providerID = providerID;
        this.securityProfile = assertion != null && assertion.isBearer() ? 3 : 2;
    }

    public DSTClient(BinarySecurityToken token, String soapURI, String providerID) {
        this.token = token;
        this.soapURI = soapURI;
        this.securityProfile = 1;
        this.providerID = providerID;
    }

    public DSTClient(String soapURI, String providerID, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.soapURI = soapURI;
        this.securityProfile = 0;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.providerID = providerID;
    }

    public DSTClient(SecurityAssertion assertion, String soapURI, String providerID, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.assertion = assertion;
        this.soapURI = soapURI;
        this.securityProfile = 2;
        this.providerID = providerID;
    }

    public DSTClient(BinarySecurityToken token, String soapURI, String providerID, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.token = token;
        this.soapURI = soapURI;
        this.securityProfile = 1;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.providerID = providerID;
    }

    public DSTClient(ResourceOffering resourceOffering, String providerID, Object credential, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws DSTException {
        if (resourceOffering == null) {
            DSTUtils.debug.error("DSTClient: resource offering is null");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        this.parseResourceOffering(resourceOffering);
        if (this.securityProfile == 1) {
            this.generateBinarySecurityToken(credential);
        }
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.providerID = providerID;
    }

    public DSTClient(ResourceOffering resourceOffering, String providerID, Object credential) throws DSTException {
        if (resourceOffering == null) {
            DSTUtils.debug.error("DSTClient: resource offering is null");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        this.parseResourceOffering(resourceOffering);
        if (this.securityProfile == 1) {
            this.generateBinarySecurityToken(credential);
        }
        this.providerID = providerID;
    }

    private void parseResourceOffering(ResourceOffering offering) throws DSTException {
        this.encryptedResourceID = offering.getEncryptedResourceID();
        if (this.encryptedResourceID != null) {
            this.isEncryptedResourceID = true;
        } else {
            ResourceID resID = offering.getResourceID();
            if (resID == null) {
                DSTUtils.debug.error("DSTClient:parseResourceOffering: No ResourceID");
                throw new DSTException(DSTUtils.bundle.getString("noResourceID"));
            }
            this.resourceID = resID.getResourceID();
        }
        ServiceInstance serviceInstance = offering.getServiceInstance();
        if (serviceInstance == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: No service instance.");
            throw new DSTException(DSTUtils.bundle.getString("noServiceInstance"));
        }
        this.serviceType = serviceInstance.getServiceType();
        if (this.serviceType == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: service type is null.");
            throw new DSTException(DSTUtils.bundle.getString("noServiceType"));
        }
        List descriptions = serviceInstance.getDescription();
        if (descriptions == null || descriptions.isEmpty()) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: descriptions are null.");
            throw new DSTException(DSTUtils.bundle.getString("noDescriptions"));
        }
        Iterator iter = descriptions.iterator();
        while (iter.hasNext()) {
            List secMechIDs;
            Description description = (Description)iter.next();
            this.soapAction = description.getSoapAction();
            this.soapURI = description.getEndpoint();
            if (this.soapURI == null || this.soapURI.length() == 0 || (secMechIDs = description.getSecurityMechID()) == null || secMechIDs.isEmpty()) continue;
            boolean foundProfile = false;
            int size = secMechIDs.size();
            for (int i = 0; i < size; ++i) {
                String secProfile = (String)secMechIDs.get(i);
                if ((secProfile = secProfile.trim()).equals("urn:liberty:security:2003-08:null:null") || secProfile.equals("urn:liberty:security:2003-08:TLS:null") || secProfile.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                    this.securityProfile = 0;
                    if (secProfile.equals("urn:liberty:security:2003-08:ClientTLS:null")) {
                        this.clientAuthEnabled = true;
                    }
                    foundProfile = true;
                    break;
                }
                if (secProfile.equals("urn:liberty:security:2003-08:null:X509") || secProfile.equals("urn:liberty:security:2003-08:TLS:X509") || secProfile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || secProfile.equals("urn:liberty:security:2005-02:null:X509") || secProfile.equals("urn:liberty:security:2005-02:TLS:X509") || secProfile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                    this.securityProfile = 1;
                    if (secProfile.equals("urn:liberty:security:2003-08:null:X509") || secProfile.equals("urn:liberty:security:2003-08:TLS:X509") || secProfile.equals("urn:liberty:security:2003-08:ClientTLS:X509")) {
                        this.wsfVersion = "1.0";
                    }
                    this.securityProfile = 1;
                    if (secProfile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || secProfile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                        this.clientAuthEnabled = true;
                    }
                    foundProfile = true;
                    break;
                }
                if (secProfile.equals("urn:liberty:security:2003-08:null:SAML") || secProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || secProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || secProfile.equals("urn:liberty:security:2005-02:null:SAML") || secProfile.equals("urn:liberty:security:2005-02:TLS:SAML") || secProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                    this.securityProfile = 2;
                    if (secProfile.equals("urn:liberty:security:2003-08:null:SAML") || secProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || secProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML")) {
                        this.wsfVersion = "1.0";
                    }
                    if (secProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || secProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                        this.clientAuthEnabled = true;
                    }
                    foundProfile = true;
                    break;
                }
                if (!secProfile.equals("urn:liberty:security:2004-04:null:Bearer") && !secProfile.equals("urn:liberty:security:2004-04:TLS:Bearer") && !secProfile.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") && !secProfile.equals("urn:liberty:security:2005-02:null:Bearer") && !secProfile.equals("urn:liberty:security:2005-02:TLS:Bearer") && !secProfile.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) continue;
                this.securityProfile = 3;
                if (secProfile.equals("urn:liberty:security:2004-04:null:Bearer") || secProfile.equals("urn:liberty:security:2004-04:TLS:Bearer") || secProfile.equals("urn:liberty:security:2004-04:ClientTLS:Bearer")) {
                    this.wsfVersion = "1.0";
                }
                if (secProfile.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") || secProfile.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) {
                    this.clientAuthEnabled = true;
                }
                foundProfile = true;
                break;
            }
            if (!foundProfile) continue;
            break;
        }
        if (this.soapURI == null) {
            DSTUtils.debug.error("DSTClient:parseResourceOffering: SOAP Endpoint or security profile is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidResourceOffering"));
        }
        if (DSTUtils.debug.messageEnabled()) {
            DSTUtils.debug.message("DSTClient.parseResourceOffering:soapURI = " + this.soapURI + "soapAction = " + this.soapAction + "securityProfile = " + this.securityProfile);
        }
    }

    private void generateBinarySecurityToken(Object credential) throws DSTException {
        try {
            SecurityTokenManagerClient manager = new SecurityTokenManagerClient(credential);
            this.token = manager.getX509CertificateToken();
            this.token.setWSFVersion(this.wsfVersion);
        }
        catch (Exception e) {
            DSTUtils.debug.error("DSTClient:generateBinarySecurityToken:Error in generating binary security token.", (Throwable)e);
            throw new DSTException(e);
        }
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
        this.isEncryptedResourceID = false;
    }

    public void setResourceID(EncryptedResourceID encResourceID) {
        this.encryptedResourceID = encResourceID;
        this.isEncryptedResourceID = true;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public void setClientCert(String certAlias) {
        this.certAlias = certAlias;
    }

    public void setSOAPAction(String action) {
        this.soapAction = action;
    }

    public void setClientAuth(boolean value) {
        this.clientAuthEnabled = value;
    }

    public void setSOAPEndPoint(String endpoint) {
        this.soapURI = endpoint;
    }

    public void setSecurityAssertion(SecurityAssertion secAssertion) {
        this.assertion = secAssertion;
    }

    public void setBinarySecurityToken(BinarySecurityToken binaryToken) {
        this.token = binaryToken;
    }

    public void setSecurityMech(String secMech) {
        if (secMech == null || secMech.endsWith("null")) {
            this.securityProfile = 0;
        } else if (secMech.endsWith("X509")) {
            this.securityProfile = 1;
        } else if (secMech.endsWith("SAML")) {
            this.securityProfile = 2;
        } else if (secMech.endsWith("Bearer")) {
            this.securityProfile = 3;
        }
    }

    public List getData(List items) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:getData:Init");
        if (items == null || items.size() == 0) {
            DSTUtils.debug.error("DSTUtils.getData:Query items are null.");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTQuery dstQuery = null;
        dstQuery = this.isEncryptedResourceID ? new DSTQuery(this.encryptedResourceID, items, null) : new DSTQuery(this.resourceID, items, null);
        ArrayList<Element> query = new ArrayList<Element>();
        query.add(DSTUtils.parseXML(dstQuery.toString(true, true)));
        List response = this.sendMessage(query);
        if (response == null || response.size() == 0) {
            DSTUtils.debug.message("DSTClient:getData: response is null");
            return null;
        }
        DSTQueryResponse queryResponse = new DSTQueryResponse((Element)response.get(0));
        return queryResponse.getData();
    }

    public DSTQueryResponse query(DSTQuery query) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:query:Init");
        if (query == null) {
            DSTUtils.debug.message("DSTClient:query:null value");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        ArrayList<Element> request = new ArrayList<Element>();
        request.add(DSTUtils.parseXML(query.toString(true, true)));
        List response = this.sendMessage(request);
        Element queryResponse = (Element)response.get(0);
        return new DSTQueryResponse(queryResponse);
    }

    public DSTModifyResponse modify(List items) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:modify:init:");
        if (items == null) {
            DSTUtils.debug.message("DSTClient:modify:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTModify modify = null;
        modify = this.isEncryptedResourceID ? new DSTModify(this.encryptedResourceID, items, null) : new DSTModify(this.resourceID, items, null);
        ArrayList<Element> request = new ArrayList<Element>();
        request.add(DSTUtils.parseXML(modify.toString(true, true)));
        List response = this.sendMessage(request);
        if (response == null || response.size() == 0) {
            DSTUtils.debug.message("DSTClient:modify: response is null");
            return null;
        }
        return new DSTModifyResponse((Element)response.get(0));
    }

    public DSTModifyResponse modify(DSTModify modify) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:modify:init");
        if (modify == null) {
            DSTUtils.debug.message("DSTClient:modify:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        ArrayList<Element> request = new ArrayList<Element>();
        request.add(DSTUtils.parseXML(modify.toString(true, true)));
        List response = this.sendMessage(request);
        return new DSTModifyResponse((Element)response.get(0));
    }

    public List getQueryResponse(List queries) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient.getQueryResponse:Init");
        if (queries == null || queries.size() == 0) {
            DSTUtils.debug.error("DSTClient.getQueryResponse:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        Iterator iter = queries.iterator();
        ArrayList<Element> requests = new ArrayList<Element>();
        while (iter.hasNext()) {
            DSTQuery query = (DSTQuery)iter.next();
            requests.add(DSTUtils.parseXML(query.toString(true, true)));
        }
        List responses = this.sendMessage(requests);
        if (responses == null || responses.size() == 0) {
            DSTUtils.debug.error("DSTClient.getQueryResponse:null responses");
            throw new DSTException(DSTUtils.bundle.getString("nullResponse"));
        }
        ArrayList<DSTQueryResponse> queryResponses = new ArrayList<DSTQueryResponse>();
        Iterator iter1 = responses.iterator();
        while (iter1.hasNext()) {
            queryResponses.add(new DSTQueryResponse((Element)iter1.next()));
        }
        return queryResponses;
    }

    public List getModifyResponse(List modifies) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient.getModifyResponse:Init");
        if (modifies == null || modifies.size() == 0) {
            DSTUtils.debug.error("DSTClient.getModifyResponse:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        Iterator iter = modifies.iterator();
        ArrayList<Element> requests = new ArrayList<Element>();
        while (iter.hasNext()) {
            DSTModify modify = (DSTModify)iter.next();
            requests.add(DSTUtils.parseXML(modify.toString(true, true)));
        }
        List responses = this.sendMessage(requests);
        if (responses == null || responses.size() == 0) {
            DSTUtils.debug.error("DSTClient.getModifyResponse:null responses");
            throw new DSTException(DSTUtils.bundle.getString("nullResponse"));
        }
        ArrayList<DSTModifyResponse> modifyResponses = new ArrayList<DSTModifyResponse>();
        Iterator iter1 = responses.iterator();
        while (iter1.hasNext()) {
            modifyResponses.add(new DSTModifyResponse((Element)iter1.next()));
        }
        return modifyResponses;
    }

    private List sendMessage(List requestObjects) throws DSTException, InteractionRedirectException {
        DSTUtils.debug.message("DSTClient:sendMessage:Init");
        if (requestObjects == null || requestObjects.size() == 0) {
            DSTUtils.debug.message("DSTClient:sendMessage: requestobj are null");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        try {
            Message msg = null;
            ProviderHeader provH = null;
            if (this.providerID != null) {
                provH = new ProviderHeader(this.providerID);
            }
            if (this.securityProfile == 1) {
                if (this.token == null) {
                    throw new DSTException(DSTUtils.bundle.getString("nullToken"));
                }
                DSTUtils.debug.message("DSTClient:sendMessage:using x509");
                msg = new Message(provH, this.token);
            } else if (this.securityProfile == 2) {
                DSTUtils.debug.message("DSTClient:sendMessage:using SAML");
                msg = new Message(provH, this.assertion);
            } else if (this.securityProfile == 3) {
                DSTUtils.debug.message("DSTClient:sendMessage:using Bearer");
                msg = new Message(provH, this.assertion);
            } else if (this.securityProfile == 0) {
                DSTUtils.debug.message("DSTClient:sendMessage:using Anonymous");
                msg = new Message(provH);
            } else {
                throw new DSTException(DSTUtils.bundle.getString("invalidSecurityProfile"));
            }
            msg.setSOAPBodies(requestObjects);
            msg.setWSFVersion(this.wsfVersion);
            if (this.clientAuthEnabled) {
                msg.setClientAuthentication(this.clientAuthEnabled);
            }
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("DSTClient:sendMessage: request:" + msg.toString());
            }
            Message response = null;
            response = this.httpRequest != null ? this.handleInteraction(msg) : Client.sendRequest(msg, this.soapURI, this.certAlias, this.soapAction);
            if (DSTUtils.debug.messageEnabled()) {
                DSTUtils.debug.message("DSTClient:sendMessage:response = " + response.toString());
            }
            this.serviceInstanceUpdateHeader = response.getServiceInstanceUpdateHeader();
            return response.getBodies();
        }
        catch (SOAPBindingException sbe) {
            DSTUtils.debug.error("DSTClient:sendMessage:soapbindexception", (Throwable)sbe);
            throw new DSTException(sbe);
        }
        catch (SOAPFaultException sfe) {
            DSTUtils.debug.error("DSTClient:sendMessage:soapfault", (Throwable)sfe);
            this.serviceInstanceUpdateHeader = sfe.getSOAPFaultMessage().getServiceInstanceUpdateHeader();
            throw new DSTException(sfe);
        }
    }

    private Message handleInteraction(Message requestMsg) throws DSTException, SOAPFaultException, SOAPBindingException, InteractionRedirectException {
        if (requestMsg == null || this.httpRequest == null || this.httpResponse == null || this.soapURI == null) {
            DSTUtils.debug.error("DSTClient:handeInteraction:null values");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        DSTUtils.debug.message("DSTClient:handleInteraction:init");
        String resend = this.httpRequest.getParameter("ResendMessage");
        String returnURL = this.httpRequest.getRequestURL().toString();
        try {
            InteractionManager manager = InteractionManager.getInstance();
            Message response = resend == null ? manager.sendRequest(requestMsg, this.soapURI, this.certAlias, this.soapAction, returnURL, this.httpRequest, this.httpResponse) : manager.resendRequest(returnURL, this.httpRequest, this.httpResponse);
            return response;
        }
        catch (InteractionRedirectException ire) {
            DSTUtils.debug.message("DSTClient:handleInteraction: InteractionRedirection happened.");
            throw ire;
        }
        catch (InteractionException ie) {
            DSTUtils.debug.error("DSTClient:handleInteraction: Interaction Error occured.", (Throwable)((Object)ie));
            throw new DSTException((Throwable)((Object)ie));
        }
    }

    public ServiceInstanceUpdateHeader getServiceInstanceUpdateHeader() {
        return this.serviceInstanceUpdateHeader;
    }

    public void setWSFVersion(String wsfVersion) {
        this.wsfVersion = wsfVersion;
    }
}

