/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.idpp.IDPPServiceManager;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.jaxb.AnalyzedNameType;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTDate;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTInteger;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTMonthDay;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTString;
import com.sun.identity.liberty.ws.idpp.jaxb.DSTURI;
import com.sun.identity.liberty.ws.idpp.plugin.AttributeMapper;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPContainer;
import com.sun.identity.liberty.ws.idpp.plugin.IDPPExtension;
import com.sun.identity.shared.datastruct.CollectionHelper;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class IDPPBaseContainer
implements IDPPContainer {
    protected String userDN = null;

    public abstract Object getContainerObject(Map var1) throws IDPPException;

    public abstract Set getContainerAttributes();

    public abstract Set getContainerAttributesForSelect(String var1);

    public abstract Map getDataMapForSelect(String var1, List var2) throws IDPPException;

    protected Map getAttributeMap(String attr, Object obj, Map map) {
        if (attr == null || map == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeMap:nullval");
            return map;
        }
        String attrKey = this.getAttributeMapper().getDSAttribute(attr);
        if (attrKey == null) {
            if (IDPPUtils.debug.messageEnabled()) {
                IDPPUtils.debug.message("IDPPBaseContainer:getAttributeMap: There's no DS Attribute mapping for this attr:" + attr);
            }
            return map;
        }
        HashSet<String> set = new HashSet<String>();
        if (obj != null) {
            if (obj instanceof List) {
                HashSet<String> values = new HashSet<String>();
                List list = (List)obj;
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String val;
                    Object ob = iter.next();
                    if (ob instanceof DSTString) {
                        DSTString str = (DSTString)ob;
                        val = str.getValue();
                        values.add(val);
                        continue;
                    }
                    if (!(obj instanceof DSTURI)) continue;
                    DSTURI uri = (DSTURI)ob;
                    val = uri.getValue();
                    values.add(val);
                }
                map.put(attrKey, values);
                return map;
            }
            String value = null;
            if (obj instanceof DSTString) {
                DSTString str = (DSTString)obj;
                value = str.getValue();
            } else if (obj instanceof DSTURI) {
                DSTURI uri = (DSTURI)obj;
                value = uri.getValue();
            } else if (obj instanceof DSTDate) {
                DSTDate date = (DSTDate)obj;
                Calendar cal = date.getValue();
                if (cal != null) {
                    value = DateFormat.getDateInstance().format(cal.getTime());
                }
            } else if (obj instanceof DSTInteger) {
                DSTInteger dstInt = (DSTInteger)obj;
                value = dstInt.getValue().toString();
            } else if (obj instanceof DSTMonthDay) {
                DSTMonthDay dstMon = (DSTMonthDay)obj;
                value = dstMon.getValue();
            }
            if (value != null) {
                set.add(value);
            }
        }
        map.put(attrKey, set);
        return map;
    }

    protected Set getMapperAttributeSet(Set set) {
        if (set == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:getAttributeSet:nullval");
            return null;
        }
        HashSet<String> returnSet = new HashSet<String>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            String attrKey = (String)iter.next();
            String attrMap = this.getAttributeMapper().getDSAttribute(attrKey);
            if (attrMap == null) {
                if (!IDPPUtils.debug.messageEnabled()) continue;
                IDPPUtils.debug.message("IDPPBaseContainer:getAttributeSet:no mapping defined for this attrib:" + attrKey);
                continue;
            }
            returnSet.add(attrMap);
        }
        return returnSet;
    }

    protected DSTString getDSTString(String value) {
        if (value == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTString:null vals");
            return null;
        }
        try {
            DSTString dstString = IDPPUtils.getIDPPFactory().createDSTString();
            dstString.setValue(value);
            return dstString;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTString:jaxbFail", (Throwable)je);
            return null;
        }
    }

    protected DSTDate getDSTDate(String value) {
        if (value == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTDate:null vals");
            return null;
        }
        try {
            DSTDate dstDate = IDPPUtils.getIDPPFactory().createDSTDate();
            Date date = DateFormat.getDateInstance(2).parse(value);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            dstDate.setValue(cal);
            return dstDate;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTDate: Exception", (Throwable)e);
            return null;
        }
    }

    protected DSTMonthDay getDSTMonthDay(String value) {
        if (value == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTMonthDay:nullvals");
            return null;
        }
        try {
            DSTMonthDay dstMonthDay = IDPPUtils.getIDPPFactory().createDSTMonthDay();
            dstMonthDay.setValue(value);
            return dstMonthDay;
        }
        catch (Exception e) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTMonthDay: Exception", (Throwable)e);
            return null;
        }
    }

    protected DSTURI getDSTURI(String value) {
        if (value == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTURI:null vals");
            return null;
        }
        try {
            DSTURI dstURI = IDPPUtils.getIDPPFactory().createDSTURI();
            dstURI.setValue(value);
            return dstURI;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTURI: Exception", (Throwable)je);
            return null;
        }
    }

    protected DSTInteger getDSTInteger(String value) {
        if (value == null) {
            IDPPUtils.debug.message("IDPPBaseContainer:getDSTInteger:null vals");
            return null;
        }
        try {
            DSTInteger dstInteger = IDPPUtils.getIDPPFactory().createDSTInteger();
            dstInteger.setValue(new BigInteger(value));
            return dstInteger;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTInteger:Error", (Throwable)je);
            return null;
        }
        catch (NumberFormatException nfe) {
            IDPPUtils.debug.error("IDPPBaseContainer:getDSTInteger: Invalid number", (Throwable)nfe);
            return null;
        }
    }

    protected AnalyzedNameType getAnalyzedName(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPContainers:getAnalyzedName:Init");
        AnalyzedNameType analyzedName = null;
        try {
            analyzedName = IDPPUtils.getIDPPFactory().createAnalyzedNameType();
            String value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("SN").toLowerCase());
            if (value != null) {
                analyzedName.setSN(this.getDSTString(value));
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("FN").toLowerCase())) != null) {
                analyzedName.setFN(this.getDSTString(value));
            }
            if ((value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("PersonalTitle").toLowerCase())) != null) {
                analyzedName.setPersonalTitle(this.getDSTString(value));
            }
            value = CollectionHelper.getMapAttr((Map)userMap, (String)this.getAttributeMapper().getDSAttribute("MN").toLowerCase());
            String nameScheme = IDPPServiceManager.getInstance().getNameScheme();
            if (nameScheme != null) {
                analyzedName.setNameScheme(nameScheme);
            }
            if (nameScheme != null && nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast") && value != null) {
                analyzedName.setMN(this.getDSTString(value));
            }
            return analyzedName;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPContainers:getAnalyzedName: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Document toXMLDocument(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPBaseContainer:toXMLDocument: Init");
        if (userMap == null) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Nodata");
            throw new IDPPException(IDPPUtils.bundle.getString("noData"));
        }
        Document doc = IDPPUtils.getDocumentBuilder().newDocument();
        try {
            IDPPUtils.getMarshaller().marshal(this.getContainerObject(userMap), (Node)doc);
            return doc;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:JAXB exception while marshalling container .", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
        catch (IDPPException ie) {
            IDPPUtils.debug.error("IDPPBaseContainer:toXMLDocument:Error retrieving common name.", (Throwable)ie);
            throw new IDPPException(ie);
        }
    }

    protected Set getAnalyzedNameAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("FN");
        set.add("SN");
        set.add("PersonalTitle");
        String nameScheme = IDPPServiceManager.getInstance().getNameScheme();
        if (nameScheme != null && nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            set.add("MN");
        }
        return this.getMapperAttributeSet(set);
    }

    protected Map getAnalyzedNameMap(Object obj, Map map) throws IDPPException {
        IDPPUtils.debug.message("IDPPBaseContainer:getAnalyzedNameMap:Init");
        DSTString fn = null;
        DSTString sn = null;
        DSTString mn = null;
        DSTString pt = null;
        if (obj != null) {
            if (obj instanceof AnalyzedNameType) {
                AnalyzedNameType analyzedName = (AnalyzedNameType)obj;
                fn = analyzedName.getFN();
                sn = analyzedName.getSN();
                mn = analyzedName.getMN();
                pt = analyzedName.getPersonalTitle();
            } else {
                throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
            }
        }
        this.getAttributeMap("FN", fn, map);
        this.getAttributeMap("SN", sn, map);
        String nameScheme = IDPPServiceManager.getInstance().getNameScheme();
        if (nameScheme != null && nameScheme.equals("urn:liberty:id-sis-pp:nameScheme:firstmiddlelast")) {
            this.getAttributeMap("MN", mn, map);
        }
        this.getAttributeMap("PersonalTitle", pt, map);
        return map;
    }

    protected AttributeMapper getAttributeMapper() {
        return IDPPServiceManager.getInstance().getAttributeMapper();
    }

    protected Set getExtensionContainerAttributes() {
        return IDPPServiceManager.getInstance().getExtensionAttributes();
    }

    protected IDPPExtension getExtensionContainerClass() {
        return IDPPServiceManager.getInstance().getContainerExtension("Extension");
    }

    public void setUserDN(String user) {
        if (IDPPUtils.debug.messageEnabled()) {
            IDPPUtils.debug.message("IDPPBaseContainer.setUserDN: userDN" + user);
        }
        this.userDN = user;
    }
}

