/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.idpp.container;

import com.sun.identity.liberty.ws.common.jaxb.xmlsig.ObjectFactory;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataElement;
import com.sun.identity.liberty.ws.common.jaxb.xmlsig.X509DataType;
import com.sun.identity.liberty.ws.idpp.common.IDPPException;
import com.sun.identity.liberty.ws.idpp.common.IDPPUtils;
import com.sun.identity.liberty.ws.idpp.container.IDPPBaseContainer;
import com.sun.identity.liberty.ws.idpp.jaxb.EncryptKeyElement;
import com.sun.identity.liberty.ws.idpp.jaxb.PPElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class IDPPEncryptKey
extends IDPPBaseContainer {
    public IDPPEncryptKey() {
        IDPPUtils.debug.message("IDPPEncryptKey:constructor:init.");
    }

    public Object getContainerObject(Map userMap) throws IDPPException {
        IDPPUtils.debug.message("IDPPEncryptKey:getContainerObject:Init");
        try {
            PPElement ppType = IDPPUtils.getIDPPFactory().createPPElement();
            EncryptKeyElement encryptKey = IDPPUtils.getIDPPFactory().createEncryptKeyElement();
            byte[][] certBytes = (byte[][])userMap.get(this.getAttributeMapper().getDSAttribute("EncryptKey").toLowerCase());
            if (certBytes != null) {
                ObjectFactory of = new ObjectFactory();
                X509DataElement x509DataType = of.createX509DataElement();
                X509DataType.X509Certificate cert = of.createX509DataTypeX509Certificate(certBytes[0]);
                x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(cert);
                encryptKey.getContent().add(x509DataType);
            }
            ppType.setEncryptKey(encryptKey);
            return ppType;
        }
        catch (JAXBException je) {
            IDPPUtils.debug.error("IDPPEncryptKey:getEncryptKey: JAXB failure", (Throwable)je);
            throw new IDPPException(IDPPUtils.bundle.getString("jaxbFailure"));
        }
    }

    public Set getContainerAttributes() {
        IDPPUtils.debug.message("IDPPEncryptKey:getContainerAttributes:Init");
        HashSet<String> set = new HashSet<String>();
        set.add("EncryptKey");
        return this.getMapperAttributeSet(set);
    }

    public Set getContainerAttributesForSelect(String select) {
        return this.getContainerAttributes();
    }

    public Map getDataMapForSelect(String select, List data) throws IDPPException {
        IDPPUtils.debug.message("IDPPEncryptKey:getDataMapForSelect:Init");
        Object dataElement = null;
        if (data != null && !data.isEmpty()) {
            dataElement = data.get(0);
        }
        HashMap<String, byte[][]> map = new HashMap<String, byte[][]>();
        if (dataElement == null) {
            map.put(this.getAttributeMapper().getDSAttribute("EncryptKey"), null);
            return map;
        }
        if (dataElement instanceof EncryptKeyElement) {
            byte[] certBytes = null;
            EncryptKeyElement encryptKey = dataElement;
            List contents = encryptKey.getContent();
            if (contents == null || contents.size() == 0) {
                map.put(this.getAttributeMapper().getDSAttribute("EncryptKey"), null);
                return map;
            }
            Iterator iter = contents.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof X509DataElement) {
                    X509DataElement x509Data = (X509DataElement)obj;
                    List certs = x509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName();
                    if (certs == null || certs.size() == 0) {
                        IDPPUtils.debug.error("IDPPEncryptKey.getDataMapForSelect:Unsupported data. certs are null");
                        return null;
                    }
                    Object certObj = certs.get(0);
                    if (certObj instanceof X509DataType.X509Certificate) {
                        X509DataType.X509Certificate cert = (X509DataType.X509Certificate)certObj;
                        certBytes = cert.getValue();
                        break;
                    }
                    IDPPUtils.debug.error("IDPPEncryptKey.getDataMapForSelect:Unsupported data. not x509 certificate");
                    return null;
                }
                IDPPUtils.debug.error("IDPPEncryptKey.getDataMapForSelect:not x509data element");
            }
            byte[][] attributeByte = new byte[1][certBytes.length];
            for (int i = 0; i < certBytes.length; ++i) {
                attributeByte[0][i] = certBytes[i];
            }
            map.put(this.getAttributeMapper().getDSAttribute("EncryptKey"), attributeByte);
            return map;
        }
        throw new IDPPException(IDPPUtils.bundle.getString("invalid Element"));
    }

    public boolean hasBinaryAttributes() {
        return true;
    }
}

