/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.DiscoveryClient;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.CorrelationHeader;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.SOAPProviderConfig;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageProcessor {
    private SOAPProviderConfig _config = null;
    private String correlationId = null;

    private MessageProcessor() {
    }

    public MessageProcessor(SOAPProviderConfig config) {
        this._config = config;
    }

    public Object validateRequest(SOAPMessage soapMessage, Subject subject, Map sharedData, HttpServletRequest httpRequest) throws SOAPBindingException {
        Utils.debug.message("SOAPProvider.validateRequest : Init");
        Message req = null;
        try {
            req = new Message(soapMessage);
            sharedData.put("LibertyRequest", req);
            if (req.getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage(req)) {
                Utils.debug.error("MessageProcessor.validateRequest: SignatureVerification failed.");
                throw new SOAPBindingException(Utils.bundle.getString("cannotVerifySignature"));
            }
            Utils.enforceProcessingRules(req, null, true);
            if (this._config != null) {
                String authMech = req.getAuthenticationMechanism();
                if (authMech == null || !this._config.getSupportedAuthenticationMechanisms().contains(authMech)) {
                    throw new SOAPBindingException(Utils.bundle.getString("unsupportedAuthMech"));
                }
            } else {
                throw new SOAPBindingException(Utils.bundle.getString("nullConfiguration"));
            }
            return this._config.getAuthenticator().authenticate(req, subject, sharedData, httpRequest);
        }
        catch (SOAPBindingException sbe) {
            Utils.debug.error("MessageProcessor.validateRequest: RequestValidation has failed.", (Throwable)sbe);
            throw sbe;
        }
        catch (SOAPFaultException sfe) {
            Utils.debug.error("MessageProcessor.validateRequest: SOAPFaultException.", (Throwable)sfe);
            throw new SOAPBindingException(Utils.bundle.getString("soapFaultException"));
        }
    }

    public SOAPMessage secureResponse(SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        Utils.debug.message("MessageProcessor.secureResponse : Init");
        try {
            Message req = (Message)sharedData.get("LibertyRequest");
            this.addCorrelationHeader(soapMessage, req);
            if (this._config.isResponseSignEnabled()) {
                soapMessage = this.signMessage(soapMessage, null, null);
            }
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("MessageProcessor.secureResponse: " + XMLUtils.print((Node)soapMessage.getSOAPPart().getEnvelope()));
            }
            return soapMessage;
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.secureResponse: Failed in securing the response", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("secureResponseFailed"));
        }
    }

    public SOAPMessage secureRequest(ResourceOffering offering, List credentials, String serviceType, SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        Utils.debug.message("MessageProcessor.secureRequest:Init");
        try {
            SOAPHeader header = this.addCorrelationHeader(soapMessage, null);
            QueryResponse discoResponse = this.getWebserviceOffering(offering, credentials, serviceType);
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("MessageProcessor.secureRequest: Discovery Response: " + discoResponse.toString());
            }
            ResourceOffering serviceOffering = (ResourceOffering)discoResponse.getResourceOffering().get(0);
            List creds = discoResponse.getCredentials();
            String securityProfile = this.processResourceOffering(serviceOffering);
            SecurityAssertion securityAssertion = null;
            if ((securityProfile.equals("urn:liberty:security:2003-08:null:SAML") || securityProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2004-04:null:Bearer") || securityProfile.equals("urn:liberty:security:2004-04:TLS:Bearer") || securityProfile.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:null:SAML") || securityProfile.equals("urn:liberty:security:2005-02:TLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:null:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:TLS:Bearer") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) && creds != null && creds.size() != 0) {
                securityAssertion = (SecurityAssertion)creds.get(0);
                securityAssertion.addToParent((Element)header);
            }
            if (securityProfile.equals("urn:liberty:security:2003-08:null:SAML") || securityProfile.equals("urn:liberty:security:2003-08:TLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2003-08:null:X509") || securityProfile.equals("urn:liberty:security:2003-08:TLS:X509") || securityProfile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || securityProfile.equals("urn:liberty:security:2005-02:null:SAML") || securityProfile.equals("urn:liberty:security:2005-02:TLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:SAML") || securityProfile.equals("urn:liberty:security:2005-02:null:X509") || securityProfile.equals("urn:liberty:security:2005-02:TLS:X509") || securityProfile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                soapMessage = this.signMessage(soapMessage, securityProfile, securityAssertion);
            }
            if (Utils.debug.messageEnabled()) {
                Utils.debug.message("MessageProcessor.secureRequest: " + XMLUtils.print((Node)soapMessage.getSOAPPart().getEnvelope()));
            }
            return soapMessage;
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.secureRequest: Failure in Securing the request.", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("secureRequestFailed"));
        }
    }

    public SOAPMessage validateResponse(SOAPMessage soapMessage, Map sharedData) throws SOAPBindingException {
        try {
            Message msg = new Message(soapMessage);
            if (this._config.isResponseSignEnabled() && !SecurityUtils.verifyMessage(msg)) {
                throw new SOAPBindingException(Utils.bundle.getString("cannotVerifySignature"));
            }
            Utils.enforceProcessingRules(msg, null, true);
            return soapMessage;
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.validateResponse:  Response validation failed.", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("validateResponseFailed"));
        }
    }

    private SOAPMessage signMessage(SOAPMessage soapMessage, String profile, SecurityAssertion assertion) throws SOAPBindingException {
        try {
            SOAPBody soapBody;
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (soapHeader == null) {
                soapMessage.getSOAPPart().getEnvelope().addHeader();
            }
            if ((soapBody = soapMessage.getSOAPPart().getEnvelope().getBody()) == null) {
                throw new SOAPBindingException(Utils.bundle.getString("nullSOAPBody"));
            }
            String bodyId = SAMLUtils.generateID();
            soapBody.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", bodyId);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(bodyId);
            if (this.correlationId != null) {
                ids.add(this.correlationId);
            }
            Certificate cert = null;
            Element sigElem = null;
            ByteArrayInputStream bin = null;
            ByteArrayOutputStream bop = new ByteArrayOutputStream();
            Document doc = null;
            if (profile == null || profile.equals("urn:liberty:security:2003-08:null:X509") || profile.equals("urn:liberty:security:2003-08:TLS:X509") || profile.equals("urn:liberty:security:2003-08:ClientTLS:X509") || profile.equals("urn:liberty:security:2005-02:null:X509") || profile.equals("urn:liberty:security:2005-02:TLS:X509") || profile.equals("urn:liberty:security:2005-02:ClientTLS:X509")) {
                BinarySecurityToken binaryToken = this.addBinaryToken(soapMessage);
                cert = SecurityUtils.getCertificate(binaryToken);
                soapMessage.writeTo((OutputStream)bop);
                bin = new ByteArrayInputStream(bop.toByteArray());
                doc = XMLUtils.toDOMDocument((InputStream)bin, (Debug)Utils.debug);
                sigElem = SecurityUtils.getSignatureManager().signWithWSSX509TokenProfile(doc, cert, "", ids, "1.1");
            } else if (profile.equals("urn:liberty:security:2003-08:null:SAML") || profile.equals("urn:liberty:security:2003-08:TLS:SAML") || profile.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || profile.equals("urn:liberty:security:2005-02:null:SAML") || profile.equals("urn:liberty:security:2005-02:TLS:SAML") || profile.equals("urn:liberty:security:2005-02:ClientTLS:SAML")) {
                cert = SecurityUtils.getCertificate(assertion);
                soapMessage.writeTo((OutputStream)bop);
                new ByteArrayInputStream(bop.toByteArray());
                bin = new ByteArrayInputStream(bop.toByteArray());
                doc = XMLUtils.toDOMDocument((InputStream)bin, (Debug)Utils.debug);
                sigElem = SecurityUtils.getSignatureManager().signWithWSSSAMLTokenProfile(doc, cert, assertion.getAssertionID(), "", ids, "1.1");
            }
            if (sigElem == null) {
                Utils.debug.error("MessageProcessor.signMessage: SigElement is null");
                throw new SOAPBindingException(Utils.bundle.getString("cannotSignMessage"));
            }
            Element securityHeader = this.getSecurityHeader(soapMessage);
            securityHeader.appendChild(securityHeader.getOwnerDocument().importNode(sigElem, true));
            return Utils.DocumentToSOAPMessage(sigElem.getOwnerDocument());
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.signMessage: Signing failed.", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("cannotSignMessage"));
        }
    }

    private SOAPHeader addCorrelationHeader(SOAPMessage msg, Message req) throws SOAPBindingException {
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                header = msg.getSOAPPart().getEnvelope().addHeader();
            }
            CorrelationHeader cHeader = new CorrelationHeader();
            this.correlationId = cHeader.getId();
            if (req != null) {
                cHeader.setRefToMessageID(req.getCorrelationHeader().getMessageID());
            }
            cHeader.addToParent((Element)header);
            return header;
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.addCorrealtionHeader: Could not add correlation header", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("cannotAddCorrelationHeader"));
        }
    }

    private BinarySecurityToken addBinaryToken(SOAPMessage msg) throws SOAPBindingException {
        try {
            SOAPHeader header = msg.getSOAPPart().getEnvelope().getHeader();
            if (header == null) {
                header = msg.getSOAPPart().getEnvelope().addHeader();
            }
            SecurityTokenManager manager = new SecurityTokenManager(null);
            BinarySecurityToken binaryToken = manager.getX509CertificateToken();
            binaryToken.setWSFVersion("1.1");
            binaryToken.addToParent((Element)header);
            return binaryToken;
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.addBinaryToken: Could not add binary security token", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("cannotAddCorrelationHeader"));
        }
    }

    private QueryResponse getWebserviceOffering(ResourceOffering offering, List credentials, String serviceType) throws SOAPBindingException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(serviceType);
        try {
            DiscoveryClient client = new DiscoveryClient(offering, null, null, credentials);
            return client.getResourceOffering(list);
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.getWebserviceOffering : Failed in discovery query.", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("discoveryQueryFailed"));
        }
    }

    private String processResourceOffering(ResourceOffering offering) throws SOAPBindingException {
        try {
            ServiceInstance si = offering.getServiceInstance();
            List descriptions = si.getDescription();
            if (descriptions == null || descriptions.isEmpty()) {
                Utils.debug.error("MessageProcessor:processResourceOffering: descriptions are null.");
                throw new SOAPBindingException(Utils.bundle.getString("noDescriptions"));
            }
            Iterator iter = descriptions.iterator();
            if (iter.hasNext()) {
                Description desc = (Description)iter.next();
                List secMechIDs = desc.getSecurityMechID();
                if (secMechIDs == null || secMechIDs.isEmpty()) {
                    Utils.debug.error("MessageProcessor.processResourceOffering: security Mechs are empty");
                    throw new SOAPBindingException(Utils.bundle.getString("noSecurityMechs"));
                }
                return (String)secMechIDs.iterator().next();
            }
            throw new SOAPBindingException(Utils.bundle.getString("noSecurityMechs"));
        }
        catch (Exception ex) {
            Utils.debug.error("MessageProcessor.processResourceOffering: Failed in processing the resource offering.", (Throwable)ex);
            throw new SOAPBindingException(Utils.bundle.getString("processOfferingFailed"));
        }
    }

    private Element getSecurityHeader(SOAPMessage soapMessage) throws SOAPBindingException {
        try {
            SOAPHeader header = soapMessage.getSOAPPart().getEnvelope().getHeader();
            NodeList headerChildNodes = header.getChildNodes();
            if (headerChildNodes == null || headerChildNodes.getLength() == 0) {
                throw new SOAPBindingException(Utils.bundle.getString("noSecurityHeader"));
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1 || !"Security".equals(currentNode.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentNode.getNamespaceURI())) continue;
                return (Element)currentNode;
            }
            return null;
        }
        catch (SOAPException se) {
            Utils.debug.error("MessageProcess.getSecurityHeader:: SOAPException", (Throwable)se);
            throw new SOAPBindingException(Utils.bundle.getString("noSecurityHeader"));
        }
    }
}

