/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.datastore;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class DataStoreProviderManager {
    public static final String DEFAULT = "default";
    public static final String PROVIDER_ATTR_PREFIX = "com.sun.identity.plugin.datastore.class.";
    public static final String DEFAULT_PROVIDER_ATTR = "com.sun.identity.plugin.datastore.class.default";
    private Map providerMap = null;
    private DataStoreProvider defaultProvider = null;
    private static DataStoreProviderManager instance = new DataStoreProviderManager();
    private Debug debug = Debug.getInstance((String)"libDataStoreProvider");
    private ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libDataStoreProvider");

    private DataStoreProviderManager() {
        this.providerMap = new HashMap();
        try {
            this.defaultProvider = this.getDefaultProvider();
            this.defaultProvider.init(DEFAULT);
        }
        catch (DataStoreProviderException de) {
            this.debug.error("DataStoreProviderManager: exception obtaining default provider:", (Throwable)((Object)de));
        }
    }

    public static DataStoreProviderManager getInstance() throws DataStoreProviderException {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreProvider getDataStoreProvider(String componentName) throws DataStoreProviderException {
        if (componentName == null || componentName.length() == 0) {
            return this.defaultProvider;
        }
        DataStoreProvider provider = (DataStoreProvider)this.providerMap.get(componentName);
        if (provider != null) {
            return provider;
        }
        String className = SystemConfigurationUtil.getProperty(PROVIDER_ATTR_PREFIX + componentName);
        if (className != null && className.length() > 0) {
            try {
                provider = (DataStoreProvider)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                this.debug.error("DataStoreProviderManager.getDataStoreProvider: exception while instanciating provider:" + className + ":", (Throwable)e);
                throw new DataStoreProviderException(e);
            }
        }
        if (provider == null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("DataStoreProviderManager.getDataStoreProvider: no provider specified for " + componentName + ", using default.");
            }
            provider = this.getDefaultProvider();
        }
        provider.init(componentName);
        Map map = this.providerMap;
        synchronized (map) {
            this.providerMap.put(componentName, provider);
        }
        return provider;
    }

    private DataStoreProvider getDefaultProvider() throws DataStoreProviderException {
        String className = SystemConfigurationUtil.getProperty(DEFAULT_PROVIDER_ATTR);
        if (className == null || className.length() == 0) {
            throw new DataStoreProviderException(this.bundle.getString("defaultProviderNotDefined"));
        }
        try {
            return (DataStoreProvider)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new DataStoreProviderException(e);
        }
    }
}

