/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.log.impl;

import com.sun.identity.plugin.log.LogException;
import com.sun.identity.plugin.log.Logger;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FedletLogger
implements Logger {
    protected java.util.logging.Logger accessLogger;
    protected java.util.logging.Logger errorLogger;
    private static Debug debug = Debug.getInstance((String)"fedletLogger");
    private static boolean logStatus = false;

    public void init(String componentName) throws LogException {
        this.accessLogger = java.util.logging.Logger.getLogger(componentName + ".access");
        this.errorLogger = java.util.logging.Logger.getLogger(componentName + ".error");
    }

    public void access(Level level, String messageId, String[] data, Object session) throws LogException {
        this.access(level, messageId, data, session, null);
    }

    public void access(Level level, String messageId, String[] data, Object session, Map props) throws LogException {
        if (this.isAccessLoggable(level)) {
            LogRecord lr = new LogRecord(level, FedletLogger.formatMessage(messageId, data, session));
            this.accessLogger.log(lr);
        }
    }

    private static String formatMessage(String messageId, String[] param, Object session) {
        if (param == null || param.length == 0) {
            return messageId;
        }
        for (int i = 0; i < param.length; ++i) {
            messageId = messageId + "\n{" + param[i] + "}";
        }
        if (session != null) {
            messageId = messageId + "\n{" + session.toString() + "}";
        }
        return messageId;
    }

    public void error(Level level, String messageId, String[] data, Object session) throws LogException {
        this.error(level, messageId, data, session, null);
    }

    public void error(Level level, String messageId, String[] data, Object session, Map props) throws LogException {
        if (this.isErrorLoggable(level)) {
            LogRecord lr = new LogRecord(level, FedletLogger.formatMessage(messageId, data, session));
            this.errorLogger.log(lr);
        }
    }

    public boolean isLogEnabled() {
        return logStatus;
    }

    public boolean isAccessLoggable(Level level) {
        return this.accessLogger.isLoggable(level);
    }

    public boolean isErrorLoggable(Level level) {
        return this.errorLogger.isLoggable(level);
    }

    static {
        String status = SystemPropertiesManager.get((String)"com.iplanet.am.logstatus");
        logStatus = status != null && status.equalsIgnoreCase("ACTIVE");
    }
}

