/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Attribute
extends AttributeDesignator {
    protected List _attributeValue;

    public Attribute(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("Attribute: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("Attribute")) {
            SAMLUtilsCommon.debug.message("Attribute: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        int i = 0;
        NamedNodeMap atts = element.getAttributes();
        int attrCount = atts.getLength();
        for (i = 0; i < attrCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Attribute:Attribute Name is either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("AttributeName")) {
                this._attributeName = ((Attr)att).getValue().trim();
                continue;
            }
            if (!attName.equals("AttributeNamespace")) continue;
            this._attributeNameSpace = ((Attr)att).getValue().trim();
        }
        if (this._attributeName == null || this._attributeName.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Attribute: AttributeName is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        if (this._attributeNameSpace == null || this._attributeNameSpace.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Attribute: AttributeNamespace is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingAttribute"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String tagName = currentNode.getLocalName();
                String tagNS = currentNode.getNamespaceURI();
                if (tagName == null || tagName.length() == 0 || tagNS == null || tagNS.length() == 0) {
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Attribute: The tag name or tag namespace of child element is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
                }
                if (tagName.equals("AttributeValue") && tagNS.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    if (this._attributeValue == null) {
                        this._attributeValue = new ArrayList();
                    }
                    if (this._attributeValue.add((Element)currentNode)) continue;
                    if (SAMLUtilsCommon.debug.messageEnabled()) {
                        SAMLUtilsCommon.debug.message("Attribute: failed to add to the attribute value list.");
                    }
                    throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
                }
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Attribute:wrong element:" + tagName);
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
        if (this._attributeValue == null || this._attributeValue.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Attribute: should contain at least one AttributeValue.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElement"));
        }
    }

    public Attribute(String name, String nameSpace, List values) throws SAMLException {
        super(name, nameSpace);
        if (values == null || values.isEmpty()) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Attribute: AttributeValue isrequired.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        if (this._attributeValue == null) {
            this._attributeValue = new ArrayList();
        }
        Iterator iter = values.iterator();
        String tag = null;
        while (iter.hasNext()) {
            tag = ((Element)iter.next()).getLocalName();
            if (tag != null && tag.equals("AttributeValue")) continue;
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeValue: wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        this._attributeValue = values;
    }

    public Attribute(String name, String nameSpace, String attributeValue) throws SAMLException {
        super(name, nameSpace);
        this.addAttributeValue(attributeValue);
    }

    public List getAttributeValue() throws SAMLException {
        return this._attributeValue;
    }

    public void addAttributeValue(String value) throws SAMLException {
        if (value == null || value.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("addAttributeValue: Input is null");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append(value).append("</").append("saml:").append("AttributeValue>");
        try {
            Element ele = XMLUtils.toDOMDocument((String)sb.toString().trim(), (Debug)SAMLUtilsCommon.debug).getDocumentElement();
            if (this._attributeValue == null) {
                this._attributeValue = new ArrayList();
            }
            if (!this._attributeValue.add(ele)) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Attribute: failed to add to the attribute value list.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("addAttributeValue error", (Throwable)e);
            throw new SAMLRequesterException("Exception in addAttributeValue" + e.getMessage());
        }
    }

    public void addAttributeValue(Element element) throws SAMLException {
        if (element == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("addAttributeValue: input  is null.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (tag == null || !tag.equals("AttributeValue")) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("AttributeValue: wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        try {
            if (this._attributeValue == null) {
                this._attributeValue = new ArrayList();
            }
            if (!this._attributeValue.add(element)) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Attribute: failed to add to the attribute value list.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("addListError"));
            }
        }
        catch (Exception e) {
            SAMLUtilsCommon.debug.error("addAttributeValue error", (Throwable)e);
            throw new SAMLRequesterException("Exception in addAttributeValue" + e.getMessage());
        }
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("Attribute").append(uri).append(" AttributeName=\"").append(this._attributeName).append("\" AttributeNamespace=\"").append(this._attributeNameSpace).append("\">\n");
        Iterator iter = this._attributeValue.iterator();
        while (iter.hasNext()) {
            result.append(XMLUtils.printAttributeValue((Element)((Element)iter.next()), (String)prefix)).append("\n");
        }
        result.append("</").append(prefix).append("Attribute>\n");
        return result.toString();
    }
}

