/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.AttributeQuery;
import com.sun.identity.saml.protocol.AuthenticationQuery;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import com.sun.identity.saml.protocol.Query;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Request
extends AbstractRequest {
    protected Query query = null;
    protected List assertionIDRefs = Collections.EMPTY_LIST;
    protected List artifacts = Collections.EMPTY_LIST;
    protected int contentType = -1;
    protected String xmlString = null;
    protected String signatureString = null;
    private static final String REQUEST_ID_ATTRIBUTE = "RequestID";
    public static final int NOT_SUPPORTED = -1;
    public static final int AUTHENTICATION_QUERY = 0;
    public static final int AUTHORIZATION_DECISION_QUERY = 1;
    public static final int ASSERTION_ID_REFERENCE = 2;
    public static final int ASSERTION_ARTIFACT = 3;
    public static final int ATTRIBUTE_QUERY = 4;

    protected Request() {
    }

    public void signXML() throws SAMLException {
        if (this.signed) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request.signXML: the request is already signed.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("alreadySigned"));
        }
        String certAlias = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.certalias");
        if (certAlias == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request.signXML: couldn't obtain this site's cert Alias.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager manager = XMLSignatureManager.getInstance();
        if (this.majorVersion == 1 && this.minorVersion == 0) {
            SAMLUtils.debug.message("Request.signXML: sign with version 1.0");
            this.signatureString = manager.signXML(this.toString(true, true), certAlias);
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)SAMLUtils.debug).getDocumentElement();
        } else {
            Document doc = XMLUtils.toDOMDocument((String)this.toString(true, true), (Debug)SAMLUtils.debug);
            this.signature = manager.signXML(doc, certAlias, null, REQUEST_ID_ATTRIBUTE, this.getRequestID(), true, null);
            this.signatureString = XMLUtils.print((Node)this.signature);
        }
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    public Request(List respondWiths, String requestId, List contents) throws SAMLException {
        Object temp = null;
        if (respondWiths != null && respondWiths != Collections.EMPTY_LIST) {
            int length = respondWiths.size();
            for (int i = 0; i < length; ++i) {
                temp = respondWiths.get(i);
                if (!(temp instanceof String)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: wrong input for RespondWith");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                if (this.respondWiths == null || this.respondWiths.size() == 0) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(this.checkAndGetRespondWith(temp));
            }
        }
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                SAMLUtils.debug.error("Request: couldn't generate RequestID.");
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorGenerateID"));
            }
        }
        this.parseContents(contents);
        this.issueInstant = new Date();
    }

    private String checkAndGetRespondWith(String respondWith) throws SAMLException {
        if (respondWith == null || respondWith.length() == 0) {
            SAMLUtils.debug.message("Request: empty RespondWith Value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (respondWith.indexOf(":") == -1) {
            return "saml:" + respondWith;
        }
        StringTokenizer st = new StringTokenizer(respondWith, ":");
        if (st.countTokens() != 2) {
            SAMLUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        st.nextToken();
        String temp = st.nextToken().trim();
        if (temp.length() == 0) {
            SAMLUtils.debug.message("Request: wrong RespondWith value.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        return "saml:" + temp;
    }

    private void parseContents(List contents) throws SAMLException {
        int length = 0;
        int i = 0;
        if (contents == null || (length = contents.size()) == 0) {
            SAMLUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        for (i = 0; i < length; ++i) {
            Object temp = contents.get(i);
            if (temp instanceof AuthenticationQuery) {
                if (this.contentType != -1 || i != length - 1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: should contain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 0;
                this.query = (AuthenticationQuery)temp;
                continue;
            }
            if (temp instanceof AuthorizationDecisionQuery) {
                if (this.contentType != -1 || i != length - 1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: should contain only one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 1;
                this.query = (AuthorizationDecisionQuery)temp;
                continue;
            }
            if (temp instanceof AttributeQuery) {
                if (this.contentType != -1 || i != length - 1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: should contain only one AttributeQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 4;
                this.query = (AttributeQuery)temp;
                continue;
            }
            if (temp instanceof AssertionIDReference) {
                if (this.contentType != -1 && this.contentType != 2) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: should contain one or more AssertionIDReference.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 2;
                if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add((AssertionIDReference)temp);
                continue;
            }
            if (temp instanceof AssertionArtifact) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request: should contain  one or more AssertionArtifact.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                this.artifacts.add((AssertionArtifact)temp);
                continue;
            }
            SAMLUtils.debug.message("Request: wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
    }

    public Request(String requestId, Query query) throws SAMLException {
        if (requestId != null && requestId.length() != 0) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                SAMLUtils.debug.error("Request: couldn't generate RequestID.");
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorGenerateID"));
            }
        }
        if (query == null) {
            SAMLUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (query instanceof AuthenticationQuery) {
            this.contentType = 0;
        } else if (query instanceof AuthorizationDecisionQuery) {
            this.contentType = 1;
        } else if (query instanceof AttributeQuery) {
            this.contentType = 4;
        } else {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request: this type of query is not supported.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("queryNotSupported"));
        }
        this.query = query;
        this.issueInstant = new Date();
    }

    public Request(String requestId, List contents) throws SAMLException {
        if (requestId != null) {
            this.requestID = requestId;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorGenerateID"));
            }
        }
        this.parseContents(contents);
        this.issueInstant = new Date();
    }

    public static Request parseXML(String xml) throws SAMLException {
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)SAMLUtils.debug);
        Element root = doc.getDocumentElement();
        return new Request(root);
    }

    public Request(Element root) throws SAMLException {
        String tag = null;
        if (root == null) {
            SAMLUtils.debug.message("Request(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        tag = root.getLocalName();
        if (tag == null || !tag.equals("Request")) {
            SAMLUtils.debug.message("Request(Element): wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        List signs = XMLUtils.getElementsByTagNameNS1((Element)root, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            this.valid = manager.verifyXMLSignature(root, REQUEST_ID_ATTRIBUTE, null);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print((Node)root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        this.requestID = root.getAttribute(REQUEST_ID_ATTRIBUTE);
        if (this.requestID == null || this.requestID.length() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): Request doesn't have a RequestID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        this.parseMajorVersion(this.requestID, root.getAttribute("MajorVersion"));
        this.parseMinorVersion(this.requestID, root.getAttribute("MinorVersion"));
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            SAMLUtils.debug.message("Request(Element): missing IssueInstant");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)instantString);
        }
        catch (ParseException e) {
            SAMLUtils.debug.message("Request(Element): could not parse IssueInstant", (Throwable)e);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("RespondWith")) {
                String respondWith = XMLUtils.getElementValue((Element)((Element)child));
                if (respondWith.length() == 0) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): wrong RespondWith value.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                if (this.respondWiths == Collections.EMPTY_LIST) {
                    this.respondWiths = new ArrayList();
                }
                this.respondWiths.add(respondWith);
                continue;
            }
            if (nodeName.equals("Signature")) {
                this.signature = (Element)child;
                continue;
            }
            if (nodeName.equals("AuthenticationQuery")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): shouldcontain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 0;
                this.query = new AuthenticationQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AuthorizationDecisionQuery")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): shouldcontain only one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 1;
                this.query = new AuthorizationDecisionQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AttributeQuery")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): shouldcontain only one AttributeQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 4;
                this.query = new AttributeQuery((Element)child);
                continue;
            }
            if (nodeName.equals("AssertionIDReference")) {
                if (this.contentType != -1 && this.contentType != 2) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): contained mixed contents.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 2;
                if (this.assertionIDRefs == Collections.EMPTY_LIST) {
                    this.assertionIDRefs = new ArrayList();
                }
                this.assertionIDRefs.add(new AssertionIDReference(XMLUtils.getElementValue((Element)((Element)child))));
                continue;
            }
            if (nodeName.equals("AssertionArtifact")) {
                if (this.contentType != -1 && this.contentType != 3) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): contained mixed contents.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 3;
                if (this.artifacts == Collections.EMPTY_LIST) {
                    this.artifacts = new ArrayList();
                }
                this.artifacts.add(new AssertionArtifact(XMLUtils.getElementValue((Element)((Element)child))));
                continue;
            }
            if (nodeName.equals("Query") || nodeName.equals("SubjectQuery")) {
                this.parseQuery(child);
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): invalid node" + nodeName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.contentType == -1) {
            SAMLUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
    }

    private void parseMajorVersion(String reqID, String majorVer) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): invalid MajorVersion", (Throwable)e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Request(Element):MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException(reqID + "|" + SAMLUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element):MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(reqID + "|" + SAMLUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String reqID, String minorVer) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): invalid MinorVersion", (Throwable)e);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion > 1) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): MinorVersion of the Request is too high.");
            }
            throw new SAMLRequestVersionTooHighException(reqID + "|" + SAMLUtils.bundle.getString("requestVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): MinorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(reqID + "|" + SAMLUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseQuery(Node child) throws SAMLException {
        NamedNodeMap nm = child.getAttributes();
        int len = nm.getLength();
        boolean found = false;
        for (int j = 0; j < len; ++j) {
            Attr attr = (Attr)nm.item(j);
            String attrName = attr.getLocalName();
            if (attrName == null || !attrName.equals("type")) continue;
            String attrValue = attr.getNodeValue();
            if (attrValue.equals("AuthenticationQueryType")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): should contain only one AuthenticationQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 0;
                this.query = new AuthenticationQuery((Element)child);
            } else if (attrValue.equals("AuthorizationDecisionQueryType")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): should contain one AuthorizationDecisionQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 1;
                this.query = new AuthorizationDecisionQuery((Element)child);
            } else if (attrValue.equals("AttributeQueryType")) {
                if (this.contentType != -1) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Request(Element): should contain one AttributeQuery.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                this.contentType = 4;
                this.query = new AttributeQuery((Element)child);
            } else {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Request(Element): This type of " + attrName + " is not supported.");
                }
                throw new SAMLResponderException(SAMLUtils.bundle.getString("queryNotSupported"));
            }
            found = true;
            break;
        }
        if (!found) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Request(Element): missing xsi:type definition in " + child.getLocalName());
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public List getAssertionIDReference() {
        return this.assertionIDRefs;
    }

    public List getAssertionArtifact() {
        return this.artifacts;
    }

    public int getContentType() {
        return this.contentType;
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print((Node)elem);
        return super.setSignature(elem);
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        return this.toString(includeNS, declareNS, false);
    }

    public String toString(boolean includeNS, boolean declareNS, boolean includeHeader) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String instantString = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        xml.append("<").append(prefix).append("Request").append(uri).append(" RequestID=\"").append(this.requestID).append("\"").append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(instantString).append("\"").append(">\n");
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            Iterator i = this.respondWiths.iterator();
            String respondWith = null;
            while (i.hasNext()) {
                respondWith = (String)i.next();
                xml.append("<").append(prefix).append("RespondWith>");
                if (respondWith.startsWith("saml:")) {
                    xml.append(respondWith);
                } else {
                    try {
                        xml.append(this.checkAndGetRespondWith(respondWith));
                    }
                    catch (SAMLException e) {
                        SAMLUtils.debug.error("Request.toString: ", (Throwable)((Object)e));
                        xml.append(respondWith);
                    }
                }
                xml.append("</").append(prefix).append("RespondWith>\n");
            }
        }
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                xml.append(this.signatureString);
            }
        }
        switch (this.contentType) {
            case 0: {
                xml.append(((AuthenticationQuery)this.query).toString(includeNS, false));
                break;
            }
            case 1: {
                xml.append(((AuthorizationDecisionQuery)this.query).toString(includeNS, false));
                break;
            }
            case 4: {
                xml.append(((AttributeQuery)this.query).toString(includeNS, false));
                break;
            }
            case 2: {
                Iterator j = this.assertionIDRefs.iterator();
                while (j.hasNext()) {
                    xml.append(((AssertionIDReference)j.next()).toString(true, true));
                }
                break;
            }
            case 3: {
                Iterator j = this.artifacts.iterator();
                while (j.hasNext()) {
                    xml.append(((AssertionArtifact)j.next()).toString(includeNS, false));
                }
                break;
            }
        }
        xml.append("</").append(prefix).append("Request>\n");
        return xml.toString();
    }
}

