/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.Advice;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.AuthzDecisionStatement;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.Statement;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.xmlenc.EncManager;
import com.sun.identity.saml2.xmlsig.SigManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssertionImpl
implements Assertion {
    private String version;
    private Date issueInstant;
    private Subject subject;
    private Advice advice;
    private String signature;
    private Conditions conditions;
    private String id;
    private List statements = new ArrayList();
    private List authnStatements = new ArrayList();
    private List authzDecisionStatements = new ArrayList();
    private List attributeStatements = new ArrayList();
    private Issuer issuer;
    private boolean isMutable = true;
    private String signedXMLString = null;
    private Boolean isSignatureValid = null;
    public static String ASSERTION_ELEMENT = "Assertion";
    public static String ASSERTION_VERSION_ATTR = "Version";
    public static String ASSERTION_ID_ATTR = "ID";
    public static String ASSERTION_ISSUEINSTANT_ATTR = "IssueInstant";
    public static String XSI_TYPE_ATTR = "xsi:type";
    public static String ASSERTION_ISSUER = "Issuer";
    public static String ASSERTION_SIGNATURE = "Signature";
    public static String ASSERTION_SUBJECT = "Subject";
    public static String ASSERTION_CONDITIONS = "Conditions";
    public static String ASSERTION_ADVICE = "Advice";
    public static String ASSERTION_STATEMENT = "Statement";
    public static String ASSERTION_AUTHNSTATEMENT = "AuthnStatement";
    public static String ASSERTION_AUTHZDECISIONSTATEMENT = "AuthzDecisionStatement";
    public static String ASSERTION_ATTRIBUTESTATEMENT = "AttributeStatement";

    public AssertionImpl() {
    }

    public AssertionImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
        if (this.signature != null) {
            this.signedXMLString = xml;
        }
    }

    public AssertionImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
        if (this.signature != null) {
            this.signedXMLString = XMLUtils.print((Node)element, (String)"UTF-8");
        }
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(ASSERTION_ELEMENT)) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute(ASSERTION_VERSION_ATTR);
        if (attrValue == null || attrValue.length() == 0) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): version missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_assertion_version"));
        }
        this.version = attrValue;
        attrValue = element.getAttribute(ASSERTION_ID_ATTR);
        if (attrValue == null || attrValue.length() == 0) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): assertion id missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_assertion_id"));
        }
        this.id = attrValue;
        attrValue = element.getAttribute(ASSERTION_ISSUEINSTANT_ATTR);
        if (attrValue == null || attrValue.length() == 0) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): issue instant missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_issue_instant"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)attrValue);
        }
        catch (ParseException pe) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): invalid issue instant");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_date_format"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes < 1) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): assertion has no subelements");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelements"));
        }
        AssertionFactory factory = AssertionFactory.getInstance();
        int nextElem = 0;
        Node child = nodes.item(nextElem);
        while (child.getNodeType() != 1) {
            if (++nextElem >= numOfNodes) {
                SAML2SDKUtils.debug.error("AssertionImpl.processElement(): assertion has no subelements");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelements"));
            }
            child = nodes.item(nextElem);
        }
        String childName = child.getLocalName();
        if (childName == null || !childName.equals(ASSERTION_ISSUER)) {
            SAML2SDKUtils.debug.error("AssertionImpl.processElement(): the first element is not <Issuer>");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelement_issuer"));
        }
        this.issuer = factory.getInstance().createIssuer((Element)child);
        if (++nextElem >= numOfNodes) {
            return;
        }
        child = nodes.item(nextElem);
        while (child.getNodeType() != 1) {
            if (++nextElem >= numOfNodes) {
                return;
            }
            child = nodes.item(nextElem);
        }
        childName = child.getLocalName();
        if (childName != null && childName.equals(ASSERTION_SIGNATURE)) {
            this.signature = XMLUtils.print((Node)((Element)child));
            if (++nextElem >= numOfNodes) {
                return;
            }
            child = nodes.item(nextElem);
            while (child.getNodeType() != 1) {
                if (++nextElem >= numOfNodes) {
                    return;
                }
                child = nodes.item(nextElem);
            }
            childName = child.getLocalName();
        } else {
            this.signature = null;
        }
        if (childName != null && childName.equals(ASSERTION_SUBJECT)) {
            this.subject = factory.createSubject((Element)child);
            if (++nextElem >= numOfNodes) {
                return;
            }
            child = nodes.item(nextElem);
            while (child.getNodeType() != 1) {
                if (++nextElem >= numOfNodes) {
                    return;
                }
                child = nodes.item(nextElem);
            }
            childName = child.getLocalName();
        } else {
            this.subject = null;
        }
        if (childName != null && childName.equals(ASSERTION_CONDITIONS)) {
            this.conditions = factory.createConditions((Element)child);
            if (++nextElem >= numOfNodes) {
                return;
            }
            child = nodes.item(nextElem);
            while (child.getNodeType() != 1) {
                if (++nextElem >= numOfNodes) {
                    return;
                }
                child = nodes.item(nextElem);
            }
            childName = child.getLocalName();
        } else {
            this.conditions = null;
        }
        if (childName != null && childName.equals(ASSERTION_ADVICE)) {
            this.advice = factory.createAdvice((Element)child);
            ++nextElem;
        } else {
            this.advice = null;
        }
        while (nextElem < numOfNodes) {
            child = nodes.item(nextElem);
            if (child.getNodeType() == 1 && (childName = child.getLocalName()) != null) {
                if (childName.equals(ASSERTION_AUTHNSTATEMENT)) {
                    this.authnStatements.add(factory.createAuthnStatement((Element)child));
                } else if (childName.equals(ASSERTION_AUTHZDECISIONSTATEMENT)) {
                    this.authzDecisionStatements.add(factory.createAuthzDecisionStatement((Element)child));
                } else if (childName.equals(ASSERTION_ATTRIBUTESTATEMENT)) {
                    this.attributeStatements.add(factory.createAttributeStatement((Element)child));
                } else if (childName != null && childName.equals(ASSERTION_SIGNATURE)) {
                    this.signature = XMLUtils.print((Node)((Element)child));
                } else {
                    String type = ((Element)child).getAttribute(XSI_TYPE_ATTR);
                    if (childName.equals(ASSERTION_STATEMENT) && type != null && type.length() > 0) {
                        this.statements.add(XMLUtils.print((Node)((Element)child)));
                    } else {
                        SAML2SDKUtils.debug.error("AssertionImpl.processElement(): unexpected subelement " + childName);
                        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
                    }
                }
            }
            ++nextElem;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.version = version;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date issueInstant) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issueInstant = issueInstant;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.subject = subject;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(Advice advice) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.advice = advice;
    }

    public String getSignature() {
        return this.signature;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.conditions = conditions;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.id = id;
    }

    public List getStatements() {
        return this.statements;
    }

    public List getAuthnStatements() {
        return this.authnStatements;
    }

    public List getAuthzDecisionStatements() {
        return this.authzDecisionStatements;
    }

    public List getAttributeStatements() {
        return this.attributeStatements;
    }

    public void setStatements(List statements) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statements = statements;
    }

    public void setAuthnStatements(List statements) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authnStatements = statements;
    }

    public void setAuthzDecisionStatements(List statements) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.authzDecisionStatements = statements;
    }

    public void setAttributeStatements(List statements) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.attributeStatements = statements;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer issuer) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issuer = issuer;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    public boolean isSignatureValid(X509Certificate senderCert) throws SAML2Exception {
        if (this.isSignatureValid == null) {
            if (this.signedXMLString == null) {
                this.signedXMLString = this.toXMLString(true, true);
            }
            this.isSignatureValid = SigManager.getSigInstance().verify(this.signedXMLString, this.getID(), senderCert);
        }
        return this.isSignatureValid;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SAML2Exception {
        Element signatureElement = SigManager.getSigInstance().sign(this.toXMLString(true, true), this.getID(), privateKey, cert);
        this.signature = XMLUtils.print((Node)signatureElement);
        this.signedXMLString = XMLUtils.print((Node)signatureElement.getOwnerDocument().getDocumentElement(), (String)"UTF-8");
        this.makeImmutable();
    }

    public EncryptedAssertion encrypt(Key recipientPublicKey, String dataEncAlgorithm, int dataEncStrength, String recipientEntityID) throws SAML2Exception {
        Element el = EncManager.getEncInstance().encrypt(this.toXMLString(true, true), recipientPublicKey, dataEncAlgorithm, dataEncStrength, recipientEntityID, "EncryptedAssertion");
        return AssertionFactory.getInstance().createEncryptedAssertion(el);
    }

    public boolean isTimeValid() {
        if (this.conditions == null) {
            return true;
        }
        return this.conditions.checkDateValidity(System.currentTimeMillis());
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        Statement st;
        int i;
        if (this.signature != null && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(ASSERTION_ELEMENT).append(NS);
        if (this.version == null || this.version.length() == 0) {
            SAML2SDKUtils.debug.error("AssertionImpl.toXMLString(): version missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_assertion_version"));
        }
        sb.append(" ").append(ASSERTION_VERSION_ATTR).append("=\"").append(this.version).append("\"");
        if (this.id == null || this.id.length() == 0) {
            SAML2SDKUtils.debug.error("AssertionImpl.toXMLString(): assertion id missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_assertion_id"));
        }
        sb.append(" ").append(ASSERTION_ID_ATTR).append("=\"").append(this.id).append("\"");
        if (this.issueInstant == null) {
            SAML2SDKUtils.debug.error("AssertionImpl.toXMLString(): issue instant missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_issue_instant"));
        }
        String instantStr = DateUtils.toUTCDateFormat((Date)this.issueInstant);
        sb.append(" ").append(ASSERTION_ISSUEINSTANT_ATTR).append("=\"").append(instantStr).append("\"").append(">\n");
        if (this.issuer == null) {
            SAML2SDKUtils.debug.error("AssertionImpl.toXMLString(): issuer missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelement_issuer"));
        }
        sb.append(this.issuer.toXMLString(includeNSPrefix, false));
        if (this.signature != null) {
            sb.append(this.signature);
        }
        if (this.subject != null) {
            sb.append(this.subject.toXMLString(includeNSPrefix, false));
        }
        if (this.conditions != null) {
            sb.append(this.conditions.toXMLString(includeNSPrefix, false));
        }
        if (this.advice != null) {
            sb.append(this.advice.toXMLString(includeNSPrefix, false));
        }
        int length = 0;
        if (this.statements != null) {
            length = this.statements.size();
            for (i = 0; i < length; ++i) {
                String str = (String)this.statements.get(i);
                sb.append(str);
            }
        }
        if (this.authnStatements != null) {
            length = this.authnStatements.size();
            for (i = 0; i < length; ++i) {
                st = (AuthnStatement)this.authnStatements.get(i);
                sb.append(st.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.authzDecisionStatements != null) {
            length = this.authzDecisionStatements.size();
            for (i = 0; i < length; ++i) {
                st = (AuthzDecisionStatement)this.authzDecisionStatements.get(i);
                sb.append(st.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.attributeStatements != null) {
            length = this.attributeStatements.size();
            for (i = 0; i < length; ++i) {
                st = (AttributeStatement)this.attributeStatements.get(i);
                sb.append(st.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(appendNS).append(ASSERTION_ELEMENT).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            int i;
            int length;
            if (this.authnStatements != null) {
                length = this.authnStatements.size();
                for (i = 0; i < length; ++i) {
                    AuthnStatement authn = (AuthnStatement)this.authnStatements.get(i);
                    authn.makeImmutable();
                }
                this.authnStatements = Collections.unmodifiableList(this.authnStatements);
            }
            if (this.authzDecisionStatements != null) {
                length = this.authzDecisionStatements.size();
                for (i = 0; i < length; ++i) {
                    AuthzDecisionStatement authz = (AuthzDecisionStatement)this.authzDecisionStatements.get(i);
                    authz.makeImmutable();
                }
                this.authzDecisionStatements = Collections.unmodifiableList(this.authzDecisionStatements);
            }
            if (this.attributeStatements != null) {
                length = this.attributeStatements.size();
                for (i = 0; i < length; ++i) {
                    AttributeStatement attr = (AttributeStatement)this.attributeStatements.get(i);
                    attr.makeImmutable();
                }
                this.attributeStatements = Collections.unmodifiableList(this.attributeStatements);
            }
            if (this.statements != null) {
                this.statements = Collections.unmodifiableList(this.statements);
            }
            if (this.conditions != null) {
                this.conditions.makeImmutable();
            }
            if (this.issuer != null) {
                this.issuer.makeImmutable();
            }
            if (this.subject != null) {
                this.subject.makeImmutable();
            }
            if (this.advice != null) {
                this.advice.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

