/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SAML2ConfigService
implements ConfigurationListener {
    static final String CONFIG_NAME = "SAML2_CONFIG";
    static final String SERVICE_NAME = "sunFAMSAML2Configuration";
    static Debug debug = Debug.getInstance((String)"libSAML2");
    static ConfigurationInstance ci = null;
    static final String SAML2_FAILOVER_ATTR = "failOverEnabled";
    static final String SAML2_BUFFER_LENGTH = "bufferLength";
    private static Map attributes = new HashMap();

    private SAML2ConfigService() {
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (debug.messageEnabled()) {
            debug.message("SAML2ConfigService: configChanged");
        }
        SAML2ConfigService.setValues();
    }

    private static void setValues() {
        String classMethod = "SAML2ConfigService.setValues:";
        if (ci == null) {
            attributes.put(SAML2_FAILOVER_ATTR, "false");
            attributes.put(SAML2_BUFFER_LENGTH, "2048");
        } else {
            Map attrMap = null;
            try {
                attrMap = ci.getConfiguration(null, null);
            }
            catch (ConfigurationException ce) {
                debug.error(classMethod, (Throwable)((Object)ce));
                return;
            }
            attributes.clear();
            if (attrMap != null) {
                Set values = (Set)attrMap.get(SAML2_FAILOVER_ATTR);
                String value = "false";
                if (values != null && values.size() == 1) {
                    value = (String)values.iterator().next();
                }
                attributes.put(SAML2_FAILOVER_ATTR, value);
                values = (Set)attrMap.get(SAML2_BUFFER_LENGTH);
                value = "2048";
                if (values != null && values.size() == 1) {
                    value = (String)values.iterator().next();
                }
                attributes.put(SAML2_BUFFER_LENGTH, value);
            }
        }
    }

    public static synchronized Object getAttribute(String attributeName) {
        return attributes.get(attributeName);
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance(CONFIG_NAME);
            ci.addListener(new SAML2ConfigService());
            SAML2ConfigService.setValues();
        }
        catch (ConfigurationException ce) {
            debug.error("SAML2ConfigService.static:", (Throwable)((Object)ce));
        }
    }
}

