/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.meta;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.saml2.jaxb.entityconfig.AffiliationConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.AttributeAuthorityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.AttributeQueryConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.AuthnAuthorityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.XACMLAuthzDecisionQueryConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.XACMLPDPConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.AttributeAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.AuthnAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLAuthzDecisionQueryDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.XACMLPDPDescriptorElement;
import com.sun.identity.saml2.jaxb.metadataextquery.AttributeQueryDescriptorElement;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaCache;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaServiceListener;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class SAML2MetaManager {
    private static final String ATTR_METADATA = "sun-fm-saml2-metadata";
    private static final String ATTR_ENTITY_CONFIG = "sun-fm-saml2-entityconfig";
    private static final String SUBCONFIG_ID = "EntityDescriptor";
    private static final int SUBCONFIG_PRIORITY = 0;
    private static Debug debug = SAML2MetaUtils.debug;
    private static CircleOfTrustManager cotm;
    private static ConfigurationInstance configInst;
    private static final String SAML2 = "SAML2";
    public static final String NAME_META_ALIAS_IN_URI = "metaAlias";

    public SAML2MetaManager() throws SAML2MetaException {
        if (configInst == null) {
            throw new SAML2MetaException("null_config", null);
        }
    }

    public EntityDescriptorElement getEntityDescriptor(String realm, String entityId) throws SAML2MetaException {
        if (entityId == null) {
            return null;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        EntityDescriptorElement descriptor = SAML2MetaCache.getEntityDescriptor(realm, entityId);
        if (descriptor != null) {
            LogUtil.access(Level.FINE, "GOT_ENTITY_DESCRIPTOR", (String[])objs, null);
            return descriptor;
        }
        try {
            Map attrs = configInst.getConfiguration(realm, entityId);
            if (attrs == null) {
                return null;
            }
            Set values = (Set)attrs.get(ATTR_METADATA);
            if (values == null || values.isEmpty()) {
                return null;
            }
            String value = (String)values.iterator().next();
            Object obj = SAML2MetaUtils.convertStringToJAXB(value);
            if (obj instanceof EntityDescriptorElement) {
                descriptor = (EntityDescriptorElement)obj;
                SAML2MetaCache.putEntityDescriptor(realm, entityId, descriptor);
                LogUtil.access(Level.FINE, "GOT_ENTITY_DESCRIPTOR", (String[])objs, null);
                return descriptor;
            }
            debug.error("SAML2MetaManager.getEntityDescriptor: invalid descriptor");
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new SAML2MetaException("invalid_descriptor", objs);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getEntityDescriptor", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ENTITY_DESCRIPTOR", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("SAML2MetaManager.getEntityDescriptor", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new SAML2MetaException("invalid_descriptor", objs);
        }
    }

    public SPSSODescriptorElement getSPSSODescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getSPSSODescriptor(eDescriptor);
    }

    public AttributeAuthorityDescriptorElement getAttributeAuthorityDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getAttributeAuthorityDescriptor(eDescriptor);
    }

    public AttributeQueryDescriptorElement getAttributeQueryDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getAttributeQueryDescriptor(eDescriptor);
    }

    public AuthnAuthorityDescriptorElement getAuthnAuthorityDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getAuthnAuthorityDescriptor(eDescriptor);
    }

    public XACMLPDPDescriptorElement getPolicyDecisionPointDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getPolicyDecisionPointDescriptor(eDescriptor);
    }

    public XACMLAuthzDecisionQueryDescriptorElement getPolicyEnforcementPointDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getPolicyEnforcementPointDescriptor(eDescriptor);
    }

    public IDPSSODescriptorElement getIDPSSODescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return SAML2MetaUtils.getIDPSSODescriptor(eDescriptor);
    }

    public AffiliationDescriptorType getAffiliationDescriptor(String realm, String entityId) throws SAML2MetaException {
        EntityDescriptorElement eDescriptor = this.getEntityDescriptor(realm, entityId);
        return eDescriptor == null ? null : eDescriptor.getAffiliationDescriptor();
    }

    public void setEntityDescriptor(String realm, EntityDescriptorElement descriptor) throws SAML2MetaException {
        String entityId = descriptor.getEntityID();
        if (entityId == null) {
            debug.error("SAML2MetaManager.setEntityDescriptor: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_SET_ENTITY_DESCRIPTOR", data, null);
            throw new SAML2MetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        try {
            Map attrs = SAML2MetaUtils.convertJAXBToAttrMap(ATTR_METADATA, descriptor);
            Map oldAttrs = configInst.getConfiguration(realm, entityId);
            oldAttrs.put(ATTR_METADATA, attrs.get(ATTR_METADATA));
            configInst.setConfiguration(realm, entityId, oldAttrs);
            LogUtil.access(Level.INFO, "SET_ENTITY_DESCRIPTOR", (String[])objs, null);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.setEntityDescriptor:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_SET_ENTITY_DESCRIPTOR", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("SAML2MetaManager.setEntityDescriptor:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "SET_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new SAML2MetaException("invalid_descriptor", objs);
        }
    }

    public void createEntityDescriptor(String realm, EntityDescriptorElement descriptor) throws SAML2MetaException {
        String entityId = descriptor.getEntityID();
        if (entityId == null) {
            debug.error("SAML2MetaManager.createEntityDescriptor: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_CREATE_ENTITY_DESCRIPTOR", data, null);
            throw new SAML2MetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        EntityDescriptorElement entityDescriptor = this.getEntityDescriptor(realm, entityId);
        if (entityDescriptor != null) {
            List currentRoles = entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
            Set currentRolesTypes = SAML2MetaManager.getEntityRolesTypes(currentRoles);
            List newRoles = descriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
            Iterator i = newRoles.iterator();
            while (i.hasNext()) {
                Object role = i.next();
                if (currentRolesTypes.contains(role.getClass().getName())) {
                    String[] data = new String[]{entityId, realm};
                    LogUtil.error(Level.INFO, "SET_ENTITY_DESCRIPTOR", data, null);
                    Object[] param = new String[]{entityId};
                    throw new SAML2MetaException("role_already_exists", param);
                }
                currentRoles.add(role);
            }
            this.setEntityDescriptor(realm, entityDescriptor);
        } else {
            try {
                Map attrs = SAML2MetaUtils.convertJAXBToAttrMap(ATTR_METADATA, descriptor);
                configInst.createConfiguration(realm, entityId, attrs);
                LogUtil.access(Level.INFO, "ENTITY_DESCRIPTOR_CREATED", (String[])objs, null);
            }
            catch (ConfigurationException e) {
                debug.error("SAML2MetaManager.createEntityDescriptor:", (Throwable)((Object)e));
                String[] data = new String[]{e.getMessage(), entityId, realm};
                LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_ENTITY_DESCRIPTOR", data, null);
                throw new SAML2MetaException((Throwable)((Object)e));
            }
            catch (JAXBException jaxbe) {
                debug.error("SAML2MetaManager.createEntityDescriptor:", (Throwable)jaxbe);
                LogUtil.error(Level.INFO, "CREATE_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
                throw new SAML2MetaException("invalid_descriptor", objs);
            }
        }
    }

    private static Set getEntityRolesTypes(Collection roles) {
        HashSet<String> types = new HashSet<String>();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            types.add(o.getClass().getName());
        }
        return types;
    }

    public void deleteEntityDescriptor(String realm, String entityId) throws SAML2MetaException {
        if (entityId == null) {
            return;
        }
        if (realm == null) {
            realm = "/";
        }
        String[] objs = new String[]{entityId, realm};
        try {
            XACMLPDPConfigElement pdpConfig;
            XACMLAuthzDecisionQueryConfigElement pepConfig;
            SPSSOConfigElement spconfig;
            IDPSSOConfigElement idpconfig = this.getIDPSSOConfig(realm, entityId);
            if (idpconfig != null) {
                this.removeFromCircleOfTrust(idpconfig, realm, entityId);
            }
            if ((spconfig = this.getSPSSOConfig(realm, entityId)) != null) {
                this.removeFromCircleOfTrust(spconfig, realm, entityId);
            }
            if ((pepConfig = this.getPolicyEnforcementPointConfig(realm, entityId)) != null) {
                this.removeFromCircleOfTrust(pepConfig, realm, entityId);
            }
            if ((pdpConfig = this.getPolicyDecisionPointConfig(realm, entityId)) != null) {
                this.removeFromCircleOfTrust(pdpConfig, realm, entityId);
            }
            configInst.deleteConfiguration(realm, entityId, null);
            LogUtil.access(Level.INFO, "ENTITY_DESCRIPTOR_DELETED", objs, null);
            SAML2MetaCache.putEntityDescriptor(realm, entityId, null);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.deleteEntityDescriptor:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_DELETE_ENTITY_DESCRIPTOR", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
    }

    public EntityConfigElement getEntityConfig(String realm, String entityId) throws SAML2MetaException {
        if (entityId == null) {
            return null;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        EntityConfigElement config = SAML2MetaCache.getEntityConfig(realm, entityId);
        if (config != null) {
            LogUtil.access(Level.FINE, "GOT_ENTITY_CONFIG", (String[])objs, null);
            return config;
        }
        try {
            Map attrs = configInst.getConfiguration(realm, entityId);
            if (attrs == null) {
                return null;
            }
            Set values = (Set)attrs.get(ATTR_ENTITY_CONFIG);
            if (values == null || values.isEmpty()) {
                return null;
            }
            String value = (String)values.iterator().next();
            Object obj = SAML2MetaUtils.convertStringToJAXB(value);
            if (obj instanceof EntityConfigElement) {
                config = (EntityConfigElement)obj;
                SAML2MetaCache.putEntityConfig(realm, entityId, config);
                LogUtil.access(Level.FINE, "GOT_ENTITY_CONFIG", (String[])objs, null);
                return config;
            }
            debug.error("SAML2MetaManager.getEntityConfig: invalid config");
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new SAML2MetaException("invalid_config", objs);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("SAML2MetaManager.getEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new SAML2MetaException("invalid_config", objs);
        }
    }

    public SPSSOConfigElement getSPSSOConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof SPSSOConfigElement)) continue;
            return (SPSSOConfigElement)obj;
        }
        return null;
    }

    public XACMLPDPConfigElement getPolicyDecisionPointConfig(String realm, String entityId) throws SAML2MetaException {
        XACMLPDPConfigElement elm = null;
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig != null) {
            List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
            Iterator i = list.iterator();
            while (i.hasNext() && elm == null) {
                Object obj = i.next();
                if (!(obj instanceof XACMLPDPConfigElement)) continue;
                elm = (XACMLPDPConfigElement)obj;
            }
        }
        return elm;
    }

    public XACMLAuthzDecisionQueryConfigElement getPolicyEnforcementPointConfig(String realm, String entityId) throws SAML2MetaException {
        XACMLAuthzDecisionQueryConfigElement elm = null;
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig != null) {
            List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
            Iterator i = list.iterator();
            while (i.hasNext() && elm == null) {
                Object obj = i.next();
                if (!(obj instanceof XACMLAuthzDecisionQueryConfigElement)) continue;
                elm = (XACMLAuthzDecisionQueryConfigElement)obj;
            }
        }
        return elm;
    }

    public IDPSSOConfigElement getIDPSSOConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof IDPSSOConfigElement)) continue;
            return (IDPSSOConfigElement)obj;
        }
        return null;
    }

    public AttributeAuthorityConfigElement getAttributeAuthorityConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof AttributeAuthorityConfigElement)) continue;
            return (AttributeAuthorityConfigElement)obj;
        }
        return null;
    }

    public AttributeQueryConfigElement getAttributeQueryConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof AttributeQueryConfigElement)) continue;
            return (AttributeQueryConfigElement)obj;
        }
        return null;
    }

    public AuthnAuthorityConfigElement getAuthnAuthorityConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof AuthnAuthorityConfigElement)) continue;
            return (AuthnAuthorityConfigElement)obj;
        }
        return null;
    }

    public AffiliationConfigElement getAffiliationConfig(String realm, String entityId) throws SAML2MetaException {
        EntityConfigElement eConfig = this.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            return null;
        }
        return (AffiliationConfigElement)eConfig.getAffiliationConfig();
    }

    public void setEntityConfig(String realm, EntityConfigElement config) throws SAML2MetaException {
        String entityId = config.getEntityID();
        if (entityId == null) {
            debug.error("SAML2MetaManager.setEntityConfig: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_SET_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        try {
            Map attrs = SAML2MetaUtils.convertJAXBToAttrMap(ATTR_ENTITY_CONFIG, config);
            Map oldAttrs = configInst.getConfiguration(realm, entityId);
            oldAttrs.put(ATTR_ENTITY_CONFIG, attrs.get(ATTR_ENTITY_CONFIG));
            configInst.setConfiguration(realm, entityId, oldAttrs);
            LogUtil.access(Level.INFO, "SET_ENTITY_CONFIG", (String[])objs, null);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.setEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_SET_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("SAML2MetaManager.setEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "SET_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new SAML2MetaException("invalid_config", objs);
        }
    }

    public void createEntityConfig(String realm, EntityConfigElement config) throws SAML2MetaException {
        String entityId = config.getEntityID();
        if (entityId == null) {
            debug.error("SAML2MetaManager.createEntityConfig: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_CREATE_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        try {
            IDPSSOConfigElement idpconfig;
            Map attrs = SAML2MetaUtils.convertJAXBToAttrMap(ATTR_ENTITY_CONFIG, config);
            Map oldAttrs = configInst.getConfiguration(realm, entityId);
            if (oldAttrs == null) {
                LogUtil.error(Level.INFO, "NO_ENTITY_DESCRIPTOR_CREATE_ENTITY_CONFIG", (String[])objs, null);
                throw new SAML2MetaException("entity_descriptor_not_exist", objs);
            }
            Set oldValues = (Set)oldAttrs.get(ATTR_ENTITY_CONFIG);
            if (oldValues != null && !oldValues.isEmpty()) {
                LogUtil.error(Level.INFO, "ENTITY_CONFIG_EXISTS", (String[])objs, null);
                throw new SAML2MetaException("entity_config_exists", objs);
            }
            configInst.setConfiguration(realm, entityId, attrs);
            LogUtil.access(Level.INFO, "ENTITY_CONFIG_CREATED", (String[])objs, null);
            SPSSOConfigElement spconfig = this.getSPSSOConfig(realm, entityId);
            if (spconfig != null) {
                this.addToCircleOfTrust(spconfig, realm, entityId);
            }
            if ((idpconfig = this.getIDPSSOConfig(realm, entityId)) != null) {
                this.addToCircleOfTrust(idpconfig, realm, entityId);
            }
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.createEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("SAML2MetaManager.createEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "CREATE_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new SAML2MetaException("invalid_config", objs);
        }
    }

    private void addToCircleOfTrust(BaseConfigType config, String realm, String entityId) {
        try {
            Map attr;
            List cotAttr;
            ArrayList cotList;
            if (config != null && (cotList = new ArrayList(cotAttr = (List)(attr = SAML2MetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String cotName = ((String)iter.next()).trim();
                    if (cotName == null || cotName.equals("")) continue;
                    cotm.addCircleOfTrustMember(realm, cotName, "saml2", entityId);
                }
            }
        }
        catch (Exception e) {
            debug.error("SAML2MetaManager.addToCircleOfTrust:Error while adding entity" + entityId + "to COT.", (Throwable)e);
        }
    }

    public void deleteEntityConfig(String realm, String entityId) throws SAML2MetaException {
        if (entityId == null) {
            return;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        try {
            SPSSOConfigElement spconfig;
            Map oldAttrs = configInst.getConfiguration(realm, entityId);
            Set oldValues = (Set)oldAttrs.get(ATTR_ENTITY_CONFIG);
            if (oldValues == null || oldValues.isEmpty()) {
                LogUtil.error(Level.INFO, "NO_ENTITY_DESCRIPTOR_DELETE_ENTITY_CONFIG", (String[])objs, null);
                throw new SAML2MetaException("entity_config_not_exist", objs);
            }
            IDPSSOConfigElement idpconfig = this.getIDPSSOConfig(realm, entityId);
            if (idpconfig != null) {
                this.removeFromCircleOfTrust(idpconfig, realm, entityId);
            }
            if ((spconfig = this.getSPSSOConfig(realm, entityId)) != null) {
                this.removeFromCircleOfTrust(spconfig, realm, entityId);
            }
            HashSet<String> attr = new HashSet<String>();
            attr.add(ATTR_ENTITY_CONFIG);
            configInst.deleteConfiguration(realm, entityId, attr);
            LogUtil.access(Level.INFO, "ENTITY_CONFIG_DELETED", (String[])objs, null);
            SAML2MetaCache.putEntityConfig(realm, entityId, null);
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.deleteEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_DELETE_ENTITY_CONFIG", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
    }

    private void removeFromCircleOfTrust(BaseConfigType config, String realm, String entityId) {
        try {
            Map attr;
            List cotAttr;
            ArrayList cotList;
            if (config != null && (cotList = new ArrayList(cotAttr = (List)(attr = SAML2MetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String cotName = ((String)iter.next()).trim();
                    if (cotName == null || cotName.equals("")) continue;
                    cotm.removeCircleOfTrustMember(realm, cotName, "saml2", entityId);
                }
            }
        }
        catch (Exception e) {
            debug.error("SAML2MetaManager.removeFromCircleOfTrust:Error while removing entity" + entityId + "from COT.", (Throwable)e);
        }
    }

    public List getAllHostedEntities(String realm) throws SAML2MetaException {
        ArrayList<String> hostedEntityIds = new ArrayList<String>();
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                Iterator iter = entityIds.iterator();
                while (iter.hasNext()) {
                    String entityId = (String)iter.next();
                    EntityConfigElement config = this.getEntityConfig(realm, entityId);
                    if (config == null || !config.isHosted()) continue;
                    hostedEntityIds.add(entityId);
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getAllHostedEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_HOSTED_ENTITIES", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        String[] objs = new String[]{realm};
        LogUtil.access(Level.FINE, "GOT_ALL_HOSTED_ENTITIES", objs, null);
        return hostedEntityIds;
    }

    public List getAllHostedServiceProviderEntities(String realm) throws SAML2MetaException {
        ArrayList<String> hostedSPEntityIds = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedEntities(realm);
        Iterator iter = hostedEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            if (this.getSPSSODescriptor(realm, entityId) == null) continue;
            hostedSPEntityIds.add(entityId);
        }
        return hostedSPEntityIds;
    }

    public List getAllHostedPolicyDecisionPointEntities(String realm) throws SAML2MetaException {
        return this.getHostedPolicyDecisionPointEntities(realm, true);
    }

    public List getAllRemotePolicyDecisionPointEntities(String realm) throws SAML2MetaException {
        return this.getHostedPolicyDecisionPointEntities(realm, false);
    }

    private List getHostedPolicyDecisionPointEntities(String realm, boolean hosted) throws SAML2MetaException {
        ArrayList<String> hostedPDPEntityIds = new ArrayList<String>();
        List hostedEntityIds = hosted ? this.getAllHostedEntities(realm) : this.getAllRemoteEntities(realm);
        Iterator i = hostedEntityIds.iterator();
        while (i.hasNext()) {
            String entityId = (String)i.next();
            if (this.getPolicyDecisionPointDescriptor(realm, entityId) == null) continue;
            hostedPDPEntityIds.add(entityId);
        }
        return hostedPDPEntityIds;
    }

    public List getAllHostedPolicyEnforcementPointEntities(String realm) throws SAML2MetaException {
        return this.getAllPolicyEnforcementPointEntities(realm, true);
    }

    public List getAllRemotePolicyEnforcementPointEntities(String realm) throws SAML2MetaException {
        return this.getAllPolicyEnforcementPointEntities(realm, false);
    }

    private List getAllPolicyEnforcementPointEntities(String realm, boolean hosted) throws SAML2MetaException {
        ArrayList<String> hostedPEPEntityIds = new ArrayList<String>();
        List hostedEntityIds = hosted ? this.getAllHostedEntities(realm) : this.getAllRemoteEntities(realm);
        Iterator i = hostedEntityIds.iterator();
        while (i.hasNext()) {
            String entityId = (String)i.next();
            if (this.getPolicyEnforcementPointDescriptor(realm, entityId) == null) continue;
            hostedPEPEntityIds.add(entityId);
        }
        return hostedPEPEntityIds;
    }

    public List getAllHostedIdentityProviderEntities(String realm) throws SAML2MetaException {
        ArrayList<String> hostedIDPEntityIds = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedEntities(realm);
        Iterator iter = hostedEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            if (this.getIDPSSODescriptor(realm, entityId) == null) continue;
            hostedIDPEntityIds.add(entityId);
        }
        return hostedIDPEntityIds;
    }

    public List getAllRemoteEntities(String realm) throws SAML2MetaException {
        ArrayList<String> remoteEntityIds = new ArrayList<String>();
        String[] objs = new String[]{realm};
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                Iterator iter = entityIds.iterator();
                while (iter.hasNext()) {
                    String entityId = (String)iter.next();
                    EntityConfigElement config = this.getEntityConfig(realm, entityId);
                    if (config != null && config.isHosted()) continue;
                    remoteEntityIds.add(entityId);
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getAllRemoteEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_REMOTE_ENTITIES", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        LogUtil.access(Level.FINE, "GOT_ALL_REMOTE_ENTITIES", objs, null);
        return remoteEntityIds;
    }

    public List getAllRemoteServiceProviderEntities(String realm) throws SAML2MetaException {
        ArrayList<String> remoteSPEntityIds = new ArrayList<String>();
        List remoteEntityIds = this.getAllRemoteEntities(realm);
        Iterator iter = remoteEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            if (this.getSPSSODescriptor(realm, entityId) == null) continue;
            remoteSPEntityIds.add(entityId);
        }
        return remoteSPEntityIds;
    }

    public List getAllRemoteIdentityProviderEntities(String realm) throws SAML2MetaException {
        ArrayList<String> remoteIDPEntityIds = new ArrayList<String>();
        List remoteEntityIds = this.getAllRemoteEntities(realm);
        Iterator iter = remoteEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            if (this.getIDPSSODescriptor(realm, entityId) == null) continue;
            remoteIDPEntityIds.add(entityId);
        }
        return remoteIDPEntityIds;
    }

    public String getEntityByMetaAlias(String metaAlias) throws SAML2MetaException {
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds == null || entityIds.isEmpty()) {
                return null;
            }
            Iterator iter = entityIds.iterator();
            while (iter.hasNext()) {
                String entityId = (String)iter.next();
                EntityConfigElement config = this.getEntityConfig(realm, entityId);
                if (config == null) continue;
                List list = config.getIDPSSOConfigOrSPSSOConfigOrAuthnAuthorityConfig();
                Iterator iter2 = list.iterator();
                while (iter2.hasNext()) {
                    BaseConfigType bConfig = (BaseConfigType)iter2.next();
                    String cMetaAlias = bConfig.getMetaAlias();
                    if (cMetaAlias == null || !cMetaAlias.equals(metaAlias)) continue;
                    return entityId;
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getEntityByMetaAlias:", (Throwable)((Object)e));
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        return null;
    }

    public String getRoleByMetaAlias(String metaAlias) throws SAML2MetaException {
        String role = "UNKNOWN";
        String entityId = this.getEntityByMetaAlias(metaAlias);
        if (entityId != null) {
            String m;
            String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
            IDPSSOConfigElement idpConfig = this.getIDPSSOConfig(realm, entityId);
            SPSSOConfigElement spConfig = this.getSPSSOConfig(realm, entityId);
            XACMLPDPConfigElement pdpConfig = this.getPolicyDecisionPointConfig(realm, entityId);
            XACMLAuthzDecisionQueryConfigElement pepConfig = this.getPolicyEnforcementPointConfig(realm, entityId);
            if (idpConfig != null) {
                String m2 = idpConfig.getMetaAlias();
                if (m2 != null && m2.equals(metaAlias)) {
                    role = "IDPRole";
                }
            } else if (spConfig != null) {
                String m3 = spConfig.getMetaAlias();
                if (m3 != null && m3.equals(metaAlias)) {
                    role = "SPRole";
                }
            } else if (pdpConfig != null) {
                String m4 = pdpConfig.getMetaAlias();
                if (m4 != null && m4.equals(metaAlias)) {
                    role = "PDPRole";
                }
            } else if (pepConfig != null && (m = pepConfig.getMetaAlias()) != null && m.equals(metaAlias)) {
                role = "PEPRole";
            }
        }
        return role;
    }

    public List getAllHostedIdentityProviderMetaAliases(String realm) throws SAML2MetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        IDPSSOConfigElement idpConfig = null;
        List hostedEntityIds = this.getAllHostedIdentityProviderEntities(realm);
        Iterator iter = hostedEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            idpConfig = this.getIDPSSOConfig(realm, entityId);
            if (idpConfig == null) continue;
            metaAliases.add(idpConfig.getMetaAlias());
        }
        return metaAliases;
    }

    public List getAllHostedServiceProviderMetaAliases(String realm) throws SAML2MetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        SPSSOConfigElement spConfig = null;
        List hostedEntityIds = this.getAllHostedServiceProviderEntities(realm);
        Iterator iter = hostedEntityIds.iterator();
        while (iter.hasNext()) {
            String entityId = (String)iter.next();
            spConfig = this.getSPSSOConfig(realm, entityId);
            if (spConfig == null) continue;
            metaAliases.add(spConfig.getMetaAlias());
        }
        return metaAliases;
    }

    public List getAllHostedPolicyDecisionPointMetaAliases(String realm) throws SAML2MetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedPolicyDecisionPointEntities(realm);
        Iterator i = hostedEntityIds.iterator();
        while (i.hasNext()) {
            String entityId = (String)i.next();
            XACMLPDPConfigElement elm = this.getPolicyDecisionPointConfig(realm, entityId);
            if (elm == null) continue;
            metaAliases.add(elm.getMetaAlias());
        }
        return metaAliases;
    }

    public List getAllHostedPolicyEnforcementPointMetaAliases(String realm) throws SAML2MetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        List hostedEntityIds = this.getAllHostedPolicyEnforcementPointEntities(realm);
        Iterator i = hostedEntityIds.iterator();
        while (i.hasNext()) {
            String entityId = (String)i.next();
            XACMLAuthzDecisionQueryConfigElement elm = this.getPolicyEnforcementPointConfig(realm, entityId);
            if (elm == null) continue;
            metaAliases.add(elm.getMetaAlias());
        }
        return metaAliases;
    }

    public boolean isTrustedProvider(String realm, String entityId, String trustedEntityId) throws SAML2MetaException {
        boolean result = false;
        SPSSOConfigElement spconfig = this.getSPSSOConfig(realm, entityId);
        if (spconfig != null) {
            result = this.isSameCircleOfTrust(spconfig, realm, trustedEntityId);
        }
        if (result) {
            return true;
        }
        IDPSSOConfigElement idpconfig = this.getIDPSSOConfig(realm, entityId);
        if (idpconfig != null) {
            return this.isSameCircleOfTrust(idpconfig, realm, trustedEntityId);
        }
        return false;
    }

    public boolean isTrustedXACMLProvider(String realm, String entityId, String trustedEntityId, String role) throws SAML2MetaException {
        boolean result = false;
        if (role != null) {
            if (role.equals("PDPRole")) {
                XACMLPDPConfigElement pdpConfig = this.getPolicyDecisionPointConfig(realm, entityId);
                if (pdpConfig != null) {
                    result = this.isSameCircleOfTrust(pdpConfig, realm, trustedEntityId);
                }
            } else if (role.equals("PEPRole")) {
                XACMLAuthzDecisionQueryConfigElement pepConfig = this.getPolicyEnforcementPointConfig(realm, entityId);
                result = this.isSameCircleOfTrust(pepConfig, realm, trustedEntityId);
            }
        }
        return result;
    }

    private boolean isSameCircleOfTrust(BaseConfigType config, String realm, String trustedEntityId) {
        try {
            Map attr;
            List cotList;
            if (config != null && (cotList = (List)(attr = SAML2MetaUtils.getAttributes(config)).get("cotlist")) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String a = (String)iter.next();
                    if (!cotm.isInCircleOfTrust(realm, a, "saml2", trustedEntityId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            debug.error("SAML2MetaManager.isSameCircleOfTrust: Error while determining two entities are in the same COT.");
            return false;
        }
    }

    public Set getAllEntities(String realm) throws SAML2MetaException {
        HashSet ret = new HashSet();
        String[] objs = new String[]{realm};
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                ret.addAll(entityIds);
            }
        }
        catch (ConfigurationException e) {
            debug.error("SAML2MetaManager.getAllEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_ENTITIES", data, null);
            throw new SAML2MetaException((Throwable)((Object)e));
        }
        LogUtil.access(Level.FINE, "GOT_ALL_ENTITIES", objs, null);
        return ret;
    }

    static {
        try {
            configInst = ConfigurationManager.getConfigurationInstance(SAML2);
        }
        catch (ConfigurationException ce) {
            debug.error("SAML2MetaManager constructor:", (Throwable)((Object)ce));
        }
        if (configInst != null) {
            try {
                configInst.addListener(new SAML2MetaServiceListener());
            }
            catch (ConfigurationException ce) {
                debug.error("SAML2MetaManager.static: Unable to add ConfigurationListener for SAML2COT service.", (Throwable)((Object)ce));
            }
        }
        try {
            cotm = new CircleOfTrustManager();
        }
        catch (COTException se) {
            debug.error("SAML2MetaManager constructor:", (Throwable)((Object)se));
        }
    }
}

