/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.assertion.AuthnStatement;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.AuthnAuthorityConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AuthnAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.AuthnQueryServiceElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.plugins.IDPAuthnContextMapper;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.protocol.AuthnQuery;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class AuthnQueryUtil {
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();

    private AuthnQueryUtil() {
    }

    public static Response sendAuthnQuery(AuthnQuery authnQuery, String authnAuthorityEntityID, String realm, String binding) throws SAML2Exception {
        SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();
        AuthnAuthorityDescriptorElement aad = null;
        try {
            aad = metaManager.getAuthnAuthorityDescriptor(realm, authnAuthorityEntityID);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("AttributeService.sendAuthnQuery:", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        if (aad == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("authnAuthorityNotFound"));
        }
        if (binding == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
        }
        String location = null;
        List authnService = aad.getAuthnQueryService();
        Iterator iter = authnService.iterator();
        while (iter.hasNext()) {
            AuthnQueryServiceElement authnService1 = (AuthnQueryServiceElement)iter.next();
            if (!binding.equalsIgnoreCase(authnService1.getBinding())) continue;
            location = authnService1.getLocation();
            break;
        }
        if (location == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
        }
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            AuthnQueryUtil.signAuthnQuery(authnQuery, realm, false);
            return AuthnQueryUtil.sendAuthnQuerySOAP(authnQuery, location, authnAuthorityEntityID, realm, aad);
        }
        throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response processAuthnQuery(AuthnQuery authnQuery, HttpServletRequest request, HttpServletResponse response, String authnAuthorityEntityID, String realm) throws SAML2Exception {
        try {
            AuthnQueryUtil.verifyAuthnQuery(authnQuery, authnAuthorityEntityID, realm);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("AuthnQueryUtil.processAuthnQuery:", (Throwable)((Object)se));
            return SAML2Utils.getErrorResponse(authnQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, se.getMessage(), null);
        }
        Issuer issuer = authnQuery.getIssuer();
        String spEntityID = issuer.getValue();
        AuthnAuthorityDescriptorElement aad = null;
        SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();
        try {
            aad = metaManager.getAuthnAuthorityDescriptor(realm, authnAuthorityEntityID);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("AuthnQueryUtil.processAuthnQuery:", (Throwable)((Object)sme));
            return SAML2Utils.getErrorResponse(authnQuery, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, SAML2Utils.bundle.getString("metaDataError"), null);
        }
        if (aad == null) {
            return SAML2Utils.getErrorResponse(authnQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, SAML2Utils.bundle.getString("authnAuthorityNotFound"), null);
        }
        NameID nameID = AuthnQueryUtil.getNameID(authnQuery.getSubject(), realm, authnAuthorityEntityID);
        if (nameID == null) {
            return SAML2Utils.getErrorResponse(authnQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null, null);
        }
        IDPAccountMapper idpAcctMapper = SAML2Utils.getIDPAccountMapper(realm, authnAuthorityEntityID);
        String userID = idpAcctMapper.getIdentity(nameID, authnAuthorityEntityID, spEntityID, realm);
        if (userID == null) {
            return SAML2Utils.getErrorResponse(authnQuery, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null, null);
        }
        IDPAuthnContextMapper idpAuthnContextMapper = IDPSSOUtil.getIDPAuthnContextMapper(realm, authnAuthorityEntityID);
        ArrayList<Assertion> returnAssertions = new ArrayList<Assertion>();
        String qSessionIndex = authnQuery.getSessionIndex();
        RequestedAuthnContext requestedAC = authnQuery.getRequestedAuthnContext();
        List assertions = (List)IDPCache.assertionCache.get((Object)userID);
        if (assertions != null && !assertions.isEmpty()) {
            List list = assertions;
            synchronized (list) {
                Iterator aIter = assertions.iterator();
                block7: while (aIter.hasNext()) {
                    Assertion assertion = (Assertion)aIter.next();
                    if (AuthnQueryUtil.assertionExpired(assertion)) {
                        if (!SAML2Utils.debug.messageEnabled()) continue;
                        SAML2Utils.debug.message("AuthnQueryUtil.processAuthnQuery:  assertion " + assertion.getID() + " expired.");
                        continue;
                    }
                    List authnStmts = assertion.getAuthnStatements();
                    Iterator asIter = authnStmts.iterator();
                    while (asIter.hasNext()) {
                        AuthnStatement authnStmt = (AuthnStatement)asIter.next();
                        AuthnContext authnStmtAC = authnStmt.getAuthnContext();
                        String sessionIndex = authnStmt.getSessionIndex();
                        String authnStmtACClassRef = authnStmtAC.getAuthnContextClassRef();
                        if (SAML2Utils.debug.messageEnabled()) {
                            SAML2Utils.debug.message("AuthnQueryUtil.processAuthnQuery: authnStmtACClassRef is " + authnStmtACClassRef + ", sessionIndex = " + sessionIndex);
                        }
                        if (qSessionIndex != null && qSessionIndex.length() != 0 && !qSessionIndex.equals(sessionIndex)) continue;
                        if (requestedAC != null) {
                            String comparison;
                            List requestedACClassRefs = requestedAC.getAuthnContextClassRef();
                            if (!idpAuthnContextMapper.isAuthnContextMatching(requestedACClassRefs, authnStmtACClassRef, comparison = requestedAC.getComparison(), realm, authnAuthorityEntityID)) continue;
                            returnAssertions.add(assertion);
                            continue block7;
                        }
                        returnAssertions.add(assertion);
                        continue block7;
                    }
                }
            }
        }
        ProtocolFactory protocolFactory = ProtocolFactory.getInstance();
        Response samlResp = protocolFactory.createResponse();
        if (!returnAssertions.isEmpty()) {
            samlResp.setAssertion(returnAssertions);
        }
        samlResp.setID(SAML2Utils.generateID());
        samlResp.setInResponseTo(authnQuery.getID());
        samlResp.setVersion("2.0");
        samlResp.setIssueInstant(new Date());
        Status status = protocolFactory.createStatus();
        StatusCode statusCode = protocolFactory.createStatusCode();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        samlResp.setStatus(status);
        Issuer respIssuer = AssertionFactory.getInstance().createIssuer();
        respIssuer.setValue(authnAuthorityEntityID);
        samlResp.setIssuer(respIssuer);
        AuthnQueryUtil.signResponse(samlResp, authnAuthorityEntityID, realm, false);
        return samlResp;
    }

    private static void signAuthnQuery(AuthnQuery authnQuery, String realm, boolean includeCert) throws SAML2Exception {
        String spEntityID = authnQuery.getIssuer().getValue();
        String alias = SAML2Utils.getSigningCertAlias(realm, spEntityID, "SPRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        if (signingKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            authnQuery.sign(signingKey, signingCert);
        }
    }

    private static void verifyAuthnQuery(AuthnQuery authnQuery, String authnAuthorityEntityID, String realm) throws SAML2Exception {
        if (!authnQuery.isSigned()) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("authnQueryNotSigned"));
        }
        Issuer issuer = authnQuery.getIssuer();
        String spEntityID = issuer.getValue();
        if (!SAML2Utils.isSourceSiteValid(issuer, realm, authnAuthorityEntityID)) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("authnQueryIssuerInvalid"));
        }
        SPSSODescriptorElement spSSODesc = SAML2Utils.getSAML2MetaManager().getSPSSODescriptor(realm, spEntityID);
        if (spSSODesc == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("authnQueryIssuerNotFound"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(spSSODesc, spEntityID, "SPRole");
        if (signingCert != null) {
            boolean valid = authnQuery.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AuthnQueryUtil.verifyAuthnQuery: Signature validity is : " + valid);
            }
            if (!valid) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureAuthnQuery"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
    }

    private static void signResponse(Response response, String authnAuthorityEntityID, String realm, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, authnAuthorityEntityID, "AuthnAuthRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        if (signingKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            response.sign(signingKey, signingCert);
        }
    }

    private static Response sendAuthnQuerySOAP(AuthnQuery authnQuery, String authnServiceURL, String authnAuthorityEntityID, String realm, AuthnAuthorityDescriptorElement aad) throws SAML2Exception {
        String authnQueryXMLString = authnQuery.toXMLString(true, true);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AuthnQueryUtil.sendAuthnQuerySOAP: authnQueryXMLString = " + authnQueryXMLString);
            SAML2Utils.debug.message("AuthnQueryUtil.sendAuthnQuerySOAP: authnServiceURL= " + authnServiceURL);
        }
        AuthnAuthorityConfigElement config = metaManager.getAuthnAuthorityConfig(realm, authnAuthorityEntityID);
        authnServiceURL = SAML2Utils.fillInBasicAuthInfo(config, authnServiceURL);
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(authnQueryXMLString, authnServiceURL);
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("AuthnQueryUtil.sendAuthnQuerySOAP: ", (Throwable)se);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorSendingAuthnQuery"));
        }
        Element respElem = SAML2Utils.getSamlpElement(resMsg, "Response");
        Response response = ProtocolFactory.getInstance().createResponse(respElem);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AuthnQueryUtil.sendAuthnQuerySOAP: response = " + response.toXMLString(true, true));
        }
        AuthnQueryUtil.verifyResponse(response, authnQuery, authnAuthorityEntityID, realm, aad);
        return response;
    }

    private static void verifyResponse(Response response, AuthnQuery authnQuery, String authnAuthorityEntityID, String realm, AuthnAuthorityDescriptorElement aad) throws SAML2Exception {
        List encAssertions;
        String authnQueryID = authnQuery.getID();
        if (authnQueryID != null && !authnQueryID.equals(response.getInResponseTo())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidInResponseToAuthnQuery"));
        }
        Issuer respIssuer = response.getIssuer();
        if (respIssuer == null) {
            return;
        }
        if (!authnAuthorityEntityID.equals(respIssuer.getValue())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("responseIssuerMismatch"));
        }
        if (!response.isSigned()) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("responseNotSigned"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(aad, authnAuthorityEntityID, "AuthnAuthRole");
        if (signingCert == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        boolean valid = response.isSignatureValid(signingCert);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AuthnQueryUtil.verifyResponse: Signature validity is : " + valid);
        }
        if (!valid) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureOnResponse"));
        }
        String spEntityID = authnQuery.getIssuer().getValue();
        ArrayList<Assertion> assertions = response.getAssertion();
        if (assertions == null && (encAssertions = response.getEncryptedAssertion()) != null && !encAssertions.isEmpty()) {
            String alias = SAML2Utils.getEncryptionCertAlias(realm, spEntityID, "SPRole");
            PrivateKey privateKey = keyProvider.getPrivateKey(alias);
            Iterator iter = encAssertions.iterator();
            while (iter.hasNext()) {
                EncryptedAssertion eAssertion = (EncryptedAssertion)iter.next();
                Assertion assertion = eAssertion.decrypt(privateKey);
                if (assertions == null) {
                    assertions = new ArrayList<Assertion>();
                }
                assertions.add(assertion);
            }
        }
        if (assertions == null || assertions.isEmpty()) {
            return;
        }
        signingCert = KeyUtil.getVerificationCert(aad, authnAuthorityEntityID, "IDPRole");
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            Assertion assertion = (Assertion)iter.next();
            if (!assertion.isSigned()) continue;
            if (signingCert == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
            }
            valid = assertion.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AuthnQueryUtil.verifyResponse: Signature validity is : " + valid);
            }
            if (valid) continue;
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureOnAssertion"));
        }
    }

    private static NameID getNameID(Subject subject, String realm, String authnAuthorityEntityID) {
        NameID nameID = subject.getNameID();
        if (nameID == null) {
            String alias = SAML2Utils.getEncryptionCertAlias(realm, authnAuthorityEntityID, "AuthnAuthRole");
            PrivateKey privateKey = keyProvider.getPrivateKey(alias);
            EncryptedID encryptedID = subject.getEncryptedID();
            try {
                nameID = encryptedID.decrypt(privateKey);
            }
            catch (SAML2Exception ex) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AuthnQueryUtil.getNameID:", (Throwable)((Object)ex));
                }
                return null;
            }
        }
        if (!SAML2Utils.isPersistentNameID(nameID)) {
            return null;
        }
        return nameID;
    }

    private static boolean assertionExpired(Assertion assertion) {
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            return true;
        }
        Date notOnOrAfter = conditions.getNotOnOrAfter();
        if (notOnOrAfter == null) {
            return true;
        }
        return notOnOrAfter.before(new Date());
    }
}

