/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.common.QuerySignatureUtil;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.IDPAuthnContextInfo;
import com.sun.identity.saml2.plugins.IDPAuthnContextMapper;
import com.sun.identity.saml2.plugins.IDPECPSessionMapper;
import com.sun.identity.saml2.profile.CacheObject;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPProxyUtil;
import com.sun.identity.saml2.profile.IDPSSOUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.SPSSOFederate;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPSSOFederate {
    private static final String REQ_ID = "ReqID";

    private IDPSSOFederate() {
    }

    public static void doSSOFederate(HttpServletRequest request, HttpServletResponse response) {
        IDPSSOFederate.doSSOFederate(request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSSOFederate(HttpServletRequest request, HttpServletResponse response, boolean isFromECP) {
        block94: {
            String classMethod = "IDPSSOFederate.doSSOFederate: ";
            Object session = null;
            SPSSODescriptorElement spSSODescriptor = null;
            try {
                String idpMetaAlias = request.getParameter("metaAlias");
                if (idpMetaAlias == null || idpMetaAlias.trim().length() == 0) {
                    idpMetaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
                }
                if (idpMetaAlias == null || idpMetaAlias.trim().length() == 0) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "unable to get IDP meta alias from request.");
                    }
                    IDPSSOFederate.sendError(response, "Client", "IDPMetaAliasNotFound", null, isFromECP);
                    return;
                }
                String idpEntityID = null;
                String realm = null;
                try {
                    if (IDPSSOUtil.metaManager == null) {
                        SAML2Utils.debug.error(classMethod + "Unable to get meta manager.");
                        IDPSSOFederate.sendError(response, "Server", "errorMetaManager", null, isFromECP);
                        return;
                    }
                    idpEntityID = IDPSSOUtil.metaManager.getEntityByMetaAlias(idpMetaAlias);
                    if (idpEntityID == null || idpEntityID.trim().length() == 0) {
                        SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
                        String[] data = new String[]{idpEntityID};
                        LogUtil.error(Level.INFO, "INVALID_IDP", data, null);
                        IDPSSOFederate.sendError(response, "Client", "nullIDPEntityID", null, isFromECP);
                        return;
                    }
                    realm = SAML2MetaUtils.getRealmByMetaAlias(idpMetaAlias);
                }
                catch (SAML2MetaException sme) {
                    SAML2Utils.debug.error(classMethod + "Unable to get IDP Entity ID from meta.");
                    String[] data = new String[]{idpMetaAlias};
                    LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
                    IDPSSOFederate.sendError(response, "Server", "nullIDPEntityID", sme.getMessage(), isFromECP);
                    return;
                }
                String reqID = request.getParameter(REQ_ID);
                if (reqID != null && reqID.trim().length() == 0) {
                    reqID = null;
                }
                AuthnRequest authnReq = null;
                String relayState = null;
                if (reqID == null) {
                    String spEntityID;
                    String binding;
                    block93: {
                        binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
                        if (request.getMethod().equals("POST")) {
                            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
                        }
                        if ((authnReq = IDPSSOFederate.getAuthnRequest(request, isFromECP, binding)) == null) {
                            IDPSSOFederate.sendError(response, "Client", "InvalidSAMLRequest", null, isFromECP);
                            return;
                        }
                        spEntityID = authnReq.getIssuer().getValue();
                        try {
                            String authnRequestStr = authnReq.toXMLString();
                            String[] logdata = new String[]{spEntityID, idpMetaAlias, authnRequestStr};
                            String logId = isFromECP ? "RECEIVED_AUTHN_REQUEST_ECP" : "RECEIVED_AUTHN_REQUEST";
                            LogUtil.access(Level.INFO, logId, logdata, null);
                        }
                        catch (SAML2Exception saml2ex) {
                            SAML2Utils.debug.error(classMethod, (Throwable)((Object)saml2ex));
                            IDPSSOFederate.sendError(response, "Client", "InvalidSAMLRequest", saml2ex.getMessage(), isFromECP);
                            return;
                        }
                        if (!SAML2Utils.isSourceSiteValid(authnReq.getIssuer(), realm, idpEntityID)) {
                            if (SAML2Utils.debug.warningEnabled()) {
                                SAML2Utils.debug.warning(classMethod + "Issuer in Request is not valid.");
                            }
                            IDPSSOFederate.sendError(response, "Client", "InvalidSAMLRequest", null, isFromECP);
                            return;
                        }
                        IDPSSODescriptorElement idpSSODescriptor = null;
                        try {
                            idpSSODescriptor = IDPSSOUtil.metaManager.getIDPSSODescriptor(realm, idpEntityID);
                        }
                        catch (SAML2MetaException sme) {
                            SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
                            idpSSODescriptor = null;
                        }
                        if (idpSSODescriptor == null) {
                            SAML2Utils.debug.error(classMethod + "Unable to get IDP SSO Descriptor from meta.");
                            IDPSSOFederate.sendError(response, "Server", "metaDataError", null, isFromECP);
                            return;
                        }
                        try {
                            spSSODescriptor = IDPSSOUtil.metaManager.getSPSSODescriptor(realm, spEntityID);
                        }
                        catch (SAML2MetaException sme) {
                            SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
                            spSSODescriptor = null;
                        }
                        if (isFromECP || idpSSODescriptor.isWantAuthnRequestsSigned()) {
                            if (spEntityID == null || spEntityID.trim().length() == 0) {
                                IDPSSOFederate.sendError(response, "Client", "InvalidSAMLRequest", null, isFromECP);
                                return;
                            }
                            if (spSSODescriptor == null) {
                                SAML2Utils.debug.error(classMethod + "Unable to get SP SSO Descriptor from meta.");
                                IDPSSOFederate.sendError(response, "Server", "metaDataError", null, isFromECP);
                                return;
                            }
                            X509Certificate spCert = KeyUtil.getVerificationCert(spSSODescriptor, spEntityID, "SPRole");
                            try {
                                boolean isSignatureOK = false;
                                if (isFromECP) {
                                    isSignatureOK = authnReq.isSignatureValid(spCert);
                                } else {
                                    String method = request.getMethod();
                                    if (method.equals("POST")) {
                                        isSignatureOK = authnReq.isSignatureValid(spCert);
                                    } else {
                                        String queryString = request.getQueryString();
                                        isSignatureOK = QuerySignatureUtil.verify(queryString, spCert);
                                    }
                                }
                                if (!isSignatureOK) {
                                    SAML2Utils.debug.error(classMethod + "authn request verification failed.");
                                    IDPSSOFederate.sendError(response, "Client", "invalidSignInRequest", null, isFromECP);
                                    return;
                                }
                                if (!isFromECP) {
                                    List ssoServiceList = idpSSODescriptor.getSingleSignOnService();
                                    String ssoURL = SPSSOFederate.getSSOURL(ssoServiceList, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
                                    if (!SAML2Utils.verifyDestination(authnReq.getDestination(), ssoURL)) {
                                        SAML2Utils.debug.error(classMethod + "authn " + "request destination verification failed.");
                                        IDPSSOFederate.sendError(response, "Client", "invalidDestination", null, isFromECP);
                                        return;
                                    }
                                }
                            }
                            catch (SAML2Exception se) {
                                SAML2Utils.debug.error(classMethod + "authn request verification failed.", (Throwable)((Object)se));
                                IDPSSOFederate.sendError(response, "Client", "invalidSignInRequest", null, isFromECP);
                                return;
                            }
                            if (SAML2Utils.debug.messageEnabled()) {
                                SAML2Utils.debug.message(classMethod + "authn " + "request signature verification is successful.");
                            }
                        }
                        reqID = authnReq.getID();
                        if (SAML2Utils.debug.messageEnabled()) {
                            SAML2Utils.debug.message(classMethod + "request id=" + reqID);
                        }
                        if (reqID == null) {
                            SAML2Utils.debug.error(classMethod + "Request id is null");
                            IDPSSOFederate.sendError(response, "Client", "InvalidSAMLRequestID", null, isFromECP);
                            return;
                        }
                        if (isFromECP) {
                            try {
                                IDPECPSessionMapper idpECPSessonMapper = IDPSSOUtil.getIDPECPSessionMapper(realm, idpEntityID);
                                session = idpECPSessonMapper.getSession(request, response);
                            }
                            catch (SAML2Exception se) {
                                if (SAML2Utils.debug.messageEnabled()) {
                                    SAML2Utils.debug.message(classMethod + "Unable to retrieve user session.");
                                }
                                break block93;
                            }
                        }
                        try {
                            session = SessionManager.getProvider().getSession(request);
                        }
                        catch (SessionException se) {
                            if (SAML2Utils.debug.messageEnabled()) {
                                SAML2Utils.debug.message(classMethod + "Unable to retrieve user session.");
                            }
                            session = null;
                        }
                    }
                    IDPAuthnContextMapper idpAuthnContextMapper = null;
                    try {
                        idpAuthnContextMapper = IDPSSOUtil.getIDPAuthnContextMapper(realm, idpEntityID);
                    }
                    catch (SAML2Exception sme) {
                        SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
                    }
                    if (idpAuthnContextMapper == null) {
                        SAML2Utils.debug.error(classMethod + "Unable to get IDPAuthnContextMapper from meta.");
                        IDPSSOFederate.sendError(response, "Server", "metaDataError", null, isFromECP);
                        return;
                    }
                    IDPAuthnContextInfo idpAuthnContextInfo = null;
                    try {
                        idpAuthnContextInfo = idpAuthnContextMapper.getIDPAuthnContextInfo(authnReq, idpEntityID, realm);
                    }
                    catch (SAML2Exception sme) {
                        SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
                    }
                    if (idpAuthnContextInfo == null) {
                        if (SAML2Utils.debug.messageEnabled()) {
                            SAML2Utils.debug.message(classMethod + "Unable to " + "find valid AuthnContext. Sending error Response.");
                        }
                        try {
                            Response res = SAML2Utils.getErrorResponse(authnReq, "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:NoAuthnContext", null, idpEntityID);
                            StringBuffer returnedBinding = new StringBuffer();
                            String acsURL = IDPSSOUtil.getACSurl(spEntityID, realm, authnReq, request, returnedBinding);
                            String acsBinding = returnedBinding.toString();
                            IDPSSOUtil.sendResponse(response, acsBinding, spEntityID, idpEntityID, idpMetaAlias, realm, null, acsURL, res, session);
                        }
                        catch (SAML2Exception sme) {
                            SAML2Utils.debug.error(classMethod, (Throwable)((Object)sme));
                            IDPSSOFederate.sendError(response, "Server", "metaDataError", null, isFromECP);
                        }
                        return;
                    }
                    if (Boolean.TRUE.equals(authnReq.isForceAuthn()) && !Boolean.TRUE.equals(authnReq.isPassive()) && session != null) {
                        try {
                            SessionManager.getProvider().invalidateSession(session, request, response);
                        }
                        catch (SessionException ssoe) {
                            SAML2Utils.debug.error(classMethod + "Unable to invalidate the sso session.");
                        }
                        session = null;
                    }
                    relayState = request.getParameter("RelayState");
                    if (session == null) {
                        PeriodicCleanUpMap ssoe = IDPCache.authnRequestCache;
                        synchronized (ssoe) {
                            IDPCache.authnRequestCache.put((Object)reqID, (Object)new CacheObject(authnReq));
                        }
                        if (relayState != null && relayState.trim().length() != 0) {
                            IDPCache.relayStateCache.put((Object)reqID, (Object)relayState);
                        }
                        try {
                            String preferredIDP;
                            boolean isProxy = IDPProxyUtil.isIDPProxyEnabled(authnReq, realm);
                            if (isProxy && (preferredIDP = IDPProxyUtil.getPreferredIDP(authnReq, idpEntityID, realm, request, response)) != null) {
                                if (SAML2Utils.debug.messageEnabled()) {
                                    SAML2Utils.debug.message(classMethod + "IDP to be proxied" + preferredIDP);
                                }
                                IDPProxyUtil.sendProxyAuthnRequest(authnReq, preferredIDP, spSSODescriptor, idpEntityID, request, response, realm, relayState, binding);
                                return;
                            }
                        }
                        catch (SAML2Exception re) {
                            if (SAML2Utils.debug.messageEnabled()) {
                                SAML2Utils.debug.message(classMethod + "Redirecting for the proxy handling error: " + re.getMessage());
                            }
                            IDPSSOFederate.sendError(response, "Server", "UnableToRedirectToPreferredIDP", re.getMessage(), isFromECP);
                        }
                        try {
                            IDPSSOFederate.redirectAuthentication(request, response, reqID, idpAuthnContextInfo, realm, idpEntityID, false);
                        }
                        catch (IOException ioe) {
                            SAML2Utils.debug.error(classMethod + "Unable to redirect to authentication.", (Throwable)ioe);
                            IDPSSOFederate.sendError(response, "Server", "UnableToRedirectToAuth", ioe.getMessage(), isFromECP);
                        }
                        catch (SAML2Exception se) {
                            SAML2Utils.debug.error(classMethod + "Unable to redirect to authentication.", (Throwable)((Object)se));
                            IDPSSOFederate.sendError(response, "Server", "UnableToRedirectToAuth", se.getMessage(), isFromECP);
                        }
                        return;
                    }
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "Session is valid");
                    }
                    IDPSession oldIDPSession = null;
                    String sessionIndex = IDPSSOUtil.getSessionIndex(session);
                    boolean sessionUpgrade = IDPSSOFederate.isSessionUpgrade(idpAuthnContextInfo.getAuthnContext(), sessionIndex);
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "Session Upgrade is :" + sessionUpgrade);
                    }
                    if (sessionUpgrade) {
                        oldIDPSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessionIndex);
                        IDPCache.oldIDPSessionCache.put(reqID, oldIDPSession);
                        IDPCache.authnRequestCache.put((Object)reqID, (Object)new CacheObject(authnReq));
                        IDPCache.isSessionUpgradeCache.add(reqID);
                        if (relayState != null && relayState.trim().length() != 0) {
                            IDPCache.relayStateCache.put((Object)reqID, (Object)relayState);
                        }
                        try {
                            IDPSSOFederate.redirectAuthentication(request, response, reqID, idpAuthnContextInfo, realm, idpEntityID, true);
                            return;
                        }
                        catch (IOException ioe) {
                            SAML2Utils.debug.error(classMethod + "Unable to redirect to authentication.", (Throwable)ioe);
                            sessionUpgrade = false;
                            IDPSSOFederate.cleanUpCache(reqID);
                            IDPSSOFederate.sendError(response, "Server", "UnableToRedirectToAuth", ioe.getMessage(), isFromECP);
                        }
                        catch (SAML2Exception se) {
                            SAML2Utils.debug.error(classMethod + "Unable to redirect to authentication.", (Throwable)((Object)se));
                            sessionUpgrade = false;
                            IDPSSOFederate.cleanUpCache(reqID);
                            IDPSSOFederate.sendError(response, "Server", "UnableToRedirectToAuth", se.getMessage(), isFromECP);
                        }
                    }
                    if (!sessionUpgrade) {
                        MultiProtocolUtils.addFederationProtocol(session, "saml2");
                        NameIDPolicy policy = authnReq.getNameIDPolicy();
                        String nameIDFormat = policy == null ? null : policy.getFormat();
                        try {
                            IDPSSOUtil.sendResponseToACS(request, response, session, authnReq, spEntityID, idpEntityID, idpMetaAlias, realm, nameIDFormat, relayState);
                        }
                        catch (SAML2Exception se) {
                            SAML2Utils.debug.error(classMethod + "Unable to do sso or federation.", (Throwable)((Object)se));
                            IDPSSOFederate.sendError(response, "Server", "UnableToDOSSOOrFederation", se.getMessage(), isFromECP);
                        }
                    }
                    break block94;
                }
                CacheObject cacheObj = null;
                PeriodicCleanUpMap spEntityID = IDPCache.authnRequestCache;
                synchronized (spEntityID) {
                    cacheObj = (CacheObject)IDPCache.authnRequestCache.remove((Object)reqID);
                }
                if (cacheObj != null) {
                    authnReq = (AuthnRequest)cacheObj.getObject();
                }
                relayState = (String)IDPCache.relayStateCache.remove((Object)reqID);
                if (authnReq == null) {
                    SAML2Utils.debug.error(classMethod + "Unable to get AuthnRequest from cache.");
                    IDPSSOFederate.sendError(response, "Server", "UnableToGetAuthnReq", null, isFromECP);
                    return;
                }
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(classMethod + "RequestID=" + reqID);
                }
                boolean isSessionUpgrade = false;
                if (IDPCache.isSessionUpgradeCache != null && !IDPCache.isSessionUpgradeCache.isEmpty() && IDPCache.isSessionUpgradeCache.contains(reqID)) {
                    isSessionUpgrade = true;
                }
                SessionProvider sessionProvider = SessionManager.getProvider();
                session = sessionProvider.getSession(request);
                if (isSessionUpgrade) {
                    IDPSession oldSess = (IDPSession)IDPCache.oldIDPSessionCache.remove(reqID);
                    String sessionIndex = IDPSSOUtil.getSessionIndex(session);
                    if (sessionIndex != null && sessionIndex.length() != 0) {
                        IDPCache.idpSessionsByIndices.put(sessionIndex, oldSess);
                    }
                }
                if (session != null) {
                    MultiProtocolUtils.addFederationProtocol(session, "saml2");
                }
                String spEntityID2 = authnReq.getIssuer().getValue();
                NameIDPolicy policy = authnReq.getNameIDPolicy();
                String nameIDFormat = policy == null ? null : policy.getFormat();
                try {
                    IDPSSOUtil.sendResponseToACS(request, response, session, authnReq, spEntityID2, idpEntityID, idpMetaAlias, realm, nameIDFormat, relayState);
                }
                catch (SAML2Exception se) {
                    SAML2Utils.debug.error(classMethod + "Unable to do sso or federation.", (Throwable)((Object)se));
                    IDPSSOFederate.sendError(response, "Server", "UnableToDOSSOOrFederation", se.getMessage(), isFromECP);
                }
            }
            catch (IOException ioe) {
                SAML2Utils.debug.error(classMethod + "I/O rrror", (Throwable)ioe);
            }
            catch (SessionException sso) {
                SAML2Utils.debug.error("SSOException : ", (Throwable)((Object)sso));
            }
            catch (SOAPException soapex) {
                SAML2Utils.debug.error("IDPSSOFederate.doSSOFederate:", (Throwable)soapex);
            }
        }
    }

    private static void sendError(HttpServletResponse response, String faultCode, String rbKey, String detail, boolean isFromECP) throws IOException, SOAPException {
        if (isFromECP) {
            SOAPMessage soapFault = SAML2Utils.createSOAPFault(faultCode, rbKey, detail);
            if (soapFault != null) {
                if (soapFault.saveRequired()) {
                    soapFault.saveChanges();
                }
                response.setStatus(200);
                SAML2Utils.putHeaders(soapFault.getMimeHeaders(), response);
                ServletOutputStream os = response.getOutputStream();
                soapFault.writeTo((OutputStream)os);
                os.flush();
                os.close();
            } else {
                response.setStatus(204);
            }
        } else {
            response.sendError(500, SAML2Utils.bundle.getString(rbKey));
        }
    }

    private static AuthnRequest getAuthnRequest(String compressedReq) {
        AuthnRequest authnReq = null;
        String outputString = SAML2Utils.decodeFromRedirect(compressedReq);
        if (outputString != null) {
            try {
                authnReq = ProtocolFactory.getInstance().createAuthnRequest(outputString);
            }
            catch (SAML2Exception se) {
                SAML2Utils.debug.error("IDPSSOFederate.getAuthnRequest(): cannot construct a AuthnRequest object from the SAMLRequest value:", (Throwable)((Object)se));
            }
        }
        return authnReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthnRequest getAuthnRequest(HttpServletRequest request, boolean isFromECP, String binding) {
        if (isFromECP) {
            MimeHeaders headers = SAML2Utils.getHeaders(request);
            try {
                ServletInputStream is = request.getInputStream();
                SOAPMessage msg = SAML2Utils.mf.createMessage(headers, (InputStream)is);
                Element elem = SAML2Utils.getSamlpElement(msg, "AuthnRequest");
                return ProtocolFactory.getInstance().createAuthnRequest(elem);
            }
            catch (Exception ex) {
                SAML2Utils.debug.error("IDPSSOFederate.getAuthnRequest:", (Throwable)ex);
                return null;
            }
        }
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
            String samlRequest = request.getParameter("SAMLRequest");
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("IDPSSOFederate.getAuthnRequest: saml request = " + samlRequest);
            }
            if (samlRequest == null) {
                return null;
            }
            return IDPSSOFederate.getAuthnRequest(samlRequest);
        }
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            String samlRequest = request.getParameter("SAMLRequest");
            ByteArrayInputStream bis = null;
            AuthnRequest authnRequest = null;
            try {
                Document doc;
                byte[] raw = Base64.decode((String)samlRequest);
                if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)SAML2Utils.debug)) != null) {
                    authnRequest = ProtocolFactory.getInstance().createAuthnRequest(doc.getDocumentElement());
                }
            }
            catch (Exception ex) {
                SAML2Utils.debug.error("IDPSSOFederate.getAuthnRequest:", (Throwable)ex);
                AuthnRequest authnRequest2 = null;
                return authnRequest2;
            }
            finally {
                block21: {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception ie) {
                            if (!SAML2Utils.debug.messageEnabled()) break block21;
                            SAML2Utils.debug.message("IDPSSOFederate.getAuthnRequest:", (Throwable)ie);
                        }
                    }
                }
            }
            return authnRequest;
        }
        return null;
    }

    private static void redirectAuthentication(HttpServletRequest request, HttpServletResponse response, String reqID, IDPAuthnContextInfo info, String realm, String idpEntityID, boolean isSessionUpgrade) throws SAML2Exception, IOException {
        String classMethod = "IDPSSOFederate.redirectAuthentication: ";
        StringBuffer newURL = new StringBuffer(IDPSSOUtil.getAuthenticationServiceURL(realm, idpEntityID, request));
        Set authnTypeAndValues = info.getAuthnTypeAndValues();
        if (authnTypeAndValues != null && !authnTypeAndValues.isEmpty()) {
            Iterator iter = authnTypeAndValues.iterator();
            StringBuffer authSB = new StringBuffer((String)iter.next());
            while (iter.hasNext()) {
                authSB.append("&");
                authSB.append((String)iter.next());
            }
            if (newURL.indexOf("?") == -1) {
                newURL.append("?");
            } else {
                newURL.append("&");
            }
            newURL.append(authSB.toString());
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(classMethod + "authString=" + authSB.toString());
            }
        }
        if (newURL.indexOf("?") == -1) {
            if (isSessionUpgrade) {
                newURL.append("?ForceAuth=true&goto=");
            } else {
                newURL.append("?goto=");
            }
        } else {
            if (isSessionUpgrade) {
                newURL.append("&ForceAuth=true");
            }
            newURL.append("&goto=");
        }
        newURL.append(URLEncDec.encode((String)request.getRequestURL().append("?ReqID=").append(reqID).toString()));
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "New URL for authentication: " + newURL.toString());
        }
        response.sendRedirect(newURL.toString());
    }

    private static boolean isSessionUpgrade(AuthnContext authnContext, String sessionIndex) {
        String classMethod = "IDPSSOFederate.isSessionUpgrade: ";
        if (sessionIndex == null) {
            return false;
        }
        Set oldAuthnContexts = (Set)IDPCache.authnContextCache.get(sessionIndex);
        if (oldAuthnContexts == null || oldAuthnContexts.isEmpty()) {
            return false;
        }
        String newAuthnContextClassRef = authnContext.getAuthnContextClassRef();
        Iterator iter = oldAuthnContexts.iterator();
        while (iter.hasNext()) {
            AuthnContext oldAuthnContext = (AuthnContext)iter.next();
            if (!newAuthnContextClassRef.equals(oldAuthnContext.getAuthnContextClassRef())) continue;
            return false;
        }
        return true;
    }

    private static void cleanUpCache(String reqID) {
        IDPCache.oldIDPSessionCache.remove(reqID);
        IDPCache.authnRequestCache.remove((Object)reqID);
        IDPCache.isSessionUpgradeCache.remove(reqID);
    }
}

