/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.profile.IDPSessionCopy;
import com.sun.identity.saml2.profile.SAML2SessionPartner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IDPSession {
    private Object session = null;
    private List nameIDandSPpairs = null;
    private String pendingLogoutRequestID = null;
    private String originatingLogoutRequestID = null;
    private String originatingLogoutSPEntityID = null;
    private boolean doLogoutAll = false;
    private List sessionPartners = null;
    private String authnContext = null;

    public IDPSession(Object session) {
        this.session = session;
        this.nameIDandSPpairs = new ArrayList();
        this.sessionPartners = new ArrayList();
    }

    public Object getSession() {
        return this.session;
    }

    public List getNameIDandSPpairs() {
        return this.nameIDandSPpairs;
    }

    public void setPendingLogoutRequestID(String id) {
        this.pendingLogoutRequestID = id;
    }

    public String getPendingLogoutRequestID() {
        return this.pendingLogoutRequestID;
    }

    public void setOriginatingLogoutRequestID(String id) {
        this.originatingLogoutRequestID = id;
    }

    public String getOriginatingLogoutRequestID() {
        return this.originatingLogoutRequestID;
    }

    public void setOriginatingLogoutSPEntityID(String id) {
        this.originatingLogoutSPEntityID = id;
    }

    public String getOriginatingLogoutSPEntityID() {
        return this.originatingLogoutSPEntityID;
    }

    public void setLogoutAll(boolean enable) {
        this.doLogoutAll = enable;
    }

    public boolean getLogoutAll() {
        return this.doLogoutAll;
    }

    public List getSessionPartners() {
        return this.sessionPartners;
    }

    public void addSessionPartner(SAML2SessionPartner sessionPartner) {
        Iterator i = this.sessionPartners.iterator();
        while (i.hasNext()) {
            if (!((SAML2SessionPartner)i.next()).equals(sessionPartner)) continue;
            return;
        }
        this.sessionPartners.add(sessionPartner);
    }

    public SAML2SessionPartner getCurrentSessionPartner() {
        Iterator i = this.sessionPartners.iterator();
        if (i.hasNext()) {
            return (SAML2SessionPartner)i.next();
        }
        return null;
    }

    public void removeSessionPartner(String sessionPartner) {
        Iterator i = this.sessionPartners.iterator();
        while (i.hasNext()) {
            SAML2SessionPartner oldSessionPartner = (SAML2SessionPartner)i.next();
            if (!oldSessionPartner.isEquals(sessionPartner)) continue;
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SAML2Session.removeSessionPartner : Removing " + sessionPartner);
            }
            i.remove();
        }
    }

    public String getAuthnContext() {
        return this.authnContext;
    }

    public void setAuthnContext(String authnContext) {
        this.authnContext = authnContext;
    }

    public IDPSession(IDPSessionCopy idpSessionCopy) {
        try {
            this.nameIDandSPpairs = new ArrayList();
            SessionProvider sessionProvider = SessionManager.getProvider();
            this.session = sessionProvider.getSession(idpSessionCopy.getSSOToken());
            this.nameIDandSPpairs = new ArrayList();
            this.nameIDandSPpairs.addAll(idpSessionCopy.getNameIDandSPpairs());
            String tmp = idpSessionCopy.getPendingLogoutRequestID();
            if (tmp != null && !tmp.equals("")) {
                this.pendingLogoutRequestID = new String(tmp);
            }
            if ((tmp = idpSessionCopy.getOriginatingLogoutRequestID()) != null && !tmp.equals("")) {
                this.originatingLogoutRequestID = new String(tmp);
            }
            if ((tmp = idpSessionCopy.getOriginatingLogoutSPEntityID()) != null && !tmp.equals("")) {
                this.originatingLogoutSPEntityID = new String(tmp);
            }
            this.doLogoutAll = idpSessionCopy.getLogoutAll();
        }
        catch (SessionException se) {
            SAML2Utils.debug.error("Session Exception.", (Throwable)((Object)se));
        }
    }
}

