/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Advice;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.EncryptedAttribute;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.ecp.ECPFactory;
import com.sun.identity.saml2.ecp.ECPRelayState;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.ArtifactResolutionServiceElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.SAML2ServiceProviderAdapter;
import com.sun.identity.saml2.plugins.SPAccountMapper;
import com.sun.identity.saml2.plugins.SPAttributeMapper;
import com.sun.identity.saml2.profile.CacheObject;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPProxyUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.ResponseInfo;
import com.sun.identity.saml2.profile.SAML2SessionPartner;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPFedSession;
import com.sun.identity.saml2.profile.SPSessionListener;
import com.sun.identity.saml2.protocol.Artifact;
import com.sun.identity.saml2.protocol.ArtifactResolve;
import com.sun.identity.saml2.protocol.ArtifactResponse;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPACSUtils {
    private SPACSUtils() {
    }

    public static ResponseInfo getResponse(HttpServletRequest request, HttpServletResponse response, String orgName, String hostEntityId, SAML2MetaManager metaManager) throws SAML2Exception, IOException {
        ResponseInfo respInfo = null;
        String method = request.getMethod();
        if (method.equals("GET")) {
            respInfo = SPACSUtils.getResponseFromGet(request, response, orgName, hostEntityId, metaManager);
        } else if (method.equals("POST")) {
            String pathInfo = request.getPathInfo();
            respInfo = pathInfo != null && pathInfo.startsWith("/ECP") ? SPACSUtils.getResponseFromPostECP(request, response, orgName, hostEntityId, metaManager) : SPACSUtils.getResponseFromPost(request, response, orgName, hostEntityId, metaManager);
        } else {
            response.sendError(405, SAML2Utils.bundle.getString("notSupportedHTTPMethod"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("notSupportedHTTPMethod"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPACSUtils.getResponse: got response=" + respInfo.getResponse().toXMLString(true, true));
        }
        return respInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResponseInfo getResponseFromGet(HttpServletRequest request, HttpServletResponse response, String orgName, String hostEntityId, SAML2MetaManager metaManager) throws SAML2Exception, IOException {
        ResponseInfo respInfo = null;
        String resID = request.getParameter("resID");
        if (resID != null && resID.length() != 0) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPACSUtils.getResponseFromGet: resID=" + resID);
            }
            PeriodicCleanUpMap periodicCleanUpMap = SPCache.responseHash;
            synchronized (periodicCleanUpMap) {
                respInfo = (ResponseInfo)SPCache.responseHash.remove((Object)resID);
            }
            if (respInfo == null) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("SPACSUtils.getResponseFromGet: couldn't find Response from resID.");
                }
                String[] data = new String[]{resID};
                LogUtil.error(Level.INFO, "RESPONSE_NOT_FOUND_FROM_CACHE", data, null);
                response.sendError(500, SAML2Utils.bundle.getString("SSOFailed"));
                throw new SAML2Exception(SAML2Utils.bundle.getString("SSOFailed"));
            }
            return respInfo;
        }
        String samlArt = request.getParameter("SAMLart");
        if (samlArt == null || samlArt.trim().length() == 0) {
            SAML2Utils.debug.error("SPACSUtils.getResponseFromGet: Artifact string is empty.");
            LogUtil.error(Level.INFO, "MISSING_ARTIFACT", null, null);
            response.sendError(400, SAML2Utils.bundle.getString("missingArtifact"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingArtifact"));
        }
        return new ResponseInfo(SPACSUtils.getResponseFromArtifact(samlArt, hostEntityId, response, orgName, metaManager), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", null);
    }

    private static Response getResponseFromArtifact(String samlArt, String hostEntityId, HttpServletResponse response, String orgName, SAML2MetaManager sm) throws SAML2Exception, IOException {
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPACSUtils.getResponseFromArtifact: samlArt = " + samlArt);
        }
        Artifact art = null;
        try {
            art = ProtocolFactory.getInstance().createArtifact(samlArt.trim());
            String[] data = new String[]{samlArt.trim()};
            LogUtil.access(Level.INFO, "RECEIVED_ARTIFACT", data, null);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("SPACSUtils.getResponseFromArtifact: Unable to decode and parse artifact string:" + samlArt);
            response.sendError(400, SAML2Utils.bundle.getString("errorObtainArtifact"));
            throw se;
        }
        String idpEntityID = SPACSUtils.getIDPEntityID(art, response, orgName, sm);
        IDPSSODescriptorElement idp = null;
        try {
            idp = sm.getIDPSSODescriptor(orgName, idpEntityID);
        }
        catch (SAML2MetaException se) {
            String[] data = new String[]{orgName, idpEntityID};
            LogUtil.error(Level.INFO, "IDP_META_NOT_FOUND", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        String location = SPACSUtils.getIDPArtifactResolutionServiceUrl(art.getEndpointIndex(), idpEntityID, idp, response);
        ArtifactResolve resolve = null;
        SOAPMessage resMsg = null;
        try {
            resolve = ProtocolFactory.getInstance().createArtifactResolve();
            resolve.setID(SAML2Utils.generateID());
            resolve.setVersion("2.0");
            resolve.setIssueInstant(new Date());
            resolve.setArtifact(art);
            resolve.setDestination(location);
            Issuer issuer = AssertionFactory.getInstance().createIssuer();
            issuer.setValue(hostEntityId);
            resolve.setIssuer(issuer);
            String needArtiResolveSigned = SAML2Utils.getAttributeValueFromSSOConfig(orgName, idpEntityID, "IDPRole", "wantArtifactResolveSigned");
            if (needArtiResolveSigned != null && needArtiResolveSigned.equals("true")) {
                String signAlias = SPACSUtils.getAttributeValueFromSPSSOConfig(orgName, hostEntityId, sm, "signingCertAlias");
                if (signAlias == null) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
                }
                KeyProvider kp = KeyUtil.getKeyProviderInstance();
                if (kp == null) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("nullKeyProvider"));
                }
                resolve.sign(kp.getPrivateKey(signAlias), kp.getX509Certificate(signAlias));
            }
            String resolveString = resolve.toXMLString(true, true);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPACSUtils.getResponseFromArtifact: ArtifactResolve=" + resolveString);
            }
            SOAPConnection con = SAML2Utils.scf.createConnection();
            SOAPMessage msg = SAML2Utils.createSOAPMessage(resolveString);
            IDPSSOConfigElement config = null;
            config = sm.getIDPSSOConfig(orgName, idpEntityID);
            location = SAML2Utils.fillInBasicAuthInfo(config, location);
            resMsg = con.call(msg, (Object)location);
        }
        catch (SAML2Exception s2e) {
            SAML2Utils.debug.error("SPACSUtils.getResponseFromArtifact: couldn't create ArtifactResolve:", (Throwable)((Object)s2e));
            String[] data = new String[]{hostEntityId, art.getArtifactValue()};
            LogUtil.error(Level.INFO, "CANNOT_CREATE_ARTIFACT_RESOLVE", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("errorCreateArtifactResolve"));
            throw s2e;
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("SPACSUtils.getResponseFromGet: couldn't get ArtifactResponse. SOAP error:", (Throwable)se);
            String[] data = new String[]{hostEntityId, location};
            LogUtil.error(Level.INFO, "CANNOT_GET_SOAP_RESPONSE", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("errorInSOAPCommunication"));
            throw new SAML2Exception(se.getMessage());
        }
        Response result = SPACSUtils.getResponseFromSOAP(resMsg, resolve, response, idpEntityID, idp, orgName, hostEntityId, sm);
        String[] data = new String[]{hostEntityId, idpEntityID, art.getArtifactValue(), ""};
        if (LogUtil.isAccessLoggable(Level.FINE)) {
            data[3] = result.toXMLString();
        }
        LogUtil.access(Level.INFO, "GOT_RESPONSE_FROM_ARTIFACT", data, null);
        return result;
    }

    private static String getIDPEntityID(Artifact art, HttpServletResponse response, String orgName, SAML2MetaManager metaManager) throws SAML2Exception, IOException {
        String sourceID = art.getSourceID();
        String idpEntityID = null;
        try {
            Iterator iter = metaManager.getAllRemoteIdentityProviderEntities(orgName).iterator();
            String tmpSourceID = null;
            while (iter.hasNext() && !sourceID.equals(tmpSourceID = SAML2Utils.generateSourceID(idpEntityID = (String)iter.next()))) {
                idpEntityID = null;
            }
            if (idpEntityID == null) {
                SAML2Utils.debug.error("SPACSUtils.getResponseFromGet: Unable to find the IDP based on the SourceID in the artifact");
                String[] data = new String[]{art.getArtifactValue(), orgName};
                LogUtil.error(Level.INFO, "IDP_NOT_FOUND", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("cannotFindIDP"));
            }
        }
        catch (SAML2Exception se) {
            String[] data = new String[]{art.getArtifactValue(), orgName};
            LogUtil.error(Level.INFO, "IDP_NOT_FOUND", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        return idpEntityID;
    }

    private static String getIDPArtifactResolutionServiceUrl(int endpointIndex, String idpEntityID, IDPSSODescriptorElement idp, HttpServletResponse response) throws SAML2Exception, IOException {
        List arsList = idp.getArtifactResolutionService();
        ArtifactResolutionServiceElement ars = null;
        String location = null;
        String defaultLocation = null;
        String firstLocation = null;
        boolean isDefault = false;
        for (int i = 0; i < arsList.size(); ++i) {
            ars = (ArtifactResolutionServiceElement)arsList.get(i);
            location = ars.getLocation();
            int index = ars.getIndex();
            isDefault = ars.isIsDefault();
            if (index == endpointIndex) break;
            if (isDefault) {
                defaultLocation = location;
            }
            if (i == 0) {
                firstLocation = location;
            }
            location = null;
        }
        if (!(location != null && location.length() != 0 || (location = defaultLocation) != null && location.length() != 0 || (location = firstLocation) != null && location.length() != 0)) {
            SAML2Utils.debug.error("SPACSUtils: Unable to get the location of artifact resolution service for " + idpEntityID);
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "ARTIFACT_RESOLUTION_URL_NOT_FOUND", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("cannotFindArtifactResolutionUrl"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("cannotFindArtifactResolutionUrl"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPACSUtils: IDP artifact resolution service url =" + location);
        }
        return location;
    }

    private static Response getResponseFromSOAP(SOAPMessage resMsg, ArtifactResolve resolve, HttpServletResponse response, String idpEntityID, IDPSSODescriptorElement idp, String orgName, String hostEntityId, SAML2MetaManager sm) throws SAML2Exception, IOException {
        String inResponseTo;
        String wantArtiRespSigned;
        String method = "SPACSUtils.getResponseFromSOAP:";
        Element resElem = null;
        try {
            resElem = SAML2Utils.getSamlpElement(resMsg, "ArtifactResponse");
        }
        catch (SAML2Exception se) {
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "SOAP_ERROR", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        ArtifactResponse artiResp = null;
        try {
            artiResp = ProtocolFactory.getInstance().createArtifactResponse(resElem);
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(method + "Couldn't create " + "ArtifactResponse:", (Throwable)((Object)se));
            }
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_ARTIFACT_RESPONSE", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        if (artiResp == null) {
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "MISSING_ARTIFACT_RESPONSE", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("missingArtifactResponse"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingArtifactResponse"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(method + "Received ArtifactResponse:" + artiResp.toXMLString(true, true));
        }
        if ((wantArtiRespSigned = SPACSUtils.getAttributeValueFromSPSSOConfig(orgName, hostEntityId, sm, "wantArtifactResponseSigned")) != null && wantArtiRespSigned.equals("true")) {
            X509Certificate cert = KeyUtil.getVerificationCert(idp, idpEntityID, "IDPRole");
            if (!artiResp.isSigned() || !artiResp.isSignatureValid(cert)) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message(method + "ArtifactResponse's signature is invalid.");
                }
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "ARTIFACT_RESPONSE_INVALID_SIGNATURE", data, null);
                response.sendError(500, SAML2Utils.bundle.getString("invalidSignature"));
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignature"));
            }
        }
        if ((inResponseTo = artiResp.getInResponseTo()) == null || !inResponseTo.equals(resolve.getID())) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(method + "ArtifactResponse's InResponseTo is invalid.");
            }
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "ARTIFACT_RESPONSE_INVALID_INRESPONSETO", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("invalidInResponseTo"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidInResponseTo"));
        }
        Issuer idpIssuer = artiResp.getIssuer();
        if (idpIssuer == null || !idpIssuer.getValue().equals(idpEntityID)) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(method + "ArtifactResponse's Issuer is invalid.");
            }
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "ARTIFACT_RESPONSE_INVALID_ISSUER", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("invalidIssuer"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidIssuer"));
        }
        Status status = artiResp.getStatus();
        if (status == null || !status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            String statusCode;
            String string = statusCode = status == null ? "" : status.getStatusCode().getValue();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(method + "ArtifactResponse's status code is not success." + statusCode);
            }
            String[] data = new String[]{idpEntityID, ""};
            if (LogUtil.isErrorLoggable(Level.FINE)) {
                data[1] = statusCode;
            }
            LogUtil.error(Level.INFO, "ARTIFACT_RESPONSE_INVALID_STATUS_CODE", data, null);
            response.sendError(500, SAML2Utils.bundle.getString("invalidStatusCode"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidStatusCode"));
        }
        try {
            return ProtocolFactory.getInstance().createResponse(artiResp.getAny());
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message(method + "couldn't instantiate Response:", (Throwable)((Object)se));
            }
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_RESPONSE_ARTIFACT", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
    }

    private static ResponseInfo getResponseFromPostECP(HttpServletRequest request, HttpServletResponse response, String orgName, String hostEntityId, SAML2MetaManager metaManager) throws SAML2Exception, IOException {
        List soapBodies;
        Message message = null;
        try {
            message = new Message(SAML2Utils.getSOAPMessage(request));
        }
        catch (SOAPException soapex) {
            String[] data = new String[]{hostEntityId};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_SOAP_MESSAGE_ECP", data, null);
            response.sendError(500, soapex.getMessage());
            throw new SAML2Exception(soapex.getMessage());
        }
        catch (SOAPBindingException soapex) {
            String[] data = new String[]{hostEntityId};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_SOAP_MESSAGE_ECP", data, null);
            response.sendError(500, soapex.getMessage());
            throw new SAML2Exception(soapex.getMessage());
        }
        catch (SOAPFaultException sfex) {
            String[] data = new String[]{hostEntityId};
            LogUtil.error(Level.INFO, "RECEIVE_SOAP_FAULT_ECP", data, null);
            String faultString = sfex.getSOAPFaultMessage().getSOAPFault().getFaultString();
            response.sendError(500, faultString);
            throw new SAML2Exception(faultString);
        }
        List soapHeaders = message.getOtherSOAPHeaders();
        ECPRelayState ecpRelayState = null;
        if (soapHeaders != null && !soapHeaders.isEmpty()) {
            Iterator iter = soapHeaders.iterator();
            while (iter.hasNext()) {
                Element headerEle = (Element)iter.next();
                try {
                    ecpRelayState = ECPFactory.getInstance().createECPRelayState(headerEle);
                    break;
                }
                catch (SAML2Exception saml2ex) {
                }
            }
        }
        String relayState = null;
        if (ecpRelayState != null) {
            relayState = ecpRelayState.getValue();
        }
        if ((soapBodies = message.getBodies()) == null || soapBodies.isEmpty()) {
            String[] data = new String[]{hostEntityId};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_SAML_RESPONSE_FROM_ECP", data, null);
            response.sendError(400, SAML2Utils.bundle.getString("missingSAMLResponse"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSAMLResponse"));
        }
        Element resElem = (Element)soapBodies.get(0);
        Response resp = null;
        try {
            resp = ProtocolFactory.getInstance().createResponse(resElem);
        }
        catch (SAML2Exception se) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPACSUtils.getResponseFromPostECP:Couldn't create Response:", (Throwable)((Object)se));
            }
            String[] data = new String[]{hostEntityId};
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_SAML_RESPONSE_FROM_ECP", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        String idpEntityID = resp.getIssuer().getValue();
        IDPSSODescriptorElement idpDesc = null;
        try {
            idpDesc = metaManager.getIDPSSODescriptor(orgName, idpEntityID);
        }
        catch (SAML2MetaException se) {
            String[] data = new String[]{orgName, idpEntityID};
            LogUtil.error(Level.INFO, "IDP_META_NOT_FOUND", data, null);
            response.sendError(500, se.getMessage());
            throw se;
        }
        X509Certificate cert = KeyUtil.getVerificationCert(idpDesc, idpEntityID, "IDPRole");
        List assertions = resp.getAssertion();
        if (assertions != null && !assertions.isEmpty()) {
            Iterator iter = assertions.iterator();
            while (iter.hasNext()) {
                Assertion assertion = (Assertion)iter.next();
                if (!assertion.isSigned()) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("SPACSUtils.getResponseFromPostECP:  Assertion is not signed.");
                    }
                    String[] data = new String[]{idpEntityID};
                    LogUtil.error(Level.INFO, "ECP_ASSERTION_NOT_SIGNED", data, null);
                    response.sendError(500, SAML2Utils.bundle.getString("assertionNotSigned"));
                    throw new SAML2Exception(SAML2Utils.bundle.getString("assertionNotSigned"));
                }
                if (assertion.isSignatureValid(cert)) continue;
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("SPACSUtils.getResponseFromPostECP:  Assertion signature is invalid.");
                }
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "ECP_ASSERTION_INVALID_SIGNATURE", data, null);
                response.sendError(500, SAML2Utils.bundle.getString("invalidSignature"));
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignature"));
            }
        }
        return new ResponseInfo(resp, "urn:oasis:names:tc:SAML:2.0:bindings:PAOS", relayState);
    }

    private static ResponseInfo getResponseFromPost(HttpServletRequest request, HttpServletResponse response, String orgName, String hostEntityId, SAML2MetaManager metaManager) throws SAML2Exception, IOException {
        SAML2Utils.debug.message("SPACSUtils:getResponseFromPost");
        String samlArt = request.getParameter("SAMLart");
        if (samlArt != null && samlArt.trim().length() != 0) {
            return new ResponseInfo(SPACSUtils.getResponseFromArtifact(samlArt, hostEntityId, response, orgName, metaManager), "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact", null);
        }
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse == null) {
            LogUtil.error(Level.INFO, "MISSING_SAML_RESPONSE_FROM_POST", null, null);
            response.sendError(400, SAML2Utils.bundle.getString("missingSAMLResponse"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSAMLResponse"));
        }
        Response resp = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlResponse);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)SAML2Utils.debug)) != null) {
                resp = ProtocolFactory.getInstance().createResponse(doc.getDocumentElement());
            }
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("SPACSUtils.getResponse: Exception when instantiating SAMLResponse:", (Throwable)((Object)se));
            LogUtil.error(Level.INFO, "CANNOT_INSTANTIATE_RESPONSE_POST", null, null);
            response.sendError(400, SAML2Utils.bundle.getString("errorObtainResponse"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorObtainResponse"));
        }
        catch (Exception e) {
            SAML2Utils.debug.error("SPACSUtils.getResponse: Exception when decoding SAMLResponse:", (Throwable)e);
            LogUtil.error(Level.INFO, "CANNOT_DECODE_RESPONSE", null, null);
            response.sendError(500, SAML2Utils.bundle.getString("errorDecodeResponse"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorDecodeResponse"));
        }
        finally {
            block16: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!SAML2Utils.debug.messageEnabled()) break block16;
                        SAML2Utils.debug.message("SPACSUtils.getResponse: Exception when close the input stream:", (Throwable)ie);
                    }
                }
            }
        }
        String[] data = new String[]{""};
        if (LogUtil.isAccessLoggable(Level.FINE)) {
            data[0] = resp.toXMLString();
        }
        LogUtil.access(Level.INFO, "GOT_RESPONSE_FROM_POST", data, null);
        return new ResponseInfo(resp, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", null);
    }

    public static Object processResponse(HttpServletRequest request, HttpServletResponse response, String metaAlias, Object session, ResponseInfo respInfo, String realm, String hostEntityId, SAML2MetaManager metaManager) throws SAML2Exception {
        boolean writeFedInfo;
        String userName;
        String classMethod = "SPACSUtils.processResponse: ";
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Response : " + respInfo.getResponse());
        }
        Map smap = null;
        try {
            smap = SAML2Utils.verifyResponse(request, response, respInfo.getResponse(), realm, hostEntityId, respInfo.getProfileBinding());
        }
        catch (SAML2Exception se) {
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 1, se);
            throw se;
        }
        Subject assertionSubject = (Subject)smap.get("Subject");
        NameID nameId = assertionSubject.getNameID();
        EncryptedID encId = assertionSubject.getEncryptedID();
        Assertion authnAssertion = (Assertion)smap.get("assertion");
        String sessionIndex = (String)smap.get("SessionIndex");
        Integer authLevel = (Integer)smap.get("AuthLevel");
        Long maxSessionTime = (Long)smap.get("maxSessionTime");
        String inRespToResp = (String)smap.get("inResponseTo");
        List assertions = (List)smap.get("assertions");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Assertions : " + assertions);
        }
        SPSSOConfigElement spssoconfig = metaManager.getSPSSOConfig(realm, hostEntityId);
        Map attributes = SAML2MetaUtils.getAttributes(spssoconfig);
        SPAccountMapper acctMapper = SPACSUtils.getSPAccountMapper(attributes);
        SPAttributeMapper attrMapper = SPACSUtils.getSPAttributeMapper(attributes);
        boolean needAttributeEncrypted = false;
        boolean needNameIDEncrypted = false;
        String assertionEncryptedAttr = SAML2Utils.getAttributeValueFromSPSSOConfig(spssoconfig, "wantAssertionEncrypted");
        if (assertionEncryptedAttr == null || !assertionEncryptedAttr.equals("true")) {
            String idEncryptedStr;
            String attrEncryptedStr = SAML2Utils.getAttributeValueFromSPSSOConfig(spssoconfig, "wantAttributeEncrypted");
            if (attrEncryptedStr != null && attrEncryptedStr.equals("true")) {
                needAttributeEncrypted = true;
            }
            if ((idEncryptedStr = SAML2Utils.getAttributeValueFromSPSSOConfig(spssoconfig, "wantNameIDEncrypted")) != null && idEncryptedStr.equals("true")) {
                needNameIDEncrypted = true;
            }
        }
        PrivateKey decryptionKey = KeyUtil.getDecryptionKey(spssoconfig);
        if (needNameIDEncrypted && encId == null) {
            SAML2Utils.debug.error(classMethod + "process: NameID was not encrypted.");
            SAML2Exception se = new SAML2Exception(SAML2Utils.bundle.getString("nameIDNotEncrypted"));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 1, se);
            throw se;
        }
        if (encId != null) {
            try {
                nameId = encId.decrypt(decryptionKey);
            }
            catch (SAML2Exception se) {
                SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 1, se);
                throw se;
            }
        }
        SPSSODescriptorElement spDesc = null;
        try {
            spDesc = metaManager.getSPSSODescriptor(realm, hostEntityId);
        }
        catch (SAML2MetaException ex) {
            SAML2Utils.debug.error(classMethod, (Throwable)((Object)ex));
        }
        if (spDesc == null) {
            SAML2Exception se = new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 11, se);
            throw se;
        }
        String nameIDFormat = nameId.getFormat();
        if (nameIDFormat != null && !spDesc.getNameIDFormat().contains(nameIDFormat)) {
            Object[] args = new Object[]{nameIDFormat};
            SAML2Exception se = new SAML2Exception("libSAML2", "unsupportedNameIDFormatSP", args);
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 1, se);
            throw se;
        }
        String existUserName = null;
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            SAML2Exception se2 = new SAML2Exception((Throwable)((Object)se));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 4, se2);
            throw se2;
        }
        if (session != null) {
            try {
                existUserName = sessionProvider.getPrincipalName(session);
            }
            catch (SessionException se) {
                SAML2Exception se2 = new SAML2Exception((Throwable)((Object)se));
                SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 4, se2);
                throw se2;
            }
        }
        try {
            userName = acctMapper.getIdentity(authnAssertion, hostEntityId, realm);
        }
        catch (SAML2Exception se) {
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 6, se);
            throw se;
        }
        if (userName == null) {
            userName = existUserName;
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "process: userName =[" + userName + "]");
        }
        ArrayList attrs = null;
        String remoteHostId = null;
        Iterator it = assertions.iterator();
        while (it.hasNext()) {
            Assertion assertion = (Assertion)it.next();
            remoteHostId = assertion.getIssuer().getValue();
            List origAttrs = SPACSUtils.getSAMLAttributes(assertion, needAttributeEncrypted, decryptionKey);
            if (origAttrs == null || origAttrs.isEmpty()) continue;
            if (attrs == null) {
                attrs = new ArrayList();
            }
            attrs.addAll(origAttrs);
        }
        Map attrMap = null;
        if (attrs != null) {
            try {
                attrMap = attrMapper.getAttributes(attrs, userName, hostEntityId, remoteHostId, realm);
            }
            catch (SAML2Exception se) {
                SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 5, se);
                throw se;
            }
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "process: remoteHostId = " + remoteHostId);
            SAML2Utils.debug.message(classMethod + "process: attrMap = " + attrMap);
        }
        if (userName == null || userName.length() == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("noUserMapping"));
        }
        boolean isFedInfoExists = SAML2Utils.isFedInfoExists(userName, hostEntityId, remoteHostId, nameId);
        boolean bl = writeFedInfo = !isFedInfoExists && !"urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equals(nameId.getFormat());
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "userName : " + userName);
            SAML2Utils.debug.message(classMethod + "isFedInfoExists : " + isFedInfoExists);
            SAML2Utils.debug.message(classMethod + "writeFedInfo : " + writeFedInfo);
        }
        AuthnRequest authnRequest = null;
        if (smap != null) {
            authnRequest = (AuthnRequest)smap.get("AuthnRequest");
        }
        if (inRespToResp != null && inRespToResp.length() != 0) {
            SPCache.requestHash.remove((Object)inRespToResp);
        }
        HashMap<String, String> sessionInfoMap = new HashMap<String, String>();
        sessionInfoMap.put("realm", realm);
        sessionInfoMap.put("principalName", userName);
        String clientAddr = request.getRemoteAddr();
        sessionInfoMap.put("Host", clientAddr);
        sessionInfoMap.put("HostName", clientAddr);
        sessionInfoMap.put("AuthLevel", String.valueOf(authLevel));
        try {
            session = sessionProvider.createSession(sessionInfoMap, request, response, null);
        }
        catch (SessionException se) {
            int failureCode = 10;
            int sessCode = se.getErrCode();
            if (sessCode == SessionException.AUTH_USER_INACTIVE) {
                failureCode = 7;
            } else if (sessCode == SessionException.AUTH_USER_LOCKED) {
                failureCode = 8;
            } else if (sessCode == SessionException.AUTH_ACCOUNT_EXPIRED) {
                failureCode = 9;
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPACSUtils.processResponse : error code=" + sessCode, (Throwable)((Object)se));
            }
            SAML2Exception se2 = new SAML2Exception((Throwable)((Object)se));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, failureCode, se2);
            throw se2;
        }
        String[] values = new String[]{metaAlias};
        try {
            SPACSUtils.setAttrMapInSession(sessionProvider, attrMap, session);
            SPACSUtils.setDiscoBootstrapCredsInSSOToken(sessionProvider, authnAssertion, session);
            sessionProvider.setProperty(session, "spMetaAlias", values);
        }
        catch (SessionException se) {
            SAML2Exception se2 = new SAML2Exception((Throwable)((Object)se));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 4, se2);
            throw se2;
        }
        NameIDInfo info = null;
        String affiID = nameId.getSPNameQualifier();
        AffiliationDescriptorType affiDesc = metaManager.getAffiliationDescriptor(realm, affiID);
        boolean isDualRole = SAML2Utils.isDualRole(hostEntityId, realm);
        if (affiDesc != null) {
            if (!affiDesc.getAffiliateMember().contains(hostEntityId)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
            }
            info = isDualRole ? new NameIDInfo(affiID, remoteHostId, nameId, "DualRole", true) : new NameIDInfo(affiID, remoteHostId, nameId, "SPRole", true);
        } else {
            info = isDualRole ? new NameIDInfo(hostEntityId, remoteHostId, nameId, "DualRole", false) : new NameIDInfo(hostEntityId, remoteHostId, nameId, "SPRole", false);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        String nameIDValueString = info.getNameIDValue();
        props.put("NameID", info.getNameIDValue());
        try {
            userName = sessionProvider.getPrincipalName(session);
        }
        catch (SessionException se) {
            SAML2Exception se2 = new SAML2Exception((Throwable)((Object)se));
            SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 4, se2);
            throw se2;
        }
        String[] data1 = new String[]{userName, nameIDValueString};
        LogUtil.access(Level.INFO, "SUCCESS_FED_SSO", data1, session, props);
        if (writeFedInfo) {
            try {
                AccountUtils.setAccountFederation(info, userName);
            }
            catch (SAML2Exception se) {
                SPACSUtils.invokeSPAdapterForSSOFailure(hostEntityId, realm, request, response, smap, respInfo, 3, se);
                throw se;
            }
            String[] data = new String[]{userName, ""};
            if (LogUtil.isAccessLoggable(Level.FINE)) {
                data[1] = info.toValueString();
            }
            LogUtil.access(Level.INFO, "FED_INFO_WRITTEN", data, session, props);
        }
        String requestID = respInfo.getResponse().getInResponseTo();
        SPACSUtils.saveInfoInMemory(sessionProvider, session, sessionIndex, info, IDPProxyUtil.isIDPProxyEnabled(requestID));
        SAML2ServiceProviderAdapter spAdapter = SAML2Utils.getSPAdapterClass(hostEntityId, realm);
        if (spAdapter != null) {
            boolean redirected = spAdapter.postSingleSignOnSuccess(hostEntityId, realm, request, response, session, authnRequest, respInfo.getResponse(), respInfo.getProfileBinding(), writeFedInfo);
            String[] value = null;
            value = redirected ? new String[]{"true"} : new String[]{"false"};
            try {
                sessionProvider.setProperty(session, "SAML2ResponseRedirected", value);
            }
            catch (SessionException ex) {
                SAML2Utils.debug.warning("SPSingleLogout.processResp", (Throwable)((Object)ex));
            }
            catch (UnsupportedOperationException ex) {
                SAML2Utils.debug.warning("SPSingleLogout.processResp", (Throwable)ex);
            }
        }
        return session;
    }

    private static void invokeSPAdapterForSSOFailure(String hostEntityId, String realm, HttpServletRequest request, HttpServletResponse response, Map smap, ResponseInfo respInfo, int errorCode, SAML2Exception se) {
        SAML2ServiceProviderAdapter spAdapter;
        block4: {
            spAdapter = null;
            try {
                spAdapter = SAML2Utils.getSPAdapterClass(hostEntityId, realm);
            }
            catch (SAML2Exception e) {
                if (!SAML2Utils.debug.messageEnabled()) break block4;
                SAML2Utils.debug.message("SPACSUtils.invokeSPAdapterForSSOFailure", (Throwable)((Object)e));
            }
        }
        if (spAdapter != null) {
            AuthnRequest authnRequest = null;
            if (smap != null) {
                authnRequest = (AuthnRequest)smap.get("AuthnRequest");
            }
            boolean redirected = spAdapter.postSingleSignOnFailure(hostEntityId, realm, request, response, authnRequest, respInfo.getResponse(), respInfo.getProfileBinding(), errorCode);
            se.setRedirectionDone(redirected);
        }
    }

    private static SPAccountMapper getSPAccountMapper(Map attributes) throws SAML2Exception {
        SPAccountMapper acctMapper = null;
        List acctMapperList = (List)attributes.get("spAccountMapper");
        if (acctMapperList != null) {
            try {
                acctMapper = (SPAccountMapper)Class.forName((String)acctMapperList.get(0)).newInstance();
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("SPACSUtils.getSPAccountMapper: mapper = " + (String)acctMapperList.get(0));
                }
            }
            catch (ClassNotFoundException cfe) {
                throw new SAML2Exception(cfe);
            }
            catch (InstantiationException ie) {
                throw new SAML2Exception(ie);
            }
            catch (IllegalAccessException iae) {
                throw new SAML2Exception(iae);
            }
        }
        if (acctMapper == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("failedAcctMapper"));
        }
        return acctMapper;
    }

    private static SPAttributeMapper getSPAttributeMapper(Map attributes) throws SAML2Exception {
        SPAttributeMapper attrMapper = null;
        List attrMapperList = (List)attributes.get("spAttributeMapper");
        if (attrMapperList != null) {
            try {
                attrMapper = (SPAttributeMapper)Class.forName((String)attrMapperList.get(0)).newInstance();
            }
            catch (ClassNotFoundException cfe) {
                throw new SAML2Exception(cfe);
            }
            catch (InstantiationException ie) {
                throw new SAML2Exception(ie);
            }
            catch (IllegalAccessException iae) {
                throw new SAML2Exception(iae);
            }
        }
        if (attrMapper == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("failedAttrMapper"));
        }
        return attrMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveInfoInMemory(SessionProvider sessionProvider, Object session, String sessionIndex, NameIDInfo info, boolean isIDPProxy) throws SAML2Exception {
        String infoKeyString = new NameIDInfoKey(info.getNameIDValue(), info.getHostEntityID(), info.getRemoteEntityID()).toValueString();
        String infoKeyAttribute = AccountUtils.getNameIDInfoKeyAttribute();
        String[] fromToken = null;
        try {
            String[] values;
            fromToken = sessionProvider.getProperty(session, infoKeyAttribute);
            if (fromToken == null || fromToken.length == 0 || fromToken[0] == null || fromToken[0].length() == 0) {
                values = new String[]{infoKeyString};
                sessionProvider.setProperty(session, infoKeyAttribute, values);
            } else if (fromToken[0].indexOf(infoKeyString) == -1) {
                values = new String[]{fromToken[0] + ";" + infoKeyString};
                sessionProvider.setProperty(session, infoKeyAttribute, values);
            }
        }
        catch (SessionException sessE) {
            throw new SAML2Exception((Throwable)((Object)sessE));
        }
        String tokenID = sessionProvider.getSessionID(session);
        ArrayList<SPFedSession> fedSessions = (ArrayList<SPFedSession>)SPCache.fedSessionListsByNameIDInfoKey.get(infoKeyString);
        if (fedSessions == null) {
            Cloneable cloneable = SPCache.fedSessionListsByNameIDInfoKey;
            synchronized (cloneable) {
                fedSessions = (List)SPCache.fedSessionListsByNameIDInfoKey.get(infoKeyString);
                if (fedSessions == null) {
                    fedSessions = new ArrayList<SPFedSession>();
                }
            }
            cloneable = fedSessions;
            synchronized (cloneable) {
                fedSessions.add(new SPFedSession(sessionIndex, tokenID, info));
                SPCache.fedSessionListsByNameIDInfoKey.put(infoKeyString, fedSessions);
            }
            if (isIDPProxy) {
                IDPSession idpSess = (IDPSession)IDPCache.idpSessionsBySessionID.get(tokenID);
                if (idpSess == null) {
                    idpSess = new IDPSession(session);
                    IDPCache.idpSessionsBySessionID.put(tokenID, idpSess);
                }
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("Add Session Partner: " + info.getRemoteEntityID());
                }
                idpSess.addSessionPartner(new SAML2SessionPartner(info.getRemoteEntityID(), true));
            }
        } else {
            ArrayList<SPFedSession> idpSess = fedSessions;
            synchronized (idpSess) {
                Iterator iter = fedSessions.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    SPFedSession temp = (SPFedSession)iter.next();
                    if (!temp.idpSessionIndex.equals(sessionIndex)) continue;
                    temp.spTokenID = tokenID;
                    temp.info = info;
                    found = true;
                    break;
                }
                if (!found) {
                    fedSessions.add(new SPFedSession(sessionIndex, tokenID, info));
                    SPCache.fedSessionListsByNameIDInfoKey.put(infoKeyString, fedSessions);
                }
            }
        }
        SPCache.fedSessionListsByNameIDInfoKey.put(infoKeyString, fedSessions);
        try {
            sessionProvider.addListener(session, new SPSessionListener(infoKeyString, tokenID));
        }
        catch (SessionException e) {
            SAML2Utils.debug.error("SPACSUtils.saveInfoInMemory: Unable to add session listener.");
        }
    }

    public static void setAttrMapInSession(SessionProvider sessionProvider, Map attrMap, Object session) throws SessionException {
        if (attrMap != null && !attrMap.isEmpty()) {
            Set entrySet = attrMap.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String attrName = (String)entry.getKey();
                Set attrValues = (Set)entry.getValue();
                if (attrValues == null || attrValues.isEmpty()) continue;
                sessionProvider.setProperty(session, attrName, attrValues.toArray(new String[attrValues.size()]));
                if (!SAML2Utils.debug.messageEnabled()) continue;
                SAML2Utils.debug.message("SPACSUtils.setAttrMapInSessioin: AttrMap:" + attrName + " , " + attrValues);
            }
        }
    }

    private static void setDiscoBootstrapCredsInSSOToken(SessionProvider sessionProvider, Assertion assertion, Object session) throws SessionException {
        List creds;
        if (assertion == null) {
            return;
        }
        HashSet discoBootstrapCreds = null;
        Advice advice = assertion.getAdvice();
        if (advice != null && (creds = advice.getAdditionalInfo()) != null && !creds.isEmpty()) {
            if (discoBootstrapCreds == null) {
                discoBootstrapCreds = new HashSet();
            }
            discoBootstrapCreds.addAll(creds);
        }
        if (discoBootstrapCreds != null) {
            sessionProvider.setProperty(session, "DiscoveryBootstrapCrendentials", discoBootstrapCreds.toArray(new String[discoBootstrapCreds.size()]));
        }
    }

    public static String getRelayState(String relayStateID, String orgName, String hostEntityId, SAML2MetaManager sm) {
        String relayStateUrl = null;
        if (relayStateID != null && relayStateID.trim().length() != 0) {
            CacheObject cache = (CacheObject)SPCache.relayStateHash.remove((Object)relayStateID);
            if (cache != null) {
                relayStateUrl = (String)cache.getObject();
            }
            if (relayStateUrl == null || relayStateUrl.trim().length() == 0) {
                relayStateUrl = relayStateID;
            }
        }
        if (relayStateUrl == null || relayStateUrl.trim().length() == 0) {
            relayStateUrl = SPACSUtils.getAttributeValueFromSPSSOConfig(orgName, hostEntityId, sm, "defaultRelayState");
        }
        return relayStateUrl;
    }

    public static String getIntermediateURL(String orgName, String hostEntityId, SAML2MetaManager sm) {
        return SPACSUtils.getAttributeValueFromSPSSOConfig(orgName, hostEntityId, sm, "intermediateUrl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prepareForLocalLogin(String orgName, String hostEntityId, SAML2MetaManager sm, ResponseInfo respInfo, String requestURI) {
        String localLoginUrl = SPACSUtils.getAttributeValueFromSPSSOConfig(orgName, hostEntityId, sm, "localAuthURL");
        if (localLoginUrl == null || localLoginUrl.length() == 0) {
            try {
                int index = requestURI.indexOf("Consumer/metaAlias");
                if (index != -1) {
                    localLoginUrl = requestURI.substring(0, index) + "UI/Login?org=" + orgName;
                }
            }
            catch (IndexOutOfBoundsException e) {
                localLoginUrl = null;
            }
            if (localLoginUrl == null || localLoginUrl.length() == 0) {
                localLoginUrl = SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol") + "://" + SystemConfigurationUtil.getProperty("com.iplanet.am.server.host") + SystemConfigurationUtil.getProperty("com.iplanet.am.server.port") + "/UI/Login?org=" + orgName;
            }
        }
        PeriodicCleanUpMap periodicCleanUpMap = SPCache.responseHash;
        synchronized (periodicCleanUpMap) {
            SPCache.responseHash.put((Object)respInfo.getResponse().getID(), (Object)respInfo);
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPACSUtils:prepareForLocalLogin: localLoginUrl = " + localLoginUrl);
        }
        return localLoginUrl;
    }

    private static String getAttributeValueFromSPSSOConfig(String orgName, String hostEntityId, SAML2MetaManager sm, String attrName) {
        String result = null;
        try {
            SPSSOConfigElement config = sm.getSPSSOConfig(orgName, hostEntityId);
            if (config == null) {
                return null;
            }
            Map attrs = SAML2MetaUtils.getAttributes(config);
            List value = (List)attrs.get(attrName);
            if (value != null && value.size() != 0) {
                result = ((String)value.iterator().next()).trim();
            }
        }
        catch (SAML2MetaException sme) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPACSUtils.getAttributeValueFromSPSSOConfig:", (Throwable)((Object)sme));
            }
            result = null;
        }
        return result;
    }

    private static List getSAMLAttributes(Assertion assertion, boolean needAttributeEncrypted, PrivateKey decryptionKey) {
        List statements;
        ArrayList<Attribute> attrList = null;
        if (assertion != null && (statements = assertion.getAttributeStatements()) != null && statements.size() > 0) {
            Iterator it = statements.iterator();
            while (it.hasNext()) {
                List encAttrs;
                AttributeStatement statement = (AttributeStatement)it.next();
                List attributes = statement.getAttribute();
                if (needAttributeEncrypted && attributes != null && attributes.isEmpty()) {
                    SAML2Utils.debug.error("Attribute not encrypted.");
                    return null;
                }
                if (attributes != null) {
                    if (attrList == null) {
                        attrList = new ArrayList<Attribute>();
                    }
                    attrList.addAll(attributes);
                }
                if ((encAttrs = statement.getEncryptedAttribute()) == null) continue;
                Iterator encIter = encAttrs.iterator();
                while (encIter.hasNext()) {
                    if (attrList == null) {
                        attrList = new ArrayList();
                    }
                    try {
                        attrList.add(((EncryptedAttribute)encIter.next()).decrypt(decryptionKey));
                    }
                    catch (SAML2Exception se) {
                        SAML2Utils.debug.error("Decryption error:", (Throwable)((Object)se));
                        return null;
                    }
                }
            }
        }
        return attrList;
    }

    public static Map processResponseForFedlet(HttpServletRequest request, HttpServletResponse response) throws SAML2Exception, IOException, SessionException, ServletException {
        String finalUrl;
        if (request == null || response == null) {
            throw new ServletException(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String requestURL = request.getRequestURL().toString();
        SAML2MetaManager metaManager = new SAML2MetaManager();
        if (metaManager == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorMetaManager"));
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
        if (metaAlias == null || metaAlias.length() == 0) {
            List spMetaAliases = metaManager.getAllHostedServiceProviderMetaAliases("/");
            if (spMetaAliases != null && !spMetaAliases.isEmpty()) {
                metaAlias = (String)spMetaAliases.get(0);
            }
            if (metaAlias == null || metaAlias.length() == 0) {
                throw new ServletException(SAML2SDKUtils.bundle.getString("nullSPEntityID"));
            }
        }
        String hostEntityId = null;
        try {
            hostEntityId = metaManager.getEntityByMetaAlias(metaAlias);
        }
        catch (SAML2MetaException sme) {
            SAML2SDKUtils.debug.error("SPACSUtils.processResponseForFedlet", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("metaDataError"));
        }
        if (hostEntityId == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("metaDataError"));
        }
        String orgName = "/";
        String relayState = request.getParameter("RelayState");
        SessionProvider sessionProvider = null;
        ResponseInfo respInfo = null;
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            SAML2SDKUtils.debug.error("SPACSUtils.processResponseForFedlet", (Throwable)((Object)se));
            throw new SAML2Exception((Throwable)((Object)se));
        }
        respInfo = SPACSUtils.getResponse(request, response, orgName, hostEntityId, metaManager);
        Object newSession = null;
        try {
            newSession = SPACSUtils.processResponse(request, response, metaAlias, null, respInfo, orgName, hostEntityId, metaManager);
        }
        catch (SAML2Exception se) {
            SAML2SDKUtils.debug.message("SPACSUtils.processResponseForFedlet", (Throwable)((Object)se));
            if (se.isRedirectionDone()) {
                return SPACSUtils.createMapForFedlet(respInfo, null);
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("SSOFailed"));
        }
        SAML2SDKUtils.debug.message("SSO SUCCESS");
        String[] redirected = sessionProvider.getProperty(newSession, "SAML2ResponseRedirected");
        if (redirected != null && redirected.length != 0 && redirected[0].equals("true")) {
            SAML2SDKUtils.debug.message("Already redirected in SPAdapter.");
            return SPACSUtils.createMapForFedlet(respInfo, null);
        }
        String realFinalUrl = finalUrl = SPACSUtils.getRelayState(relayState, orgName, hostEntityId, metaManager);
        if (finalUrl != null && finalUrl.length() != 0) {
            try {
                realFinalUrl = sessionProvider.rewriteURL(newSession, finalUrl);
            }
            catch (SessionException se) {
                SAML2SDKUtils.debug.message("SPACSUtils.processRespForFedlet", (Throwable)((Object)se));
                realFinalUrl = finalUrl;
            }
        }
        String redirectUrl = SPACSUtils.getIntermediateURL(orgName, hostEntityId, metaManager);
        String realRedirectUrl = null;
        if (redirectUrl != null && redirectUrl.length() != 0) {
            if (realFinalUrl != null && realFinalUrl.length() != 0) {
                redirectUrl = redirectUrl.indexOf("?") != -1 ? redirectUrl + "&goto=" : redirectUrl + "?goto=";
                redirectUrl = redirectUrl + URLEncDec.encode((String)realFinalUrl);
                try {
                    realRedirectUrl = sessionProvider.rewriteURL(newSession, redirectUrl);
                }
                catch (SessionException se) {
                    SAML2SDKUtils.debug.message("SPACSUtils.processRespForFedlet: rewriting failed.", (Throwable)((Object)se));
                    realRedirectUrl = redirectUrl;
                }
            } else {
                realRedirectUrl = redirectUrl;
            }
        } else {
            realRedirectUrl = finalUrl;
        }
        return SPACSUtils.createMapForFedlet(respInfo, realRedirectUrl);
    }

    private static Map createMapForFedlet(ResponseInfo respInfo, String relayUrl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (relayUrl != null) {
            map.put("RelayState", relayUrl);
        }
        Response samlResp = respInfo.getResponse();
        map.put("Response", samlResp);
        Assertion assertion = (Assertion)samlResp.getAssertion().get(0);
        map.put("Assertion", assertion);
        map.put("Subject", assertion.getSubject());
        map.put("idpEntityID", assertion.getIssuer().getValue());
        AttributeStatement attrStat = null;
        List lst = assertion.getAttributeStatements();
        if (lst != null && !lst.isEmpty()) {
            attrStat = (AttributeStatement)assertion.getAttributeStatements().get(0);
        }
        if (attrStat != null) {
            HashMap<String, List> valMap = new HashMap<String, List>();
            List attrList = attrStat.getAttribute();
            Iterator iter = attrList.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                valMap.put(attr.getName(), attr.getAttributeValueString());
            }
            map.put("attributeMap", valMap);
        }
        return map;
    }
}

