/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSHeader;
import com.sun.identity.liberty.ws.paos.PAOSRequest;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.QuerySignatureUtil;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.ecp.ECPFactory;
import com.sun.identity.saml2.ecp.ECPRelayState;
import com.sun.identity.saml2.ecp.ECPRequest;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.AssertionConsumerServiceElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.ExtensionsType;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SingleSignOnServiceElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.SAML2IDPFinder;
import com.sun.identity.saml2.plugins.SAML2ServiceProviderAdapter;
import com.sun.identity.saml2.plugins.SPAuthnContextMapper;
import com.sun.identity.saml2.profile.AuthnRequestInfo;
import com.sun.identity.saml2.profile.CacheObject;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.protocol.AuthnRequest;
import com.sun.identity.saml2.protocol.Extensions;
import com.sun.identity.saml2.protocol.GetComplete;
import com.sun.identity.saml2.protocol.IDPEntry;
import com.sun.identity.saml2.protocol.IDPList;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.saml2.protocol.Scoping;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class SPSSOFederate {
    static SAML2MetaManager sm = null;

    public static void initiateAuthnRequest(HttpServletRequest request, HttpServletResponse response, String metaAlias, String idpEntityID, Map paramsMap) throws SAML2Exception {
        try {
            String spEntityID = sm.getEntityByMetaAlias(metaAlias);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPSSOFederate : spEntityID is :" + spEntityID);
                SAML2Utils.debug.message("SPSSOFederate realm is :" + realm);
            }
            SPSSOFederate.initiateAuthnRequest(request, response, spEntityID, idpEntityID, realm, paramsMap);
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("SPSSOFederate: Error retreiving spEntityID from MetaAlias", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaAliasError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initiateAuthnRequest(HttpServletRequest request, HttpServletResponse response, String spEntityID, String idpEntityID, String realmName, Map paramsMap) throws SAML2Exception {
        if (spEntityID == null) {
            SAML2Utils.debug.error("SPSSOFederate:Service Provider ID   is missing.");
            String[] data = new String[]{spEntityID};
            LogUtil.error(Level.INFO, "INVALID_SP", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSPEntityID"));
        }
        if (idpEntityID == null) {
            SAML2Utils.debug.error("SPSSOFederate: Identity Provider ID is missing .");
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "INVALID_IDP", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPEntityID"));
        }
        String binding = SPSSOFederate.getParameter(paramsMap, "reqBinding");
        if (binding == null) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate: in initiateSSOFed");
            SAML2Utils.debug.message("SPSSOFederate: spEntityID is : " + spEntityID);
            SAML2Utils.debug.message("SPSSOFederate: idpEntityID : " + idpEntityID);
        }
        String realm = SPSSOFederate.getRealm(realmName);
        try {
            SPSSODescriptorElement spsso;
            if (sm == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
            }
            SPSSOConfigElement spEntityCfg = sm.getSPSSOConfig(realm, spEntityID);
            Map spConfigAttrsMap = null;
            if (spEntityCfg != null) {
                spConfigAttrsMap = SAML2MetaUtils.getAttributes(spEntityCfg);
            }
            if ((spsso = sm.getSPSSODescriptor(realm, spEntityID)) == null) {
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            List extensionsList = SPSSOFederate.getExtensionsList(sm, spEntityID, realm);
            IDPSSODescriptorElement idpsso = sm.getIDPSSODescriptor(realm, idpEntityID);
            if (idpsso == null) {
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            List ssoServiceList = idpsso.getSingleSignOnService();
            String ssoURL = SPSSOFederate.getSSOURL(ssoServiceList, binding);
            if (ssoURL == null || ssoURL.length() == 0) {
                String[] data = new String[]{idpEntityID};
                LogUtil.error(Level.INFO, "SSO_NOT_FOUND", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("ssoServiceNotfound"));
            }
            AuthnRequest authnRequest = SPSSOFederate.createAuthnRequest(realm, spEntityID, paramsMap, spConfigAttrsMap, extensionsList, spsso, idpsso, ssoURL, false);
            SAML2ServiceProviderAdapter spAdapter = SAML2Utils.getSPAdapterClass(spEntityID, realmName);
            if (spAdapter != null) {
                spAdapter.preSingleSignOnRequest(spEntityID, idpEntityID, realmName, request, response, authnRequest);
            }
            String authReqXMLString = authnRequest.toXMLString(true, true);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPSSOFederate: AuthnRequest:" + authReqXMLString);
            }
            String relayState = SPSSOFederate.getParameter(paramsMap, "RelayState");
            String relayStateID = null;
            if (relayState != null && relayState.length() > 0) {
                relayStateID = SPSSOFederate.getRelayStateID(relayState, authnRequest.getID());
            }
            if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                if (idpsso != null && idpsso.isWantAuthnRequestsSigned() || spsso != null && spsso.isAuthnRequestsSigned()) {
                    String certAlias = SPSSOFederate.getParameter(spConfigAttrsMap, "signingCertAlias");
                    SPSSOFederate.signAuthnRequest(certAlias, authnRequest);
                }
                String authXMLString = authnRequest.toXMLString(true, true);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("SPSSOFederate.initiateAuthnRequest: SAML Response content :\n" + authXMLString);
                }
                String encodedReqMsg = SAML2Utils.encodeForPOST(authXMLString);
                SAML2Utils.postToTarget(response, "SAMLRequest", encodedReqMsg, "RelayState", relayStateID, ssoURL);
            } else {
                String encodedXML = SAML2Utils.encodeForRedirect(authReqXMLString);
                StringBuffer queryString = new StringBuffer();
                queryString.append("SAMLRequest").append("=").append(encodedXML);
                if (relayStateID != null && relayStateID.length() > 0) {
                    queryString.append("&").append("RelayState").append("=").append(URLEncDec.encode((String)relayStateID));
                }
                StringBuffer redirectURL = new StringBuffer().append(ssoURL).append("?");
                if (idpsso != null && idpsso.isWantAuthnRequestsSigned() || spsso != null && spsso.isAuthnRequestsSigned()) {
                    String certAlias = SPSSOFederate.getParameter(spConfigAttrsMap, "signingCertAlias");
                    String signedQueryStr = SPSSOFederate.signQueryString(queryString.toString(), certAlias);
                    redirectURL.append(signedQueryStr);
                } else {
                    redirectURL.append(queryString);
                }
                response.sendRedirect(redirectURL.toString());
            }
            String[] data = new String[]{ssoURL};
            LogUtil.access(Level.INFO, "REDIRECT_TO_SP", data, null);
            AuthnRequestInfo reqInfo = new AuthnRequestInfo(request, response, realm, spEntityID, idpEntityID, authnRequest, relayState, paramsMap);
            PeriodicCleanUpMap periodicCleanUpMap = SPCache.requestHash;
            synchronized (periodicCleanUpMap) {
                SPCache.requestHash.put((Object)authnRequest.getID(), (Object)reqInfo);
            }
        }
        catch (IOException ioe) {
            SAML2Utils.debug.error("SPSSOFederate: Exception :", (Throwable)ioe);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorCreatingAuthnRequest"));
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("SPSSOFederate:Error retreiving metadata", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initiateECPRequest(HttpServletRequest request, HttpServletResponse response) throws SAML2Exception, IOException {
        if (!SPSSOFederate.isFromECP(request)) {
            SAML2Utils.debug.error("SPSSOFederate.initiateECPRequest: invalid HTTP request from ECP.");
            response.sendError(400, SAML2Utils.bundle.getString("invalidHttpRequestFromECP"));
            return;
        }
        String metaAlias = request.getParameter("metaAlias");
        Map paramsMap = SAML2Utils.getParamsMap(request);
        String spEntityID = sm.getEntityByMetaAlias(metaAlias);
        String realm = SPSSOFederate.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate.initiateECPRequest: spEntityID is " + spEntityID + ", realm is " + realm);
        }
        try {
            List idps;
            SPSSODescriptorElement spsso;
            if (sm == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
            }
            SPSSOConfigElement spEntityCfg = sm.getSPSSOConfig(realm, spEntityID);
            Map spConfigAttrsMap = null;
            if (spEntityCfg != null) {
                spConfigAttrsMap = SAML2MetaUtils.getAttributes(spEntityCfg);
            }
            if ((spsso = sm.getSPSSODescriptor(realm, spEntityID)) == null) {
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            String[] data = new String[]{spEntityID, realm};
            LogUtil.access(Level.INFO, "RECEIVED_HTTP_REQUEST_ECP", data, null);
            List extensionsList = SPSSOFederate.getExtensionsList(sm, spEntityID, realm);
            AuthnRequest authnRequest = SPSSOFederate.createAuthnRequest(realm, spEntityID, paramsMap, spConfigAttrsMap, extensionsList, spsso, null, null, true);
            SAML2ServiceProviderAdapter spAdapter = SAML2Utils.getSPAdapterClass(spEntityID, realm);
            if (spAdapter != null) {
                spAdapter.preSingleSignOnRequest(spEntityID, realm, null, request, response, authnRequest);
            }
            String alias = SAML2Utils.getSigningCertAlias(realm, spEntityID, "SPRole");
            PrivateKey signingKey = KeyUtil.getKeyProviderInstance().getPrivateKey(alias);
            if (signingKey == null) {
                SAML2Utils.debug.error("SPSSOFederate.initiateECPRequest: Unable to find signing key.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            authnRequest.sign(signingKey, null);
            ECPFactory ecpFactory = ECPFactory.getInstance();
            String relayState = SPSSOFederate.getParameter(paramsMap, "RelayState");
            String ecpRelayStateXmlStr = "";
            if (relayState != null && relayState.length() > 0) {
                String relayStateID = SPSSOFederate.getRelayStateID(relayState, authnRequest.getID());
                ECPRelayState ecpRelayState = ecpFactory.createECPRelayState();
                ecpRelayState.setValue(relayStateID);
                ecpRelayState.setMustUnderstand(Boolean.TRUE);
                ecpRelayState.setActor("http://schemas.xmlsoap.org/soap/actor/next");
                ecpRelayStateXmlStr = ecpRelayState.toXMLString(true, true);
            }
            ECPRequest ecpRequest = ecpFactory.createECPRequest();
            ecpRequest.setIssuer(SPSSOFederate.createIssuer(spEntityID));
            ecpRequest.setMustUnderstand(Boolean.TRUE);
            ecpRequest.setActor("http://schemas.xmlsoap.org/soap/actor/next");
            ecpRequest.setIsPassive(authnRequest.isPassive());
            SAML2IDPFinder ecpIDPFinder = SAML2Utils.getECPIDPFinder(realm, spEntityID);
            if (ecpIDPFinder != null && (idps = ecpIDPFinder.getPreferredIDP(authnRequest, spEntityID, realm, request, response)) != null && !idps.isEmpty()) {
                SAML2MetaManager saml2MetaManager = SAML2Utils.getSAML2MetaManager();
                ArrayList<IDPEntry> idpEntries = null;
                Iterator iter = idps.iterator();
                while (iter.hasNext()) {
                    String idpEntityID = (String)iter.next();
                    IDPSSODescriptorElement idpDesc = saml2MetaManager.getIDPSSODescriptor(realm, idpEntityID);
                    if (idpDesc == null) continue;
                    IDPEntry idpEntry = ProtocolFactory.getInstance().createIDPEntry();
                    idpEntry.setProviderID(idpEntityID);
                    String description = SAML2Utils.getAttributeValueFromSSOConfig(realm, idpEntityID, "IDPRole", "description");
                    idpEntry.setName(description);
                    List ssoServiceList = idpDesc.getSingleSignOnService();
                    String ssoURL = SPSSOFederate.getSSOURL(ssoServiceList, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
                    idpEntry.setLoc(ssoURL);
                    if (idpEntries == null) {
                        idpEntries = new ArrayList<IDPEntry>();
                    }
                    idpEntries.add(idpEntry);
                }
                if (idpEntries != null) {
                    IDPList idpList = ProtocolFactory.getInstance().createIDPList();
                    idpList.setIDPEntries(idpEntries);
                    ecpRequest.setIDPList(idpList);
                    Map attrs = SAML2MetaUtils.getAttributes(spEntityCfg);
                    List values = (List)attrs.get("ECPRequestIDPListGetComplete");
                    if (values != null && !values.isEmpty()) {
                        GetComplete getComplete = ProtocolFactory.getInstance().createGetComplete();
                        getComplete.setValue((String)values.get(0));
                        idpList.setGetComplete(getComplete);
                    }
                }
            }
            String paosRequestXmlStr = "";
            try {
                PAOSRequest paosRequest = new PAOSRequest(authnRequest.getAssertionConsumerServiceURL(), "urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", null, Boolean.TRUE, "http://schemas.xmlsoap.org/soap/actor/next");
                paosRequestXmlStr = paosRequest.toXMLString(true, true);
            }
            catch (PAOSException paosex) {
                SAML2Utils.debug.error("SPSSOFederate.initiateECPRequest:", (Throwable)((Object)paosex));
                throw new SAML2Exception(paosex.getMessage());
            }
            String header = paosRequestXmlStr + ecpRequest.toXMLString(true, true) + ecpRelayStateXmlStr;
            String body = authnRequest.toXMLString(true, true);
            try {
                SOAPMessage reply = SAML2Utils.createSOAPMessage(header, body);
                String[] data2 = new String[]{spEntityID, realm, ""};
                if (LogUtil.isAccessLoggable(Level.FINE)) {
                    data2[2] = SAML2Utils.soapMessageToString(reply);
                }
                LogUtil.access(Level.INFO, "SEND_ECP_PAOS_REQUEST", data2, null);
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                response.setStatus(200);
                SAML2Utils.putHeaders(reply.getMimeHeaders(), response);
                response.setContentType("application/vnd.paos+xml");
                ServletOutputStream os = response.getOutputStream();
                reply.writeTo((OutputStream)os);
                os.flush();
            }
            catch (SOAPException soapex) {
                SAML2Utils.debug.error("SPSSOFederate.initiateECPRequest", (Throwable)soapex);
                String[] data3 = new String[]{spEntityID, realm};
                LogUtil.error(Level.INFO, "SEND_ECP_PAOS_REQUEST_FAILED", data3, null);
                response.sendError(500, soapex.getMessage());
                return;
            }
            AuthnRequestInfo reqInfo = new AuthnRequestInfo(request, response, realm, spEntityID, null, authnRequest, relayState, paramsMap);
            PeriodicCleanUpMap periodicCleanUpMap = SPCache.requestHash;
            synchronized (periodicCleanUpMap) {
                SPCache.requestHash.put((Object)authnRequest.getID(), (Object)reqInfo);
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("SPSSOFederate:Error retreiving metadata", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    public static boolean isFromECP(HttpServletRequest request) {
        PAOSHeader paosHeader = null;
        try {
            paosHeader = new PAOSHeader(request);
        }
        catch (PAOSException pex) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPSSOFederate.initiateECPRequest:no PAOS header");
            }
            return false;
        }
        HashMap svcOpts = paosHeader.getServicesAndOptions();
        if (svcOpts == null || !svcOpts.containsKey("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp")) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("SPSSOFederate.initiateECPRequest:PAOS header doesn't contain ECP service");
            }
            return false;
        }
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            return false;
        }
        return acceptHeader.indexOf("application/vnd.paos+xml") != -1;
    }

    private static NameIDPolicy createNameIDPolicy(String spEntityID, String format, boolean allowCreate, SPSSODescriptorElement spsso, IDPSSODescriptorElement idpsso, String realm, Map paramsMap) throws SAML2Exception {
        format = SAML2Utils.verifyNameIDFormat(format, spsso, idpsso);
        NameIDPolicy nameIDPolicy = ProtocolFactory.getInstance().createNameIDPolicy();
        String affiliationID = SPSSOFederate.getParameter(paramsMap, "affiliationID");
        if (affiliationID != null) {
            AffiliationDescriptorType affiDesc = sm.getAffiliationDescriptor(realm, affiliationID);
            if (affiDesc == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("affiliationNotFound"));
            }
            if (!affiDesc.getAffiliateMember().contains(spEntityID)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
            }
            nameIDPolicy.setSPNameQualifier(affiliationID);
        } else {
            nameIDPolicy.setSPNameQualifier(spEntityID);
        }
        nameIDPolicy.setAllowCreate(allowCreate);
        nameIDPolicy.setFormat(format);
        return nameIDPolicy;
    }

    private static Issuer createIssuer(String spEntityID) throws SAML2Exception {
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue(spEntityID);
        return issuer;
    }

    private static AuthnRequest createAuthnRequest(String realmName, String spEntityID, Map paramsMap, Map spConfigMap, List extensionsList, SPSSODescriptorElement spsso, IDPSSODescriptorElement idpsso, String ssourl, boolean isForECP) throws SAML2Exception {
        String requestID = SAML2Utils.generateID();
        if (requestID == null || requestID.length() == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("cannotGenerateID"));
        }
        String destinationURI = SPSSOFederate.getParameter(paramsMap, "Destination");
        Boolean isPassive = SPSSOFederate.doPassive(paramsMap, spConfigMap);
        Boolean isforceAuthn = SPSSOFederate.isForceAuthN(paramsMap, spConfigMap);
        boolean allowCreate = SPSSOFederate.isAllowCreate(paramsMap, spConfigMap);
        String consent = SPSSOFederate.getParameter(paramsMap, "Consent");
        Extensions extensions = SPSSOFederate.createExtensions(extensionsList);
        String nameIDPolicyFormat = SPSSOFederate.getParameter(paramsMap, "NameIDFormat");
        NameIDPolicy nameIDPolicy = SPSSOFederate.createNameIDPolicy(spEntityID, nameIDPolicyFormat, allowCreate, spsso, idpsso, realmName, paramsMap);
        Issuer issuer = SPSSOFederate.createIssuer(spEntityID);
        Integer acsIndex = SPSSOFederate.getIndex(paramsMap, "AssertionConsumerServiceIndex");
        Integer attrIndex = SPSSOFederate.getIndex(paramsMap, "AttributeConsumingServiceIndex");
        String protocolBinding = isForECP ? "urn:oasis:names:tc:SAML:2.0:bindings:PAOS" : SPSSOFederate.getParameter(paramsMap, "binding");
        OrderedSet acsSet = SPSSOFederate.getACSUrl(spsso, protocolBinding);
        String acsURL = (String)acsSet.get(0);
        protocolBinding = (String)acsSet.get(1);
        RequestedAuthnContext reqAuthnContext = SPSSOFederate.createReqAuthnContext(realmName, spEntityID, paramsMap, spConfigMap);
        AuthnRequest authnReq = ProtocolFactory.getInstance().createAuthnRequest();
        if (!isForECP) {
            if (destinationURI == null || destinationURI.length() == 0) {
                authnReq.setDestination(ssourl);
            } else {
                authnReq.setDestination(destinationURI);
            }
        }
        authnReq.setConsent(consent);
        authnReq.setIsPassive(isPassive);
        authnReq.setForceAuthn(isforceAuthn);
        authnReq.setAttributeConsumingServiceIndex(attrIndex);
        authnReq.setAssertionConsumerServiceIndex(acsIndex);
        authnReq.setAssertionConsumerServiceURL(acsURL);
        authnReq.setProtocolBinding(protocolBinding);
        authnReq.setIssuer(issuer);
        authnReq.setNameIDPolicy(nameIDPolicy);
        authnReq.setRequestedAuthnContext(reqAuthnContext);
        if (extensions != null) {
            authnReq.setExtensions(extensions);
        }
        authnReq.setID(requestID);
        authnReq.setVersion("2.0");
        authnReq.setIssueInstant(new Date());
        Boolean enableIDPProxy = SPSSOFederate.getAttrValueFromMap(spConfigMap, "enableIDPProxy");
        if (enableIDPProxy != null && enableIDPProxy.booleanValue()) {
            List proxyIDPs;
            Scoping scoping = ProtocolFactory.getInstance().createScoping();
            String proxyCountParam = SPSSOFederate.getParameter(spConfigMap, "idpProxyCount");
            if (proxyCountParam != null && !proxyCountParam.equals("")) {
                scoping.setProxyCount(new Integer(proxyCountParam));
            }
            if ((proxyIDPs = (List)spConfigMap.get("idpProxyList")) != null && !proxyIDPs.isEmpty()) {
                Iterator iter = proxyIDPs.iterator();
                ArrayList<IDPEntry> list = new ArrayList<IDPEntry>();
                while (iter.hasNext()) {
                    IDPEntry entry = ProtocolFactory.getInstance().createIDPEntry();
                    entry.setProviderID((String)iter.next());
                    list.add(entry);
                }
                IDPList idpList = ProtocolFactory.getInstance().createIDPList();
                idpList.setIDPEntries(list);
                scoping.setIDPList(idpList);
            }
            authnReq.setScoping(scoping);
        }
        return authnReq;
    }

    public static Boolean getAttrValueFromMap(Map attrMap, String attrName) {
        String attrVal;
        Boolean boolVal = null;
        if (attrMap != null && attrMap.size() > 0 && (attrVal = SPSSOFederate.getParameter(attrMap, attrName)) != null && (attrVal.equals("true") || attrVal.equals("false"))) {
            boolVal = new Boolean(attrVal);
        }
        return boolVal;
    }

    static String getSSOURL(List ssoServiceList, String binding) {
        String ssoURL = null;
        if (ssoServiceList != null && !ssoServiceList.isEmpty()) {
            Iterator i = ssoServiceList.iterator();
            while (i.hasNext()) {
                SingleSignOnServiceElement sso = (SingleSignOnServiceElement)i.next();
                if (sso == null || sso.getBinding() == null || !sso.getBinding().equals(binding)) continue;
                ssoURL = sso.getLocation();
                break;
            }
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate:  SingleSignOnService URL :" + ssoURL);
        }
        return ssoURL;
    }

    static OrderedSet getACSUrl(SPSSODescriptorElement spsso, String binding) {
        String responseBinding = binding;
        if (binding != null && binding.length() > 0 && binding.indexOf("urn:oasis:names:tc:SAML:2.0:bindings:") == -1) {
            responseBinding = "urn:oasis:names:tc:SAML:2.0:bindings:" + binding;
        }
        List acsList = spsso.getAssertionConsumerService();
        String acsURL = null;
        if (acsList != null && !acsList.isEmpty()) {
            Iterator ac = acsList.iterator();
            while (ac.hasNext()) {
                AssertionConsumerServiceElement ace = (AssertionConsumerServiceElement)ac.next();
                if (ace != null && ace.isIsDefault() && (responseBinding == null || responseBinding.length() == 0)) {
                    acsURL = ace.getLocation();
                    responseBinding = ace.getBinding();
                    break;
                }
                if (ace == null || !ace.getBinding().equals(responseBinding)) continue;
                acsURL = ace.getLocation();
                break;
            }
        }
        OrderedSet ol = new OrderedSet();
        ol.add(acsURL);
        ol.add((Object)responseBinding);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate: AssertionConsumerService : URL :" + acsURL);
            SAML2Utils.debug.message("SPSSOFederate: AssertionConsumerService : Binding Passed in Query: " + binding);
            SAML2Utils.debug.message("SPSSOFederate: AssertionConsumerService : Binding : " + responseBinding);
        }
        return ol;
    }

    private static String getRealm(String realm) {
        return realm == null || realm.length() == 0 ? "/" : realm;
    }

    private static Boolean doPassive(Map paramsMap, Map spConfigAttrsMap) {
        Boolean isPassive = Boolean.FALSE;
        String isPassiveStr = SPSSOFederate.getParameter(paramsMap, "IsPassive");
        isPassive = isPassiveStr != null && (isPassiveStr.equals("true") || isPassiveStr.equals("false")) ? new Boolean(isPassiveStr) : SPSSOFederate.getAttrValueFromMap(spConfigAttrsMap, "IsPassive");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate: isPassive : " + isPassive);
        }
        return isPassive == null ? Boolean.FALSE : isPassive;
    }

    private static Boolean isForceAuthN(Map paramsMap, Map spConfigAttrsMap) {
        Boolean isforceAuthn = Boolean.FALSE;
        String forceAuthn = SPSSOFederate.getParameter(paramsMap, "ForceAuthn");
        isforceAuthn = forceAuthn != null && (forceAuthn.equals("true") || forceAuthn.equals("false")) ? new Boolean(forceAuthn) : SPSSOFederate.getAttrValueFromMap(spConfigAttrsMap, "ForceAuthn");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate:ForceAuthn: " + forceAuthn);
        }
        return isforceAuthn == null ? Boolean.FALSE : isforceAuthn;
    }

    private static boolean isAllowCreate(Map paramsMap, Map spConfigAttrsMap) {
        boolean allowCreate = true;
        String allowCreateStr = SPSSOFederate.getParameter(paramsMap, "AllowCreate");
        if (allowCreateStr != null && (allowCreateStr.equals("true") || allowCreateStr.equals("false"))) {
            allowCreate = new Boolean(allowCreateStr);
        } else {
            Boolean val = SPSSOFederate.getAttrValueFromMap(spConfigAttrsMap, "AllowCreate");
            if (val != null) {
                allowCreate = val;
            }
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate:AllowCreate:" + allowCreate);
        }
        return allowCreate;
    }

    private static Integer getIndex(Map paramsMap, String attrName) {
        Integer attrIndex = null;
        String index = SPSSOFederate.getParameter(paramsMap, attrName);
        if (index != null && index.length() > 0) {
            attrIndex = new Integer(index);
        }
        return attrIndex;
    }

    public static String getParameter(Map paramsMap, String attrName) {
        List attrValList;
        String attrVal = null;
        if (paramsMap != null && !paramsMap.isEmpty() && (attrValList = (List)paramsMap.get(attrName)) != null && !attrValList.isEmpty()) {
            attrVal = (String)attrValList.iterator().next();
        }
        return attrVal;
    }

    private static List getExtensionsList(SAML2MetaManager sm, String entityID, String realm) {
        List extensionsList = null;
        try {
            ExtensionsType ext;
            EntityDescriptorElement ed = sm.getEntityDescriptor(realm, entityID);
            if (ed != null && (ext = ed.getExtensions()) != null) {
                extensionsList = ext.getAny();
            }
        }
        catch (SAML2Exception e) {
            SAML2Utils.debug.error("SPSSOFederate:Error retrieving EntityDescriptor");
        }
        return extensionsList;
    }

    private static Extensions createExtensions(List extensionsList) throws SAML2Exception {
        Extensions extensions = null;
        if (extensionsList != null && !extensionsList.isEmpty()) {
            extensions = ProtocolFactory.getInstance().createExtensions();
            extensions.setAny(extensionsList);
        }
        return extensions;
    }

    public static String getRelayStateID(String relayState, String requestID) {
        SPCache.relayStateHash.put((Object)requestID, (Object)new CacheObject(relayState));
        return requestID;
    }

    private static RequestedAuthnContext createReqAuthnContext(String realmName, String spEntityID, Map paramsMap, Map spConfigMap) {
        RequestedAuthnContext reqCtx;
        block3: {
            List listVal;
            reqCtx = null;
            String className = null;
            if (spConfigMap != null && !spConfigMap.isEmpty() && (listVal = (List)spConfigMap.get("spAuthncontextMapper")) != null && listVal.size() != 0) {
                className = ((String)listVal.iterator().next()).trim();
            }
            SPAuthnContextMapper spAuthnContextMapper = SAML2Utils.getSPAuthnContextMapper(realmName, spEntityID, className);
            try {
                reqCtx = spAuthnContextMapper.getRequestedAuthnContext(realmName, spEntityID, paramsMap);
            }
            catch (SAML2Exception e) {
                if (!SAML2Utils.debug.messageEnabled()) break block3;
                SAML2Utils.debug.message("SPSSOFederate:Error creating RequestedAuthnContext", (Throwable)((Object)e));
            }
        }
        return reqCtx;
    }

    public static String signQueryString(String queryString, String certAlias) throws SAML2Exception {
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPSSOFederate:queryString:" + queryString);
            SAML2Utils.debug.message("SPSSOFederate: certAlias :" + certAlias);
        }
        KeyProvider kp = KeyUtil.getKeyProviderInstance();
        PrivateKey privateKey = kp.getPrivateKey(certAlias);
        return QuerySignatureUtil.sign(queryString, privateKey);
    }

    public static void signAuthnRequest(String certAlias, AuthnRequest authnRequest) throws SAML2Exception {
        KeyProvider kp = KeyUtil.getKeyProviderInstance();
        if (kp == null) {
            SAML2Utils.debug.error("SPSSOFederate:signAuthnRequest: Unable to get a key provider instance.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullKeyProvider"));
        }
        authnRequest.sign(kp.getPrivateKey(certAlias), kp.getX509Certificate(certAlias));
    }

    static {
        try {
            sm = new SAML2MetaManager();
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("SPSSOFederate: Error retreiving metadata", (Throwable)((Object)sme));
        }
    }
}

