/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameIDType;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.SAML2ServiceProviderAdapter;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPProxyUtil;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPFedSession;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;

public class SPSingleLogout {
    static SAML2MetaManager sm = null;
    static AssertionFactory af = AssertionFactory.getInstance();
    static Debug debug = SAML2Utils.debug;
    static final Status SUCCESS_STATUS = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
    static final Status PARTIAL_LOGOUT_STATUS = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("partialLogout"));
    static SessionProvider sessionProvider = null;

    public static void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, String binding, Map paramsMap) throws SAML2Exception {
        SPSingleLogout.initiateLogoutRequest(request, response, binding, paramsMap, null, null, null);
    }

    public static void initiateLogoutRequest(HttpServletRequest request, HttpServletResponse response, String binding, Map paramsMap, LogoutRequest origLogoutRequest, SOAPMessage msg, Object newSession) throws SAML2Exception {
        if (debug.messageEnabled()) {
            debug.message("SPSingleLogout:initiateLogoutRequest");
            debug.message("binding : " + binding);
            debug.message("paramsMap : " + paramsMap);
        }
        String metaAlias = (String)paramsMap.get("spMetaAlias");
        try {
            SOAPMessage soapMsg;
            SPSSODescriptorElement spsso;
            String[] values;
            Object session = null;
            session = newSession != null ? newSession : sessionProvider.getSession(request);
            if (session == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSSOToken"));
            }
            if (metaAlias == null && (values = sessionProvider.getProperty(session, "spMetaAlias")) != null && values.length > 0) {
                metaAlias = values[0];
            }
            if (metaAlias == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSPMetaAlias"));
            }
            paramsMap.put("metaAlias", metaAlias);
            String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
            debug.message("realm : " + realm);
            String spEntityID = sm.getEntityByMetaAlias(metaAlias);
            if (spEntityID == null) {
                debug.error("Service Provider ID is missing");
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "INVALID_SP", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSPEntityID"));
            }
            debug.message("spEntityID : " + spEntityID);
            String tokenID = sessionProvider.getSessionID(session);
            String infoKeyString = null;
            try {
                String[] values2 = sessionProvider.getProperty(session, AccountUtils.getNameIDInfoKeyAttribute());
                if (values2 != null && values2.length > 0) {
                    infoKeyString = values2[0];
                }
            }
            catch (SessionException se) {
                debug.error("Unable to get infoKeyString from session.", (Throwable)((Object)se));
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorInfoKeyString"));
            }
            if (infoKeyString == null) {
                debug.error("Unable to get infoKeyString from session.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorInfoKeyString"));
            }
            if (debug.messageEnabled()) {
                debug.message("tokenID : " + tokenID);
                debug.message("infoKeyString : " + infoKeyString);
            }
            if ((spsso = sm.getSPSSODescriptor(realm, spEntityID)) == null) {
                String[] data = new String[]{spEntityID};
                LogUtil.error(Level.INFO, "SP_METADATA_ERROR", data, null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
            List extensionsList = LogoutUtil.getExtensionsList(paramsMap);
            String relayState = SAML2Utils.getParameter(paramsMap, "RelayState");
            if (relayState == null || relayState.equals("")) {
                relayState = SAML2Utils.getAttributeValueFromSSOConfig(realm, spEntityID, "SPRole", "defaultRelayState");
            }
            StringTokenizer st = new StringTokenizer(infoKeyString, ";");
            String requestID = null;
            if (st != null && st.hasMoreTokens()) {
                while (st.hasMoreTokens()) {
                    String tmpInfoKeyString = st.nextToken();
                    requestID = SPSingleLogout.prepareForLogout(realm, tokenID, metaAlias, extensionsList, binding, relayState, request, response, paramsMap, tmpInfoKeyString, origLogoutRequest, msg);
                }
            }
            if ((soapMsg = (SOAPMessage)IDPCache.SOAPMessageByLogoutRequestID.get(requestID)) != null) {
                IDPProxyUtil.sendProxyLogoutResponseBySOAP(soapMsg, response);
            }
            if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                sessionProvider.invalidateSession(session, request, response);
            }
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retreiving metadata", (Throwable)((Object)sme));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        catch (SessionException ssoe) {
            debug.error("Session exception: ", (Throwable)((Object)ssoe));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String prepareForLogout(String realm, String tokenID, String metaAlias, List extensionsList, String binding, String relayState, HttpServletRequest request, HttpServletResponse response, Map paramsMap, String infoKeyString, LogoutRequest origLogoutRequest, SOAPMessage msg) throws SAML2Exception, SessionException {
        SPFedSession fedSession = null;
        List list = (List)SPCache.fedSessionListsByNameIDInfoKey.get(infoKeyString);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                ListIterator iter = list.listIterator();
                while (iter.hasNext()) {
                    fedSession = (SPFedSession)iter.next();
                    if (tokenID.equals(fedSession.spTokenID)) {
                        iter.remove();
                        if (list.size() != 0) break;
                        SPCache.fedSessionListsByNameIDInfoKey.remove(infoKeyString);
                        break;
                    }
                    fedSession = null;
                }
            }
        }
        NameIDInfoKey nameIdInfoKey = NameIDInfoKey.parse(infoKeyString);
        if (fedSession == null) {
            if (debug.messageEnabled()) {
                debug.message("No session partner, just do local logout.");
            }
            return null;
        }
        IDPSSODescriptorElement idpsso = sm.getIDPSSODescriptor(realm, nameIdInfoKey.getRemoteEntityID());
        if (idpsso == null) {
            String[] data = new String[]{nameIdInfoKey.getRemoteEntityID()};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List slosList = idpsso.getSingleLogoutService();
        if (slosList == null) {
            String[] data = new String[]{nameIdInfoKey.getRemoteEntityID()};
            LogUtil.error(Level.INFO, "SLO_NOT_FOUND", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("sloServiceListNotfound"));
        }
        IDPSSOConfigElement idpConfig = null;
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            idpConfig = sm.getIDPSSOConfig(realm, nameIdInfoKey.getRemoteEntityID());
        }
        StringBuffer requestID = LogoutUtil.doLogout(metaAlias, nameIdInfoKey.getRemoteEntityID(), slosList, extensionsList, binding, relayState, fedSession.idpSessionIndex, fedSession.info.getNameID(), request, response, paramsMap, idpConfig);
        String requestIDStr = requestID.toString();
        if (debug.messageEnabled()) {
            debug.message("\nSPSLO.requestIDStr = " + requestIDStr + "\nbinding = " + binding);
        }
        if (requestIDStr != null && requestIDStr.length() != 0 && (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect") || binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) && origLogoutRequest != null) {
            IDPCache.proxySPLogoutReqCache.put(requestIDStr, origLogoutRequest);
        } else if (requestIDStr != null && requestIDStr.length() != 0 && binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP") && msg != null) {
            IDPCache.SOAPMessageByLogoutRequestID.put(requestIDStr, msg);
        }
        return requestIDStr;
    }

    public static Map processLogoutResponse(HttpServletRequest request, HttpServletResponse response, String samlResponse, String relayState) throws SAML2Exception, SessionException {
        String method = "SPSingleLogout:processLogoutResponse : ";
        if (debug.messageEnabled()) {
            debug.message(method + "samlResponse : " + samlResponse);
            debug.message(method + "relayState : " + relayState);
        }
        String rmethod = request.getMethod();
        LogoutResponse logoutRes = null;
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        if (rmethod.equals("POST")) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
            logoutRes = LogoutUtil.getLogoutResponseFromPost(samlResponse, response);
        } else if (rmethod.equals("GET")) {
            String decodedStr = SAML2Utils.decodeFromRedirect(samlResponse);
            if (decodedStr == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
            }
            logoutRes = ProtocolFactory.getInstance().createLogoutResponse(decodedStr);
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        String spEntityID = sm.getEntityByMetaAlias(metaAlias);
        String idpEntityID = logoutRes.getIssuer().getValue();
        Issuer resIssuer = logoutRes.getIssuer();
        String inResponseTo = logoutRes.getInResponseTo();
        LogoutRequest logoutReq = (LogoutRequest)SPCache.logoutRequestIDHash.remove((Object)inResponseTo);
        String userId = SPSingleLogout.preSingleLogoutProcess(spEntityID, realm, request, response, null, logoutReq, logoutRes, binding);
        SAML2Utils.verifyResponseIssuer(realm, spEntityID, resIssuer, inResponseTo);
        boolean needToVerify = SAML2Utils.getWantLogoutResponseSigned(realm, spEntityID, "SPRole");
        if (debug.messageEnabled()) {
            debug.message(method + "metaAlias : " + metaAlias);
            debug.message(method + "realm : " + realm);
            debug.message(method + "idpEntityID : " + idpEntityID);
            debug.message(method + "spEntityID : " + spEntityID);
        }
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("entityid", spEntityID);
        if (needToVerify) {
            boolean valid = false;
            if (rmethod.equals("GET")) {
                String queryString = request.getQueryString();
                valid = SAML2Utils.verifyQueryString(queryString, realm, "SPRole", idpEntityID);
            } else {
                valid = LogoutUtil.verifySLOResponse(logoutRes, realm, idpEntityID, spEntityID, "SPRole");
            }
            if (!valid) {
                debug.error("SPSingleLogout.processLogoutResponse: Invalid signature in SLO Response.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
            }
            SPSSODescriptorElement spsso = sm.getSPSSODescriptor(realm, spEntityID);
            String loc = SPSingleLogout.getSLOResponseLocationOrLocation(spsso, binding);
            if (!SAML2Utils.verifyDestination(logoutRes.getDestination(), loc)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidDestination"));
            }
        }
        if (inResponseTo == null || inResponseTo.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("LogoutResponse inResponseTo is null");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullInResponseToFromSamlResponse"));
        }
        if (logoutReq != null) {
            if (debug.messageEnabled()) {
                debug.message("LogoutResponse inResponseTo matches LogoutRequest ID.");
            }
        } else {
            if (debug.messageEnabled()) {
                debug.message("LogoutResponse inResponseTo does not match LogoutRequest ID.");
            }
            throw new SAML2Exception(SAML2Utils.bundle.getString("LogoutRequestIDandInResponseToDoNotMatch"));
        }
        infoMap.put("inResponseTo", inResponseTo);
        infoMap.put("RelayState", relayState);
        SessionProvider sessionProvider = SessionManager.getProvider();
        Object session = sessionProvider.getSession(request);
        if (session != null && sessionProvider.isValid(session)) {
            sessionProvider.invalidateSession(session, request, response);
        }
        SPSingleLogout.postSingleLogoutSuccess(spEntityID, realm, request, response, userId, logoutReq, logoutRes, binding);
        return infoMap;
    }

    static String preSingleLogoutProcess(String hostedEntityID, String realm, HttpServletRequest request, HttpServletResponse response, String userID, LogoutRequest logoutRequest, LogoutResponse logoutResponse, String binding) throws SAML2Exception {
        SAML2ServiceProviderAdapter spAdapter;
        block7: {
            spAdapter = null;
            try {
                spAdapter = SAML2Utils.getSPAdapterClass(hostedEntityID, realm);
            }
            catch (SAML2Exception e) {
                if (!SAML2Utils.debug.messageEnabled()) break block7;
                SAML2Utils.debug.message("SPACSUtils.invokeSPAdapterForPreSLOProcess", (Throwable)((Object)e));
            }
        }
        if (spAdapter != null) {
            block8: {
                if (userID == null) {
                    try {
                        Object session = SessionManager.getProvider().getSession(request);
                        if (session != null) {
                            userID = SessionManager.getProvider().getPrincipalName(session);
                        }
                    }
                    catch (SessionException ex) {
                        if (!SAML2Utils.debug.messageEnabled()) break block8;
                        SAML2Utils.debug.message("SPACSUtils.invokeSPAdapterForPreSLOProcess2", (Throwable)((Object)ex));
                    }
                }
            }
            spAdapter.preSingleLogoutProcess(hostedEntityID, realm, request, response, userID, logoutRequest, logoutResponse, binding);
        }
        return userID;
    }

    static void postSingleLogoutSuccess(String hostedEntityID, String realm, HttpServletRequest request, HttpServletResponse response, String userID, LogoutRequest logoutRequest, LogoutResponse logoutResponse, String binding) {
        SAML2ServiceProviderAdapter spAdapter;
        block3: {
            spAdapter = null;
            try {
                spAdapter = SAML2Utils.getSPAdapterClass(hostedEntityID, realm);
            }
            catch (SAML2Exception e) {
                if (!SAML2Utils.debug.messageEnabled()) break block3;
                SAML2Utils.debug.message("SPACSUtils.invokeSPAdapterForPostSLOProcess", (Throwable)((Object)e));
            }
        }
        if (spAdapter != null) {
            spAdapter.postSingleLogoutSuccess(hostedEntityID, realm, request, response, userID, logoutRequest, logoutResponse, binding);
        }
    }

    public static void processLogoutRequest(HttpServletRequest request, HttpServletResponse response, String samlRequest, String relayState) throws SAML2Exception, SessionException {
        List partners;
        IDPSSODescriptorElement idpsso;
        String method = "processLogoutRequest : ";
        if (debug.messageEnabled()) {
            debug.message(method + "samlRequest : " + samlRequest);
            debug.message(method + "relayState : " + relayState);
        }
        String rmethod = request.getMethod();
        LogoutRequest logoutReq = null;
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
        if (rmethod.equals("POST")) {
            binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
            logoutReq = LogoutUtil.getLogoutRequestFromPost(samlRequest, response);
        } else if (rmethod.equals("GET")) {
            String decodedStr = SAML2Utils.decodeFromRedirect(samlRequest);
            if (decodedStr == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlRequest"));
            }
            logoutReq = ProtocolFactory.getInstance().createLogoutRequest(decodedStr);
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        String realm = SAML2Utils.getRealm(SAML2MetaUtils.getRealmByMetaAlias(metaAlias));
        String spEntityID = sm.getEntityByMetaAlias(metaAlias);
        String location = null;
        String idpEntityID = logoutReq.getIssuer().getValue();
        boolean needToVerify = SAML2Utils.getWantLogoutRequestSigned(realm, spEntityID, "SPRole");
        if (debug.messageEnabled()) {
            debug.message(method + "metaAlias : " + metaAlias);
            debug.message(method + "realm : " + realm);
            debug.message(method + "idpEntityID : " + idpEntityID);
            debug.message(method + "spEntityID : " + spEntityID);
        }
        if (needToVerify) {
            boolean valid = false;
            if (rmethod.equals("POST")) {
                valid = LogoutUtil.verifySLORequest(logoutReq, realm, idpEntityID, spEntityID, "SPRole");
            } else {
                String queryString = request.getQueryString();
                valid = SAML2Utils.verifyQueryString(queryString, realm, "SPRole", idpEntityID);
            }
            if (!valid) {
                debug.error("SPSingleLogout.processLogoutRequest: Invalid signature in SLO Request.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
            }
            SPSSODescriptorElement spsso = sm.getSPSSODescriptor(realm, spEntityID);
            String loc = SPSingleLogout.getSLOResponseLocationOrLocation(spsso, binding);
            if (!SAML2Utils.verifyDestination(logoutReq.getDestination(), loc)) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidDestination"));
            }
        }
        if ((idpsso = sm.getIDPSSODescriptor(realm, idpEntityID)) == null) {
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "IDP_METADATA_ERROR", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        List slosList = idpsso.getSingleLogoutService();
        if (slosList == null) {
            String[] data = new String[]{idpEntityID};
            LogUtil.error(Level.INFO, "SLO_NOT_FOUND", data, null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("sloServiceListNotfound"));
        }
        location = LogoutUtil.getSLOResponseServiceLocation(slosList, binding);
        if (location == null || location.length() == 0) {
            location = LogoutUtil.getSLOServiceLocation(slosList, binding);
            if (location == null || location.length() == 0) {
                debug.error("Unable to find the IDP's single logout response service with the HTTP-Redirect binding");
                throw new SAML2Exception(SAML2Utils.bundle.getString("sloResponseServiceLocationNotfound"));
            }
            if (debug.messageEnabled()) {
                debug.message("SP's single logout response service location = " + location);
            }
        } else if (debug.messageEnabled()) {
            debug.message("IDP's single logout response service location = " + location);
        }
        if ((partners = IDPProxyUtil.getSPSessionPartners(request)) != null && !partners.isEmpty()) {
            LogoutResponse logoutRespon = SPSingleLogout.processLogoutRequest(logoutReq, spEntityID, realm, request, response, false, false, binding, true);
            logoutRespon.setDestination(location);
            IDPProxyUtil.sendIDPInitProxyLogoutRequest(request, response, logoutRespon, location, spEntityID, idpEntityID, binding);
        } else {
            LogoutResponse logoutRes = SPSingleLogout.processLogoutRequest(logoutReq, spEntityID, realm, request, response, true, binding, true);
            logoutRes.setDestination(location);
            LogoutUtil.sendSLOResponse(response, logoutRes, location, relayState, realm, spEntityID, "SPRole", idpEntityID, binding);
        }
    }

    public static LogoutResponse processLogoutRequest(LogoutRequest logoutReq, String spEntityID, String realm, HttpServletRequest request, HttpServletResponse response, boolean isLBReq, String binding, boolean isVerified) {
        return SPSingleLogout.processLogoutRequest(logoutReq, spEntityID, realm, request, response, isLBReq, true, binding, isVerified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogoutResponse processLogoutRequest(LogoutRequest logoutReq, String spEntityID, String realm, HttpServletRequest request, HttpServletResponse response, boolean isLBReq, boolean destroySession, String binding, boolean isVerified) {
        LogoutResponse logResponse;
        String userId;
        String idpEntity;
        Issuer issuer;
        Status status;
        NameIDType nameID;
        block54: {
            String method = "processLogoutRequest : ";
            nameID = null;
            status = null;
            issuer = null;
            idpEntity = logoutReq.getIssuer().getValue();
            userId = null;
            try {
                Object token;
                List remoteServiceURLs;
                boolean foundPeer;
                List list;
                int numSI;
                List siList;
                block55: {
                    String spQ;
                    issuer = logoutReq.getIssuer();
                    String requestId = logoutReq.getID();
                    SAML2Utils.verifyRequestIssuer(realm, spEntityID, issuer, requestId);
                    issuer = SAML2Utils.createIssuer(spEntityID);
                    siList = logoutReq.getSessionIndex();
                    numSI = 0;
                    if (siList != null) {
                        numSI = siList.size();
                        if (debug.messageEnabled()) {
                            debug.message("processLogoutRequest : Number of session indices in the logout request is " + numSI);
                        }
                    }
                    if ((nameID = LogoutUtil.getNameIDFromSLORequest(logoutReq, realm, spEntityID, "SPRole")) == null) {
                        debug.error("processLogoutRequest : LogoutRequest does not contain Name ID");
                        status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("missing_name_identifier"));
                        break block54;
                    }
                    String infoKeyString = null;
                    infoKeyString = new NameIDInfoKey(nameID.getValue(), spEntityID, idpEntity).toValueString();
                    if (debug.messageEnabled()) {
                        debug.message("processLogoutRequest : infokey=" + infoKeyString);
                    }
                    list = (List)SPCache.fedSessionListsByNameIDInfoKey.get(infoKeyString);
                    if (debug.messageEnabled()) {
                        debug.message("processLogoutRequest : SPFedsessions=" + list);
                    }
                    if (!(list != null && !list.isEmpty() || (spQ = nameID.getSPNameQualifier()) != null && spQ.length() != 0)) {
                        infoKeyString = new NameIDInfoKey(nameID.getValue(), spEntityID, nameID.getNameQualifier()).toValueString();
                        list = (List)SPCache.fedSessionListsByNameIDInfoKey.get(infoKeyString);
                    }
                    foundPeer = false;
                    remoteServiceURLs = null;
                    if (isLBReq) {
                        remoteServiceURLs = SAML2Utils.getRemoteServiceURLs(request);
                        boolean bl = foundPeer = remoteServiceURLs != null && !remoteServiceURLs.isEmpty();
                    }
                    if (debug.messageEnabled()) {
                        debug.message("processLogoutRequest : isLBReq = " + isLBReq + ", foundPeer = " + foundPeer);
                    }
                    if (list == null || list.isEmpty()) {
                        if (foundPeer) {
                            boolean peerError = false;
                            Iterator iter = remoteServiceURLs.iterator();
                            while (iter.hasNext()) {
                                String remoteLogoutURL = SPSingleLogout.getRemoteLogoutURL((String)iter.next(), request);
                                LogoutResponse logoutRes = LogoutUtil.forwardToRemoteServer(logoutReq, remoteLogoutURL);
                                if (logoutRes == null || SPSingleLogout.isNameNotFound(logoutRes)) continue;
                                if (SPSingleLogout.isSuccess(logoutRes)) {
                                    if (numSI <= 0 || (siList = LogoutUtil.getSessionIndex(logoutRes)) != null && !siList.isEmpty()) continue;
                                    peerError = false;
                                    break;
                                }
                                peerError = true;
                            }
                            status = peerError || siList != null && siList.size() > 0 ? PARTIAL_LOGOUT_STATUS : SUCCESS_STATUS;
                        } else {
                            debug.error("processLogoutRequest : invalid Name ID received");
                            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("invalid_name_identifier"));
                        }
                        break block54;
                    }
                    if (!isVerified && !LogoutUtil.verifySLORequest(logoutReq, realm, logoutReq.getIssuer().getValue(), spEntityID, "SPRole")) {
                        throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
                    }
                    try {
                        String tokenId = ((SPFedSession)list.iterator().next()).spTokenID;
                        token = sessionProvider.getSession(tokenId);
                        userId = sessionProvider.getPrincipalName(token);
                        if (SAML2Utils.debug.messageEnabled()) {
                            SAML2Utils.debug.message("SPSingleLogout.processLogoutRequest, user = " + userId);
                        }
                    }
                    catch (SessionException ex) {
                        if (!SAML2Utils.debug.messageEnabled()) break block55;
                        SAML2Utils.debug.message("SPSingleLogout.processLogoutRequest", (Throwable)((Object)ex));
                    }
                }
                userId = SPSingleLogout.preSingleLogoutProcess(spEntityID, realm, request, response, userId, logoutReq, null, binding);
                if (numSI == 0) {
                    Iterator iter;
                    ArrayList<String> tokenIDsToBeDestroyed = new ArrayList<String>();
                    token = list;
                    synchronized (token) {
                        iter = list.listIterator();
                        while (iter.hasNext()) {
                            SPFedSession fedSession = (SPFedSession)iter.next();
                            tokenIDsToBeDestroyed.add(fedSession.spTokenID);
                            iter.remove();
                        }
                    }
                    ListIterator iter2 = tokenIDsToBeDestroyed.listIterator();
                    while (iter2.hasNext()) {
                        String tokenID = (String)iter2.next();
                        Object token2 = null;
                        try {
                            token2 = sessionProvider.getSession(tokenID);
                        }
                        catch (SessionException se) {
                            debug.error("processLogoutRequest : Could not create session from token ID = " + tokenID);
                            continue;
                        }
                        if (debug.messageEnabled()) {
                            debug.message("processLogoutRequest : destroy token " + tokenID);
                        }
                        if (!destroySession) continue;
                        sessionProvider.invalidateSession(token2, request, response);
                    }
                    if (foundPeer) {
                        boolean peerError = false;
                        iter = remoteServiceURLs.iterator();
                        while (iter.hasNext()) {
                            String remoteLogoutURL = SPSingleLogout.getRemoteLogoutURL((String)iter.next(), request);
                            LogoutResponse logoutRes = LogoutUtil.forwardToRemoteServer(logoutReq, remoteLogoutURL);
                            if (logoutRes != null && (SPSingleLogout.isSuccess(logoutRes) || SPSingleLogout.isNameNotFound(logoutRes))) continue;
                            peerError = true;
                        }
                        status = peerError ? PARTIAL_LOGOUT_STATUS : SUCCESS_STATUS;
                    }
                    break block54;
                }
                String sessionIndex = null;
                List<String> siNotFound = new ArrayList<String>();
                for (int i = 0; i < numSI; ++i) {
                    sessionIndex = (String)siList.get(i);
                    String tokenIDToBeDestroyed = null;
                    List logoutRes = list;
                    synchronized (logoutRes) {
                        ListIterator iter = list.listIterator();
                        while (iter.hasNext()) {
                            SPFedSession fedSession = (SPFedSession)iter.next();
                            if (!sessionIndex.equals(fedSession.idpSessionIndex)) continue;
                            if (debug.messageEnabled()) {
                                debug.message("processLogoutRequest :  found si + " + sessionIndex);
                            }
                            tokenIDToBeDestroyed = fedSession.spTokenID;
                            iter.remove();
                            break;
                        }
                    }
                    if (tokenIDToBeDestroyed != null) {
                        try {
                            Object token3 = sessionProvider.getSession(tokenIDToBeDestroyed);
                            if (debug.messageEnabled()) {
                                debug.message("processLogoutRequest : destroy token (2) " + tokenIDToBeDestroyed);
                            }
                            if (!destroySession) continue;
                            sessionProvider.invalidateSession(token3, request, response);
                        }
                        catch (SessionException se) {
                            debug.error("processLogoutRequest : Could not create session from token ID = " + tokenIDToBeDestroyed);
                        }
                        continue;
                    }
                    siNotFound.add(sessionIndex);
                }
                if (isLBReq) {
                    if (foundPeer && !siNotFound.isEmpty()) {
                        boolean peerError = false;
                        LogoutRequest lReq = SPSingleLogout.copyAndMakeMutable(logoutReq);
                        Iterator iter = remoteServiceURLs.iterator();
                        while (iter.hasNext()) {
                            lReq.setSessionIndex(siNotFound);
                            String remoteLogoutURL = SPSingleLogout.getRemoteLogoutURL((String)iter.next(), request);
                            LogoutResponse logoutRes = LogoutUtil.forwardToRemoteServer(lReq, remoteLogoutURL);
                            if (logoutRes != null && !SPSingleLogout.isNameNotFound(logoutRes)) {
                                if (SPSingleLogout.isSuccess(logoutRes)) {
                                    siNotFound = LogoutUtil.getSessionIndex(logoutRes);
                                } else {
                                    peerError = true;
                                }
                            }
                            if (debug.messageEnabled()) {
                                debug.message("processLogoutRequest : siNotFound = " + siNotFound);
                            }
                            if (siNotFound != null && !siNotFound.isEmpty()) continue;
                            peerError = false;
                            break;
                        }
                        status = peerError || siNotFound != null && !siNotFound.isEmpty() ? PARTIAL_LOGOUT_STATUS : SUCCESS_STATUS;
                    } else {
                        status = SUCCESS_STATUS;
                    }
                } else if (siNotFound.isEmpty()) {
                    status = SUCCESS_STATUS;
                } else {
                    status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
                    LogoutUtil.setSessionIndex(status, siNotFound);
                }
            }
            catch (SessionException se) {
                debug.error("processLogoutRequest: ", (Throwable)((Object)se));
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", se.toString());
            }
            catch (SAML2Exception e) {
                debug.error("processLogoutRequest: failed to create response", (Throwable)((Object)e));
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", e.toString());
            }
        }
        if (spEntityID == null) {
            spEntityID = nameID.getSPNameQualifier();
        }
        if (SPSingleLogout.isSuccess(logResponse = LogoutUtil.generateResponse(status, logoutReq.getID(), issuer, realm, "SPRole", idpEntity))) {
            SPSingleLogout.postSingleLogoutSuccess(spEntityID, realm, request, response, userId, logoutReq, logResponse, binding);
        }
        return logResponse;
    }

    static boolean isSuccess(LogoutResponse logoutRes) {
        return logoutRes.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    static boolean isNameNotFound(LogoutResponse logoutRes) {
        Status status = logoutRes.getStatus();
        String statusMessage = status.getStatusMessage();
        return status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Responder") && statusMessage != null && statusMessage.equals(SAML2Utils.bundle.getString("invalid_name_identifier"));
    }

    private static LogoutRequest copyAndMakeMutable(LogoutRequest src) {
        LogoutRequest dest = ProtocolFactory.getInstance().createLogoutRequest();
        try {
            dest.setNotOnOrAfter(src.getNotOnOrAfter());
            dest.setReason(src.getReason());
            dest.setEncryptedID(src.getEncryptedID());
            dest.setNameID(src.getNameID());
            dest.setBaseID(src.getBaseID());
            dest.setSessionIndex(src.getSessionIndex());
            dest.setIssuer(src.getIssuer());
            dest.setExtensions(src.getExtensions());
            dest.setID(src.getID());
            dest.setVersion(src.getVersion());
            dest.setIssueInstant(src.getIssueInstant());
            dest.setDestination(src.getDestination());
            dest.setConsent(src.getConsent());
        }
        catch (SAML2Exception ex) {
            debug.error("SPLogoutUtil.copyAndMakeMutable:", (Throwable)((Object)ex));
        }
        return dest;
    }

    private static String getSLOResponseLocationOrLocation(SPSSODescriptorElement spsso, String binding) {
        List sloList;
        String location = null;
        if (!(spsso == null || (sloList = spsso.getSingleLogoutService()) == null || sloList.isEmpty() || (location = LogoutUtil.getSLOResponseServiceLocation(sloList, binding)) != null && location.length() != 0)) {
            location = LogoutUtil.getSLOServiceLocation(sloList, binding);
        }
        return location;
    }

    private static String getRemoteLogoutURL(String serverURL, HttpServletRequest request) {
        if (serverURL == null || request == null) {
            return null;
        }
        String queryString = request.getQueryString();
        if (queryString == null) {
            return serverURL + SAML2Utils.removeDeployUri(request.getRequestURI()) + "?isLBReq=false";
        }
        return serverURL + SAML2Utils.removeDeployUri(request.getRequestURI()) + "?" + queryString + "&isLBReq=false";
    }

    static {
        try {
            sm = new SAML2MetaManager();
        }
        catch (SAML2MetaException sme) {
            debug.error("Error retrieving metadata.", (Throwable)((Object)sme));
        }
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            debug.error("Error retrieving session provider.", (Throwable)((Object)se));
        }
    }
}

