/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.soapbinding;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedAssertion;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.metadata.XACMLAuthzDecisionQueryDescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.soapbinding.RequestHandler;
import com.sun.identity.saml2.soapbinding.SOAPBindingService;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryHandlerServlet
extends HttpServlet {
    static final String REQUEST_ABSTRACT = "RequestAbstract";
    static final String XSI_TYPE_ATTR = "xsi:type";
    static final String XACML_AUTHZ_QUERY = "XACMLAuthzDecisionQuery";
    static final String METAALIAS_KEY = "/metaAlias";
    static Debug debug = Debug.getInstance((String)"libSAML2SOAP");
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();

    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String classMethod = "QueryHandlerServlet:processRequest";
        try {
            SAMLUtils.checkHTTPContentLength(request);
            String requestURI = request.getRequestURI();
            String queryMetaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURI);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "queryMetaAlias is :" + queryMetaAlias);
            }
            String pdpEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(queryMetaAlias);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(queryMetaAlias);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "uri : " + requestURI + ",queryMetaAlias=" + queryMetaAlias + ", pdpEntityID=" + pdpEntityID);
            }
            MimeHeaders headers = SAML2Utils.getHeaders(request);
            ServletInputStream is = request.getInputStream();
            SOAPMessage soapMsg = SAML2Utils.mf.createMessage(headers, (InputStream)is);
            Element soapBody = SAML2Utils.getSOAPBody(soapMsg);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "SOAPMessage received.:" + XMLUtils.print((Node)soapBody));
            }
            SOAPMessage reply = null;
            reply = this.onMessage(soapMsg, request, response, realm, pdpEntityID);
            if (reply != null) {
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                response.setStatus(200);
                SAML2Utils.putHeaders(reply.getMimeHeaders(), response);
            } else {
                debug.error(classMethod + "SOAPMessage is null");
                response.setStatus(204);
                reply = SAML2Utils.createSOAPFault("Server", "invalidQuery", null);
            }
            ServletOutputStream os = response.getOutputStream();
            reply.writeTo((OutputStream)os);
            os.flush();
        }
        catch (SAML2Exception ex) {
            debug.error(classMethod, (Throwable)((Object)ex));
            response.sendError(500, ex.getMessage());
        }
        catch (SOAPException soap) {
            debug.error(classMethod, (Throwable)soap);
            response.sendError(500, soap.getMessage());
        }
    }

    public SOAPMessage onMessage(SOAPMessage soapMsg, HttpServletRequest request, HttpServletResponse response, String realm, String pdpEntityID) throws SOAPException {
        String classMethod = "QueryHandlerServlet:onMessage:";
        SOAPMessage soapMessage = null;
        Object pepEntityID = null;
        try {
            Element soapBody = SAML2Utils.getSOAPBody(soapMsg);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "SOAPMessage recd. :" + XMLUtils.print((Node)soapBody));
            }
            Element reqAbs = SAML2Utils.getSamlpElement(soapMsg, REQUEST_ABSTRACT);
            Response samlResponse = this.processSAMLRequest(realm, pdpEntityID, reqAbs, request, soapMsg);
            soapMessage = SAML2Utils.createSOAPMessage(samlResponse.toXMLString(true, true));
        }
        catch (SAML2Exception se) {
            debug.error(classMethod + "XACML Response Error SOAP Fault", (Throwable)((Object)se));
            soapMessage = SAML2Utils.createSOAPFault("Server", "invalidQuery", se.getMessage());
        }
        return soapMessage;
    }

    static void signAssertion(String realm, String pdpEntityID, Assertion assertion) throws SAML2Exception {
        String classMethod = "QueryHandlerServlet.signAssertion: ";
        if (keyProvider == null) {
            debug.error(classMethod + "Unable to get a key provider instance.");
            throw new SAML2Exception("nullKeyProvider");
        }
        String pdpSignCertAlias = SAML2Utils.getAttributeValueFromXACMLConfig(realm, "PDPRole", pdpEntityID, "signingCertAlias");
        if (pdpSignCertAlias == null) {
            debug.error(classMethod + "Unable to get the hosted PDP signing certificate alias.");
            String[] data = new String[]{realm, pdpEntityID};
            LogUtil.error(Level.INFO, "NULL_PDP_SIGN_CERT_ALIAS", data);
            throw new SAML2Exception("missingSigningCertAlias");
        }
        assertion.sign(keyProvider.getPrivateKey(pdpSignCertAlias), keyProvider.getX509Certificate(pdpSignCertAlias));
    }

    Response processSAMLRequest(String realm, String pdpEntityID, Element reqAbs, HttpServletRequest request, SOAPMessage soapMsg) throws SAML2Exception {
        String classMethod = "QueryHandlerServlet:processSAMLRequest";
        Response samlResponse = null;
        if (reqAbs != null) {
            String xsiType = reqAbs.getAttribute(XSI_TYPE_ATTR);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "xsi type is : " + xsiType);
            }
            if (xsiType != null && xsiType.indexOf(XACML_AUTHZ_QUERY) != -1) {
                XACMLAuthzDecisionQuery samlRequest = ContextFactory.getInstance().createXACMLAuthzDecisionQuery(reqAbs);
                String requestStr = samlRequest.toXMLString(true, true);
                String[] data = new String[]{requestStr, pdpEntityID};
                LogUtil.access(Level.FINE, "REQUEST_MESSAGE", data);
                Issuer issuer = samlRequest.getIssuer();
                String pepEntityID = null;
                if (issuer != null) {
                    pepEntityID = issuer.getValue().trim();
                }
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Issuer is:" + pepEntityID);
                }
                boolean isTrusted = false;
                try {
                    isTrusted = SAML2Utils.getSAML2MetaManager().isTrustedXACMLProvider(realm, pdpEntityID, pepEntityID, "PDPRole");
                }
                catch (SAML2MetaException sme) {
                    debug.error("Error retreiving meta", (Throwable)((Object)sme));
                }
                if (!isTrusted) {
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "Issuer in Request is not valid." + pepEntityID);
                    }
                    String[] args = new String[]{realm, pepEntityID, pdpEntityID};
                    LogUtil.error(Level.INFO, "INVALID_ISSUER_IN_PEP_REQUEST", args);
                    throw new SAML2Exception("invalidIssuerInRequest");
                }
                samlResponse = this.processXACMLResponse(realm, pdpEntityID, samlRequest, request, soapMsg);
            }
        }
        return samlResponse;
    }

    Response processXACMLResponse(String realm, String pdpEntityID, RequestAbstract samlRequest, HttpServletRequest request, SOAPMessage soapMsg) throws SAML2Exception {
        RequestHandler handler;
        String classMethod = "QueryHandlerServlet:processXACMLResponse";
        Response samlResponse = null;
        String path = request.getPathInfo();
        String key = path.substring(path.indexOf(METAALIAS_KEY) + 10);
        String pepEntityID = samlRequest.getIssuer().getValue();
        if (debug.messageEnabled()) {
            debug.message(classMethod + "SOAPMessage KEY . :" + key);
            debug.message(classMethod + "pepEntityID is :" + pepEntityID);
        }
        boolean pdpWantAuthzQuerySigned = SAML2Utils.getWantXACMLAuthzDecisionQuerySigned(realm, pdpEntityID, "PDPRole");
        if (debug.messageEnabled()) {
            debug.message(classMethod + "PDP wantAuthzQuerySigned:" + pdpWantAuthzQuerySigned);
        }
        if (pdpWantAuthzQuerySigned) {
            String signAlias = SAML2Utils.getAttributeValueFromXACMLConfig(realm, "PEPRole", pepEntityID, "signingCertAlias");
            if (debug.messageEnabled()) {
                debug.message(classMethod + "PEP signAlias :" + signAlias);
            }
            if (signAlias != null) {
                XACMLAuthzDecisionQueryDescriptorElement pep = SAML2Utils.getSAML2MetaManager().getPolicyEnforcementPointDescriptor(realm, pepEntityID);
                X509Certificate cert = KeyUtil.getPEPVerificationCert(pep, pepEntityID);
                String[] data = new String[]{realm, pepEntityID, signAlias};
                if (cert == null || !samlRequest.isSignatureValid(cert)) {
                    debug.error(classMethod + "Invalid signature in message");
                    LogUtil.error(Level.INFO, "INVALID_SIGNATURE_QUERY", data);
                    throw new SAML2Exception("invalidQuerySignature");
                }
                debug.message(classMethod + "Valid signature found");
                LogUtil.access(Level.FINE, "VALID_SIGNATURE_QUERY", data);
            } else {
                debug.error("Signing alias is null");
                String[] data = new String[]{realm, pepEntityID};
                LogUtil.error(Level.INFO, "NULL_PEP_SIGN_CERT_ALIAS", data);
                throw new SAML2Exception("nullSigningAlias");
            }
        }
        if ((handler = (RequestHandler)SOAPBindingService.handlers.get(key)) != null) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Found handler");
            }
            samlResponse = handler.handleQuery(pdpEntityID, pepEntityID, samlRequest, soapMsg);
            samlResponse.setID(SAML2Utils.generateID());
            samlResponse.setVersion("2.0");
            samlResponse.setIssueInstant(new Date());
            Issuer issuer = AssertionFactory.getInstance().createIssuer();
            issuer.setValue(pdpEntityID);
            samlResponse.setIssuer(issuer);
            ArrayList<EncryptedAssertion> assertionList = samlResponse.getAssertion();
            Assertion assertion = (Assertion)assertionList.get(0);
            assertion.setID(SAML2Utils.generateID());
            assertion.setVersion("2.0");
            assertion.setIssueInstant(new Date());
            assertion.setIssuer(issuer);
            String wantAssertionEncrypted = SAML2Utils.getAttributeValueFromXACMLConfig(realm, "PEPRole", pepEntityID, "wantAssertionEncrypted");
            XACMLAuthzDecisionQueryDescriptorElement pepDescriptor = SAML2Utils.getSAML2MetaManager().getPolicyEnforcementPointDescriptor(realm, pepEntityID);
            EncInfo encInfo = null;
            boolean wantAssertionSigned = pepDescriptor.isWantAssertionsSigned();
            if (debug.messageEnabled()) {
                debug.message(classMethod + " wantAssertionSigned :" + wantAssertionSigned);
            }
            if (wantAssertionSigned) {
                QueryHandlerServlet.signAssertion(realm, pdpEntityID, assertion);
            }
            if (wantAssertionEncrypted != null && wantAssertionEncrypted.equalsIgnoreCase("true")) {
                encInfo = KeyUtil.getPEPEncInfo(pepDescriptor, pepEntityID);
                EncryptedAssertion encryptedAssertion = assertion.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), pepEntityID);
                if (encryptedAssertion == null) {
                    debug.error(classMethod + "Assertion encryption failed.");
                    throw new SAML2Exception("FailedToEncryptAssertion");
                }
                assertionList = new ArrayList<EncryptedAssertion>();
                assertionList.add(encryptedAssertion);
                samlResponse.setEncryptedAssertion(assertionList);
                samlResponse.setAssertion(new ArrayList());
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "Assertion encrypted.");
                }
            } else {
                ArrayList<Assertion> assertionsList = new ArrayList<Assertion>();
                assertionsList.add(assertion);
                samlResponse.setAssertion(assertionsList);
            }
        } else {
            debug.error(classMethod + "RequestHandler not found");
            throw new SAML2Exception("missingRequestHandler");
        }
        QueryHandlerServlet.signResponse(samlResponse, realm, pepEntityID, pdpEntityID);
        return samlResponse;
    }

    static void signResponse(Response response, String realm, String pepEntityID, String pdpEntityID) throws SAML2Exception {
        String classMethod = "signResponse : ";
        String attrName = "wantXACMLAuthzDecisionResponseSigned";
        String wantResponseSigned = SAML2Utils.getAttributeValueFromXACMLConfig(realm, "PEPRole", pepEntityID, attrName);
        if (wantResponseSigned == null || wantResponseSigned.equalsIgnoreCase("false")) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Response doesn't need to be signed.");
            }
        } else {
            String pdpSignCertAlias = SAML2Utils.getAttributeValueFromXACMLConfig(realm, "PDPRole", pdpEntityID, "signingCertAlias");
            if (pdpSignCertAlias == null) {
                debug.error(classMethod + "PDP certificate alias is null.");
                String[] data = new String[]{realm, pdpEntityID};
                LogUtil.error(Level.INFO, "NULL_PDP_SIGN_CERT_ALIAS", data);
                throw new SAML2Exception("missingSigningCertAlias");
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "realm is : " + realm);
                debug.message(classMethod + "pepEntityID is :" + pepEntityID);
                debug.message(classMethod + "pdpEntityID : " + pdpEntityID);
                debug.message(classMethod + "wantResponseSigned" + wantResponseSigned);
                debug.message(classMethod + "Cert Alias:" + pdpSignCertAlias);
            }
            PrivateKey signingKey = keyProvider.getPrivateKey(pdpSignCertAlias);
            X509Certificate signingCert = keyProvider.getX509Certificate(pdpSignCertAlias);
            if (signingKey != null) {
                response.sign(signingKey, signingCert);
            } else {
                debug.error("Incorrect configuration for Signing Certificate.");
                throw new SAML2Exception("metaDataError");
            }
        }
    }
}

