/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.servlet;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.profile.SPACSUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.plugins.SPAccountMapper;
import com.sun.identity.wsfederation.plugins.SPAttributeMapper;
import com.sun.identity.wsfederation.profile.RequestSecurityTokenResponse;
import com.sun.identity.wsfederation.servlet.WSFederationAction;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RPSigninResponse
extends WSFederationAction {
    private static Debug debug = WSFederationUtils.debug;
    private String wresult;
    private String wctx;

    public RPSigninResponse(HttpServletRequest request, HttpServletResponse response, String wresult, String wctx) {
        super(request, response);
        this.wresult = wresult;
        this.wctx = wctx;
    }

    public void process() throws WSFederationException, IOException {
        String classMethod = "RPSigninResponse.process: ";
        if (this.wresult == null || this.wresult.length() == 0) {
            String[] data = new String[]{this.request.getQueryString()};
            LogUtil.error(Level.INFO, "MISSING_WRESULT", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullWresult"));
        }
        RequestSecurityTokenResponse rstr = null;
        try {
            rstr = RequestSecurityTokenResponse.parseXML(this.wresult);
        }
        catch (WSFederationException wsfe) {
            String[] data = new String[]{this.wresult};
            LogUtil.error(Level.INFO, "INVALID_WRESULT", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidWresult"));
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Received RSTR: " + rstr.toString());
        }
        String realm = null;
        String requestURL = this.request.getRequestURL().toString();
        String metaAlias = WSFederationMetaUtils.getMetaAliasByUri(requestURL);
        realm = WSFederationMetaUtils.getRealmByMetaAlias(metaAlias);
        String spEntityId = null;
        try {
            spEntityId = WSFederationMetaManager.getEntityByMetaAlias(metaAlias);
        }
        catch (WSFederationException wsfe) {
            String[] data = new String[]{wsfe.getLocalizedMessage(), metaAlias, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ENTITY_CONFIG", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidMetaAlias"));
        }
        if (realm == null || realm.length() == 0) {
            realm = "/";
        }
        SPSSOConfigElement spssoconfig = WSFederationMetaManager.getSPSSOConfig(realm, spEntityId);
        int timeskew = 300;
        String timeskewStr = WSFederationMetaUtils.getAttribute(spssoconfig, "assertionTimeSkew");
        if (timeskewStr != null && timeskewStr.trim().length() > 0 && (timeskew = Integer.parseInt(timeskewStr)) < 0) {
            timeskew = 300;
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "timeskew = " + timeskew);
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + " - verifying assertion");
        }
        Map<String, Object> smap = rstr.getRequestedSecurityToken().verifyToken(realm, spEntityId, timeskew);
        assert (smap != null);
        Map<String, List<String>> attributes = WSFederationMetaUtils.getAttributes(spssoconfig);
        SPAccountMapper acctMapper = RPSigninResponse.getSPAccountMapper(attributes);
        SPAttributeMapper attrMapper = this.getSPAttributeMapper(attributes);
        String userName = acctMapper.getIdentity(rstr, spEntityId, realm);
        if (userName == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullUserID"));
        }
        String idpEntityId = WSFederationMetaManager.getEntityByTokenIssuerName(realm, rstr.getRequestedSecurityToken().getIssuer());
        List attrs = rstr.getRequestedSecurityToken().getAttributes();
        Map attrMap = null;
        if (attrs != null) {
            attrMap = attrMapper.getAttributes(attrs, userName, spEntityId, idpEntityId, realm);
        }
        String authLevel = smap.get("AuthLevel").toString();
        HashMap<String, String> sessionInfoMap = new HashMap<String, String>();
        sessionInfoMap.put("realm", realm);
        sessionInfoMap.put("principalName", userName);
        sessionInfoMap.put("AuthLevel", authLevel);
        Object session = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            session = sessionProvider.createSession(sessionInfoMap, this.request, this.response, null);
            SPACSUtils.setAttrMapInSession(sessionProvider, attrMap, session);
            String[] idpArray = new String[]{idpEntityId};
            sessionProvider.setProperty(session, "sun-fm-wsfed-idp", idpArray);
        }
        catch (SessionException se) {
            String[] data = new String[]{se.getLocalizedMessage(), realm, userName, authLevel};
            LogUtil.error(Level.INFO, "CANT_CREATE_SESSION", data, null);
            throw new WSFederationException((Throwable)((Object)se));
        }
        String target = null;
        target = this.wctx != null ? WSFederationUtils.removeReplyURL(this.wctx) : WSFederationMetaUtils.getAttribute(spssoconfig, "defaultRelayState");
        String[] data = new String[]{this.wctx, LogUtil.isErrorLoggable(Level.FINER) ? this.wresult : rstr.getRequestedSecurityToken().getTokenId(), realm, userName, authLevel, target};
        LogUtil.access(Level.INFO, "SSO_SUCCESSFUL", data, session);
        if (target == null) {
            PrintWriter pw = this.response.getWriter();
            pw.println("Logged in");
            return;
        }
        this.response.sendRedirect(target);
    }

    private static SPAccountMapper getSPAccountMapper(Map attributes) throws WSFederationException {
        SPAccountMapper acctMapper = null;
        List acctMapperList = (List)attributes.get("spAccountMapper");
        if (acctMapperList != null) {
            try {
                acctMapper = (SPAccountMapper)Class.forName((String)acctMapperList.get(0)).newInstance();
                if (debug.messageEnabled()) {
                    debug.message("RPSigninResponse.getSPAccountMapper: mapper = " + (String)acctMapperList.get(0));
                }
            }
            catch (ClassNotFoundException cfe) {
                throw new WSFederationException(cfe);
            }
            catch (InstantiationException ie) {
                throw new WSFederationException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new WSFederationException(iae);
            }
        }
        if (acctMapper == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("failedAcctMapper"));
        }
        return acctMapper;
    }

    private SPAttributeMapper getSPAttributeMapper(Map attributes) throws WSFederationException {
        SPAttributeMapper attrMapper = null;
        List attrMapperList = (List)attributes.get("spAttributeMapper");
        if (attrMapperList != null) {
            try {
                attrMapper = (SPAttributeMapper)Class.forName((String)attrMapperList.get(0)).newInstance();
            }
            catch (ClassNotFoundException cfe) {
                throw new WSFederationException(cfe);
            }
            catch (InstantiationException ie) {
                throw new WSFederationException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new WSFederationException(iae);
            }
        }
        if (attrMapper == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("failedAttrMapper"));
        }
        return attrMapper;
    }

    public static void setAttrMapInSession(SessionProvider sessionProvider, Map attrMap, Object session) throws SessionException {
        if (attrMap != null && !attrMap.isEmpty()) {
            Set entrySet = attrMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String attrName = (String)entry.getKey();
                Set attrValues = (Set)entry.getValue();
                if (attrValues == null || attrValues.isEmpty()) continue;
                sessionProvider.setProperty(session, attrName, attrValues.toArray(new String[attrValues.size()]));
                if (!WSFederationUtils.debug.messageEnabled()) continue;
                WSFederationUtils.debug.message("SPACSUtils.setAttrMapInSession: AttrMap:" + attrName + " , " + attrValues);
            }
        }
    }
}

