/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Attribute;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeImpl
implements Attribute {
    URI id = null;
    URI type = null;
    String issuer = null;
    private List values;
    private boolean isMutable = true;

    public AttributeImpl() {
    }

    public AttributeImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("AttributeImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public AttributeImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        Object value = null;
        if (element == null) {
            XACMLSDKUtils.debug.error("AttributeImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        if (!element.getLocalName().equals(XACMLConstants.ATTRIBUTE)) {
            XACMLSDKUtils.debug.error("AttributeImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        NamedNodeMap attrs = element.getAttributes();
        try {
            this.id = new URI(attrs.getNamedItem(XACMLConstants.ATTRIBUTE_ID).getNodeValue());
        }
        catch (Exception e) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_not_uri"));
        }
        if (this.id == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
        }
        try {
            this.type = new URI(attrs.getNamedItem(XACMLConstants.DATATYPE).getNodeValue());
        }
        catch (Exception e) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_not_uri"));
        }
        if (this.type == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
        }
        try {
            Node issuerNode = attrs.getNamedItem(XACMLConstants.ISSUER);
            if (issuerNode != null) {
                this.issuer = issuerNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_parsing_error"));
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 && node.getNodeType() != 2 || !node.getLocalName().equals(XACMLConstants.ATTRIBUTE_VALUE)) continue;
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(node);
        }
        if (this.values == null || this.values.isEmpty()) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute_value"));
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.issuer = issuer;
    }

    public URI getAttributeId() {
        return this.id;
    }

    public void setAttributeId(URI attributeId) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (attributeId == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.id = attributeId;
    }

    public URI getDataType() {
        return this.type;
    }

    public void setDataType(URI dataType) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (dataType == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.type = dataType;
    }

    public List getAttributeValues() {
        return this.values;
    }

    public void setAttributeValues(List values) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if (values == null || values.isEmpty()) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        for (int i = 0; i < values.size(); ++i) {
            Element value = (Element)values.get(i);
            String elemName = value.getLocalName();
            if (elemName == null || !elemName.equals(XACMLConstants.ATTRIBUTE_VALUE)) {
                XACMLSDKUtils.debug.error("StatusMessageImpl.processElement():local name missing or incorrect");
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
            }
            this.values.add(value);
        }
    }

    public void setAttributeStringValues(List stringValues) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if (stringValues == null || stringValues.isEmpty()) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        for (int i = 0; i < stringValues.size(); ++i) {
            String value = (String)stringValues.get(i);
            StringBuffer sb = new StringBuffer(200);
            sb.append("<").append(XACMLConstants.ATTRIBUTE_VALUE).append(">").append(value).append("</").append(XACMLConstants.ATTRIBUTE_VALUE).append(">\n");
            Document document = XMLUtils.toDOMDocument((String)sb.toString(), (Debug)XACMLSDKUtils.debug);
            Element element = null;
            if (document != null) {
                element = document.getDocumentElement();
            }
            if (element == null) continue;
            this.values.add(element);
        }
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        StringBuffer NS = new StringBuffer(100);
        includeNSPrefix = false;
        declareNS = false;
        String appendNS = "";
        if (declareNS) {
            NS.append(XACMLConstants.CONTEXT_NS_DECLARATION).append(XACMLConstants.SPACE);
            NS.append(XACMLConstants.XSI_NS_URI).append(XACMLConstants.SPACE).append(XACMLConstants.CONTEXT_SCHEMA_LOCATION);
        }
        if (includeNSPrefix) {
            appendNS = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(appendNS).append(XACMLConstants.ATTRIBUTE).append(NS);
        sb.append(XACMLConstants.SPACE);
        if (this.id != null) {
            sb.append(XACMLConstants.ATTRIBUTE_ID).append("=").append("\"").append(this.id.toString());
            sb.append("\"").append(XACMLConstants.SPACE);
        }
        if (this.type != null) {
            sb.append(XACMLConstants.DATATYPE).append("=").append("\"").append(this.type.toString());
            sb.append("\"").append(XACMLConstants.SPACE);
        }
        if (this.issuer != null) {
            sb.append(XACMLConstants.ISSUER).append("=").append("\"").append(this.issuer).append("\"");
        }
        sb.append(">");
        boolean length = false;
        Object xmlString = null;
        if (this.values != null && !this.values.isEmpty()) {
            for (int i = 0; i < this.values.size(); ++i) {
                Element value = (Element)this.values.get(i);
                sb.append("\n");
                if (includeNSPrefix && value.getPrefix() == null) {
                    value.setPrefix(appendNS.substring(0, appendNS.length() - 1));
                }
                if (declareNS) {
                    int index = NS.indexOf("=");
                    String namespaceName = NS.substring(0, index);
                    String namespaceURI = NS.substring(index + 1);
                    if (value.getNamespaceURI() == null) {
                        value.setAttribute(namespaceName, namespaceURI);
                    }
                }
                sb.append(XMLUtils.print((Node)value));
            }
        }
        sb.append("\n</").append(appendNS).append(XACMLConstants.ATTRIBUTE);
        sb.append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

