/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.IRegistryV3;
import org.apache.ws.scout.registry.JAXBContextUtil;
import org.apache.ws.scout.registry.RegistryV3Exception;
import org.apache.ws.scout.transport.Transport;
import org.apache.ws.scout.transport.TransportException;
import org.apache.ws.scout.util.XMLUtils;
import org.uddi.api_v3.AssertionStatusReport;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingDetail;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.DispositionReport;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.GetBusinessDetail;
import org.uddi.api_v3.GetPublisherAssertions;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.GetServiceDetail;
import org.uddi.api_v3.GetTModelDetail;
import org.uddi.api_v3.IdentifierBag;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ObjectFactory;
import org.uddi.api_v3.PublisherAssertion;
import org.uddi.api_v3.PublisherAssertions;
import org.uddi.api_v3.PublisherAssertionsResponse;
import org.uddi.api_v3.RegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.ServiceDetail;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.SetPublisherAssertions;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelBag;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryV3Impl
implements IRegistryV3 {
    public static final String INQUIRY_ENDPOINT_PROPERTY_NAME = "scout.proxy.inquiryURL";
    public static final String PUBLISH_ENDPOINT_PROPERTY_NAME = "scout.proxy.publishURL";
    public static final String SECURITY_ENDPOINT_PROPERTY_NAME = "scout.proxy.securityURL";
    public static final String ADMIN_ENDPOINT_PROPERTY_NAME = "scout.proxy.adminURL";
    public static final String TRANSPORT_CLASS_PROPERTY_NAME = "scout.proxy.transportClass";
    public static final String SECURITY_PROVIDER_PROPERTY_NAME = "scout.proxy.securityProvider";
    public static final String PROTOCOL_HANDLER_PROPERTY_NAME = "scout.proxy.protocolHandler";
    public static final String UDDI_VERSION_PROPERTY_NAME = "scout.proxy.uddiVersion";
    public static final String UDDI_NAMESPACE_PROPERTY_NAME = "scout.proxy.uddiNamespace";
    public static final String DEFAULT_INQUIRY_ENDPOINT = "http://localhost/juddi/inquiry";
    public static final String DEFAULT_PUBLISH_ENDPOINT = "http://localhost/juddi/publish";
    public static final String DEFAULT_SECURITY_ENDPOINT = "http://localhost/juddi/security";
    public static final String DEFAULT_ADMIN_ENDPOINT = "http://localhost/juddi/admin";
    public static final String DEFAULT_TRANSPORT_CLASS = "org.apache.ws.scout.transport.AxisTransport";
    public static final String DEFAULT_SECURITY_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String DEFAULT_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String DEFAULT_UDDI_VERSION = "2.0";
    public static final String DEFAULT_UDDI_NAMESPACE = "urn:uddi-org:api_v2";
    private URI adminURI;
    private URI inquiryURI;
    private URI publishURI;
    private URI securityURI;
    private Transport transport;
    private String securityProvider;
    private String protocolHandler;
    private String uddiVersion;
    private String uddiNamespace;
    private ObjectFactory objectFactory = new ObjectFactory();
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private static Log log = LogFactory.getLog(RegistryV3Impl.class);

    public RegistryV3Impl(Properties props) {
        this.init(props);
    }

    private void init(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        try {
            String iURL = props.getProperty(INQUIRY_ENDPOINT_PROPERTY_NAME);
            if (iURL != null) {
                this.setInquiryURI(new URI(iURL));
            } else {
                this.setInquiryURI(new URI(DEFAULT_INQUIRY_ENDPOINT));
            }
            String pURL = props.getProperty(PUBLISH_ENDPOINT_PROPERTY_NAME);
            if (pURL != null) {
                this.setPublishURI(new URI(pURL));
            } else {
                this.setPublishURI(new URI(DEFAULT_PUBLISH_ENDPOINT));
            }
            String sURL = props.getProperty(SECURITY_ENDPOINT_PROPERTY_NAME);
            if (sURL != null) {
                this.setSecurityURI(new URI(sURL));
            } else {
                this.setSecurityURI(new URI(DEFAULT_SECURITY_ENDPOINT));
            }
            String aURL = props.getProperty(ADMIN_ENDPOINT_PROPERTY_NAME);
            if (aURL != null) {
                this.setAdminURI(new URI(aURL));
            } else {
                this.setAdminURI(new URI(DEFAULT_ADMIN_ENDPOINT));
            }
        }
        catch (URISyntaxException muex) {
            throw new RuntimeException(muex);
        }
        String secProvider = props.getProperty(SECURITY_PROVIDER_PROPERTY_NAME);
        if (secProvider != null) {
            this.setSecurityProvider(secProvider);
        } else {
            this.setSecurityProvider(DEFAULT_SECURITY_PROVIDER);
        }
        String protoHandler = props.getProperty(PROTOCOL_HANDLER_PROPERTY_NAME);
        if (protoHandler != null) {
            this.setProtocolHandler(protoHandler);
        } else {
            this.setProtocolHandler(DEFAULT_PROTOCOL_HANDLER);
        }
        String uddiVer = props.getProperty(UDDI_VERSION_PROPERTY_NAME);
        if (uddiVer != null) {
            this.setUddiVersion(uddiVer);
        } else {
            this.setUddiVersion(DEFAULT_UDDI_VERSION);
        }
        String uddiNS = props.getProperty(UDDI_NAMESPACE_PROPERTY_NAME);
        if (uddiNS != null) {
            this.setUddiNamespace(uddiNS);
        } else {
            this.setUddiNamespace(DEFAULT_UDDI_NAMESPACE);
        }
        String transClass = props.getProperty(TRANSPORT_CLASS_PROPERTY_NAME);
        if (transClass != null) {
            this.setTransport(this.getTransport(transClass));
        } else {
            this.setTransport(this.getTransport(DEFAULT_TRANSPORT_CLASS));
        }
        try {
            JAXBContext v3context = JAXBContextUtil.getContext("3.0");
            this.unmarshaller = v3context.createUnmarshaller();
            this.marshaller = v3context.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String execute(String uddiRequest, String urltype) throws TransportException {
        URI endPointURL = null;
        endPointURL = urltype.equalsIgnoreCase("INQUIRY") ? this.getInquiryURI() : this.getPublishURI();
        return this.transport.send(uddiRequest, endPointURL);
    }

    public JAXBElement<?> execute(JAXBElement<?> uddiRequest, URI endPointURI) throws RegistryV3Exception {
        String responseName;
        Element response;
        Document doc;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.marshaller.marshal(uddiRequest, (OutputStream)baos);
            doc = docBuilder.parse(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (SAXException saxe) {
            throw new RegistryV3Exception(saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryV3Exception(pce);
        }
        catch (IOException ioe) {
            throw new RegistryV3Exception(ioe);
        }
        catch (JAXBException ioe) {
            throw new RegistryV3Exception((Exception)((Object)ioe));
        }
        Element request = doc.getDocumentElement();
        request.setAttribute("xmlns", this.getUddiNamespace());
        if (!"3.0".equals(this.getUddiVersion())) {
            request.setAttribute("generic", this.getUddiVersion());
        }
        try {
            response = this.transport.send(request, endPointURI);
        }
        catch (TransportException te) {
            throw new RegistryV3Exception(te);
        }
        if (response.getNamespaceURI() == null) {
            response.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", this.getUddiNamespace());
        }
        if ((responseName = response.getLocalName()) == null) {
            throw new RegistryV3Exception("Unsupported response from registry. A value was not present.");
        }
        JAXBElement uddiResponse = null;
        try {
            String xml = XMLUtils.convertNodeToXMLString(response);
            log.debug((Object)("Response is: " + xml));
            StringReader reader = new StringReader(xml);
            uddiResponse = (JAXBElement)this.unmarshaller.unmarshal((Source)new StreamSource(reader));
        }
        catch (JAXBException xmle) {
            throw new RegistryV3Exception((Exception)((Object)xmle));
        }
        if (responseName.toLowerCase().equals("fault")) {
            NodeList nodeList = null;
            String fCode = null;
            nodeList = response.getElementsByTagName("faultcode");
            if (nodeList.getLength() > 0) {
                fCode = nodeList.item(0).getNodeValue();
            }
            String fString = null;
            nodeList = response.getElementsByTagName("faultstring");
            if (nodeList.getLength() > 0) {
                fString = nodeList.item(0).getNodeValue();
            }
            String fActor = null;
            nodeList = response.getElementsByTagName("faultactor");
            if (nodeList.getLength() > 0) {
                fActor = nodeList.item(0).getNodeValue();
            }
            DispositionReport dispRpt = null;
            nodeList = response.getElementsByTagName("detail");
            if (nodeList.getLength() > 0 && (nodeList = ((Element)nodeList.item(0)).getElementsByTagName("dispositionReport")).getLength() > 0) {
                JAXBElement dispRptObj = null;
                try {
                    dispRptObj = (JAXBElement)this.unmarshaller.unmarshal((Node)((Element)nodeList.item(0)));
                }
                catch (JAXBException xmle) {
                    throw new RegistryV3Exception((Exception)((Object)xmle));
                }
                dispRpt = (DispositionReport)dispRptObj.getValue();
            }
            RegistryV3Exception e = new RegistryV3Exception(fCode, fString, fActor, dispRpt);
            throw e;
        }
        return uddiResponse;
    }

    public URI getAdminURI() {
        return this.adminURI;
    }

    public void setAdminURI(URI url) {
        this.adminURI = url;
    }

    @Override
    public URI getInquiryURI() {
        return this.inquiryURI;
    }

    @Override
    public void setInquiryURI(URI inquiryURI) {
        this.inquiryURI = inquiryURI;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    @Override
    public URI getPublishURI() {
        return this.publishURI;
    }

    @Override
    public URI getSecurityURI() {
        return this.securityURI;
    }

    @Override
    public void setPublishURI(URI publishURI) {
        this.publishURI = publishURI;
    }

    @Override
    public void setSecurityURI(URI securityURI) {
        this.securityURI = securityURI;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String securityProvider) {
        this.securityProvider = securityProvider;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getUddiNamespace() {
        return this.uddiNamespace;
    }

    public void setUddiNamespace(String uddiNS) {
        this.uddiNamespace = uddiNS;
    }

    public String getUddiVersion() {
        return this.uddiVersion;
    }

    public void setUddiVersion(String uddiVersion) {
        this.uddiVersion = uddiVersion;
    }

    @Override
    public DispositionReport deleteBinding(String authInfo, String[] bindingKeyArray) throws RegistryV3Exception {
        DeleteBinding request = this.objectFactory.createDeleteBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingKeyArray != null) {
            request.getBindingKey().addAll(Arrays.asList(bindingKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteBinding(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteBusiness(String authInfo, String[] businessKeyArray) throws RegistryV3Exception {
        DeleteBusiness request = this.objectFactory.createDeleteBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessKeyArray != null) {
            request.getBusinessKey().addAll(Arrays.asList(businessKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteBusiness(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deletePublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryV3Exception {
        DeletePublisherAssertions request = this.objectFactory.createDeletePublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.getPublisherAssertion().addAll(Arrays.asList(assertionArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeletePublisherAssertions(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteService(String authInfo, String[] serviceKeyArray) throws RegistryV3Exception {
        DeleteService request = this.objectFactory.createDeleteService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceKeyArray != null) {
            request.getServiceKey().addAll(Arrays.asList(serviceKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteService(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public DispositionReport deleteTModel(String authInfo, String[] tModelKeyArray) throws RegistryV3Exception {
        DeleteTModel request = this.objectFactory.createDeleteTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelKeyArray != null) {
            request.getTModelKey().addAll(Arrays.asList(tModelKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createDeleteTModel(request), this.getPublishURI());
        DispositionReport dr = (DispositionReport)o.getValue();
        return dr;
    }

    @Override
    public BusinessList findBusiness(Name[] nameArray, DiscoveryURLs discoveryURLs, IdentifierBag identifierBag, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryV3Exception {
        FindBusiness request = this.objectFactory.createFindBusiness();
        if (nameArray != null) {
            request.getName().addAll(Arrays.asList(nameArray));
        }
        if (discoveryURLs != null) {
            request.setDiscoveryURLs(discoveryURLs);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(Integer.valueOf(maxRows));
        JAXBElement<?> o = this.execute(this.objectFactory.createFindBusiness(request), this.getInquiryURI());
        BusinessList bl = (BusinessList)o.getValue();
        return bl;
    }

    @Override
    public BindingDetail findBinding(String serviceKey, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryV3Exception {
        FindBinding request = this.objectFactory.createFindBinding();
        if (serviceKey != null) {
            request.setServiceKey(serviceKey);
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(Integer.valueOf(maxRows));
        JAXBElement<?> o = this.execute(this.objectFactory.createFindBinding(request), this.getInquiryURI());
        BindingDetail bd = (BindingDetail)o.getValue();
        return bd;
    }

    @Override
    public ServiceList findService(String businessKey, Name[] nameArray, CategoryBag categoryBag, TModelBag tModelBag, FindQualifiers findQualifiers, int maxRows) throws RegistryV3Exception {
        FindService request = this.objectFactory.createFindService();
        if (businessKey != null) {
            request.setBusinessKey(businessKey);
        }
        if (nameArray != null) {
            request.getName().addAll(Arrays.asList(nameArray));
        }
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (tModelBag != null) {
            request.setTModelBag(tModelBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(Integer.valueOf(maxRows));
        JAXBElement<?> o = this.execute(this.objectFactory.createFindService(request), this.getInquiryURI());
        ServiceList sl = (ServiceList)o.getValue();
        return sl;
    }

    @Override
    public TModelList findTModel(String name, CategoryBag categoryBag, IdentifierBag identifierBag, FindQualifiers findQualifiers, int maxRows) throws RegistryV3Exception {
        FindTModel request = this.objectFactory.createFindTModel();
        Name jaxbName = this.objectFactory.createName();
        if (name != null) {
            jaxbName.setValue(name);
        }
        request.setName(jaxbName);
        if (categoryBag != null) {
            request.setCategoryBag(categoryBag);
        }
        if (identifierBag != null) {
            request.setIdentifierBag(identifierBag);
        }
        if (findQualifiers != null) {
            request.setFindQualifiers(findQualifiers);
        }
        request.setMaxRows(Integer.valueOf(maxRows));
        JAXBElement<?> o = this.execute(this.objectFactory.createFindTModel(request), this.getInquiryURI());
        TModelList tml = (TModelList)o.getValue();
        return tml;
    }

    @Override
    public AssertionStatusReport getAssertionStatusReport(String authInfo, String completionStatus) throws RegistryV3Exception {
        GetAssertionStatusReport request = this.objectFactory.createGetAssertionStatusReport();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (completionStatus != null) {
            CompletionStatus cs = CompletionStatus.fromValue((String)completionStatus);
            request.setCompletionStatus(cs);
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetAssertionStatusReport(request), this.getPublishURI());
        AssertionStatusReport asr = (AssertionStatusReport)o.getValue();
        return asr;
    }

    @Override
    public AuthToken getAuthToken(String userID, String cred) throws RegistryV3Exception {
        GetAuthToken request = this.objectFactory.createGetAuthToken();
        if (userID != null) {
            request.setUserID(userID);
        }
        if (cred != null) {
            request.setCred(cred);
        }
        URI getAuthTokenURI = null;
        getAuthTokenURI = "3.0".equals(this.uddiVersion) ? this.getSecurityURI() : this.getPublishURI();
        JAXBElement<?> o = this.execute(this.objectFactory.createGetAuthToken(request), getAuthTokenURI);
        AuthToken at = (AuthToken)o.getValue();
        return at;
    }

    @Override
    public BusinessDetail getBusinessDetail(String businessKey) throws RegistryV3Exception {
        String[] keys = new String[]{businessKey};
        return this.getBusinessDetail(keys);
    }

    @Override
    public BusinessDetail getBusinessDetail(String[] businessKeyArray) throws RegistryV3Exception {
        GetBusinessDetail request = this.objectFactory.createGetBusinessDetail();
        if (businessKeyArray != null) {
            request.getBusinessKey().addAll(Arrays.asList(businessKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetBusinessDetail(request), this.getInquiryURI());
        BusinessDetail bd = (BusinessDetail)o.getValue();
        return bd;
    }

    @Override
    public PublisherAssertions getPublisherAssertions(String authInfo) throws RegistryV3Exception {
        GetPublisherAssertions request = this.objectFactory.createGetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        PublisherAssertions pa = new PublisherAssertions();
        JAXBElement<?> o = this.execute(this.objectFactory.createGetPublisherAssertions(request), this.getPublishURI());
        PublisherAssertionsResponse par = (PublisherAssertionsResponse)o.getValue();
        List assertions = par.getPublisherAssertion();
        for (int i = 0; i < assertions.size(); ++i) {
            pa.getPublisherAssertion().add((PublisherAssertion)assertions.get(i));
        }
        return pa;
    }

    @Override
    public RegisteredInfo getRegisteredInfo(String authInfo) throws RegistryV3Exception {
        GetRegisteredInfo request = this.objectFactory.createGetRegisteredInfo();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetRegisteredInfo(request), this.getPublishURI());
        RegisteredInfo ri = (RegisteredInfo)o.getValue();
        return ri;
    }

    @Override
    public ServiceDetail getServiceDetail(String serviceKey) throws RegistryV3Exception {
        String[] keys = new String[]{serviceKey};
        return this.getServiceDetail(keys);
    }

    @Override
    public ServiceDetail getServiceDetail(String[] serviceKeyArray) throws RegistryV3Exception {
        GetServiceDetail request = this.objectFactory.createGetServiceDetail();
        if (serviceKeyArray != null) {
            request.getServiceKey().addAll(Arrays.asList(serviceKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetServiceDetail(request), this.getInquiryURI());
        ServiceDetail sd = (ServiceDetail)o.getValue();
        return sd;
    }

    @Override
    public TModelDetail getTModelDetail(String tModelKey) throws RegistryV3Exception {
        String[] keys = new String[]{tModelKey};
        return this.getTModelDetail(keys);
    }

    @Override
    public TModelDetail getTModelDetail(String[] tModelKeyArray) throws RegistryV3Exception {
        GetTModelDetail request = this.objectFactory.createGetTModelDetail();
        if (tModelKeyArray != null) {
            request.getTModelKey().addAll(Arrays.asList(tModelKeyArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createGetTModelDetail(request), this.getInquiryURI());
        TModelDetail tmd = (TModelDetail)o.getValue();
        return tmd;
    }

    @Override
    public PublisherAssertions setPublisherAssertions(String authInfo, PublisherAssertion[] assertionArray) throws RegistryV3Exception {
        SetPublisherAssertions request = this.objectFactory.createSetPublisherAssertions();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (assertionArray != null) {
            request.getPublisherAssertion().addAll(Arrays.asList(assertionArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSetPublisherAssertions(request), this.getPublishURI());
        PublisherAssertions pa = (PublisherAssertions)o.getValue();
        return pa;
    }

    @Override
    public BindingDetail saveBinding(String authInfo, BindingTemplate[] bindingArray) throws RegistryV3Exception {
        SaveBinding request = this.objectFactory.createSaveBinding();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (bindingArray != null) {
            request.getBindingTemplate().addAll(Arrays.asList(bindingArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveBinding(request), this.getPublishURI());
        BindingDetail bd = (BindingDetail)o.getValue();
        return bd;
    }

    @Override
    public BusinessDetail saveBusiness(String authInfo, BusinessEntity[] businessArray) throws RegistryV3Exception {
        SaveBusiness request = this.objectFactory.createSaveBusiness();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (businessArray != null) {
            for (int i = 0; i < businessArray.length; ++i) {
                BusinessEntity be = businessArray[i];
                if (be.getBusinessServices().getBusinessService().size() != 0) continue;
                be.setBusinessServices(null);
            }
            request.getBusinessEntity().addAll(Arrays.asList(businessArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveBusiness(request), this.getPublishURI());
        BusinessDetail bd = (BusinessDetail)o.getValue();
        return bd;
    }

    @Override
    public ServiceDetail saveService(String authInfo, BusinessService[] serviceArray) throws RegistryV3Exception {
        SaveService request = this.objectFactory.createSaveService();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (serviceArray != null) {
            request.getBusinessService().addAll(Arrays.asList(serviceArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveService(request), this.getPublishURI());
        ServiceDetail sd = (ServiceDetail)o.getValue();
        return sd;
    }

    @Override
    public TModelDetail saveTModel(String authInfo, TModel[] tModelArray) throws RegistryV3Exception {
        SaveTModel request = this.objectFactory.createSaveTModel();
        if (authInfo != null) {
            request.setAuthInfo(authInfo);
        }
        if (tModelArray != null) {
            request.getTModel().addAll(Arrays.asList(tModelArray));
        }
        JAXBElement<?> o = this.execute(this.objectFactory.createSaveTModel(request), this.getPublishURI());
        TModelDetail tmd = (TModelDetail)o.getValue();
        return tmd;
    }

    public Transport getTransport(String className) {
        Transport transport = null;
        Class transportClass = null;
        if (className == null) {
            className = DEFAULT_TRANSPORT_CLASS;
        }
        try {
            transportClass = RegistryV3Impl.getClassForName(className);
        }
        catch (ClassNotFoundException cnfex) {
            throw new RuntimeException(cnfex);
        }
        try {
            transport = (Transport)transportClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return transport;
    }

    public static Class getClassForName(String name) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> clazz = null;
        try {
            ClassLoader ccl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            clazz = Class.forName(name, true, ccl);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to load the class " + name + " with context class loader " + e));
        }
        if (null == clazz) {
            ClassLoader scl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            try {
                clazz = Class.forName(name, true, scl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return clazz;
    }
}

