/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.SubscriptionView;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.SubscriptionInfo;

public class InactiveDurableSubscriptionView
extends SubscriptionView
implements DurableSubscriptionViewMBean {
    protected ManagedRegionBroker broker;
    protected SubscriptionInfo subscriptionInfo;

    public InactiveDurableSubscriptionView(ManagedRegionBroker broker, String clientId, SubscriptionInfo sub) {
        super(clientId, null);
        this.broker = broker;
        this.subscriptionInfo = sub;
    }

    public long getSubcriptionId() {
        return -1L;
    }

    public String getDestinationName() {
        return this.subscriptionInfo.getDestination().getPhysicalName();
    }

    public boolean isDestinationQueue() {
        return false;
    }

    public boolean isDestinationTopic() {
        return true;
    }

    public boolean isDestinationTemporary() {
        return false;
    }

    public String getSubscriptionName() {
        return this.subscriptionInfo.getSubcriptionName();
    }

    public boolean isActive() {
        return false;
    }

    public CompositeData[] browse() throws OpenDataException {
        return this.broker.browse(this);
    }

    public TabularData browseAsTable() throws OpenDataException {
        return this.broker.browseAsTable(this);
    }

    public void destroy() throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubcriptionName(this.subscriptionInfo.getSubcriptionName());
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(this.clientId);
        this.broker.removeSubscription(context, info);
    }

    public String toString() {
        return "InactiveDurableSubscriptionView: " + this.getClientId() + ":" + this.getSubscriptionName();
    }
}

