/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.ArrayList;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.MessageEvaluationContext;

public class FixedCountSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference[] messages;
    private int maximumSize = 100;
    private int tail = 0;

    public SubscriptionRecoveryPolicy copy() {
        FixedCountSubscriptionRecoveryPolicy rc = new FixedCountSubscriptionRecoveryPolicy();
        rc.setMaximumSize(this.maximumSize);
        return rc;
    }

    public synchronized boolean add(ConnectionContext context, MessageReference node) throws Exception {
        this.messages[this.tail++] = node;
        if (this.tail >= this.messages.length) {
            this.tail = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover(ConnectionContext context, Topic topic, Subscription sub) throws Exception {
        int t = this.tail;
        if (this.messages[t] == null) {
            t = 0;
        }
        if (this.messages[t] == null) {
            return;
        }
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        do {
            MessageReference node = this.messages[t];
            try {
                msgContext.setDestination(node.getRegionDestination().getActiveMQDestination());
                msgContext.setMessageReference(node);
                if (sub.matches(node, msgContext)) {
                    sub.add(node);
                }
            }
            finally {
                msgContext.clear();
            }
            if (++t < this.messages.length) continue;
            t = 0;
        } while (t != this.tail);
    }

    public void start() throws Exception {
        this.messages = new MessageReference[this.maximumSize];
    }

    public void stop() throws Exception {
        this.messages = null;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Message[] browse(ActiveMQDestination destination) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        int t = this.tail;
        if (this.messages[t] == null) {
            t = 0;
        }
        if (this.messages[t] != null) {
            do {
                MessageReference ref;
                Message message;
                if (filter.matches((message = (ref = this.messages[t]).getMessage()).getDestination())) {
                    result.add(message);
                }
                if (++t < this.messages.length) continue;
                t = 0;
            } while (t != this.tail);
        }
        return result.toArray(new Message[result.size()]);
    }
}

