/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.rapid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.journal.active.Location;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.JournalQueueAck;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.rapid.RapidMessageReference;
import org.apache.activemq.store.rapid.RapidPersistenceAdapter;
import org.apache.activemq.store.rapid.RapidTransactionStore;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.TransactionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RapidMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)RapidMessageStore.class);
    protected final RapidPersistenceAdapter peristenceAdapter;
    protected final RapidTransactionStore transactionStore;
    protected final MapContainer messageContainer;
    protected final ActiveMQDestination destination;
    protected final TransactionTemplate transactionTemplate;
    protected RecordLocation lastLocation;
    protected HashSet inFlightTxLocations = new HashSet();

    public RapidMessageStore(RapidPersistenceAdapter adapter, ActiveMQDestination destination, MapContainer container) {
        this.peristenceAdapter = adapter;
        this.transactionStore = adapter.getTransactionStore();
        this.messageContainer = container;
        this.destination = destination;
        this.transactionTemplate = new TransactionTemplate(adapter, new ConnectionContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ConnectionContext context, final Message message) throws IOException {
        final MessageId id = message.getMessageId();
        final boolean debug = log.isDebugEnabled();
        final RecordLocation location = this.peristenceAdapter.writeCommand(message, message.isResponseRequired());
        final RapidMessageReference md = new RapidMessageReference(message, location);
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message add for: " + id + ", at: " + location));
            }
            this.addMessage(md);
        } else {
            message.incrementReferenceCount();
            if (debug) {
                log.debug((Object)("Journalled transacted message add for: " + id + ", at: " + location));
            }
            RapidMessageStore rapidMessageStore = this;
            synchronized (rapidMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.addMessage(this, message, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted message add commit for: " + id + ", at: " + location));
                    }
                    message.decrementReferenceCount();
                    RapidMessageStore rapidMessageStore = RapidMessageStore.this;
                    synchronized (rapidMessageStore) {
                        RapidMessageStore.this.inFlightTxLocations.remove(location);
                        RapidMessageStore.this.addMessage(md);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted message add rollback for: " + id + ", at: " + location));
                    }
                    message.decrementReferenceCount();
                    RapidMessageStore rapidMessageStore = RapidMessageStore.this;
                    synchronized (rapidMessageStore) {
                        RapidMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(RapidMessageReference messageReference) {
        RapidMessageStore rapidMessageStore = this;
        synchronized (rapidMessageStore) {
            this.lastLocation = messageReference.getLocation();
            MessageId id = messageReference.getMessageId();
            this.messageContainer.put(id.toString(), messageReference);
        }
    }

    protected static String toString(RecordLocation location) {
        Location l = (Location)location;
        return l.getLogFileId() + ":" + l.getLogFileOffset();
    }

    protected static RecordLocation toRecordLocation(String t) {
        String[] strings = t.split(":");
        if (strings.length != 2) {
            throw new IllegalArgumentException("Invalid location: " + t);
        }
        return new Location(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]));
    }

    public void replayAddMessage(ConnectionContext context, Message message, RecordLocation location) {
        try {
            RapidMessageReference messageReference = new RapidMessageReference(message, location);
            this.messageContainer.put(message.getMessageId().toString(), messageReference);
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay add for message '" + message.getMessageId() + "'.  Message may have already been added. reason: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(ConnectionContext context, final MessageAck ack) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalQueueAck remove = new JournalQueueAck();
        remove.setDestination(this.destination);
        remove.setMessageAck(ack);
        final RecordLocation location = this.peristenceAdapter.writeCommand(remove, ack.isResponseRequired());
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            this.removeMessage(ack, location);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted message remove for: " + ack.getLastMessageId() + ", at: " + location));
            }
            RapidMessageStore rapidMessageStore = this;
            synchronized (rapidMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.removeMessage(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted message remove commit for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    RapidMessageStore rapidMessageStore = RapidMessageStore.this;
                    synchronized (rapidMessageStore) {
                        RapidMessageStore.this.inFlightTxLocations.remove(location);
                        RapidMessageStore.this.removeMessage(ack, location);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() throws Exception {
                    if (debug) {
                        log.debug((Object)("Transacted message remove rollback for: " + ack.getLastMessageId() + ", at: " + location));
                    }
                    RapidMessageStore rapidMessageStore = RapidMessageStore.this;
                    synchronized (rapidMessageStore) {
                        RapidMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMessage(MessageAck ack, RecordLocation location) {
        RapidMessageStore rapidMessageStore = this;
        synchronized (rapidMessageStore) {
            this.lastLocation = location;
            MessageId id = ack.getLastMessageId();
            this.messageContainer.remove(id.toString());
        }
    }

    public void replayRemoveMessage(ConnectionContext context, MessageAck ack) {
        try {
            MessageId id = ack.getLastMessageId();
            this.messageContainer.remove(id.toString());
        }
        catch (Throwable e) {
            log.warn((Object)("Could not replay acknowledge for message '" + ack.getLastMessageId() + "'.  Message may have already been acknowledged. reason: " + e));
        }
    }

    public Message getMessage(MessageId id) throws IOException {
        RapidMessageReference messageReference = (RapidMessageReference)this.messageContainer.get(id.toString());
        if (messageReference == null) {
            return null;
        }
        return (Message)this.peristenceAdapter.readCommand(messageReference.getLocation());
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        Iterator iter = this.messageContainer.values().iterator();
        while (iter.hasNext()) {
            RapidMessageReference messageReference = (RapidMessageReference)iter.next();
            Message m = (Message)this.peristenceAdapter.readCommand(messageReference.getLocation());
            listener.recoverMessage(m);
        }
        listener.finished();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        throw new IOException("The journal does not support message references.");
    }

    public String getMessageReference(MessageId identity) throws IOException {
        throw new IOException("The journal does not support message references.");
    }

    public void setUsageManager(UsageManager usageManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        ArrayList cpActiveJournalLocations;
        RapidMessageStore rapidMessageStore = this;
        synchronized (rapidMessageStore) {
            cpActiveJournalLocations = new ArrayList(this.inFlightTxLocations);
        }
        if (cpActiveJournalLocations.size() > 0) {
            Collections.sort(cpActiveJournalLocations);
            return (RecordLocation)cpActiveJournalLocations.get(0);
        }
        return this.lastLocation;
    }
}

