/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdc;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.cdc.LdapSPValidator;
import com.iplanet.services.cdc.SPValidator;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.common.LogUtil;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.CookieUtils;
import com.sun.identity.shared.encode.URLEncDec;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CDCServlet
extends HttpServlet {
    static Debug debug;
    private static final String UNIQUE_COOKIE_NAME = "sunIdentityServerAuthNServer";
    private static final String DEFAULT_DEPLOY_URI = "/amserver";
    private static final String GOTO_PARAMETER = "goto";
    private static final String TARGET_PARAMETER = "TARGET";
    private static final String CDCURI = "/cdcservlet";
    private static final String AUTHURI = "/UI/Login";
    private static final String PROVIDER_ID = "ProviderID";
    private static final String REQUEST_ID = "RequestID";
    private static final String RELAY_STATE = "RelayState";
    private static final String SELF_PROVIDER_ID;
    private static final List adviceParams;
    private static final String AUTHN_RESPONSE_HTML = "<HTML><BODY Onload=\"document.Response.submit()\"><FORM NAME=\"Response\" METHOD=\"POST\" ACTION=\"{0}\"><INPUT TYPE=\"HIDDEN\" NAME=\"LARES\" VALUE=\"{1}\"/></FORM></BODY></HTML>";
    private SSOTokenManager tokenManager;
    private SessionService sessionService;
    private SPValidator spValidator;
    private String DNSAddress = "localhost";
    private String IPAddress = "127.0.0.1";
    private String authURLCookieName;
    private String authURLCookieDomain;
    private String deployDescriptor;
    private String policyAdviceList;
    private String responseID;
    private boolean uniqueCookieEnabled;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        debug = Debug.getInstance((String)"amCDC");
        debug.message("CDCServlet Initializing...");
        try {
            this.tokenManager = SSOTokenManager.getInstance();
            this.sessionService = SessionService.getSessionService();
            this.spValidator = new LdapSPValidator();
            this.DNSAddress = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host");
            this.IPAddress = InetAddress.getByName(this.DNSAddress).getHostAddress();
            this.authURLCookieName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.authentication.uniqueCookieName", (String)UNIQUE_COOKIE_NAME);
            this.authURLCookieDomain = SystemConfigurationUtil.getProperty((String)"com.sun.identity.authentication.uniqueCookieDomain", (String)"");
            this.deployDescriptor = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.services.deploymentDescriptor", (String)DEFAULT_DEPLOY_URI);
            this.uniqueCookieEnabled = Boolean.valueOf(SystemConfigurationUtil.getProperty((String)"com.sun.identity.enableUniqueSSOTokenCookie", (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("CDCServlet init params: Restricted Token Enabled = " + this.uniqueCookieEnabled + " Auth URL Cookie Name = " + this.authURLCookieName + " Auth URL Cookie Domain = " + this.authURLCookieDomain + " Deployment Descriptor: " + this.deployDescriptor);
            }
        }
        catch (SSOException e) {
            debug.error("CDCServlet.init: Unable to get SSOTokenManager", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (UnknownHostException e) {
            debug.error("CDCServlet.init", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetPost(request, response);
    }

    private void doGetPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SSOToken token;
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.doGetPost: Query String received: " + request.getQueryString());
        }
        if ((token = this.getSSOToken(request, response)) == null) {
            this.policyAdviceList = null;
        }
        this.policyAdviceList = this.checkForPolicyAdvice(request, response);
        if (token == null || this.policyAdviceList != null) {
            this.redirectForAuthentication(request, response);
        } else {
            this.redirectWithAuthNResponse(request, response, token);
        }
    }

    private void redirectWithAuthNResponse(HttpServletRequest request, HttpServletResponse response, SSOToken token) throws ServletException, IOException {
        String gotoURL = this.getRedirectURL(request, response);
        if (gotoURL != null) {
            try {
                String inResponseTo = request.getParameter(REQUEST_ID);
                String spDescriptor = request.getParameter(PROVIDER_ID);
                String resTokenID = null;
                resTokenID = this.uniqueCookieEnabled ? this.sessionService.getRestrictedTokenId(token.getTokenID().toString(), this.spValidator.validateAndGetRestriction(FSAuthnRequest.parseURLEncodedRequest((HttpServletRequest)request), gotoURL)) : token.getTokenID().toString();
                FSAssertion assertion = this.createAssertion(spDescriptor, SELF_PROVIDER_ID, resTokenID, token.getAuthType(), token.getProperty("authInstant"), token.getPrincipal().getName(), inResponseTo);
                String relayState = request.getParameter(RELAY_STATE);
                Status status = new Status(new StatusCode("samlp:Success"));
                FSAuthnResponse authnResponse = this.createAuthnResponse(SELF_PROVIDER_ID, this.responseID, inResponseTo, status, assertion, relayState);
                this.sendAuthnResponse(request, response, authnResponse, gotoURL);
            }
            catch (SAMLException se) {
                debug.error("CDCServlet.doGetPost", (Throwable)se);
                this.showError(response);
            }
            catch (FSMsgException fe) {
                debug.error("CDCServlet.doGetPost", (Throwable)fe);
                this.showError(response);
            }
            catch (FSException fse) {
                debug.error("CDCServlet.doGetPost", (Throwable)fse);
                this.showError(response);
            }
            catch (SessionException e) {
                debug.error("CDCServlet.doGetPost", (Throwable)e);
            }
            catch (SSOException ssoe) {
                debug.error("CDCServlet.doGetPost", (Throwable)ssoe);
            }
            catch (Exception e) {
                debug.error("CDCServlet.doGetPost", (Throwable)e);
                this.showError(response, "Access to resource is denied.");
            }
        }
    }

    private String getRedirectURL(HttpServletRequest request, HttpServletResponse response) {
        String gotoURL = request.getParameter(GOTO_PARAMETER);
        String targetURL = request.getParameter(TARGET_PARAMETER);
        if (gotoURL == null || gotoURL.length() == 0) {
            gotoURL = request.getParameter(TARGET_PARAMETER);
        }
        if (gotoURL == null || gotoURL.length() == 0) {
            debug.error("No GOTO or TARGET URL present in the Query !!");
            this.showError(response);
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.getRedirectURL, URL =" + gotoURL);
        }
        return gotoURL;
    }

    private String getParameterString(HttpServletRequest request) {
        StringBuffer parameterString = new StringBuffer(1024);
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String[] values;
            String paramName = (String)e.nextElement();
            if (paramName.equalsIgnoreCase(GOTO_PARAMETER) || adviceParams.contains(paramName) || (values = request.getParameterValues(paramName)) == null) continue;
            for (int i = 0; i < values.length; ++i) {
                parameterString.append("&").append(paramName).append("=").append(URLEncDec.encode((String)values[i]));
            }
        }
        return parameterString.deleteCharAt(0).toString();
    }

    private String checkForPolicyAdvice(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer adviceList = null;
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String[] values;
            String paramName = (String)e.nextElement();
            if (!adviceParams.contains(paramName)) continue;
            if (adviceList == null) {
                adviceList = new StringBuffer();
            } else {
                adviceList.append("&");
            }
            if ((values = request.getParameterValues(paramName)) == null) continue;
            for (int i = 0; i < values.length; ++i) {
                adviceList.append(paramName).append("=").append(values[i]);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.checkForPolicyAdvice: Advice List is : " + adviceList);
        }
        return adviceList == null ? null : adviceList.toString();
    }

    private void redirectForAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer redirectURL = new StringBuffer(1024);
        String authURL = null;
        Cookie authCookie = CookieUtils.getCookieFromReq((HttpServletRequest)request, (String)this.authURLCookieName);
        if (authCookie != null) {
            authURL = CookieUtils.getCookieValue((Cookie)authCookie);
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.redirectForAuthentiation: got an authenticated URL: " + authURL);
            }
        }
        try {
            if (authURL == null || authURL.length() == 0 || this.policyAdviceList != null || !authURL.toLowerCase().startsWith("http")) {
                String finalURL = this.getRedirectURL(request, response);
                if (finalURL != null) {
                    StringBuffer gotoURL = new StringBuffer(1024);
                    gotoURL.append(this.deployDescriptor).append(CDCURI).append("?").append(TARGET_PARAMETER).append("=").append(URLEncDec.encode((String)finalURL)).append("&").append(this.getParameterString(request));
                    redirectURL.append(AUTHURI).append("?");
                    if (this.policyAdviceList != null) {
                        redirectURL.append(this.policyAdviceList).append("&");
                    }
                    redirectURL.append(GOTO_PARAMETER).append("=").append(URLEncDec.encode((String)gotoURL.toString()));
                    if (this.policyAdviceList != null) {
                        redirectURL.append("&").append(this.policyAdviceList);
                    }
                    RequestDispatcher dispatcher = request.getRequestDispatcher(redirectURL.toString());
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
            } else {
                redirectURL.append(authURL).append(this.deployDescriptor).append(CDCURI).append("?").append(request.getQueryString());
                if (authCookie != null) {
                    authCookie.setValue("");
                    response.addCookie(authCookie);
                }
                response.sendRedirect(redirectURL.toString());
            }
            if (debug.messageEnabled()) {
                debug.message("Forwarding for authentication to: " + redirectURL);
            }
        }
        catch (IOException e) {
            debug.error("CDCServlet.redirectForAuthentication", (Throwable)e);
            this.showError(response);
        }
        catch (ServletException e) {
            debug.error("CDCServlet.redirectForAuthentication", (Throwable)e);
            this.showError(response);
        }
        catch (IllegalStateException e) {
            debug.error("CDCServlet.redirectForAuthentication", (Throwable)e);
            this.showError(response);
        }
    }

    private void showError(HttpServletResponse response) {
        this.showError(response, "ERROR: An application error has occured.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showError(HttpServletResponse response, String msg) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.println(msg);
            out.flush();
        }
        catch (IOException e) {
            debug.error("CDCServlet.showError: Could not show error message to the user", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private SSOToken getSSOToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOToken token = null;
        try {
            token = this.tokenManager.createSSOToken(request);
            if (token == null || !this.tokenManager.isValidToken(token)) {
                if (debug.messageEnabled()) {
                    debug.message("CDCSerlvet.getSSOToken: SSOToken is either null or not valid: " + token + "\nRedirecting for authentication");
                }
                token = null;
            }
        }
        catch (SSOException e) {
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.getSSOToken" + (Object)((Object)e));
            }
            token = null;
        }
        return token;
    }

    private FSAuthnResponse createAuthnResponse(String providerID, String responseID, String inResponseTo, Status status, FSAssertion assertion, String relayState) throws SAMLException, FSMsgException {
        ArrayList<FSAssertion> contents = new ArrayList<FSAssertion>(1);
        contents.add(assertion);
        FSAuthnResponse response = new FSAuthnResponse(null, inResponseTo, status, contents, relayState);
        response.setProviderId(providerID);
        return response;
    }

    private FSAssertion createAssertion(String destID, String sourceID, String tokenID, String authType, String strAuthInst, String userDN, String inResponseTo) throws FSException, SAMLException {
        NameIdentifier idpHandle;
        debug.message("Entering CDCServlet.createAssertion Method");
        if (destID == null || sourceID == null || tokenID == null || authType == null || userDN == null || inResponseTo == null) {
            debug.message("CDCServlet,createAssertion: null input");
            throw new FSException(FSUtils.bundle.getString("nullInput"));
        }
        String securityDomain = sourceID;
        NameIdentifier spHandle = idpHandle = new NameIdentifier(URLEncDec.encode((String)tokenID), sourceID);
        String authMethod = authType;
        Date authInstant = this.convertAuthInstanceToDate(strAuthInst);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion Creating Authentication Assertion for user with opaqueHandle =" + spHandle.getName() + " and SecurityDomain = " + securityDomain);
        }
        SubjectConfirmation subConfirmation = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        IDPProvidedNameIdentifier idpNi = new IDPProvidedNameIdentifier(idpHandle.getNameQualifier(), idpHandle.getName());
        FSSubject sub = new FSSubject(spHandle, subConfirmation, idpNi);
        SubjectLocality authLocality = new SubjectLocality(this.IPAddress, this.DNSAddress);
        AuthnContext authnContextStmt = new AuthnContext(null, null);
        FSAuthenticationStatement statement = new FSAuthenticationStatement(authMethod, authInstant, (Subject)sub, authLocality, null, authnContextStmt);
        Date issueInstant = new Date();
        Integer assertionTimeout = new Integer(60);
        long period = assertionTimeout * 1000;
        if (period < 60000L) {
            period = 60000L;
        }
        Date notAfter = new Date(issueInstant.getTime() + period);
        statement.setReauthenticateOnOrAfter(notAfter);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion: Authentication Statement: " + statement.toXMLString());
        }
        Conditions cond = new Conditions(issueInstant, notAfter);
        if (destID != null && destID.length() != 0) {
            ArrayList<String> targets = new ArrayList<String>(1);
            targets.add(destID);
            cond.addAudienceRestrictionCondition(new AudienceRestrictionCondition(targets));
        }
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion: Condition: " + cond.toString());
        }
        AssertionIDReference aID = new AssertionIDReference();
        HashSet<FSAuthenticationStatement> statements = new HashSet<FSAuthenticationStatement>(2);
        statements.add(statement);
        FSAssertion assertion = new FSAssertion(aID.getAssertionIDReference(), sourceID, issueInstant, cond, statements, inResponseTo);
        assertion.setID(aID.getAssertionIDReference());
        String[] params = new String[]{FSUtils.bundle.getString("assertionCreated") + ":" + assertion.toString()};
        LogUtil.access((Level)Level.INFO, (String)"FSAssertionManager", (String[])params);
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.createAssertion: Returning Assertion: " + assertion.toXMLString());
        }
        return assertion;
    }

    private Date convertAuthInstanceToDate(String strAuthInst) {
        Date authInstant;
        block3: {
            authInstant = null;
            if (strAuthInst != null) {
                try {
                    authInstant = DateUtils.stringToDate((String)strAuthInst);
                }
                catch (ParseException ex) {
                    if (!debug.messageEnabled()) break block3;
                    debug.message("CDCServlet.convertAuthInstanceToDate: cannot convert " + strAuthInst);
                }
            }
        }
        return authInstant == null ? new Date() : authInstant;
    }

    private void sendAuthnResponse(HttpServletRequest request, HttpServletResponse response, FSAuthnResponse authnResponse, String destURL) {
        if (debug.messageEnabled()) {
            debug.message("CDCServlet.sendAuthnResponse: Called");
        }
        try {
            String respStr = authnResponse.toXMLString(true, true);
            if (debug.messageEnabled()) {
                debug.message("CDCServlet.sendAuthnResponse: AuthnResponse: " + respStr);
            }
            String b64Resp = Base64.encode((byte[])respStr.getBytes());
            response.setContentType("text/html");
            response.setHeader("Pragma", "no-cache");
            Object[] params = new Object[]{destURL, b64Resp};
            PrintWriter out = response.getWriter();
            out.println(MessageFormat.format(AUTHN_RESPONSE_HTML, params));
            out.close();
            if (debug.messageEnabled()) {
                debug.message("CDCServlet:sendAuthnResponse: AuthnResponse sent successfully to: " + destURL);
            }
        }
        catch (FSMsgException fme) {
            debug.error("CDCServlet.sendAuthnResponse:" + (Object)((Object)fme));
        }
        catch (IOException ioe) {
            debug.error("CDCServlet.sendAuthnResponse:" + ioe);
        }
    }

    static {
        SELF_PROVIDER_ID = FSServiceUtils.getBaseURL() + CDCURI;
        adviceParams = new ArrayList();
        adviceParams.add("module");
        adviceParams.add("authlevel");
        adviceParams.add("role");
        adviceParams.add("service");
        adviceParams.add("user");
        adviceParams.add("realm");
        adviceParams.add("org");
        adviceParams.add("sunamcompositeadvice");
    }
}

