/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.accountmgmt.FSAccountUtils;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.shared.encode.Base64;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BulkFederation
extends AuthenticatedCommand {
    static final String ARGUMENT_METADATA = "metaalias";
    static final String ARGUMENT_REMOTE_ID = "remoteentityid";
    static final String ARGUMENT_USER_ID_MAPPING = "useridmapping";
    static final String ARGUMENT_NAME_ID_MAPPING = "nameidmapping";
    static final String HEADER_LOCAL = "#local:";
    static final String HEADER_REMOTE = "#remote:";
    static final String HEADER_ROLE = "#role:";
    static final String HEADER_SPEC = "#specification:";
    private SecureRandom randomGenerator = new SecureRandom();
    private String metaAlias;
    private String localEntityId;
    private String remoteEntityId;
    private boolean isIDP;
    private String userIdMappingFileName;
    private String outFile;
    private String spec;
    static Set idffUserAttributesFed = new HashSet(4);
    static Set saml2UserAttributesFed = new HashSet(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(RequestContext rc) throws CLIException {
        block10: {
            super.handleRequest(rc);
            this.ldapLogin();
            this.metaAlias = this.getStringOptionValue(ARGUMENT_METADATA);
            this.remoteEntityId = this.getStringOptionValue(ARGUMENT_REMOTE_ID);
            this.userIdMappingFileName = this.getStringOptionValue(ARGUMENT_USER_ID_MAPPING);
            this.outFile = this.getStringOptionValue(ARGUMENT_NAME_ID_MAPPING);
            this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
            BufferedWriter out = null;
            try {
                if (this.spec.equals("saml2")) {
                    this.getEntityRoleAndIdSAML2();
                    out = this.validateFiles();
                    this.handleSAML2Request(out);
                    break block10;
                }
                if (this.spec.equals("idff")) {
                    this.getEntityRoleAndIdIDFF();
                    out = this.validateFiles();
                    this.handleIDFFRequest(out);
                    break block10;
                }
                throw new CLIException(this.getResourceString("unsupported-specification"), 127);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void handleSAML2Request(BufferedWriter out) throws CLIException {
        Map userIdMapping = this.getUserIdMapping(this.userIdMappingFileName);
        Iterator i = userIdMapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String localUserId = (String)e.getKey();
            String remoteUserId = (String)e.getValue();
            this.saml2FederateUser(localUserId, remoteUserId, out);
        }
        IOutput outputWriter = this.getOutputWriter();
        outputWriter.printlnMessage(this.getResourceString("bulk-federation-succeeded"));
    }

    private void handleIDFFRequest(BufferedWriter out) throws CLIException {
        Map userIdMapping = this.getUserIdMapping(this.userIdMappingFileName);
        Iterator i = userIdMapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String localUserId = (String)e.getKey();
            String remoteUserId = (String)e.getValue();
            this.idffFederateUser(localUserId, remoteUserId, out);
        }
        IOutput outputWriter = this.getOutputWriter();
        outputWriter.printlnMessage(this.getResourceString("bulk-federation-succeeded"));
    }

    private void idffFederateUser(String localUserId, String remoteUserId, BufferedWriter out) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        try {
            AMIdentity amid = IdUtils.getIdentity((SSOToken)adminSSOToken, (String)localUserId);
            String nameId = this.createNameIdentifier();
            FSAccountFedInfoKey key = this.isIDP ? new FSAccountFedInfoKey(this.remoteEntityId, nameId) : new FSAccountFedInfoKey(this.localEntityId, nameId);
            FSAccountFedInfo info = null;
            info = this.isIDP ? new FSAccountFedInfo(this.remoteEntityId, new NameIdentifier(nameId, this.remoteEntityId, "urn:liberty:iff:nameid:federated"), 0, true) : new FSAccountFedInfo(this.remoteEntityId, new NameIdentifier(nameId, this.localEntityId, "urn:liberty:iff:nameid:federated"), 1, true);
            Map attributes = amid.getAttributes(idffUserAttributesFed);
            HashSet<String> setInfoKey = (HashSet<String>)attributes.get("iplanet-am-user-federation-info-key");
            if (setInfoKey == null || setInfoKey.isEmpty()) {
                setInfoKey = new HashSet<String>(2);
                attributes.put("iplanet-am-user-federation-info-key", setInfoKey);
            }
            setInfoKey.add(FSAccountUtils.objectToKeyString((FSAccountFedInfoKey)key));
            HashSet<String> setInfo = (HashSet<String>)attributes.get("iplanet-am-user-federation-info");
            if (setInfo == null || setInfo.isEmpty()) {
                setInfo = new HashSet<String>(2);
                attributes.put("iplanet-am-user-federation-info", setInfo);
            }
            setInfo.add(FSAccountUtils.objectToInfoString((FSAccountFedInfo)info));
            amid.setAttributes(attributes);
            amid.store();
            out.write(remoteUserId + "|" + nameId);
            out.newLine();
        }
        catch (FSAccountMgmtException e) {
            this.debugError("BulkFederation.idffFederateUser", e);
            Object[] param = new Object[]{localUserId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (SAMLException e) {
            this.debugError("BulkFederation.idffFederateUser", e);
            Object[] param = new Object[]{localUserId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (IOException e) {
            this.debugError("BulkFederation.idffFederateUser", e);
            Object[] param = new Object[]{localUserId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (IdRepoException e) {
            this.debugError("BulkFederation.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
        catch (SSOException e) {
            this.debugError("BulkFederation.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
    }

    private void saml2FederateUser(String localUserId, String remoteUserId, BufferedWriter out) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        try {
            AMIdentity amid = IdUtils.getIdentity((SSOToken)adminSSOToken, (String)localUserId);
            String nameIdValue = this.createNameIdentifier();
            NameID nameId = AssertionFactory.getInstance().createNameID();
            nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            if (this.isIDP) {
                nameId.setNameQualifier(this.localEntityId);
                nameId.setSPNameQualifier(this.remoteEntityId);
            } else {
                nameId.setNameQualifier(this.remoteEntityId);
                nameId.setSPNameQualifier(this.localEntityId);
            }
            nameId.setValue(nameIdValue);
            String role = this.isIDP ? "IDPRole" : "SPRole";
            NameIDInfoKey key = new NameIDInfoKey(nameIdValue, this.localEntityId, this.remoteEntityId);
            NameIDInfo info = new NameIDInfo(this.localEntityId, this.remoteEntityId, nameId, role, true);
            Map attributes = amid.getAttributes(saml2UserAttributesFed);
            HashSet<String> setInfoKey = (HashSet<String>)attributes.get("sun-fm-saml2-nameid-infokey");
            if (setInfoKey == null || setInfoKey.isEmpty()) {
                setInfoKey = new HashSet<String>(2);
                attributes.put("sun-fm-saml2-nameid-infokey", setInfoKey);
            }
            setInfoKey.add(key.toValueString());
            HashSet<String> setInfo = (HashSet<String>)attributes.get("sun-fm-saml2-nameid-info");
            if (setInfo == null || setInfo.isEmpty()) {
                setInfo = new HashSet<String>(2);
                attributes.put("sun-fm-saml2-nameid-info", setInfo);
            }
            setInfo.add(info.toValueString());
            amid.setAttributes(attributes);
            amid.store();
            out.write(remoteUserId + "|" + nameIdValue);
            out.newLine();
        }
        catch (SAML2Exception e) {
            this.debugError("BulkFederation.saml2FederateUser", e);
            Object[] param = new Object[]{localUserId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (IOException e) {
            this.debugError("BulkFederation.saml2FederateUser", e);
            Object[] param = new Object[]{localUserId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (IdRepoException e) {
            this.debugError("BulkFederation.saml2FederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
        catch (SSOException e) {
            this.debugError("BulkFederation.saml2FederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
    }

    private void getEntityRoleAndIdIDFF() throws CLIException {
        try {
            IDFFMetaManager idffMgr = new IDFFMetaManager((Object)this.getAdminSSOToken());
            String role = idffMgr.getProviderRoleByMetaAlias(this.metaAlias);
            if (role == null) {
                Object[] param = new Object[]{this.metaAlias};
                throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-unknown-metaalias"), param), 127);
            }
            this.isIDP = role.equals("IDP");
            this.localEntityId = idffMgr.getEntityIDByMetaAlias(this.metaAlias);
        }
        catch (IDFFMetaException e) {
            this.debugError("BulkFederation.getEntityRoleAndIdIDFF", e);
            Object[] param = new Object[]{this.metaAlias};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-unknown-metaalias"), param), 127);
        }
    }

    private void getEntityRoleAndIdSAML2() throws CLIException {
        try {
            SAML2MetaManager saml2Mgr = new SAML2MetaManager();
            String role = saml2Mgr.getRoleByMetaAlias(this.metaAlias);
            if (role.equals("UNKNOWN")) {
                Object[] param = new Object[]{this.metaAlias};
                throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-unknown-metaalias"), param), 127);
            }
            this.isIDP = role.equals("IDPRole");
            this.localEntityId = saml2Mgr.getEntityByMetaAlias(this.metaAlias);
        }
        catch (SAML2MetaException e) {
            this.debugError("BulkFederation.getEntityRoleAndIdSAML2", e);
            Object[] param = new Object[]{this.metaAlias};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-unknown-metaalias"), param), 127);
        }
    }

    private BufferedWriter validateFiles() throws CLIException {
        File input = new File(this.userIdMappingFileName);
        if (!input.exists()) {
            Object[] param = new Object[]{this.userIdMappingFileName};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-infile-do-not-exists"), param), 127);
        }
        File output = new File(this.outFile);
        if (output.exists()) {
            Object[] param = new Object[]{this.outFile};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-outfile-exists"), param), 127);
        }
        try {
            output.createNewFile();
            if (!output.canWrite()) {
                Object[] param = new Object[]{this.outFile};
                throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-outfile-cannot-write"), param), 127);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(output));
            out.write(HEADER_LOCAL + this.localEntityId);
            out.newLine();
            out.write(HEADER_REMOTE + this.remoteEntityId);
            out.newLine();
            String role = this.isIDP ? "IDP" : "SP";
            out.write(HEADER_ROLE + role);
            out.newLine();
            if (this.spec.equals("idff")) {
                out.write("#specification:idff");
            } else {
                out.write("#specification:saml2");
            }
            out.newLine();
            return out;
        }
        catch (IOException e) {
            throw new CLIException(e.getMessage(), 127);
        }
    }

    private Map getUserIdMapping(String fileName) throws CLIException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader io = null;
        try {
            io = new BufferedReader(new FileReader(fileName));
            String line = io.readLine();
            while (line != null) {
                int len = (line = line.trim()).length();
                if (len > 0) {
                    int idx = line.indexOf(124);
                    if (idx == -1 || idx == 0 || idx == len - 1) {
                        Object[] param = new Object[]{line, fileName};
                        throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-wrong-format"), param), 127);
                    }
                    map.put(line.substring(0, idx), line.substring(idx + 1));
                }
                line = io.readLine();
            }
        }
        catch (IOException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (io != null) {
                try {
                    io.close();
                }
                catch (IOException ex) {}
            }
        }
        return map;
    }

    private String createNameIdentifier() throws CLIException {
        byte[] handleBytes = new byte[21];
        this.randomGenerator.nextBytes(handleBytes);
        if (handleBytes == null) {
            throw new CLIException(this.getResourceString("bulk-federation-cannot-generate-name-id"), 127);
        }
        return Base64.encode((byte[])handleBytes);
    }

    static {
        idffUserAttributesFed.add("iplanet-am-user-federation-info-key");
        idffUserAttributesFed.add("iplanet-am-user-federation-info");
        saml2UserAttributesFed.add("sun-fm-saml2-nameid-infokey");
        saml2UserAttributesFed.add("sun-fm-saml2-nameid-info");
    }
}

