/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.shared.debug.Debug;
import java.text.MessageFormat;

public class DeleteCircleOfTrust
extends AuthenticatedCommand {
    private static Debug debug = COTUtils.debug;
    private String realm;
    private String cot;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.deleteCircleOfTrust(this.realm, this.cot);
            Object[] obj = new Object[]{this.cot};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("delete-circle-of-trust-succeeded"), obj));
        }
        catch (COTException e) {
            debug.warning("DeleteCircleOfTrust.handleRequest", (Throwable)e);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

