/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.accountmgmt.FSAccountUtils;
import com.sun.identity.federation.cli.BulkFederation;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.federation.meta.IDFFMetaException;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ImportBulkFederationData
extends AuthenticatedCommand {
    static final String ARGUMENT_METADATA = "metaalias";
    static final String ARGUMENT_BULK_DATA = "bulk-data-file";
    private String metaAlias;
    private String bulkFedData;
    private String spec;
    boolean isIDP;
    private String localEntityId;
    private String remoteEntityId;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.metaAlias = this.getStringOptionValue(ARGUMENT_METADATA);
        this.bulkFedData = this.getStringOptionValue(ARGUMENT_BULK_DATA);
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        if (this.spec.equals("saml2")) {
            this.saml2GetRoleAndEntityId();
            HashMap nameIds = new HashMap();
            this.validateFile(nameIds);
            this.handleSAML2Request(nameIds);
        } else if (this.spec.equals("idff")) {
            this.idffGetRoleAndEntityId();
            HashMap nameIds = new HashMap();
            this.validateFile(nameIds);
            this.handleIDFFRequest(nameIds);
        } else {
            throw new CLIException(this.getResourceString("unsupported-specification"), 127);
        }
    }

    private void idffGetRoleAndEntityId() throws CLIException {
        try {
            IDFFMetaManager idffMgr = new IDFFMetaManager((Object)this.getAdminSSOToken());
            String role = idffMgr.getProviderRoleByMetaAlias(this.metaAlias);
            if (role == null) {
                Object[] param = new Object[]{this.metaAlias};
                throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-unknown-metaalias"), param), 127);
            }
            this.isIDP = role.equals("IDP");
            this.localEntityId = idffMgr.getEntityIDByMetaAlias(this.metaAlias);
        }
        catch (IDFFMetaException e) {
            this.debugError("ImportBulkFederationData.idffGetRoleAndEntityId", e);
            Object[] param = new Object[]{this.metaAlias};
            throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-unknown-metaalias"), param), 127);
        }
    }

    private void saml2GetRoleAndEntityId() throws CLIException {
        try {
            SAML2MetaManager saml2Mgr = new SAML2MetaManager();
            String role = saml2Mgr.getRoleByMetaAlias(this.metaAlias);
            if (role.equals("UNKNOWN")) {
                Object[] param = new Object[]{this.metaAlias};
                throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-unknown-metaalias"), param), 127);
            }
            this.isIDP = role.equals("IDPRole");
            this.localEntityId = saml2Mgr.getEntityByMetaAlias(this.metaAlias);
        }
        catch (SAML2MetaException e) {
            this.debugError("ImportBulkFederationData.idffGetRoleAndEntityId", e);
            Object[] param = new Object[]{this.metaAlias};
            throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-unknown-metaalias"), param), 127);
        }
    }

    private void handleSAML2Request(Map nameIds) throws CLIException {
        Iterator i = nameIds.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String userId = (String)e.getKey();
            String nameId = (String)e.getValue();
            this.saml2FederateUser(userId, nameId);
        }
        IOutput outputWriter = this.getOutputWriter();
        outputWriter.printlnMessage(this.getResourceString("import-bulk-federation-data-succeeded"));
    }

    private void handleIDFFRequest(Map nameIds) throws CLIException {
        Iterator i = nameIds.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String userId = (String)e.getKey();
            String nameId = (String)e.getValue();
            this.idffFederateUser(userId, nameId);
        }
        IOutput outputWriter = this.getOutputWriter();
        outputWriter.printlnMessage(this.getResourceString("import-bulk-federation-data-succeeded"));
    }

    private void validateFile(Map map) throws CLIException {
        BufferedReader io = null;
        String localId = null;
        try {
            io = new BufferedReader(new FileReader(this.bulkFedData));
            localId = this.getLocalEntityId(io.readLine());
            this.matchEntityId(io.readLine(), this.localEntityId);
            this.matchRole(io.readLine(), this.isIDP);
            this.validateSpec(io.readLine());
            String line = io.readLine();
            while (line != null) {
                int len = (line = line.trim()).length();
                if (len > 0) {
                    int idx = line.indexOf(124);
                    if (idx == -1 || idx == 0 || idx == len - 1) {
                        Object[] param = new Object[]{line};
                        throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-incorrect-data-format"), param), 127);
                    }
                    map.put(line.substring(0, idx), line.substring(idx + 1));
                }
                line = io.readLine();
            }
            this.remoteEntityId = localId;
        }
        catch (IOException e) {
            throw new CLIException(e.getMessage(), 127);
        }
        finally {
            if (io != null) {
                try {
                    io.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private String getLocalEntityId(String line) throws CLIException {
        if (line == null || !line.startsWith("#local:")) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-file-format"), 127);
        }
        return line.substring("#local:".length());
    }

    private void matchEntityId(String line, String entityId) throws CLIException {
        if (line == null || !line.startsWith("#remote:")) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-file-format"), 127);
        }
        String remoteId = line.substring("#remote:".length());
        if (!entityId.equals(remoteId)) {
            Object[] param = new Object[]{remoteId};
            throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-incorrect-entity-id"), param), 127);
        }
    }

    private void matchRole(String line, boolean isIDP) throws CLIException {
        if (line == null || !line.startsWith("#role:")) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-file-format"), 127);
        }
        String role = line.substring("#role:".length());
        if (isIDP == role.equals("IDP")) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-role"), 127);
        }
    }

    private void validateSpec(String line) throws CLIException {
        if (line == null || !line.startsWith("#specification:")) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-file-format"), 127);
        }
        String s = line.substring("#specification:".length());
        if (!this.spec.equals(s)) {
            throw new CLIException(this.getResourceString("import-bulk-federation-data-incorrect-spec"), 127);
        }
    }

    private void idffFederateUser(String userId, String nameId) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        try {
            AMIdentity amid = IdUtils.getIdentity((SSOToken)adminSSOToken, (String)userId);
            FSAccountFedInfoKey key = !this.isIDP ? new FSAccountFedInfoKey(this.localEntityId, nameId) : new FSAccountFedInfoKey(this.remoteEntityId, nameId);
            FSAccountFedInfo info = null;
            info = this.isIDP ? new FSAccountFedInfo(this.remoteEntityId, new NameIdentifier(nameId, this.remoteEntityId, "urn:liberty:iff:nameid:federated"), 0, false) : new FSAccountFedInfo(this.remoteEntityId, new NameIdentifier(nameId, this.localEntityId, "urn:liberty:iff:nameid:federated"), 1, false);
            Map attributes = amid.getAttributes(BulkFederation.idffUserAttributesFed);
            HashSet<String> setInfoKey = (HashSet<String>)attributes.get("iplanet-am-user-federation-info-key");
            if (setInfoKey == null || setInfoKey.isEmpty()) {
                setInfoKey = new HashSet<String>(2);
                attributes.put("iplanet-am-user-federation-info-key", setInfoKey);
            }
            setInfoKey.add(FSAccountUtils.objectToKeyString((FSAccountFedInfoKey)key));
            HashSet<String> setInfo = (HashSet<String>)attributes.get("iplanet-am-user-federation-info");
            if (setInfo == null || setInfo.isEmpty()) {
                setInfo = new HashSet<String>(2);
                attributes.put("iplanet-am-user-federation-info", setInfo);
            }
            setInfo.add(FSAccountUtils.objectToInfoString((FSAccountFedInfo)info));
            amid.setAttributes(attributes);
            amid.store();
        }
        catch (FSAccountMgmtException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            Object[] param = new Object[]{userId};
            throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-cannot-federate"), param), 127);
        }
        catch (SAMLException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            Object[] param = new Object[]{userId};
            throw new CLIException(MessageFormat.format(this.getResourceString("bulk-federation-cannot-federate"), param), 127);
        }
        catch (IdRepoException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
        catch (SSOException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
    }

    private void saml2FederateUser(String userId, String nameIdValue) throws CLIException {
        SSOToken adminSSOToken = this.getAdminSSOToken();
        try {
            AMIdentity amid = IdUtils.getIdentity((SSOToken)adminSSOToken, (String)userId);
            NameID nameId = AssertionFactory.getInstance().createNameID();
            nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            if (this.isIDP) {
                nameId.setNameQualifier(this.localEntityId);
                nameId.setSPNameQualifier(this.remoteEntityId);
            } else {
                nameId.setNameQualifier(this.remoteEntityId);
                nameId.setSPNameQualifier(this.localEntityId);
            }
            nameId.setValue(nameIdValue);
            String role = this.isIDP ? "IDPRole" : "SPRole";
            NameIDInfoKey key = new NameIDInfoKey(nameIdValue, this.localEntityId, this.remoteEntityId);
            NameIDInfo info = new NameIDInfo(this.localEntityId, this.remoteEntityId, nameId, role, true);
            Map attributes = amid.getAttributes(BulkFederation.saml2UserAttributesFed);
            HashSet<String> setInfoKey = (HashSet<String>)attributes.get("iplanet-am-user-federation-info-key");
            if (setInfoKey == null || setInfoKey.isEmpty()) {
                setInfoKey = new HashSet<String>(2);
                attributes.put("sun-fm-saml2-nameid-infokey", setInfoKey);
            }
            setInfoKey.add(key.toValueString());
            HashSet<String> setInfo = (HashSet<String>)attributes.get("iplanet-am-user-federation-info");
            if (setInfo == null || setInfo.isEmpty()) {
                setInfo = new HashSet<String>(2);
                attributes.put("sun-fm-saml2-nameid-info", setInfo);
            }
            setInfo.add(info.toValueString());
            amid.setAttributes(attributes);
            amid.store();
        }
        catch (SAML2Exception e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            Object[] param = new Object[]{userId};
            throw new CLIException(MessageFormat.format(this.getResourceString("import-bulk-federation-data-cannot-federate"), param), 127);
        }
        catch (IdRepoException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
        catch (SSOException e) {
            this.debugError("ImportBulkFederationData.idffFederateUser", e);
            IOutput outputWriter = this.getOutputWriter();
            outputWriter.printlnError(e.getMessage());
        }
    }
}

