/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcClient;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.AssertionTokenSpec;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.security.SAML2TokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.SecurityTokenFactory;
import com.sun.identity.wss.security.UserNameTokenSpec;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.X509TokenSpec;
import com.sun.identity.wss.security.handler.MessageAuthenticator;
import com.sun.identity.wss.security.handler.MessageProcessor;
import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import com.sun.identity.wss.security.handler.SecureSOAPMessage;
import com.sun.identity.wss.security.handler.ThreadLocalService;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.TrustAuthorityClient;
import com.sun.identity.wss.sts.config.FAMSTSConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPRequestHandler
implements SOAPRequestHandlerInterface {
    private String providerName = null;
    private String PROVIDER_NAME = "providername";
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static String BACK_SLASH = "\\";
    private static String FORWARD_SLASH = "/";
    private static MessageAuthenticator authenticator = null;
    private static final String WSS_AUTHENTICATOR = "com.sun.identity.wss.security.authenticator";
    private static final String LIBERTY_AUTHN_URL = "com.sun.identity.liberty.authnsvc.url";
    private static final String MECHANISM_SSOTOKEN = "SSOTOKEN";

    public void init(Map config) throws SecurityException {
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.Init map:" + config);
        }
        this.providerName = (String)config.get(this.PROVIDER_NAME);
        if (this.providerName == null || this.providerName.length() == 0) {
            debug.error("SOAPRequestHandler.init:: provider name is null");
            throw new SecurityException(bundle.getString("SOAPRequestHandlerInitFailed"));
        }
    }

    public Object validateRequest(SOAPMessage soapRequest, Subject subject, Map sharedState, HttpServletRequest request, HttpServletResponse response) throws SecurityException {
        boolean isSTS;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateRequest: sharedState map : " + sharedState);
        }
        ProviderConfig config = null;
        FAMSTSConfiguration stsConfig = null;
        Boolean isTrustMessage = (Boolean)sharedState.get("IS_TRUST_MSG");
        boolean bl = isSTS = isTrustMessage != null ? isTrustMessage : false;
        if (isSTS) {
            debug.message("ValidateRequest: This is WS-Trust Request");
            stsConfig = new FAMSTSConfiguration();
        } else {
            config = this.getWSPConfig();
        }
        if (this.isLibertyMessage(soapRequest)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.validateRequest:: Incoming SOAPMessage is of liberty message type.");
            }
            MessageProcessor processor = new MessageProcessor(config);
            try {
                processor.validateRequest(soapRequest, subject, sharedState, request);
                this.removeValidatedHeaders(config, soapRequest);
                return subject;
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.validateRequest:: SOAPBindingException:: ", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        SecureSOAPMessage secureMsg = new SecureSOAPMessage(soapRequest, false);
        secureMsg.parseSecurityHeader(secureMsg.getSecurityHeaderElement());
        if (config != null && (config.isRequestEncryptEnabled() || config.isRequestHeaderEncryptEnabled()) || stsConfig != null && (stsConfig.isRequestEncryptEnabled() || stsConfig.isRequestHeaderEncryptEnabled())) {
            secureMsg.decrypt(config.isRequestEncryptEnabled(), config.isRequestHeaderEncryptEnabled());
            soapRequest = secureMsg.getSOAPMessage();
            secureMsg = new SecureSOAPMessage(soapRequest, false);
            secureMsg.parseSecurityHeader(secureMsg.getSecurityHeaderElement());
        }
        if ((config != null && config.isRequestSignEnabled() || stsConfig != null && stsConfig.isRequestSignEnabled()) && !secureMsg.verifySignature()) {
            debug.error("SOAPRequestHandler.validateRequest:: Signature verification failed.");
            throw new SecurityException(bundle.getString("signatureValidationFailed"));
        }
        SecurityMechanism securityMechanism = secureMsg.getSecurityMechanism();
        String uri = securityMechanism.getURI();
        List list = null;
        if (config != null) {
            list = config.getSecurityMechanisms();
        } else if (stsConfig != null) {
            list = stsConfig.getSecurityMechanisms();
        }
        if (debug.messageEnabled()) {
            debug.message("List of getSecurityMechanisms : " + list);
            debug.message("current uri : " + uri);
        }
        if (!list.contains(uri)) {
            if (!(list.contains("urn:sun:wss:security:null:Anonymous") || list.contains("urn:sun:wss:security:TLS:Anonymous") || list.contains("urn:sun:wss:security:ClientTLS:Anonymous"))) {
                throw new SecurityException(bundle.getString("unsupportedSecurityMechanism"));
            }
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.validateRequest:: provider is not configured for the incoming message  level type but allows anonymous");
            }
            return subject;
        }
        if ("urn:sun:wss:security:null:Anonymous".equals(uri) || "urn:sun:wss:security:TLS:Anonymous".equals(uri) || "urn:sun:wss:security:ClientTLS:Anonymous".equals(uri)) {
            return subject;
        }
        subject = (Subject)SOAPRequestHandler.getAuthenticator().authenticate(subject, secureMsg.getSecurityMechanism(), secureMsg.getSecurityToken(), config, secureMsg, false);
        this.removeValidatedHeaders(config, soapRequest);
        return subject;
    }

    public SOAPMessage secureResponse(SOAPMessage soapMessage, Map sharedState) throws SecurityException {
        boolean isSTS;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.secureResponse: sharedState map : " + sharedState);
            debug.message("SOAPRequestHandler.secureResponse - Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        ProviderConfig config = null;
        FAMSTSConfiguration stsConfig = null;
        Boolean isTrustMessage = (Boolean)sharedState.get("IS_TRUST_MSG");
        boolean bl = isSTS = isTrustMessage != null ? isTrustMessage : false;
        if (isSTS) {
            debug.message("SecureResponse: This is WS-Trust Response");
            stsConfig = new FAMSTSConfiguration();
        } else {
            config = this.getWSPConfig();
        }
        Object req = sharedState.get("LibertyRequest");
        if (req != null) {
            MessageProcessor processor = new MessageProcessor(config);
            try {
                return processor.secureResponse(soapMessage, sharedState);
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.secureResponse:: SOAPBindingException.", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        if (config != null && !config.isResponseSignEnabled() && !config.isResponseEncryptEnabled() || stsConfig != null && !stsConfig.isResponseSignEnabled() && !stsConfig.isResponseEncryptEnabled()) {
            return soapMessage;
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        SecurityTokenFactory factory = SecurityTokenFactory.getInstance(token);
        String keyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        if (config != null && !config.useDefaultKeyStore()) {
            keyAlias = config.getKeyAlias();
        } else if (stsConfig != null) {
            keyAlias = stsConfig.getPrivateKeyAlias();
        }
        String[] certAlias = new String[]{keyAlias};
        X509TokenSpec tokenSpec = new X509TokenSpec(certAlias, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        SecurityToken securityToken = factory.getSecurityToken(tokenSpec);
        SecureSOAPMessage secureMessage = new SecureSOAPMessage(soapMessage, true);
        secureMessage.setSecurityToken(securityToken);
        secureMessage.setSecurityMechanism(SecurityMechanism.WSS_NULL_X509_TOKEN);
        if (config != null && config.isResponseSignEnabled() || stsConfig != null && stsConfig.isResponseSignEnabled()) {
            secureMessage.sign(keyAlias);
        }
        if (config != null && config.isResponseEncryptEnabled() || stsConfig != null && stsConfig.isResponseEncryptEnabled()) {
            secureMessage.encrypt(keyAlias, true, false);
        }
        soapMessage = secureMessage.getSOAPMessage();
        return soapMessage;
    }

    public SOAPMessage secureRequest(SOAPMessage soapMessage, Subject subject, Map sharedState) throws SecurityException {
        ProviderConfig config;
        if (WSSUtils.debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.secureRequest: sharedState map : " + sharedState);
        }
        if ((config = this.getProviderConfig(sharedState)) == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SOAPRequestHandler.secureRequest: Provider configuration from shared map is null");
            }
            config = this.getWSCConfig();
        }
        SecurityToken securityToken = null;
        List secMechs = config.getSecurityMechanisms();
        if (secMechs == null || secMechs.isEmpty()) {
            throw new SecurityException(bundle.getString("securityMechNotConfigured"));
        }
        String sechMech = (String)secMechs.iterator().next();
        SecurityMechanism securityMechanism = SecurityMechanism.getSecurityMechanism(sechMech);
        SecureSOAPMessage secureMessage = null;
        String uri = securityMechanism.getURI();
        if ("urn:sun:wss:security:null:Anonymous".equals(uri) || "urn:sun:wss:security:TLS:Anonymous".equals(uri) || "urn:sun:wss:security:ClientTLS:Anonymous".equals(uri)) {
            secureMessage = new SecureSOAPMessage(soapMessage, true);
        } else {
            if (securityMechanism.isTALookupRequired()) {
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken ssoToken = subjectSecurity.ssoToken;
                if (securityMechanism.getURI().equals("urn:sun:liberty:discovery:security")) {
                    if (subjectSecurity.ssoToken == null) {
                        throw new SecurityException(bundle.getString("invalidSSOToken"));
                    }
                    return this.getSecureMessageFromLiberty(subjectSecurity.ssoToken, subject, soapMessage, sharedState, config);
                }
                try {
                    TrustAuthorityClient client = new TrustAuthorityClient();
                    TrustAuthorityConfig taconfig = config.getTrustAuthorityConfig();
                    String taName = taconfig.getName();
                    if (taName != null) {
                        ThreadLocalService.setServiceName(taName);
                    }
                    securityToken = client.getSecurityToken(config, subjectSecurity.ssoToken);
                }
                catch (FAMSTSException stsEx) {
                    debug.error("SOAPRequestHandler.secureRequest: exceptionin obtaining STS Token", (Throwable)stsEx);
                    throw new SecurityException(stsEx.getMessage());
                }
            } else {
                securityToken = this.getSecurityToken(securityMechanism, config, subject);
            }
            secureMessage = new SecureSOAPMessage(soapMessage, true);
            secureMessage.setSecurityToken(securityToken);
        }
        secureMessage.setSecurityMechanism(securityMechanism);
        String keyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        if (!config.useDefaultKeyStore()) {
            keyAlias = config.getKeyAlias();
        }
        if (config.isRequestSignEnabled()) {
            secureMessage.sign(keyAlias);
        }
        if (config.isRequestEncryptEnabled() || config.isRequestHeaderEncryptEnabled()) {
            secureMessage.encrypt(keyAlias, config.isRequestEncryptEnabled(), config.isRequestHeaderEncryptEnabled());
        }
        soapMessage = secureMessage.getSOAPMessage();
        return soapMessage;
    }

    public void validateResponse(SOAPMessage soapMessage, Map sharedState) throws SecurityException {
        ProviderConfig config;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateResponse: sharedState map : " + sharedState);
            debug.message("SOAPRequestHandler.validateResponse - Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        if ((config = this.getProviderConfig(sharedState)) == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SOAPRequestHandler.validateResponse: Provider configuration from shared map is null");
            }
            config = this.getWSCConfig();
        }
        if (this.isLibertyMessage(soapMessage)) {
            MessageProcessor processor = new MessageProcessor(config);
            try {
                processor.validateResponse(soapMessage, sharedState);
                this.removeValidatedHeaders(config, soapMessage);
                return;
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.validateResponse:: SOAPBindingException. ", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        if (config.isResponseEncryptEnabled() || config.isResponseSignEnabled()) {
            SecureSOAPMessage secureMessage = new SecureSOAPMessage(soapMessage, false);
            if (config.isResponseEncryptEnabled()) {
                secureMessage.decrypt(config.isResponseEncryptEnabled(), false);
                soapMessage = secureMessage.getSOAPMessage();
            }
            secureMessage.parseSecurityHeader(secureMessage.getSecurityHeaderElement());
            if (config.isResponseSignEnabled() && !secureMessage.verifySignature()) {
                debug.error("SOAPRequestHandler.validateResponse:: Signature Verification failed");
                throw new SecurityException(bundle.getString("signatureValidationFailed"));
            }
        }
        this.removeValidatedHeaders(config, soapMessage);
    }

    private void initializeSystemProperties(ProviderConfig config) throws IOException {
        String keyStoreFile = config.getKeyStoreFile();
        String ksPasswd = config.getKeyStoreEncryptedPasswd();
        String keyPasswd = config.getKeyEncryptedPassword();
        String certAlias = config.getKeyAlias();
        if (keyStoreFile == null || ksPasswd == null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.initSystemProperties:: Provider config does not have keystore information. Will fallback to the default configuration in AMConfig.");
            }
            return;
        }
        if (keyStoreFile.indexOf(BACK_SLASH) != -1) {
            keyStoreFile.replaceAll(BACK_SLASH, FORWARD_SLASH);
        }
        int index = keyStoreFile.lastIndexOf(FORWARD_SLASH);
        String storePassFile = keyStoreFile.substring(0, index) + "/.storepassfile";
        String keyPassFile = keyStoreFile.substring(0, index) + "/.keypassfile";
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.initSystemProperties:: \nKeyStoreFile: " + keyStoreFile + "\n" + "Encrypted keystore password: " + ksPasswd + "\n" + "Encrypted key password: " + keyPasswd + "\n" + "Location of the store encrypted password: " + storePassFile + "\n" + "Location of the key encrypted password: " + keyPassFile);
        }
        if (keyPasswd == null) {
            keyPasswd = ksPasswd;
        }
        FileOutputStream out = new FileOutputStream(new File(keyPassFile));
        out.write(keyPasswd.getBytes());
        out.flush();
        FileOutputStream out1 = new FileOutputStream(new File(storePassFile));
        out1.write(ksPasswd.getBytes());
        out1.flush();
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.keystore", (String)keyStoreFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.storepass", (String)storePassFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.keypass", (String)keyPassFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.certalias", (String)certAlias);
    }

    private ProviderConfig getWSPConfig() throws SecurityException {
        ProviderConfig config = null;
        try {
            if (!ProviderConfig.isProviderExists(this.providerName, "WSPAgent")) {
                config = ProviderConfig.getProvider(this.providerName, "WSPAgent", true);
                if (!ProviderConfig.isProviderExists(this.providerName, "WSPAgent")) {
                    this.providerName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.provider.defaultWSP", (String)"wsp");
                    config = ProviderConfig.getProvider(this.providerName, "WSPAgent");
                }
            } else {
                config = ProviderConfig.getProvider(this.providerName, "WSPAgent");
            }
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
        }
        catch (ProviderException pe) {
            debug.error("SOAPRequestHandler.getWSPConfig:: Provider configuration read failure", (Throwable)pe);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        catch (IOException ie) {
            debug.error("SOAPRequestHandler.getWSPConfig:: Provider configuration read failure", (Throwable)ie);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        return config;
    }

    private ProviderConfig getWSCConfig() throws SecurityException {
        ProviderConfig config = null;
        try {
            config = ProviderConfig.getProvider(this.providerName, "WSCAgent");
            if (!ProviderConfig.isProviderExists(this.providerName, "WSCAgent")) {
                this.providerName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.provider.defaultWSC", (String)"wsc");
                config = ProviderConfig.getProvider(this.providerName, "WSCAgent");
            }
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
        }
        catch (ProviderException pe) {
            debug.error("SOAPRequestHandler.getWSCConfig:: Provider configuration read failure", (Throwable)pe);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        catch (IOException ie) {
            debug.error("SOAPRequestHandler.getWSCConfig:: Provider configuration read failure", (Throwable)ie);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        return config;
    }

    private SecurityToken getSecurityToken(SecurityMechanism secMech, ProviderConfig config, Subject subject) throws SecurityException {
        String uri = secMech.getURI();
        String certAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        if (!config.useDefaultKeyStore()) {
            certAlias = config.getKeyAlias();
        }
        SecurityToken securityToken = null;
        if (debug.messageEnabled()) {
            debug.message("getSecurityToken: SecurityMechanism URI : " + uri);
        }
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        SecurityTokenFactory factory = SecurityTokenFactory.getInstance(token);
        if ("urn:sun:wss:security:null:X509Token".equals(uri) || "urn:sun:wss:security:TLS:X509Token".equals(uri) || "urn:sun:wss:security:ClientTLS:X509Token".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating X509 token");
            }
            String[] aliases = new String[]{certAlias};
            X509TokenSpec tokenSpec = new X509TokenSpec(aliases, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating SAML token");
            }
            NameIdentifier ni = null;
            try {
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken userToken = subjectSecurity.ssoToken;
                ni = userToken != null ? new NameIdentifier(userToken.getPrincipal().getName()) : new NameIdentifier(config.getProviderName());
            }
            catch (Exception ex) {
                throw new SecurityException(ex.getMessage());
            }
            AssertionTokenSpec tokenSpec = new AssertionTokenSpec(ni, secMech, certAlias);
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:UserNameToken".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken".equals(uri) || "urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
            List creds;
            block26: {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getSecurityToken:: creating UserName token");
                }
                creds = null;
                try {
                    SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                    creds = subjectSecurity.userCredentials;
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block26;
                    debug.message("SOAPRequestHandler.getSecurityToken:: getSubjectSecurity error :" + ex.getMessage());
                }
            }
            if (creds == null || creds.isEmpty()) {
                creds = config.getUsers();
            }
            if (creds == null || creds.isEmpty()) {
                debug.error("SOAPRequestHandler.getSecurityToken:: No users  are configured.");
                throw new SecurityException(bundle.getString("nousers"));
            }
            PasswordCredential credential = (PasswordCredential)creds.iterator().next();
            UserNameTokenSpec tokenSpec = new UserNameTokenSpec();
            if ("urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
                tokenSpec.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            } else {
                tokenSpec.setNonce(true);
                tokenSpec.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            }
            tokenSpec.setCreateTimeStamp(true);
            tokenSpec.setUserName(credential.getUserName());
            tokenSpec.setPassword(credential.getPassword());
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating SAML2 token");
            }
            NameID ni = null;
            try {
                AssertionFactory assertionFactory = AssertionFactory.getInstance();
                ni = assertionFactory.createNameID();
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken userToken = subjectSecurity.ssoToken;
                if (userToken != null) {
                    ni.setValue(userToken.getPrincipal().getName());
                } else {
                    ni.setValue(config.getProviderName());
                }
            }
            catch (Exception ex) {
                throw new SecurityException(ex.getMessage());
            }
            SAML2TokenSpec tokenSpec = new SAML2TokenSpec(ni, secMech, certAlias);
            securityToken = factory.getSecurityToken(tokenSpec);
        } else {
            throw new SecurityException(bundle.getString("unsupportedSecurityMechanism"));
        }
        return securityToken;
    }

    private SubjectSecurity getSubjectSecurity(Subject subject) {
        final SubjectSecurity subjectSecurity = new SubjectSecurity();
        final Subject sub = subject;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Object> creds = sub.getPrivateCredentials();
                if (creds == null || creds.isEmpty()) {
                    return null;
                }
                for (Object credObj : creds) {
                    List list;
                    if (credObj instanceof SSOToken) {
                        subjectSecurity.ssoToken = (SSOToken)credObj;
                        continue;
                    }
                    if (credObj instanceof ResourceOffering) {
                        subjectSecurity.discoRO = (ResourceOffering)credObj;
                        continue;
                    }
                    if (!(credObj instanceof List) || (list = (List)credObj) == null || list.size() <= 0) continue;
                    if (list.get(0) instanceof SecurityAssertion) {
                        subjectSecurity.discoCredentials = list;
                        continue;
                    }
                    if (!(list.get(0) instanceof PasswordCredential)) continue;
                    subjectSecurity.userCredentials = list;
                }
                return null;
            }
        });
        return subjectSecurity;
    }

    public static MessageAuthenticator getAuthenticator() throws SecurityException {
        if (authenticator != null) {
            return authenticator;
        }
        String classImpl = SystemConfigurationUtil.getProperty((String)WSS_AUTHENTICATOR, (String)"com.sun.identity.wss.security.handler.DefaultAuthenticator");
        try {
            Class<?> authnClass = Class.forName(classImpl);
            authenticator = (MessageAuthenticator)authnClass.newInstance();
        }
        catch (Exception ex) {
            debug.error("SOAPRequestHandler.getAuthenticator:: Unable to get the authenticator", (Throwable)ex);
            throw new SecurityException(bundle.getString("authenticatorNotFound"));
        }
        return authenticator;
    }

    private SOAPMessage getSecureMessageFromLiberty(SSOToken ssoToken, Subject subject, SOAPMessage soapMessage, Map sharedData, ProviderConfig providerConfig) throws SecurityException {
        try {
            SSOTokenManager.getInstance().validateToken(ssoToken);
            ResourceOffering discoRO = this.getDiscoveryResourceOffering(subject, ssoToken);
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecureMessageFromLiberty:: Discovery service resource offering. " + discoRO.toString());
            }
            List credentials = this.getDiscoveryCredentials(subject);
            MessageProcessor processor = new MessageProcessor(providerConfig);
            return processor.secureRequest(discoRO, credentials, providerConfig.getServiceType(), soapMessage, sharedData);
        }
        catch (SSOException se) {
            debug.error("SOAPRequestHandler.getSecureMessageFromLiberty:: Invalid sso token", (Throwable)se);
            throw new SecurityException(bundle.getString("invalidSSOToken"));
        }
        catch (SOAPBindingException sbe) {
            debug.error("SOAPRequestHandler.getSecureMessageFromLiberty::  SOAPBinding exception", (Throwable)sbe);
            throw new SecurityException(sbe.getMessage());
        }
    }

    private ResourceOffering getDiscoveryResourceOffering(Subject subject, SSOToken ssoToken) throws SecurityException {
        SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
        if (subjectSecurity.discoRO != null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getDiscoveryResourceOffering:: subject contains resource offering.");
            }
            return subjectSecurity.discoRO;
        }
        SASLResponse saslResponse = this.getSASLResponse(ssoToken);
        if (saslResponse == null) {
            debug.error("SOAPRequestHandler.getDiscoveryResourceOffering:: SASL Response is null");
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
        final ResourceOffering discoRO = saslResponse.getResourceOffering();
        if (discoRO == null) {
            throw new SecurityException(bundle.getString("resourceOfferingMissing"));
        }
        final List credentials = saslResponse.getCredentials();
        final Subject sub = subject;
        if (discoRO != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sub.getPrivateCredentials().add(discoRO);
                    if (credentials != null) {
                        sub.getPrivateCredentials().add(credentials);
                    }
                    return null;
                }
            });
        }
        return discoRO;
    }

    private List getDiscoveryCredentials(Subject subject) {
        SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
        return subjectSecurity.discoCredentials;
    }

    private SASLResponse getSASLResponse(SSOToken ssoToken) throws SecurityException {
        SASLRequest saslReq = new SASLRequest(MECHANISM_SSOTOKEN);
        try {
            String authURL = SystemConfigurationUtil.getProperty((String)LIBERTY_AUTHN_URL);
            if (authURL == null) {
                debug.error("SOAPRequestHandler.getSASLResponse:: AuthnURL  not present in the configuration.");
                throw new SecurityException(bundle.getString("authnURLMissing"));
            }
            SASLResponse saslResp = AuthnSvcClient.sendRequest((SASLRequest)saslReq, (String)authURL);
            if (!saslResp.getStatusCode().equals("continue")) {
                debug.error("SOAPRequestHandler.getSASLResponse:: ABORT");
                throw new SecurityException(bundle.getString("SASLFailure"));
            }
            String serverMechanism = saslResp.getServerMechanism();
            saslReq = new SASLRequest(serverMechanism);
            saslReq.setData(ssoToken.getTokenID().toString().getBytes("UTF-8"));
            saslReq.setRefToMessageID(saslResp.getMessageID());
            saslResp = AuthnSvcClient.sendRequest((SASLRequest)saslReq, (String)authURL);
            if (!saslResp.getStatusCode().equals("OK")) {
                debug.error("SOAPRequestHandler.getSASLResponse:: SASL Failure");
                throw new SecurityException(bundle.getString("SASLFailure"));
            }
            return saslResp;
        }
        catch (AuthnSvcException ae) {
            debug.error("SOAPRequestHandler.getSASLResponse:: Exception", (Throwable)ae);
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
        catch (UnsupportedEncodingException uae) {
            debug.error("SOAPRequestHandler.getSASLResponse:: Exception", (Throwable)uae);
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
    }

    private boolean isLibertyMessage(SOAPMessage soapMessage) throws SecurityException {
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (soapHeader == null) {
                return false;
            }
            NodeList headerChildNodes = soapHeader.getChildNodes();
            if (headerChildNodes == null || headerChildNodes.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1 || !"Correlation".equals(currentNode.getLocalName()) || !"urn:liberty:sb:2003-08".equals(currentNode.getNamespaceURI())) continue;
                return true;
            }
            return false;
        }
        catch (SOAPException se) {
            debug.error("SOAPRequest.isLibertyRequest:: SOAPException", (Throwable)se);
            throw new SecurityException(se.getMessage());
        }
    }

    private ProviderConfig getProviderConfig(Map sharedMap) {
        if (sharedMap == null || sharedMap.isEmpty()) {
            return null;
        }
        try {
            String serviceName = ThreadLocalService.getServiceName();
            if (serviceName == null) {
                serviceName = this.getServiceName(sharedMap);
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getServiceName: Service Name from javax.xml.ws.wsdl.service : " + serviceName);
                }
            } else {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getProviderConfig: Service Name found in thread local" + serviceName);
                }
                ThreadLocalService.removeServiceName(serviceName);
                STSConfig stsConfig = (STSConfig)TrustAuthorityConfig.getConfig(serviceName, "STSAgent");
                ProviderConfig pc = ProviderConfig.getProvider(serviceName, "WSCAgent");
                pc.setSecurityMechanisms(stsConfig.getSecurityMech());
                pc.setRequestSignEnabled(stsConfig.isRequestSignEnabled());
                pc.setRequestEncryptEnabled(stsConfig.isRequestEncryptEnabled());
                pc.setDefaultKeyStore(true);
                pc.setUsers(stsConfig.getUsers());
                return pc;
            }
            if (!ProviderConfig.isProviderExists(serviceName, "WSCAgent")) {
                return null;
            }
            ProviderConfig config = ProviderConfig.getProvider(serviceName, "WSCAgent");
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
            return config;
        }
        catch (ProviderException pe) {
            WSSUtils.debug.error("SOAPRequestHandler.getProviderConfig: fromshared map: Exception", (Throwable)pe);
            return null;
        }
        catch (IOException ie) {
            WSSUtils.debug.error("SOAPRequestHandler.getProviderConfig: fromshared map: IOException", (Throwable)ie);
            return null;
        }
    }

    private String getServiceName(Map sharedMap) {
        if (sharedMap == null || sharedMap.isEmpty()) {
            return null;
        }
        QName service = (QName)sharedMap.get("javax.xml.ws.wsdl.service");
        if (service == null) {
            return null;
        }
        return service.getLocalPart();
    }

    public String print(Node node) {
        return WSSUtils.print(node);
    }

    private void removeValidatedHeaders(ProviderConfig config, SOAPMessage soapMessage) {
        SOAPHeader header = null;
        try {
            header = soapMessage.getSOAPPart().getEnvelope().getHeader();
        }
        catch (SOAPException se) {
            WSSUtils.debug.error("SOAPRequestHandler.removeValidateHeaders: Failed to read the SOAP Header.");
        }
        if (header != null) {
            Iterator iter = header.examineAllHeaderElements();
            while (iter.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)iter.next();
                if ((config == null || !config.preserveSecurityHeader()) && "Security".equalsIgnoreCase(headerElement.getElementName().getLocalName())) {
                    headerElement.detachNode();
                }
                if (!"Correlation".equalsIgnoreCase(headerElement.getElementName().getLocalName())) continue;
                headerElement.detachNode();
            }
        }
    }

    private class SubjectSecurity {
        SSOToken ssoToken = null;
        ResourceOffering discoRO = null;
        List discoCredentials = null;
        List userCredentials = null;

        private SubjectSecurity() {
        }
    }
}

