/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.sts.ClientUserToken;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.STSClientConfiguration;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import org.w3c.dom.Element;

public class TrustAuthorityClientImpl {
    private static Debug debug = STSUtils.debug;
    private static Class clientTokenClass;

    public Element getSTSTokenElement(String wspEndPoint, String stsEndpoint, String stsMexAddress, Object ssoToken) throws FAMSTSException {
        STSClientConfiguration config = new STSClientConfiguration(stsEndpoint, stsMexAddress);
        if (ssoToken != null) {
            config.setOBOToken(TrustAuthorityClientImpl.getClientUserToken(ssoToken));
        }
        try {
            IssuedTokenManager manager = IssuedTokenManager.getInstance();
            IssuedTokenContext ctx = manager.createIssuedTokenContext((IssuedTokenConfiguration)config, wspEndPoint);
            manager.getIssuedToken(ctx);
            Token issuedToken = ctx.getSecurityToken();
            Element element = (Element)issuedToken.getTokenValue();
            return element;
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityClientImpl.getSTSToken:: Failed inobtainining STS Token Element: ", (Throwable)ex);
            throw new FAMSTSException("TrustAuthorityClientImpl:ws trust exception");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static Token getClientUserToken(Object ssoTokenObj) throws FAMSTSException {
        if (clientTokenClass == null) {
            String className = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.sts.clientusertoken", (String)"com.sun.identity.wss.sts.STSClientUserToken");
            try {
                clientTokenClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityClientImpl.getClientUserToken:Failed in obtaining class", (Throwable)ex);
                throw new FAMSTSException("initializationFailed");
            }
        }
        try {
            ClientUserToken userToken = (ClientUserToken)clientTokenClass.newInstance();
            userToken.init(ssoTokenObj);
            if (debug.messageEnabled()) {
                debug.message("TrustAuthorityClientImpl:getClientUserToken: Client User Token : " + userToken);
            }
            return userToken;
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityClientImpl.getClientUserToken: Failed in initialization", (Throwable)ex);
            throw new FAMSTSException("initializationFailed");
        }
    }
}

