/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.impl.FMSessionProvider;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.Subject;
import com.sun.identity.xacml.spi.SubjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FMSubjectMapper
implements SubjectMapper {
    FMSessionProvider fmSessionProvider = new FMSessionProvider();

    public void initialize(String pdpEntityId, String pepEntityId, Map properties) throws XACMLException {
    }

    public Object mapToNativeSubject(List xacmlContextSubjects) throws XACMLException {
        SSOToken ssoToken;
        block11: {
            String userName;
            block10: {
                if (xacmlContextSubjects == null) {
                    return null;
                }
                String sid = null;
                userName = null;
                Iterator iter = xacmlContextSubjects.iterator();
                while (iter.hasNext()) {
                    List attributes;
                    URI subjectCategory;
                    Subject subject = (Subject)iter.next();
                    if (subject == null || (subjectCategory = subject.getSubjectCategory()) != null && !subjectCategory.toString().equals(XACMLConstants.ACCESS_SUBJECT) || (attributes = subject.getAttributes()) == null) continue;
                    for (int count = 0; count < attributes.size(); ++count) {
                        Element sidElement;
                        URI tmpURI;
                        Attribute attr = (Attribute)attributes.get(count);
                        if (attr == null || !(tmpURI = attr.getAttributeId()).toString().equals(XACMLConstants.SUBJECT_ID)) continue;
                        tmpURI = attr.getDataType();
                        if (tmpURI.toString().equals(XACMLConstants.OPENSSO_SESSION_ID)) {
                            sidElement = (Element)attr.getAttributeValues().get(0);
                            sid = XMLUtils.getElementValue((Element)sidElement);
                            continue;
                        }
                        if (!tmpURI.toString().equals(XACMLConstants.X500NAME)) continue;
                        sidElement = (Element)attr.getAttributeValues().get(0);
                        userName = XMLUtils.getElementValue((Element)sidElement);
                    }
                }
                ssoToken = null;
                if (sid != null) {
                    try {
                        SSOTokenManager tokenManager = SSOTokenManager.getInstance();
                        ssoToken = tokenManager.createSSOToken(sid);
                    }
                    catch (SSOException ssoExp) {
                        if (!XACMLSDKUtils.debug.messageEnabled()) break block10;
                        XACMLSDKUtils.debug.message("FMSubjectMapper.mapToNativeSubject():caught SSOException:", (Throwable)ssoExp);
                    }
                }
            }
            if (ssoToken == null && userName != null) {
                try {
                    ssoToken = this.createFMSession(userName);
                }
                catch (SessionException se) {
                    if (!XACMLSDKUtils.debug.messageEnabled()) break block11;
                    XACMLSDKUtils.debug.message("FMSubjectMapper.mapToNativeSubject():caught SessionException:", (Throwable)se);
                }
            }
        }
        return ssoToken;
    }

    private SSOToken createFMSession(String userName) throws SessionException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("realm", "/");
        info.put("principalName", userName);
        SSOToken ssoToken = (SSOToken)this.fmSessionProvider.createSession(info, null, null, null);
        return ssoToken;
    }
}

