/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.obl.Obligation;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseActionType;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntryType;
import edu.umd.cs.findbugs.util.ExactStringMatcher;
import edu.umd.cs.findbugs.util.StringMatcher;
import edu.umd.cs.findbugs.util.SubtypeTypeMatcher;
import edu.umd.cs.findbugs.util.TypeMatcher;
import java.util.Collection;
import org.apache.bcel.generic.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchMethodEntry
implements ObligationPolicyDatabaseEntry {
    private final TypeMatcher receiverType;
    private final StringMatcher methodName;
    private final StringMatcher signature;
    private final boolean isStatic;
    private final ObligationPolicyDatabaseActionType action;
    private final Obligation obligation;
    private final ObligationPolicyDatabaseEntryType entryType;

    public MatchMethodEntry(XMethod xmethod, ObligationPolicyDatabaseActionType action, Obligation obligation, ObligationPolicyDatabaseEntryType entryType) {
        this(new SubtypeTypeMatcher(xmethod.getClassDescriptor()), new ExactStringMatcher(xmethod.getName()), new ExactStringMatcher(xmethod.getSignature()), xmethod.isStatic(), action, obligation, entryType);
    }

    public MatchMethodEntry(TypeMatcher receiverType, StringMatcher methodName, StringMatcher signature, boolean isStatic, ObligationPolicyDatabaseActionType action, Obligation obligation, ObligationPolicyDatabaseEntryType entryType) {
        this.receiverType = receiverType;
        this.methodName = methodName;
        this.signature = signature;
        this.isStatic = isStatic;
        this.action = action;
        this.obligation = obligation;
        this.entryType = entryType;
    }

    @Override
    public ObligationPolicyDatabaseEntryType getEntryType() {
        return this.entryType;
    }

    @Override
    public boolean getActions(ReferenceType receiverType, String methodName, String signature, boolean isStatic, Collection<ObligationPolicyDatabaseAction> actionList) {
        if (this.methodName.matches(methodName) && this.signature.matches(signature) && this.isStatic == isStatic && this.receiverType.matches(receiverType)) {
            actionList.add(new ObligationPolicyDatabaseAction(this.action, this.obligation));
            return true;
        }
        return false;
    }

    public String toString() {
        return "(" + this.receiverType + "," + this.methodName + "," + this.signature + "," + this.isStatic + "," + (Object)((Object)this.action) + "," + this.obligation + "," + (Object)((Object)this.entryType) + ")";
    }
}

