/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAttributeList {
    private List<NameValuePair> nameValuePairList = new LinkedList<NameValuePair>();

    public XMLAttributeList addAttribute(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name must be nonnull");
        }
        if (value == null) {
            throw new NullPointerException("value must be nonnull");
        }
        this.nameValuePairList.add(new NameValuePair(name, value));
        return this;
    }

    public XMLAttributeList addOptionalAttribute(@NonNull String name, @CheckForNull String value) {
        if (value == null) {
            return this;
        }
        return this.addAttribute(name, value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (NameValuePair pair : this.nameValuePairList) {
            buf.append(' ');
            buf.append(pair.getName());
            buf.append('=');
            buf.append('\"');
            buf.append(XMLAttributeList.getQuotedAttributeValue(pair.getValue()));
            buf.append('\"');
        }
        return buf.toString();
    }

    public Iterator<NameValuePair> iterator() {
        return this.nameValuePairList.iterator();
    }

    public static String getQuotedAttributeValue(@NonNull String rawValue) {
        return StringEscapeUtils.escapeXml((String)rawValue);
    }

    public static class NameValuePair {
        private String name;
        private String value;

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

