/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMGroupImpl;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.util.DN;

class AMDynamicGroupImpl
extends AMGroupImpl
implements AMDynamicGroup {
    public AMDynamicGroupImpl(SSOToken ssoToken, String dn) {
        super(ssoToken, dn, 11);
    }

    public String getFilter() throws AMException, SSOException {
        String[] array = this.dsServices.getGroupFilterAndScope(this.token, this.entryDN, this.profileType);
        return array[2];
    }

    public void setFilter(String filter) throws AMException, SSOException {
        this.dsServices.setGroupFilter(this.token, this.entryDN, filter);
        this.setACI();
    }

    private void setACI() {
        try {
            DN thisDN = new DN(this.entryDN);
            String orgDN = this.getOrganizationDN();
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + thisDN.toString().replace(',', '_') + "," + orgDN;
            AMStoreConnection amsc = new AMStoreConnection(this.token);
            AMRole gRole = amsc.getRole(roleDN);
            Set aciValue = null;
            aciValue = gRole.getAttribute("iplanet-am-role-aci-list");
            Iterator iter = aciValue.iterator();
            HashSet<String> newACIValue = new HashSet<String>();
            while (iter.hasNext()) {
                String aci = (String)iter.next();
                int indx = aci.indexOf("iplanet-am-static-group-dn=");
                if (indx < 0) {
                    newACIValue.add(aci);
                    continue;
                }
                String targetFilter = aci.substring(0, indx);
                String restACI = aci.substring(aci.indexOf("(|(nsroledn"));
                StringBuffer sb = new StringBuffer();
                sb.append(targetFilter).append("iplanet-am-static-group-dn=*").append(this.entryDN).append(")").append(this.getFilter()).append("))").append(restACI);
                newACIValue.add(sb.toString());
            }
            HashMap<String, HashSet<String>> avPairs = new HashMap<String, HashSet<String>>(1);
            avPairs.put("iplanet-am-role-aci-list", newACIValue);
            try {
                gRole.setAttributes(avPairs);
                gRole.store();
            }
            catch (AMException ame) {
                if (debug.warningEnabled()) {
                    debug.warning("error setting attribute ", (Throwable)ame);
                }
            }
            catch (SSOException soe) {
                debug.error("Error in SSO Token");
            }
        }
        catch (AMException amex) {
            if (debug.warningEnabled()) {
                debug.warning("Could not set aci " + amex);
            }
        }
        catch (SSOException soe) {
            debug.error("Error in SSO Token" + (Object)((Object)soe));
        }
    }
}

