/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMCompliance;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMCrypt;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMEvent;
import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrgTemplateImpl;
import com.iplanet.am.sdk.AMOrganizationImpl;
import com.iplanet.am.sdk.AMPeopleContainerImpl;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMRoleImpl;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMSSOTokenListener;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchFilterManager;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMTemplateImpl;
import com.iplanet.am.sdk.AMUserImpl;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.SearchControl;
import com.sun.identity.common.DNUtils;
import com.sun.identity.common.admin.DisplayOptionsUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import netscape.ldap.LDAPUrl;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class AMObjectImpl
implements AMObject {
    private static final String POLICY_ADMIN_ROLE_NAME = "Organization Policy Admin Role";
    private static final String POLICY_ADMIN_ROLE_PERMISSION = "Organization Policy Admin";
    private static final String ROLE_DISPLAY_ATTR = "iplanet-am-role-display-options";
    private static Map objImplListeners = new HashMap();
    protected static Hashtable profileNameTable = new Hashtable();
    protected static Debug debug = AMCommonUtils.debug;
    protected IDirectoryServices dsServices;
    protected SSOToken token;
    protected String entryDN;
    protected String rfcDN = null;
    protected String locale = "en_US";
    protected int profileType;
    private AMHashMap byteValueModMap;
    private AMHashMap stringValueModMap;
    private Set listeners = new HashSet();
    private String organizationDN = null;
    private boolean isRegistered = false;

    AMObjectImpl(SSOToken ssoToken, String dn, int type) {
        this.entryDN = dn;
        this.rfcDN = DNUtils.normalizeDN(this.entryDN);
        this.token = ssoToken;
        this.profileType = type;
        this.dsServices = AMDirectoryAccessFactory.getDirectoryServices();
        this.stringValueModMap = new AMHashMap(false);
        this.byteValueModMap = new AMHashMap(true);
        this.locale = AMCommonUtils.getUserLocale(this.token);
    }

    public Set getAssignedServices() throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        HashSet<String> result = new HashSet<String>(1);
        Set objectClasses = this.getAttribute("objectclass");
        String parentOrgDN = this.getOrganizationDN();
        AMOrganizationImpl parentOrg = new AMOrganizationImpl(this.token, parentOrgDN);
        Set serviceNames = parentOrg.getRegisteredServiceNames();
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            HashSet<String> tmpService = new HashSet<String>(1);
            tmpService.add(serviceName);
            Set serviceOCs = AMServiceUtils.getServiceObjectClasses(this.token, tmpService);
            if (serviceOCs.isEmpty()) continue;
            boolean serviceAssigned = true;
            Iterator iter2 = serviceOCs.iterator();
            while (iter2.hasNext()) {
                String oc = (String)iter2.next();
                if (AMCommonUtils.isObjectClassPresent(objectClasses, oc)) continue;
                serviceAssigned = false;
                break;
            }
            if (!serviceAssigned) continue;
            result.add(serviceName);
        }
        return result;
    }

    public void setAttribute(String attributeName, Set attributeValue) throws AMException, SSOException {
        Set copyValue = AMCommonUtils.getSetCopy(attributeValue);
        this.stringValueModMap.put(attributeName, copyValue);
    }

    public Set getAttribute(String attributeName) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> attrName = new HashSet<String>(1);
        attrName.add(attributeName);
        Map attributes = this.dsServices.getAttributes(this.token, this.entryDN, attrName, this.profileType);
        Set values = (Set)attributes.get(attributeName);
        return values != null ? values : new HashSet();
    }

    public void setAttributeByteArray(String attrName, byte[][] byteValues) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.byteValueModMap.put(attrName, byteValues);
    }

    public byte[][] getAttributeByteArray(String attributeName) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> attrName = new HashSet<String>(1);
        attrName.add(attributeName);
        Map attributes = this.dsServices.getAttributesByteValues(this.token, this.entryDN, attrName, this.profileType);
        byte[][] values = (byte[][])attributes.get(attributeName);
        return values;
    }

    public void setAttributes(Map attributes) throws AMException, SSOException {
        this.stringValueModMap.copy(attributes);
    }

    public Map getAttributes() throws AMException, SSOException {
        return this.getAttributes(null);
    }

    public Map getAttributes(Set attributeNames) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map attributes = this.dsServices.getAttributes(this.token, this.entryDN, attributeNames, this.profileType);
        attributes = this.replaceMapKey(attributes, attributeNames);
        return attributes;
    }

    public Map getAttributesFromDataStore() throws AMException, SSOException {
        return this.getAttributesFromDataStore(null);
    }

    public Map getAttributesFromDataStore(Set attributeNames) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map attributes = this.dsServices.getAttributesFromDS(this.token, this.entryDN, attributeNames, this.profileType);
        attributes = this.replaceMapKey(attributes, attributeNames);
        return attributes;
    }

    public void setAttributesByteArray(Map attributes) throws SSOException, AMException {
        SSOTokenManager.getInstance().validateToken(this.token);
        this.byteValueModMap.copy(attributes);
    }

    public Map getAttributesByteArray() throws AMException, SSOException {
        return this.getAttributesByteArray(null);
    }

    public Map getAttributesByteArray(Set attributeNames) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        Map attributes = this.dsServices.getAttributesByteValues(this.token, this.entryDN, attributeNames, this.profileType);
        attributes = this.replaceMapKey(attributes, attributeNames);
        return attributes;
    }

    public void setBooleanAttribute(String attributeName, boolean value) throws AMException, SSOException {
        if (value) {
            this.setStringAttribute(attributeName, "true");
        } else {
            this.setStringAttribute(attributeName, "false");
        }
    }

    public boolean getBooleanAttribute(String attributeName) throws AMException, SSOException {
        Set attributeValue = this.getAttribute(attributeName);
        if (attributeValue.size() == 1) {
            String str = (String)attributeValue.iterator().next();
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            throw new AMException(AMSDKBundle.getString("154", this.locale), "154");
        }
        if (attributeValue.size() == 0) {
            throw new AMException(AMSDKBundle.getString("155", this.locale), "155");
        }
        throw new AMException(AMSDKBundle.getString("154", this.locale), "154");
    }

    public String getDN() {
        return this.entryDN;
    }

    public boolean isExists() throws SSOException {
        if (this.rfcDN == null) {
            return false;
        }
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.isExists(): DN=" + this.entryDN);
        }
        return this.dsServices.doesEntryExists(this.token, this.entryDN);
    }

    public void setIntegerAttribute(String attributeName, int value) throws AMException, SSOException {
        this.setStringAttribute(attributeName, "" + value);
    }

    public int getIntegerAttribute(String attributeName) throws AMException, SSOException {
        Set attributeValue = this.getAttribute(attributeName);
        if (attributeValue.size() == 1) {
            try {
                String str = (String)attributeValue.iterator().next();
                return Integer.parseInt(str);
            }
            catch (NumberFormatException nfex) {
                throw new AMException(AMSDKBundle.getString("152", this.locale), "152");
            }
        }
        if (attributeValue.size() == 0) {
            throw new AMException(AMSDKBundle.getString("153", this.locale), "153");
        }
        throw new AMException(AMSDKBundle.getString("152", this.locale), "152");
    }

    public String getOrganizationDN() throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.organizationDN == null) {
            String startDN = this.entryDN;
            if (this.profileType == 1) {
                startDN = this.getParentDN();
            }
            this.organizationDN = this.dsServices.getOrganizationDN(this.token, startDN);
        }
        return this.organizationDN;
    }

    public String getParentDN() {
        if (this.entryDN.equalsIgnoreCase(AMStoreConnection.getAMSdkBaseDN())) {
            return null;
        }
        return new DN(this.entryDN).getParent().toString();
    }

    public Map getPolicy(String serviceName) throws UnsupportedOperationException, AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getPolicy(" + serviceName + "): DN=" + this.entryDN);
        }
        try {
            Set serviceAttributeNames = AMServiceUtils.getServiceAttributeNames(this.token, serviceName, SchemaType.POLICY);
            Map map = this.getAttributes(serviceAttributeNames);
            return map;
        }
        catch (SMSException smsex) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.getPolicy(" + serviceName + ")", (Throwable)smsex);
            }
            throw new AMException(AMSDKBundle.getString("498", this.locale), "498");
        }
    }

    public AMTemplate getPolicyTemplate(String serviceName) throws UnsupportedOperationException, AMException, SSOException {
        return this.getTemplate(serviceName, 300);
    }

    public Map getServiceAttributes(String serviceName) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getServiceAttributes(" + serviceName + "): DN=" + this.entryDN);
        }
        try {
            Set serviceAttributeNames = AMServiceUtils.getServiceAttributeNames(this.token, serviceName, SchemaType.DYNAMIC);
            Set set = AMServiceUtils.getServiceAttributeNames(this.token, serviceName, SchemaType.GLOBAL);
            if (!set.isEmpty()) {
                if (serviceAttributeNames.size() == 0) {
                    serviceAttributeNames = set;
                } else {
                    serviceAttributeNames.addAll(set);
                }
            }
            if (!(set = AMServiceUtils.getServiceAttributeNames(this.token, serviceName, SchemaType.USER)).isEmpty()) {
                if (serviceAttributeNames.size() == 0) {
                    serviceAttributeNames = set;
                } else {
                    serviceAttributeNames.addAll(set);
                }
            }
            return this.getAttributes(serviceAttributeNames);
        }
        catch (SMSException smsex) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.getServiceAttributes(" + serviceName + ")", (Throwable)smsex);
            }
            throw new AMException(AMSDKBundle.getString("915", this.locale), "915");
        }
    }

    public void setServiceStatus(String sname, String status) throws AMException, SSOException {
        String stAttributeName = null;
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        Set assignedServices = this.getAssignedServices();
        if (!assignedServices.contains(sname)) {
            throw new AMException(AMSDKBundle.getString("126", this.locale), "126");
        }
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(sname, this.token);
            ServiceSchema ss = null;
            if (this.profileType == 1) {
                ss = ssm.getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                ss = ssm.getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                ss = ssm.getSchema(SchemaType.GROUP);
            }
            stAttributeName = ss.getStatusAttribute();
        }
        catch (SMSException se) {
            debug.error("AMObjectImpl.setServiceStatus: SMSException: ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("908", this.locale), "908");
        }
        HashSet<String> attrVal = new HashSet<String>();
        attrVal.add(status);
        if (stAttributeName == null) {
            throw new AMException(AMSDKBundle.getString("705", this.locale), "705");
        }
        this.setAttribute(stAttributeName, attrVal);
        this.store();
    }

    public String getServiceStatus(String serviceName) throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        String stAttributeName = null;
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(serviceName, this.token);
            ServiceSchema ss = null;
            if (this.profileType == 1) {
                ss = ssm.getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                ss = ssm.getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                ss = ssm.getSchema(SchemaType.GROUP);
            }
            if (ss != null) {
                stAttributeName = ss.getStatusAttribute();
            }
        }
        catch (SMSException se) {
            debug.error("AMObjectImpl.getServiceStatus: SMSException: ", (Throwable)se);
            throw new AMException(AMSDKBundle.getString("908", this.locale), "908");
        }
        if (stAttributeName != null) {
            Set res = this.getAttribute(stAttributeName);
            if (res == null || res.isEmpty()) {
                return null;
            }
            Iterator it = res.iterator();
            return (String)it.next();
        }
        return null;
    }

    public void setStringAttribute(String attributeName, String value) throws AMException, SSOException {
        HashSet<String> attrValue = new HashSet<String>(1);
        attrValue.add(value);
        this.stringValueModMap.put(attributeName, attrValue);
    }

    public String getStringAttribute(String attributeName) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        HashSet<String> attrName = new HashSet<String>(1);
        attrName.add(attributeName);
        Map attributes = this.dsServices.getAttributes(this.token, this.entryDN, attrName, this.profileType);
        Set values = (Set)attributes.get(attributeName);
        if (values != null && values.size() == 1) {
            return (String)values.iterator().next();
        }
        if (values == null || values.isEmpty()) {
            return "";
        }
        throw new AMException(AMSDKBundle.getString("150", this.locale), "150");
    }

    public AMTemplate getTemplate(String serviceName, int templateType) throws UnsupportedOperationException, AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.profileType != 2 && this.profileType != 6 && this.profileType != 3 && this.profileType != 8) {
            throw new UnsupportedOperationException();
        }
        if (templateType == 302) {
            if (this.profileType != 3 && this.profileType != 2) {
                throw new UnsupportedOperationException();
            }
            ServiceConfig sc = AMServiceUtils.getOrgConfig(this.token, this.rfcDN, serviceName);
            if (sc == null) {
                Object[] args = new Object[]{serviceName};
                throw new AMException(AMSDKBundle.getString("480", args, this.locale), "480", args);
            }
            return new AMOrgTemplateImpl(this.token, sc.getDN(), serviceName, sc, this.rfcDN);
        }
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.getTemplate(" + serviceName + ", " + templateType + "): DN=" + this.entryDN);
        }
        String templateDN = this.dsServices.getAMTemplateDN(this.token, this.rfcDN, this.profileType, serviceName, templateType);
        return new AMTemplateImpl(this.token, templateDN, serviceName, templateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(AMEventListener listener) throws SSOException {
        Object object;
        SSOTokenManager.getInstance().validateToken(this.token);
        if (!this.isRegistered) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.addEventListener(..): registering this instance to obj*Impl table");
            }
            try {
                AMObjectImpl.addToProfileNameTable(this.token, this.entryDN);
            }
            catch (SSOException se) {
                debug.message("AMObjectImpl.addEventListener(): " + se.toString());
                throw se;
            }
            object = objImplListeners;
            synchronized (object) {
                HashSet<AMObjectImpl> destObjs = (HashSet<AMObjectImpl>)objImplListeners.get(this.entryDN.toLowerCase());
                if (destObjs == null) {
                    destObjs = new HashSet<AMObjectImpl>();
                    objImplListeners.put(this.entryDN.toLowerCase(), destObjs);
                }
                destObjs.add(this);
                this.isRegistered = true;
            }
        }
        object = this.listeners;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    public void assignPolicies(String serviceName, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    public void assignServices(Map serviceNamesAndAttr) throws AMException, SSOException {
        this.assignServices(serviceNamesAndAttr, true);
    }

    public void assignServices(Map serviceNamesAndAttr, boolean store) throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        if (serviceNamesAndAttr == null || serviceNamesAndAttr.isEmpty()) {
            return;
        }
        Set newOCs = new HashSet();
        Set<Object> canAssign = new HashSet();
        if (store) {
            Set assignedServices = this.getAssignedServices();
            Set toAssign = serviceNamesAndAttr.keySet();
            Iterator<Object> it = toAssign.iterator();
            while (it.hasNext()) {
                String thisService = (String)it.next();
                if (!assignedServices.contains(thisService)) {
                    canAssign.add(thisService);
                    continue;
                }
                if (!debug.warningEnabled()) continue;
                debug.warning("AMObjectImpl.assignService()-> " + thisService + " is already assigned to " + this.entryDN);
            }
            Set registered = null;
            registered = this.profileType == 2 ? this.dsServices.getRegisteredServiceNames(null, this.entryDN) : this.dsServices.getRegisteredServiceNames(null, this.getOrganizationDN());
            it = canAssign.iterator();
            while (it.hasNext()) {
                if (registered.contains((String)it.next())) continue;
                throw new AMException(AMSDKBundle.getString("126", this.locale), "126");
            }
        } else {
            canAssign = serviceNamesAndAttr.keySet();
        }
        newOCs = AMServiceUtils.getServiceObjectClasses(this.token, canAssign);
        if (store) {
            Set oldOCs = this.getAttribute("objectclass");
            newOCs = AMCommonUtils.combineOCs(newOCs, oldOCs);
        }
        this.setAttribute("objectclass", newOCs);
        Iterator<Object> it = canAssign.iterator();
        while (it.hasNext()) {
            String thisService = (String)it.next();
            Map attrMap = (HashMap)serviceNamesAndAttr.get(thisService);
            if (attrMap == null || attrMap.isEmpty()) {
                attrMap = new HashMap();
            }
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(thisService, this.token);
                ServiceSchema ss = null;
                Object[] args = new Object[]{thisService};
                if (this.profileType == 1) {
                    ss = ssm.getSchema(SchemaType.USER);
                    if (ss == null) {
                        ss = ssm.getSchema(SchemaType.DYNAMIC);
                    }
                } else if (this.profileType == 2 || this.profileType == 3) {
                    ss = ssm.getSchema(SchemaType.DOMAIN);
                } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                    ss = ssm.getSchema(SchemaType.GROUP);
                }
                if (ss == null) {
                    debug.warning(AMSDKBundle.getString("1001"));
                    throw new AMException(AMSDKBundle.getString("1001", args, this.locale), "1001", args);
                }
                if (ss.getServiceType() != SchemaType.DYNAMIC) {
                    attrMap = ss.validateAndInheritDefaults(attrMap, true);
                }
                attrMap = AMCommonUtils.removeEmptyValues(attrMap);
            }
            catch (SMSException smse) {
                debug.error("AMObjectImpl:assignService-> unable to validate attributes for " + thisService, (Throwable)smse);
                throw new AMException(AMSDKBundle.getString("908", this.locale), "908");
            }
            this.setAttributes(attrMap);
        }
        if (store) {
            this.store();
        }
    }

    public void create() throws AMException, SSOException {
        block45: {
            block44: {
                block38: {
                    SSOTokenManager.getInstance().validateToken(this.token);
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.create(): DN=" + this.entryDN);
                    }
                    if (this.rfcDN == null) {
                        throw new AMInvalidDNException(AMSDKBundle.getString("157", this.locale), "157");
                    }
                    DN dn = new DN(this.entryDN);
                    String parentDN = dn.getParent().toString();
                    String name = ((RDN)dn.getRDNs().firstElement()).getValues()[0];
                    if (this.profileType == 1) {
                        AMUserImpl admin = new AMUserImpl(this.token, this.token.getPrincipal().getName());
                        Set roleDNs = admin.getRoleDNs();
                        if (roleDNs.size() > 0) {
                            this.stringValueModMap.put("iplanet-am-modifiable-by", roleDNs);
                        }
                        this.stringValueModMap = this.integrateLocale();
                    }
                    this.dsServices.createEntry(this.token, name, this.profileType, parentDN, this.stringValueModMap);
                    if (this.profileType == 2 || this.profileType == 3) {
                        String peopleDN = AMNamingAttrManager.getNamingAttr(5) + "=People," + this.entryDN;
                        try {
                            AMPeopleContainerImpl people = new AMPeopleContainerImpl(this.token, peopleDN);
                            people.createAdminRole();
                        }
                        catch (Exception ex) {
                            if (!debug.messageEnabled()) break block38;
                            debug.message("AMObject.create: Unable to create admin role for " + peopleDN + ex);
                        }
                    }
                }
                if (this.profileType == 2 || this.profileType == 3) {
                    String policyAdminRoleDN;
                    AMRoleImpl policyAdminRole;
                    block42: {
                        String helpRoleDN;
                        AMRoleImpl helpRole;
                        String helpRolePermission;
                        String helpRoleName;
                        block40: {
                            String adminRolePermission;
                            String adminRoleName;
                            if (this.profileType == 2) {
                                adminRoleName = "Organization Admin Role";
                                helpRoleName = "Organization Help Desk Admin Role";
                                adminRolePermission = "Organization Admin";
                                helpRolePermission = "Organization Help Desk Admin";
                            } else {
                                adminRoleName = "Container Admin Role";
                                helpRoleName = "Container Help Desk Admin Role";
                                adminRolePermission = "Container Admin";
                                helpRolePermission = "Container Help Desk Admin";
                            }
                            String adminRoleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + adminRoleName + "," + this.entryDN;
                            AMRoleImpl adminRole = new AMRoleImpl(this.token, adminRoleDN);
                            if (adminRole.isExists()) {
                                block39: {
                                    try {
                                        this.setRoleAciDescAciList(adminRole, adminRolePermission);
                                        this.setAciForRole(adminRole);
                                    }
                                    catch (Exception ex) {
                                        if (!debug.messageEnabled()) break block39;
                                        debug.message("AMObject.create: Unable to set aci or org admin role. ", (Throwable)ex);
                                    }
                                }
                                try {
                                    adminRole.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                                    adminRole.store();
                                }
                                catch (Exception ex) {
                                    if (!debug.warningEnabled()) break block40;
                                    debug.warning("AMObject.create: Unable to set managed dn for org admin role.", (Throwable)ex);
                                }
                            }
                        }
                        if ((helpRole = new AMRoleImpl(this.token, helpRoleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + helpRoleName + "," + this.entryDN)).isExists()) {
                            block41: {
                                try {
                                    this.setRoleAciDescAciList(helpRole, helpRolePermission);
                                    this.setAciForRole(helpRole);
                                }
                                catch (Exception ex) {
                                    if (!debug.messageEnabled()) break block41;
                                    debug.message("AMObject.create: Unable to set aci or org help desk admin role. ", (Throwable)ex);
                                }
                            }
                            try {
                                helpRole.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                                helpRole.store();
                            }
                            catch (Exception ex) {
                                if (!debug.warningEnabled()) break block42;
                                debug.warning("AMObject.create: Unable to set managed dn for org help role.", (Throwable)ex);
                            }
                        }
                    }
                    if ((policyAdminRole = new AMRoleImpl(this.token, policyAdminRoleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + POLICY_ADMIN_ROLE_NAME + "," + this.entryDN)).isExists()) {
                        block43: {
                            try {
                                this.setRoleAciDescAciList(policyAdminRole, POLICY_ADMIN_ROLE_PERMISSION);
                                this.setAciForRole(policyAdminRole);
                            }
                            catch (Exception ex) {
                                if (!debug.messageEnabled()) break block43;
                                debug.message("AMObject.create: Unable to set aci or org policy admin role. ", (Throwable)ex);
                            }
                        }
                        try {
                            policyAdminRole.setStringAttribute("iplanet-am-role-managed-container-dn", this.entryDN);
                            policyAdminRole.store();
                        }
                        catch (Exception ex) {
                            if (debug.warningEnabled()) {
                                debug.warning("AMObject.create: Unable to set managed dn for org policy admin role.", (Throwable)ex);
                            }
                        }
                    }
                } else {
                    if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12 || this.profileType == 5) {
                        try {
                            if (!AMDCTree.isRequired()) {
                                this.createAdminRole();
                            }
                            break block44;
                        }
                        catch (Exception ex) {
                            if (debug.messageEnabled()) {
                                debug.message("AMObject.create: Unable to create admin role for " + this.entryDN + ex);
                            }
                            break block44;
                        }
                    }
                    if (this.profileType == 6 || this.profileType == 8) {
                        this.setAciForRole((AMRole)((Object)this));
                    }
                }
            }
            if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12) {
                try {
                    if (!AMDCTree.isRequired()) {
                        this.setAciBasedOnGroupPclist();
                    }
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block45;
                    debug.message("AMObject.create: Unable to set aci based on group pclist for " + this.entryDN + ex);
                }
            }
        }
        this.stringValueModMap.clear();
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.clear();
        }
    }

    public AMTemplate createPolicyTemplate(String serviceName, Map attributes) throws UnsupportedOperationException, AMException, SSOException {
        return this.createPolicyTemplate(serviceName, attributes, -1);
    }

    public AMTemplate createPolicyTemplate(String serviceName, Map attributes, int priority) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(300, serviceName, attributes, priority);
    }

    public AMTemplate createTemplate(int templateType, String serviceName, Map attributes) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(templateType, serviceName, attributes, -1);
    }

    public AMTemplate createTemplate(int templateType, String serviceName, Map attributes, int priority) throws UnsupportedOperationException, AMException, SSOException {
        return this.createTemplate(templateType, serviceName, attributes, priority, null);
    }

    public AMTemplate createTemplate(int templateType, String serviceName, Map attributes, int priority, Set policyDNs) throws UnsupportedOperationException, AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (this.profileType != 2 && this.profileType != 6 && this.profileType != 3 && this.profileType != 8) {
            throw new UnsupportedOperationException();
        }
        if (templateType == 302) {
            if (this.profileType != 3 && this.profileType != 2) {
                throw new UnsupportedOperationException();
            }
            ServiceConfig sc = AMServiceUtils.createOrgConfig(this.token, this.entryDN, serviceName, attributes);
            return new AMOrgTemplateImpl(this.token, sc.getDN(), serviceName, sc, this.entryDN);
        }
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createTemplate(" + templateType + ", " + serviceName + ", Map, " + priority + "): DN=" + this.entryDN);
        }
        if (attributes == null) {
            try {
                attributes = AMServiceUtils.getServiceConfig(this.token, serviceName, SchemaType.DYNAMIC);
            }
            catch (SMSException smsex) {
                if (debug.messageEnabled()) {
                    debug.message("AMObjectImpl.createTemplate(" + templateType + ", " + serviceName + ", Map, " + priority + ")", (Throwable)smsex);
                }
                throw new AMException(AMSDKBundle.getString("451", this.locale), "451");
            }
        }
        ServiceSchemaManager ssm = null;
        ServiceSchema ss = null;
        try {
            ssm = new ServiceSchemaManager(serviceName, this.token);
            ss = ssm.getSchema(SchemaType.DYNAMIC);
        }
        catch (SMSException sme) {
            debug.error("AMObjectImpl.createTemplate()", (Throwable)sme);
            throw new AMException(AMSDKBundle.getString("484", this.locale), "484");
        }
        if (ss == null) {
            throw new AMException(AMSDKBundle.getString("484", this.locale), "484");
        }
        attributes = AMCrypt.encryptPasswords(attributes, ss);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createTemplate(): attributes encrypted: " + attributes);
        }
        attributes = this.integrateLocaleForTemplateCreation(attributes);
        String templateDN = this.dsServices.createAMTemplate(this.token, this.rfcDN, this.profileType, serviceName, attributes, priority);
        return new AMTemplateImpl(this.token, templateDN, serviceName, templateType);
    }

    public void delete(boolean recursive) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (AMCompliance.isComplianceUserDeletionEnabled()) {
            switch (this.profileType) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 21: {
                    AMCompliance.verifyAndDeleteObject(this.token, this.rfcDN);
                    return;
                }
                case 6: 
                case 8: {
                    this.purge(recursive, -1);
                    return;
                }
                case 5: {
                    String pcFilter = this.getSearchFilter(5);
                    String userFilter = this.getSearchFilter(1);
                    StringBuffer sb = new StringBuffer();
                    sb.append("(|").append(pcFilter).append(userFilter);
                    sb.append(")");
                    String filter = sb.toString();
                    Set pcEntries = new HashSet();
                    try {
                        pcEntries = this.search(1, filter);
                    }
                    catch (AMException ame) {
                        String ldapErr = ame.getLDAPErrorCode();
                        int ldapError = Integer.parseInt(ldapErr);
                        if (ldapErr != null && (ldapError == 4 || ldapError == 11)) {
                            String locale = AMCommonUtils.getUserLocale(this.token);
                            throw new AMException(AMSDKBundle.getString("977", locale), "977");
                        }
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.delete people container " + ame);
                        }
                        throw ame;
                    }
                    if (pcEntries != null && !pcEntries.isEmpty()) {
                        throw new AMException(AMSDKBundle.getString("977", this.locale), "977");
                    }
                    this.purge(recursive, -1);
                    return;
                }
                case 4: {
                    String gcFilter = this.getSearchFilter(4);
                    String groupFilter = this.getSearchFilter(9);
                    StringBuffer sbf = new StringBuffer();
                    sbf.append("(|").append(gcFilter).append(groupFilter);
                    sbf.append(")");
                    String flt = sbf.toString();
                    Set gcEntries = new HashSet();
                    try {
                        gcEntries = this.search(1, flt);
                    }
                    catch (AMException ame) {
                        String ldapErr = ame.getLDAPErrorCode();
                        int ldapError = Integer.parseInt(ldapErr);
                        if (ldapErr != null && (ldapError == 4 || ldapError == 11)) {
                            throw new AMException(AMSDKBundle.getString("977", this.locale), "977");
                        }
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.delete group container " + ame);
                        }
                        throw ame;
                    }
                    if (gcEntries != null && !gcEntries.isEmpty()) {
                        throw new AMException(AMSDKBundle.getString("977", this.locale), "977");
                    }
                    this.purge(recursive, -1);
                    return;
                }
            }
            this.purge(recursive, -1);
            return;
        }
        this.purge(recursive, -1);
    }

    public void delete() throws AMException, SSOException {
        this.delete(false);
    }

    public void modifyService(String sname, Map attrMap) throws AMException, SSOException {
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        if (attrMap == null || attrMap.isEmpty() || sname == null) {
            return;
        }
        Set assignedServices = this.getAssignedServices();
        if (!assignedServices.contains(sname)) {
            throw new AMException(AMSDKBundle.getString("126", this.locale), "126");
        }
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager(sname, this.token);
            ServiceSchema ss = null;
            if (this.profileType == 1) {
                ss = ssm.getSchema(SchemaType.USER);
            } else if (this.profileType == 2 || this.profileType == 3) {
                ss = ssm.getSchema(SchemaType.DOMAIN);
            } else if (this.profileType == 10 || this.profileType == 11 || this.profileType == 12 || this.profileType == 9) {
                ss = ssm.getSchema(SchemaType.GROUP);
            }
            ss.validateAttributes(attrMap, this.getOrganizationDN());
        }
        catch (SMSException smse) {
            debug.error("AMObjectImpl:modifyService-> unable to validate attributes for " + sname, (Throwable)smse);
            Object[] args = new Object[]{sname};
            throw new AMException(AMSDKBundle.getString("976", args, this.locale), "976", args);
        }
        this.setAttributes(attrMap);
        this.store();
    }

    public void purge(boolean recursive, int graceperiod) throws AMException, SSOException {
        block15: {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.delete(): DN=" + this.entryDN + " recursive=" + recursive + "graceperiod= " + graceperiod);
            }
            if (this.entryDN.equals(AMStoreConnection.defaultOrg)) {
                throw new AMException(AMSDKBundle.getString("160", this.locale), "160");
            }
            if (graceperiod > -1 && graceperiod < AMStoreConnection.daysSinceModified(this.token, this.entryDN)) {
                if (debug.messageEnabled()) {
                    debug.message("AMObjectImpl.purge-> " + this.entryDN + "will not be purged. Grace period= " + graceperiod + " has not expired");
                }
                throw new AMException(AMSDKBundle.getString("974", this.locale), "974");
            }
            if (this.profileType == 9 || this.profileType == 11 || this.profileType == 12 || this.profileType == 5) {
                block14: {
                    try {
                        this.removeAdminRoleAci(recursive);
                    }
                    catch (Exception e) {
                        if (!debug.messageEnabled()) break block14;
                        debug.message("AMObjectImpl.delete: Unable to remove admin role aci." + e);
                    }
                }
                try {
                    this.dsServices.removeAdminRole(this.token, this.entryDN, recursive);
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) break block15;
                    debug.message("AMObjectImpl.delete: " + e.getMessage());
                }
            }
        }
        Set aciList = null;
        Set templateDNs = null;
        if (this.profileType == 6 || this.profileType == 8) {
            aciList = this.findRemovableAciList(this.getAttribute("iplanet-am-role-aci-list"));
            String filter = "(&(objectclass=costemplate)(cn=\"" + this.entryDN + "\"))";
            templateDNs = this.dsServices.search(this.token, this.getOrganizationDN(), filter, 2);
        }
        this.dsServices.removeEntry(this.token, this.entryDN, this.profileType, recursive, false);
        if (aciList != null) {
            this.removeAci(aciList);
        }
        if (templateDNs != null && !templateDNs.isEmpty()) {
            Iterator iter = templateDNs.iterator();
            while (iter.hasNext()) {
                String templateDN = (String)iter.next();
                this.dsServices.removeEntry(this.token, templateDN, 13, recursive, false);
            }
        }
        this.stringValueModMap.clear();
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.clear();
        }
    }

    public void removeAttributes(Set attrNames) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.removeAttributes(Set): DN=" + this.entryDN + "\n" + attrNames);
        }
        Iterator itr = attrNames.iterator();
        HashMap<String, Set> attributes = new HashMap<String, Set>(attrNames.size());
        HashMap<String, Set> altAttributes = new HashMap<String, Set>();
        while (itr.hasNext()) {
            String name = (String)itr.next();
            attributes.put(name, AMConstants.REMOVE_ATTRIBUTE);
            if (AMCommonUtils.integrateLocale && name.equalsIgnoreCase("preferredLanguage")) {
                altAttributes.put("preferredLocale", AMConstants.REMOVE_ATTRIBUTE);
            }
            if (!AMCommonUtils.integrateLocale || !name.equalsIgnoreCase("preferredLocale")) continue;
            altAttributes.put("preferredLanguage", AMConstants.REMOVE_ATTRIBUTE);
        }
        this.dsServices.setAttributes(this.token, this.entryDN, this.profileType, attributes, null, false);
        if (!altAttributes.isEmpty()) {
            try {
                this.dsServices.setAttributes(this.token, this.entryDN, this.profileType, altAttributes, null, false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.stringValueModMap.removeKeys(attrNames);
        if (!this.byteValueModMap.isEmpty()) {
            this.byteValueModMap.removeKeys(attrNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(AMEventListener listener) {
        boolean removed = false;
        Object object = this.listeners;
        synchronized (object) {
            removed = this.listeners.remove(listener);
        }
        if (removed && this.listeners.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("AMObjectImpl.removeEventListener(..): private listener table empty for this instance");
            }
            object = objImplListeners;
            synchronized (object) {
                Set destObjs = (Set)objImplListeners.get(this.entryDN.toLowerCase());
                if (destObjs != null) {
                    destObjs.remove(this);
                    if (destObjs.isEmpty()) {
                        objImplListeners.remove(this.entryDN);
                    }
                }
                this.isRegistered = false;
            }
            AMObjectImpl.removeFromProfileNameTable(this.token, this.entryDN);
        }
    }

    public Set search(int level, String filter) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.search(" + level + ", " + filter + "): DN=" + this.entryDN);
        }
        return this.dsServices.search(this.token, this.entryDN, filter, level);
    }

    public Set searchObjects(String namingAttr, String objectClassFilter, String wildcard, Map avPairs, int level) throws AMException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + namingAttr + ", " + objectClassFilter + ", " + wildcard + ", Map): DN=" + this.entryDN + ", level " + level + "\n" + this.mapToString(avPairs));
        }
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&").append(AMObjectImpl.constructFilter(namingAttr, objectClassFilter, wildcard));
        if (avPairs != null && avPairs.size() > 0) {
            filterSB.append(AMObjectImpl.constructFilter(avPairs));
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("    filter: " + filterSB.toString());
        }
        return this.search(level, filterSB.toString());
    }

    public void store() throws AMException, SSOException {
        this.store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(boolean isAdd) throws AMException, SSOException {
        try {
            Set oldUM;
            block25: {
                Set oldAciList;
                block23: {
                    block22: {
                        SSOTokenManager.getInstance().validateToken(this.token);
                        if (debug.messageEnabled()) {
                            if (this.stringValueModMap.containsKey("userpassword")) {
                                Map noPasswdMap = this.stringValueModMap.getCopy();
                                noPasswdMap.remove("userpassword");
                                HashSet<String> set = new HashSet<String>(2);
                                set.add("********");
                                noPasswdMap.put("userpassword", set);
                                debug.message("AMObjectImpl.store(): DN=" + this.entryDN + "\n" + AMCommonUtils.mapSetToString(noPasswdMap));
                            } else {
                                debug.message("AMObjectImpl.store(): DN=" + this.entryDN + "\n" + AMCommonUtils.mapSetToString(this.stringValueModMap));
                            }
                        }
                        if (this.profileType == 2 && this.stringValueModMap.containsKey("sunOrganizationAlias")) {
                            Set currentOC = this.getAttribute("objectclass");
                            Set ocSet = (Set)this.stringValueModMap.get("objectclass");
                            ocSet = ocSet == null || ocSet == Collections.EMPTY_SET ? currentOC : AMCommonUtils.combineOCs(ocSet, currentOC);
                            boolean hasIt = false;
                            Iterator itr = ocSet.iterator();
                            while (itr.hasNext()) {
                                String value = (String)itr.next();
                                if (!value.equalsIgnoreCase("sunISManagedOrganization")) continue;
                                hasIt = true;
                                break;
                            }
                            if (!hasIt) {
                                ocSet.add("sunISManagedOrganization");
                            }
                            this.stringValueModMap.put("objectclass", ocSet);
                        }
                        this.stringValueModMap = this.integrateLocale();
                        oldAciList = null;
                        if (this.stringValueModMap.containsKey("iplanet-am-role-aci-list")) {
                            try {
                                oldAciList = this.findRemovableAciList(this.getAttribute("iplanet-am-role-aci-list"));
                            }
                            catch (Exception ex) {
                                if (!debug.messageEnabled()) break block22;
                                debug.message("AMObjectImpl.store: Failed to get old iplanet-am-role-aci-list");
                            }
                        }
                    }
                    oldUM = null;
                    if (this.profileType == 9 && this.stringValueModMap.containsKey("uniquemember")) {
                        try {
                            oldUM = this.getAttribute("uniquemember");
                        }
                        catch (Exception ex) {
                            if (!debug.messageEnabled()) break block23;
                            debug.message("AMObjectImpl.store: Failed to get old uniquemember");
                        }
                    }
                }
                this.dsServices.setAttributes(this.token, this.entryDN, this.profileType, this.stringValueModMap, this.byteValueModMap, isAdd);
                if (this.stringValueModMap.containsKey("iplanet-am-role-aci-list")) {
                    block24: {
                        try {
                            this.removeAci(oldAciList);
                        }
                        catch (Exception ex) {
                            if (!debug.messageEnabled()) break block24;
                            debug.message("AMObjectImpl.store: Failed to remove old acis");
                        }
                    }
                    try {
                        this.setAciForRole(new AMRoleImpl(this.token, this.entryDN));
                    }
                    catch (Exception ex) {
                        if (!debug.messageEnabled()) break block25;
                        debug.message("AMObjectImpl.store: Failed to add new acis");
                    }
                }
            }
            if (this.profileType == 9 && this.stringValueModMap.containsKey("uniquemember")) {
                if (oldUM != null) {
                    this.dsServices.updateUserAttribute(this.token, oldUM, this.entryDN, false);
                }
                Set set = (Set)this.stringValueModMap.get("uniquemember");
                this.dsServices.updateUserAttribute(this.token, set, this.entryDN, true);
            }
        }
        finally {
            this.stringValueModMap.clear();
            this.byteValueModMap.clear();
        }
    }

    public void unassignPolicies(String serviceName, Set policyDNs) throws AMException, SSOException {
        this.unassignPolicies(serviceName, policyDNs, true);
    }

    public void unassignServices(Set serviceNames) throws AMException, SSOException {
        if (serviceNames == null || serviceNames.isEmpty()) {
            return;
        }
        if (this.profileType != 2 && this.profileType != 1 && this.profileType != 10 && this.profileType != 11 && this.profileType != 3 && this.profileType != 12 && this.profileType != 9) {
            throw new UnsupportedOperationException();
        }
        Set assignedServices = this.getAssignedServices();
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = (String)iter.next();
            if (assignedServices.contains(serviceName)) continue;
            debug.error(AMSDKBundle.getString("126", this.locale));
            throw new AMException(AMSDKBundle.getString("126", this.locale), "126");
        }
        Set removeOCs = AMServiceUtils.getServiceObjectClasses(this.token, serviceNames);
        Set objectClasses = this.getAttribute("objectclass");
        removeOCs = AMCommonUtils.updateAndGetRemovableOCs(objectClasses, removeOCs);
        HashSet<String> removeAttrs = new HashSet<String>();
        Iterator iter1 = removeOCs.iterator();
        while (iter1.hasNext()) {
            String oc = (String)iter1.next();
            Set attrs = this.dsServices.getAttributesForSchema(oc);
            Iterator iter2 = attrs.iterator();
            while (iter2.hasNext()) {
                String attrName = (String)iter2.next();
                removeAttrs.add(attrName.toLowerCase());
            }
        }
        Map avPair = this.getAttributes();
        Iterator itr = avPair.keySet().iterator();
        while (itr.hasNext()) {
            String attrName = (String)itr.next();
            if (!removeAttrs.contains(attrName)) continue;
            try {
                HashSet<String> tmpSet = new HashSet<String>();
                tmpSet.add(attrName);
                this.removeAttributes(tmpSet);
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) continue;
                debug.message("AMUserImpl.unassignServices()Error occured while removing attribute: " + attrName);
            }
        }
        this.setAttribute("objectclass", objectClasses);
        this.store();
    }

    protected static String constructFilter(String objectClassFilter) {
        int index = objectClassFilter.indexOf("%U");
        if (index == -1) {
            return objectClassFilter;
        }
        StringBuffer filterSB = new StringBuffer();
        filterSB.append(objectClassFilter.substring(0, index)).append("*");
        int index2 = objectClassFilter.indexOf("%V");
        if (index2 == -1) {
            filterSB.append(objectClassFilter.substring(index + 2));
        } else {
            filterSB.append(objectClassFilter.substring(index + 2, index2)).append("*").append(objectClassFilter.substring(index2 + 2));
        }
        return filterSB.toString();
    }

    protected static String constructFilter(String namingAttr, String objectClassFilter, String wildcard) {
        StringBuffer filterSB = new StringBuffer();
        int index = objectClassFilter.indexOf("%U");
        int vIndex = objectClassFilter.indexOf("%V");
        if (index == -1 && vIndex == -1) {
            filterSB.append("(&(").append(namingAttr).append("=").append(wildcard).append(")").append(objectClassFilter).append(")");
            objectClassFilter = filterSB.toString();
            return objectClassFilter;
        }
        while (index != -1) {
            filterSB.append(objectClassFilter.substring(0, index)).append(wildcard).append(objectClassFilter.substring(index + 2));
            objectClassFilter = filterSB.toString();
            filterSB = new StringBuffer();
            index = objectClassFilter.indexOf("%U");
        }
        while (vIndex != -1) {
            filterSB.append(objectClassFilter.substring(0, vIndex)).append(wildcard).append(objectClassFilter.substring(vIndex + 2));
            objectClassFilter = filterSB.toString();
            filterSB = new StringBuffer();
            vIndex = objectClassFilter.indexOf("%V");
        }
        return objectClassFilter;
    }

    protected static String constructFilter(Map avPairs) {
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&");
        Iterator iter = avPairs.keySet().iterator();
        while (iter.hasNext()) {
            String attributeName = (String)iter.next();
            Iterator iter2 = ((Set)avPairs.get(attributeName)).iterator();
            while (iter2.hasNext()) {
                String attributeValue = (String)iter2.next();
                filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
            }
        }
        filterSB.append(")");
        return filterSB.toString();
    }

    protected String getSearchFilter(int objectType) {
        return this.getSearchFilter(objectType, null);
    }

    protected String getSearchFilter(int objectType, String searchTempName) {
        try {
            return AMSearchFilterManager.getSearchFilter(objectType, this.getOrganizationDN(), searchTempName, false);
        }
        catch (Exception ex) {
            return AMSearchFilterManager.getGlobalSearchFilter(objectType, searchTempName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyACIChangeEvent(String dn, int eventType) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.notifyACIChangeEvent(..): " + dn);
        }
        Map map = objImplListeners;
        synchronized (map) {
            if (objImplListeners.isEmpty()) {
                return;
            }
            AMEvent dpEvent = new AMEvent(new AMEvent(dn), eventType);
            switch (eventType) {
                case 4: 
                case 8: {
                    if (debug.messageEnabled()) {
                        debug.message("In AMObjectImpl.notifyACIChangeEvent(..): ACI Entry renamed/changed event");
                    }
                    AMObjectImpl.notifyAffectedDNs(dn, dpEvent);
                    break;
                }
                case 2: {
                    Set objImplSet;
                    if (debug.messageEnabled()) {
                        debug.message("In AMObjectImpl.notifyACIChangeEvent(..): ACI Entry removed event");
                    }
                    if ((objImplSet = (Set)objImplListeners.get(dn.toLowerCase())) == null) {
                        return;
                    }
                    Iterator itr = objImplSet.iterator();
                    while (itr.hasNext()) {
                        AMObjectImpl dpObjImpl = (AMObjectImpl)itr.next();
                        dpObjImpl.sendEvents(dpEvent);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyEntryEvent(String dn, int eventType, boolean cosType) {
        Map map = objImplListeners;
        synchronized (map) {
            if (objImplListeners.isEmpty()) {
                return;
            }
            AMEvent dpEvent = new AMEvent(new AMEvent(dn), eventType);
            switch (eventType) {
                case 1: {
                    if (!cosType) break;
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove cos event!" + dn);
                    }
                    AMObjectImpl.notifyAffectedDNs(dn, dpEvent);
                    break;
                }
                case 2: 
                case 4: {
                    Set objImplSet;
                    if (cosType) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove cos event!" + dn);
                        }
                        AMObjectImpl.notifyAffectedDNs(dn, dpEvent);
                        break;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): change/remove entry event!" + dn);
                    }
                    if ((objImplSet = (Set)objImplListeners.get(dn.toLowerCase())) == null) {
                        return;
                    }
                    Iterator itr = objImplSet.iterator();
                    while (itr.hasNext()) {
                        AMObjectImpl dpObjImpl = (AMObjectImpl)itr.next();
                        dpObjImpl.sendEvents(dpEvent);
                    }
                    break;
                }
                case 8: {
                    if (debug.messageEnabled()) {
                        debug.message("AMObjectImpl.notifyEntryEvent(..): rename entry event!" + dn);
                    }
                    AMObjectImpl.notifyAffectedDNs(dn, dpEvent);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendExpiryEvent(String sourceDN, int sourceType) {
        Set objectImplSet;
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.sendExpiryEvent(..) - for:" + sourceDN);
        }
        if ((objectImplSet = (Set)objImplListeners.get(sourceDN.toLowerCase())) != null) {
            Set set = objectImplSet;
            synchronized (set) {
                Iterator itr = objectImplSet.iterator();
                AMEvent amEvent = new AMEvent(sourceDN, 9, sourceDN, sourceType);
                while (itr.hasNext()) {
                    AMObjectImpl amObjectImpl = (AMObjectImpl)itr.next();
                    amObjectImpl.sendEvents(amEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Set removeFromProfileNameTable(SSOToken ssoToken) {
        Hashtable pTable = profileNameTable;
        if (pTable == null || pTable.isEmpty()) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("In ProfileService.removeFromProfilefNameTable(SSOTokenID)..");
        }
        Set dnList = null;
        Hashtable hashtable = pTable;
        synchronized (hashtable) {
            String principal;
            try {
                principal = ssoToken.getPrincipal().getName();
            }
            catch (SSOException ssoe) {
                debug.error("AMObjectImpl.removeFromProfileNameTable(): Could not update PFN table");
                return null;
            }
            dnList = (Set)pTable.remove(principal);
        }
        return dnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeObjImplListeners(Set dnSet, SSOTokenID ssoTokenId) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.removeObjImplListeners(..): ");
        }
        Map map = objImplListeners;
        synchronized (map) {
            Iterator dnItr = dnSet.iterator();
            while (dnItr.hasNext()) {
                String dn = (String)dnItr.next();
                Set objSet = (Set)objImplListeners.get(dn.toLowerCase());
                if (objSet == null) continue;
                Iterator objItr = objSet.iterator();
                while (objItr.hasNext()) {
                    AMObjectImpl dpObjectImpl = (AMObjectImpl)objItr.next();
                    SSOToken dpObjSSOToken = dpObjectImpl.getSSOToken();
                    if (!((Object)ssoTokenId).equals(dpObjSSOToken.getTokenID())) continue;
                    objSet.remove(dpObjectImpl);
                }
                if (!objSet.isEmpty()) continue;
                objImplListeners.remove(dn);
            }
        }
    }

    protected Set replaceAciListMacros(Set aciSet, String roleDN, String orgDN, String groupDN, String pcDN) {
        HashSet<String> resultSet = new HashSet<String>();
        Iterator iter = aciSet.iterator();
        while (iter.hasNext()) {
            resultSet.add(this.replaceAciMacros((String)iter.next(), roleDN, orgDN, groupDN, pcDN));
        }
        return resultSet;
    }

    protected String replaceAciMacro(String aci, String macro, String str) {
        if (str == null) {
            return aci;
        }
        StringBuffer sb = new StringBuffer();
        while (true) {
            int index;
            if ((index = aci.indexOf(macro)) == -1) break;
            sb.append(aci.substring(0, index)).append(str);
            aci = aci.substring(index + macro.length());
        }
        sb.append(aci);
        return sb.toString();
    }

    protected String replaceAciMacros(String aci, String roleDN, String orgDN, String groupDN, String pcDN) {
        String result = this.replaceAciMacro(aci, "ROLENAME", roleDN);
        result = this.replaceAciMacro(result, "ORGANIZATION", orgDN);
        result = this.replaceAciMacro(result, "GROUPNAME", groupDN);
        result = this.replaceAciMacro(result, "PCNAME", pcDN);
        String filter = null;
        String adgFilter = "(memberof=*" + this.entryDN + ")";
        String sgFilter = "(iplanet-am-static-group-dn=*" + this.entryDN + ")";
        if (this.profileType == 11) {
            block8: {
                Set attr = (Set)this.stringValueModMap.get("memberurl");
                if (attr != null && attr.iterator().hasNext()) {
                    String memberurl = (String)attr.iterator().next();
                    try {
                        LDAPUrl ldapurl = new LDAPUrl(memberurl);
                        filter = "(|" + adgFilter + sgFilter + ldapurl.getFilter() + ")";
                    }
                    catch (MalformedURLException ex) {
                        if (!debug.messageEnabled()) break block8;
                        debug.message("AMObject.create: Invalid member url " + memberurl);
                    }
                }
            }
            if (filter == null) {
                filter = "(|" + adgFilter + sgFilter + ")";
            }
        } else if (this.profileType == 12 || this.profileType == 9) {
            filter = "(|" + adgFilter + sgFilter + ")";
        }
        if (filter != null) {
            result = this.replaceAciMacro(result, "FILTER", filter);
        }
        return result;
    }

    protected AMSearchResults searchObjects(String namingAttr, String objectClassFilter, String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&").append(AMObjectImpl.constructFilter(namingAttr, objectClassFilter, wildcard));
        if (avPairs != null && !avPairs.isEmpty()) {
            filterSB.append(AMObjectImpl.constructFilter(avPairs));
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + namingAttr + ", " + objectClassFilter + ", " + wildcard + ", Map): DN=" + this.entryDN + ", level " + searchControl.getSearchScope() + "\n" + this.mapToString(avPairs));
            debug.message("AMObjectImpl.searchObjects(): filter: " + filterSB.toString());
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.entryDN, filterSB.toString(), sc, returnAttrs);
    }

    protected AMSearchResults searchObjects(String namingAttr, String objectClassFilter, String wildcard, AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&").append(AMObjectImpl.constructFilter(namingAttr, objectClassFilter, wildcard));
        if (avfilter != null) {
            filterSB.append(avfilter);
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + namingAttr + ", " + objectClassFilter + ", " + wildcard + ", " + avfilter + "): DN=" + this.entryDN + ", level " + searchControl.getSearchScope());
            debug.message("AMObjectImpl.searchObjects(): filter: " + filterSB.toString());
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.entryDN, filterSB.toString(), sc, returnAttrs);
    }

    protected AMSearchResults searchObjects(String objectClassFilter, AMSearchControl searchControl, String avfilter) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&").append(AMObjectImpl.constructFilter(objectClassFilter));
        if (avfilter != null) {
            filterSB.append(avfilter);
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(" + objectClassFilter + ", " + avfilter + "): DN=" + this.entryDN + ", level " + searchControl.getSearchScope());
            debug.message("AMObjectImpl.searchObjects(): filter: " + filterSB.toString());
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.entryDN, filterSB.toString(), sc, returnAttrs);
    }

    protected Set searchObjects(int[] objectTypes, String wildcard, Map avPairs, int level) throws AMException, SSOException {
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&");
        filterSB.append("(|");
        for (int i = 0; i < objectTypes.length; ++i) {
            String namingAttr = AMNamingAttrManager.getNamingAttr(objectTypes[i]);
            String objectClassFilter = this.getSearchFilter(objectTypes[i]);
            filterSB.append(AMObjectImpl.constructFilter(namingAttr, objectClassFilter, wildcard));
        }
        filterSB.append(")");
        if (avPairs != null && !avPairs.isEmpty()) {
            filterSB.append(AMObjectImpl.constructFilter(avPairs));
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("    filter: " + filterSB.toString());
        }
        return this.search(level, filterSB.toString());
    }

    protected AMSearchResults searchObjects(int[] objectTypes, String wildcard, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        SSOTokenManager.getInstance().validateToken(this.token);
        StringBuffer filterSB = new StringBuffer();
        filterSB.append("(&");
        filterSB.append("(|");
        for (int i = 0; i < objectTypes.length; ++i) {
            String namingAttr = AMNamingAttrManager.getNamingAttr(objectTypes[i]);
            String objectClassFilter = this.getSearchFilter(objectTypes[i]);
            filterSB.append(AMObjectImpl.constructFilter(namingAttr, objectClassFilter, wildcard));
        }
        filterSB.append(")");
        if (avPairs != null && !avPairs.isEmpty()) {
            filterSB.append(AMObjectImpl.constructFilter(avPairs));
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.searchObjects(): filter: " + filterSB.toString());
        }
        SearchControl sc = searchControl.getSearchControl();
        String[] returnAttrs = searchControl.getReturnAttributes();
        return this.dsServices.search(this.token, this.entryDN, filterSB.toString(), sc, returnAttrs);
    }

    void setAciBasedOnGroupPclist() throws AMException, SSOException {
        String roleDN;
        AMRoleImpl gRole;
        DN thisDN;
        HashSet<String> pcSet;
        AMOrganizationImpl org;
        String orgDN;
        block8: {
            orgDN = this.getOrganizationDN();
            org = new AMOrganizationImpl(this.token, orgDN);
            pcSet = new HashSet<String>();
            thisDN = new DN(this.entryDN);
            try {
                String defaultPc;
                AMTemplate template = org.getTemplate("iPlanetAMAdminConsoleService", 302);
                Set groupPclist = template.getAttribute("iplanet-am-admin-console-group-pclist");
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciBasedOnGroupPclist: iplanet-am-admin-console-group-pclist " + this.setToString(groupPclist));
                }
                Iterator iter = groupPclist.iterator();
                while (iter.hasNext()) {
                    DN groupDN;
                    String groupPc = (String)iter.next();
                    int index = groupPc.indexOf("|");
                    if (index == -1 || !(groupDN = new DN(groupPc.substring(0, index))).equals(thisDN)) continue;
                    pcSet.add(groupPc.substring(index + 1));
                }
                if (pcSet.isEmpty() && (defaultPc = template.getStringAttribute("iplanet-am-admin-console-group-default-pc")) != null && defaultPc.length() > 0) {
                    pcSet.add(defaultPc);
                }
            }
            catch (AMException ex) {
                if (!debug.messageEnabled()) break block8;
                debug.message("AMObject.setAciBasedOnGroupPclist: Unable to get template for iPlanetAMAdminConsoleService");
            }
        }
        if (pcSet.isEmpty()) {
            pcSet.add(AMNamingAttrManager.getNamingAttr(5) + "=People," + orgDN);
        }
        if (!(gRole = new AMRoleImpl(this.token, roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + thisDN.toString().replace(',', '_') + "," + orgDN)).isExists()) {
            return;
        }
        HashSet<String> aciSet = new HashSet<String>();
        HashSet<String> aciListSet = new HashSet<String>();
        Iterator iter = pcSet.iterator();
        while (iter.hasNext()) {
            String pc = (String)iter.next();
            String thisAci = "(target=\"ldap:///" + pc + "\")" + "(targetattr=\"nsroledn\")" + "(targattrfilters=\"add=nsroledn:(!(nsroledn=*))," + "del=nsroledn:(!(nsroledn=*))\")" + "(version 3.0; acl \"Group admin's right to add user " + "to people container\"; allow (add) roledn = \"" + "ldap:///" + roleDN + "\";)";
            aciSet.add(thisAci);
            aciListSet.add(orgDN + ":aci:" + thisAci);
        }
        org.setAttribute("aci", aciSet);
        org.store(true);
        gRole.setAttribute("iplanet-am-role-aci-list", aciListSet);
        gRole.store(true);
    }

    void setAciForRole(AMRole role) throws AMException, SSOException {
        TreeSet aciSet = new TreeSet(role.getAttribute("iplanet-am-role-aci-list"));
        Iterator iter = aciSet.iterator();
        DN targetDN = null;
        Set acis = new HashSet();
        HashSet<String> newAcis = new HashSet<String>();
        boolean needUpdate = false;
        boolean denied = false;
        AMObjectImpl targetObj = null;
        while (iter.hasNext()) {
            String newAci;
            DN tmpDN;
            block13: {
                String aci = (String)iter.next();
                int index = aci.indexOf(":aci:");
                if (index == -1) continue;
                tmpDN = new DN(aci.substring(0, index));
                newAci = aci.substring(index + 5).trim();
                if (targetDN == null) {
                    targetDN = tmpDN;
                    try {
                        targetObj = new AMObjectImpl(this.token, targetDN.toString(), -1);
                        acis = targetObj.getAttribute("aci");
                        if (acis.contains(newAci)) continue;
                        needUpdate = true;
                        newAcis.add(newAci);
                    }
                    catch (Exception ex) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObject.setAciForRole :" + targetDN.toString() + " read access denied." + ex);
                        }
                        denied = true;
                    }
                    continue;
                }
                if (tmpDN.equals(targetDN)) {
                    if (denied || acis.contains(newAci)) continue;
                    needUpdate = true;
                    newAcis.add(newAci);
                    continue;
                }
                if (!denied && needUpdate) {
                    try {
                        targetObj.setAttribute("aci", newAcis);
                        targetObj.store(true);
                    }
                    catch (Exception ex) {
                        if (!debug.messageEnabled()) break block13;
                        debug.message("AMObject.setAciForRole :" + targetDN.toString() + " write access denied." + ex);
                    }
                }
            }
            needUpdate = false;
            denied = false;
            targetDN = tmpDN;
            try {
                targetObj = new AMObjectImpl(this.token, targetDN.toString(), -1);
                acis = targetObj.getAttribute("aci");
                if (acis.contains(newAci)) continue;
                needUpdate = true;
                newAcis.add(newAci);
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciForRole :" + targetDN.toString() + " read access denied." + ex);
                }
                denied = true;
            }
        }
        if (needUpdate) {
            targetObj.setAttribute("aci", newAcis);
            targetObj.store(true);
        }
    }

    Set getDefaultAcis(String permission, StringBuffer aciDesc) throws AMException, SSOException {
        Map map;
        try {
            map = AMServiceUtils.getServiceConfig(this.token, "iPlanetAMAdminConsoleService", SchemaType.GLOBAL);
        }
        catch (SMSException smsex) {
            debug.error(smsex.toString());
            throw new AMException(AMSDKBundle.getString("158", this.locale), "158");
        }
        Set defaultAcis = (Set)map.get("iplanet-am-admin-console-dynamic-aci-list");
        Iterator iter = defaultAcis.iterator();
        String aci = null;
        while (iter.hasNext()) {
            String defaultAci = (String)iter.next();
            if (!defaultAci.startsWith(permission + "|")) continue;
            aci = defaultAci;
            break;
        }
        if (aci == null) {
            throw new AMException(AMSDKBundle.getString("158", this.locale), "158");
        }
        StringTokenizer stz = new StringTokenizer(aci, "|");
        if (stz.countTokens() < 3) {
            throw new AMException(AMSDKBundle.getString("159", this.locale), "159");
        }
        permission = stz.nextToken();
        aciDesc.append(stz.nextToken());
        int index = aci.indexOf(124, permission.length() + 1);
        String acis = aci.substring(index + 1);
        stz = new StringTokenizer(acis, "##");
        HashSet<String> aciSet = new HashSet<String>();
        while (stz.hasMoreTokens()) {
            aciSet.add(stz.nextToken());
        }
        return aciSet;
    }

    void setPolicyTemplate(AMTemplate template, Set policyDNs) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    void setRoleAciDescAciList(AMRole role, String permission) throws AMException, SSOException {
        StringBuffer aciDescSB = new StringBuffer();
        Set aciSet = this.getDefaultAcis(permission, aciDescSB);
        Set displayOptions = this.getDefaultDisplayOptions(permission);
        HashMap<String, Set> attributeMap = new HashMap<String, Set>();
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add(aciDescSB.toString());
        attributeMap.put("iplanet-am-role-aci-description", valueSet);
        attributeMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(aciSet, role.getDN(), this.entryDN, null, null));
        if (displayOptions != null && !displayOptions.isEmpty()) {
            attributeMap.put(ROLE_DISPLAY_ATTR, displayOptions);
        } else if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.setRoleAciDescAciList-> Display Options for permision = " + permission + "  are not defined");
        }
        role.setAttributes(attributeMap);
        role.store();
    }

    private Set getDefaultDisplayOptions(String permission) throws AMException, SSOException {
        Set displayOptions = null;
        try {
            displayOptions = DisplayOptionsUtils.getDefaultDisplayOptions(this.token, permission);
        }
        catch (SMSException smse) {
            debug.error("AMObjectImpl.getDefaultDisplayOptions", (Throwable)smse);
            throw new AMException(AMSDKBundle.getString("158", this.locale), "158");
        }
        return displayOptions;
    }

    void createAdminRole() throws SSOException, AMException {
        if (debug.messageEnabled()) {
            debug.message("AMObject.createAdminRole : dn=" + this.entryDN);
        }
        DN ldapDN = new DN(this.entryDN);
        String orgDN = this.dsServices.getOrganizationDN(this.token, ldapDN.getParent().toString());
        if (this.profileType == 5) {
            String permission = "People Container Admin";
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + ldapDN.toString().replace(',', '_') + "," + orgDN;
            this.createAdminRole(permission, orgDN, roleDN);
        } else {
            String permission = "Group Admin";
            String roleDN = AMNamingAttrManager.getNamingAttr(6) + "=" + ldapDN.toString().replace(',', '_') + "," + orgDN;
            this.createAdminRole(permission, orgDN, roleDN);
        }
    }

    void createAdminRole(String permission, String orgDN, String roleDN) throws SSOException, AMException {
        StringBuffer aciDescSB = new StringBuffer();
        Set aciSet = this.getDefaultAcis(permission, aciDescSB);
        Set displayOptions = this.getDefaultDisplayOptions(permission);
        HashMap<String, Set> attributeMap = new HashMap<String, Set>();
        HashSet<String> valueSet = new HashSet<String>();
        valueSet.add("2");
        attributeMap.put("iplanet-am-role-type", valueSet);
        valueSet = new HashSet();
        valueSet.add(permission);
        attributeMap.put("iplanet-am-role-description", valueSet);
        valueSet = new HashSet();
        valueSet.add(aciDescSB.toString());
        attributeMap.put("iplanet-am-role-aci-description", valueSet);
        if (this.profileType == 5) {
            attributeMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(aciSet, roleDN, orgDN, null, this.entryDN));
        } else {
            attributeMap.put("iplanet-am-role-aci-list", this.replaceAciListMacros(aciSet, roleDN, orgDN, this.entryDN, null));
        }
        if (displayOptions != null && !displayOptions.isEmpty()) {
            attributeMap.put(ROLE_DISPLAY_ATTR, displayOptions);
        } else if (debug.messageEnabled()) {
            debug.message("AMObjectImpl.createAdminRole-> Display Options for permision = " + permission + " are not defined");
        }
        valueSet = new HashSet();
        valueSet.add(this.entryDN);
        attributeMap.put("iplanet-am-role-managed-container-dn", valueSet);
        AMRoleImpl dpRole = new AMRoleImpl(this.token, roleDN);
        dpRole.setAttributes(attributeMap);
        dpRole.create();
    }

    Set findRemovableAciList(Set aciList) throws AMException, SSOException {
        HashSet<String> resultSet = new HashSet<String>();
        if (aciList == null) {
            return resultSet;
        }
        Iterator iter = aciList.iterator();
        while (iter.hasNext()) {
            String aci = (String)iter.next();
            Set objs = this.dsServices.search(this.token, AMStoreConnection.getAMSdkBaseDN(), "(&" + AMSearchFilterManager.getGlobalSearchFilter(9) + "(iplanet-am-role-aci-list=" + aci + "))", 2);
            if (objs.size() >= 2) continue;
            resultSet.add(aci);
        }
        return resultSet;
    }

    void removeAci(Set aciList) throws AMException, SSOException {
        if (aciList == null) {
            return;
        }
        if (aciList.size() == 0) {
            return;
        }
        TreeSet aciSet = new TreeSet(aciList);
        Iterator iter = aciSet.iterator();
        DN targetDN = null;
        Set acis = new HashSet();
        boolean needUpdate = false;
        boolean denied = false;
        AMObjectImpl targetObj = null;
        while (iter.hasNext()) {
            String oldAci;
            DN tmpDN;
            block15: {
                String aci = (String)iter.next();
                int index = aci.indexOf(":aci:");
                if (index == -1) continue;
                tmpDN = new DN(aci.substring(0, index));
                oldAci = aci.substring(index + 5).trim();
                if (targetDN == null) {
                    targetDN = tmpDN;
                    try {
                        targetObj = new AMObjectImpl(this.token, targetDN.toString(), -1);
                        acis = targetObj.getAttribute("aci");
                        if (!acis.remove(oldAci)) continue;
                        needUpdate = true;
                    }
                    catch (Exception ex) {
                        if (debug.messageEnabled()) {
                            debug.message("AMObject.removeAci :" + targetDN.toString() + " read access denied." + ex);
                        }
                        denied = true;
                    }
                    continue;
                }
                if (tmpDN.equals(targetDN)) {
                    if (denied || !acis.remove(oldAci)) continue;
                    needUpdate = true;
                    continue;
                }
                if (!denied && needUpdate) {
                    try {
                        targetObj.setAttribute("aci", acis);
                        targetObj.store();
                    }
                    catch (Exception ex) {
                        if (!debug.messageEnabled()) break block15;
                        debug.message("AMObject.removeAci :" + targetDN.toString() + " write access denied." + ex);
                    }
                }
            }
            needUpdate = false;
            denied = false;
            targetDN = tmpDN;
            try {
                targetObj = new AMObjectImpl(this.token, targetDN.toString(), -1);
                acis = targetObj.getAttribute("aci");
                if (!acis.remove(oldAci)) continue;
                needUpdate = true;
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("AMObject.setAciForRole :" + targetDN.toString() + " read access denied." + ex);
                }
                denied = true;
            }
        }
        if (needUpdate) {
            targetObj.setAttribute("aci", acis);
            targetObj.store();
        }
    }

    void removeAdminRoleAci(boolean recursive) throws AMException, SSOException {
        String orgDN = this.getOrganizationDN();
        AMOrganizationImpl org = new AMOrganizationImpl(this.token, orgDN);
        Set aciSet = org.getAttribute("aci");
        HashSet<String> newAciSet = new HashSet<String>();
        Iterator iter = aciSet.iterator();
        DN thisDN = new DN(this.entryDN);
        while (iter.hasNext()) {
            String aci = (String)iter.next();
            int index = aci.indexOf("version 3.0;");
            if (index == -1) {
                newAciSet.add(aci);
                continue;
            }
            if ((index = aci.indexOf("roledn", index)) == -1) {
                newAciSet.add(aci);
                continue;
            }
            if ((index = aci.indexOf("ldap:///", index)) == -1) {
                newAciSet.add(aci);
                continue;
            }
            int index2 = aci.lastIndexOf("\"");
            DN roleDN = new DN(aci.substring(index + 8, index2));
            String roleName = ((RDN)roleDN.getRDNs().firstElement()).getValues()[0];
            String tmpdn = roleName.replace('_', ',');
            if (DN.isDN((String)tmpdn)) {
                DN tmpDN = new DN(tmpdn);
                if (tmpDN.equals(thisDN)) continue;
                if (tmpDN.isDescendantOf(thisDN)) {
                    if (recursive) continue;
                    newAciSet.add(aci);
                    continue;
                }
                newAciSet.add(aci);
                continue;
            }
            newAciSet.add(aci);
        }
        org.setAttribute("aci", newAciSet);
        org.store();
    }

    void unassignPolicies(String serviceName, Set policyDNs, boolean toVerify) throws AMException, SSOException {
        if (policyDNs == null || policyDNs.size() == 0) {
            return;
        }
        AMTemplate template = this.getTemplate(serviceName, 300);
        this.unassignPolicies(template, policyDNs, toVerify);
    }

    void unassignPolicies(AMTemplate template, Set policyDNs, boolean toVerify) throws AMException, SSOException {
        throw new UnsupportedOperationException();
    }

    private Map replaceMapKey(Map attributes, Set attributeNames) {
        if (attributeNames != null) {
            Iterator iter = attributeNames.iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                String attrNameLower = attrName.toLowerCase();
                if (!attributes.containsKey(attrNameLower)) continue;
                Object attrValue = attributes.get(attrNameLower);
                attributes.remove(attrNameLower);
                attributes.put(attrName, attrValue);
            }
        }
        return attributes;
    }

    private SSOToken getSSOToken() {
        return this.token;
    }

    private String setToString(Set set) {
        if (set == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            sb.append("    ").append((String)iter.next()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToProfileNameTable(SSOToken ssoToken, String dn) throws SSOException {
        Hashtable pTable;
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.addToProfileNameTable(SSOToken,dn)..");
        }
        Hashtable hashtable = pTable = profileNameTable;
        synchronized (hashtable) {
            HashSet<String> dnList = (HashSet<String>)pTable.get(ssoToken.getPrincipal().getName());
            if (dnList == null) {
                AMSSOTokenListener ssoTokenListener = new AMSSOTokenListener(ssoToken.getPrincipal().getName());
                ssoToken.addSSOTokenListener(ssoTokenListener);
                dnList = new HashSet<String>();
                pTable.put(ssoToken.getPrincipal().getName(), dnList);
            }
            dnList.add(dn);
        }
    }

    private String mapToString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String attributeName = (String)iter.next();
            if (attributeName.equalsIgnoreCase("userpassword") || attributeName.equalsIgnoreCase("encrypteduserpassword")) continue;
            Set attributeValue = (Set)map.get(attributeName);
            Iterator iter2 = attributeValue.iterator();
            while (iter2.hasNext()) {
                sb.append("    ").append(attributeName).append(": ").append((String)iter2.next()).append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyAffectedDNs(String affectedDN, AMEvent dpEvent) {
        if (debug.messageEnabled()) {
            debug.message("In AMObjectImpl.notifyAffectedDNs(..): ");
        }
        Map map = objImplListeners;
        synchronized (map) {
            Iterator mapItr = objImplListeners.entrySet().iterator();
            while (mapItr.hasNext()) {
                Map.Entry me = mapItr.next();
                if (!((String)me.getKey()).endsWith(affectedDN)) continue;
                Set objImplSet = (Set)me.getValue();
                Iterator setItr = objImplSet.iterator();
                while (setItr.hasNext()) {
                    AMObjectImpl dpObjImpl = (AMObjectImpl)setItr.next();
                    dpObjImpl.sendEvents(dpEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromProfileNameTable(SSOToken ssoToken, String dn) {
        Hashtable pTable;
        if (debug.messageEnabled()) {
            debug.message("In ProfileService.removeFromProfileNameTable(SSOToken,dn)..");
        }
        if ((pTable = profileNameTable) == null || pTable.isEmpty()) {
            return;
        }
        Hashtable hashtable = pTable;
        synchronized (hashtable) {
            String principal;
            try {
                principal = ssoToken.getPrincipal().getName();
            }
            catch (SSOException ssoe) {
                debug.error("AMObjectImpl.removeFromProfileNameTable(): Could not update PFN table");
                return;
            }
            Set dnList = (Set)pTable.get(principal);
            if (dnList != null) {
                dnList.remove(dn);
                if (dnList.isEmpty()) {
                    pTable.remove(principal);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents(AMEvent dpEvent) {
        Set set = this.listeners;
        synchronized (set) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AMEventListener listener = (AMEventListener)iterator.next();
                try {
                    switch (dpEvent.getEventType()) {
                        case 4: 
                        case 9: {
                            listener.objectChanged(dpEvent);
                            break;
                        }
                        case 2: {
                            listener.objectRemoved(dpEvent);
                            break;
                        }
                        case 8: {
                            listener.objectRenamed(dpEvent);
                            break;
                        }
                    }
                }
                catch (Throwable t) {}
            }
        }
    }

    private AMHashMap integrateLocale() throws AMException, SSOException {
        Set pL;
        Iterator it;
        if (AMCommonUtils.integrateLocale && (this.profileType == 1 || this.profileType == 301) && this.stringValueModMap.containsKey("preferredLocale")) {
            Set prefLoc = (Set)this.stringValueModMap.get("preferredLocale");
            HashSet<String> prefLang = (HashSet<String>)this.stringValueModMap.get("preferredLanguage");
            if (prefLang == null) {
                prefLang = new HashSet<String>();
            }
            it = prefLoc.iterator();
            while (it.hasNext()) {
                String prefLocVal = (String)it.next();
                String prefLangVal = prefLocVal.replace('_', '-');
                prefLang.add(prefLangVal);
            }
            if (prefLang.isEmpty()) {
                pL = this.getAttribute("preferredLanguage");
                if (pL != null && !pL.isEmpty()) {
                    this.stringValueModMap.put("preferredLanguage", prefLang);
                }
            } else {
                this.stringValueModMap.put("preferredLanguage", prefLang);
            }
        }
        if (AMCommonUtils.integrateLocale && (this.profileType == 1 || this.profileType == 301) && this.stringValueModMap.containsKey("preferredLanguage")) {
            Set prefLang = (Set)this.stringValueModMap.get("preferredLanguage");
            HashSet<String> prefLoc = (HashSet<String>)this.stringValueModMap.get("preferredLocale");
            if (prefLoc == null) {
                prefLoc = new HashSet<String>();
            }
            it = prefLang.iterator();
            while (it.hasNext()) {
                String prefLangVal = (String)it.next();
                String prefLocVal = prefLangVal.replace('-', '_');
                prefLoc.add(prefLocVal);
            }
            if (prefLoc.isEmpty()) {
                pL = this.getAttribute("preferredLocale");
                if (pL != null && !pL.isEmpty()) {
                    this.stringValueModMap.put("preferredLocale", prefLoc);
                }
            } else {
                this.stringValueModMap.put("preferredLocale", prefLoc);
            }
        }
        return this.stringValueModMap;
    }

    private Map integrateLocaleForTemplateCreation(Map attributes) {
        if (AMCommonUtils.integrateLocale) {
            AMHashMap sdkMap = new AMHashMap();
            sdkMap.copy(attributes);
            if (sdkMap.containsKey("preferredLocale")) {
                Set pLoc = (Set)sdkMap.get("preferredLocale");
                HashSet<String> pLang = new HashSet<String>();
                Iterator it = pLoc.iterator();
                while (it.hasNext()) {
                    String prefLangVal = (String)it.next();
                    String prefLocVal = prefLangVal.replace('_', '-');
                    pLang.add(prefLocVal);
                }
                sdkMap.put("preferredLanguage", pLang);
            } else if (sdkMap.containsKey("preferredLanguage")) {
                Set pLang = (Set)sdkMap.get("preferredLanguage");
                HashSet<String> pLoc = new HashSet<String>();
                Iterator it = pLang.iterator();
                while (it.hasNext()) {
                    String prefLangVal = (String)it.next();
                    String prefLocVal = prefLangVal.replace('-', '_');
                    pLoc.add(prefLocVal);
                }
                sdkMap.put("preferredLocale", pLoc);
            }
            attributes.clear();
            attributes.putAll(sdkMap);
        }
        return attributes;
    }
}

