/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClusterStateService
extends GeneralTaskRunnable {
    private Map servers = new HashMap();
    private Set downServers = new HashSet();
    private ServerInfo[] serverSelectionList = new ServerInfo[0];
    private int lastSelected = -1;
    public static final int DEFAULT_TIMEOUT = 1000;
    private int timeout = 1000;
    public static final long DEFAULT_PERIOD = 1000L;
    private long period = 1000L;
    private String localServerId = null;
    private SessionService ss = null;

    public ClusterStateService(SessionService ss, String localServerId, int timeout, long period, Map members) throws Exception {
        this.ss = ss;
        this.localServerId = localServerId;
        this.timeout = timeout;
        this.period = period;
        this.serverSelectionList = new ServerInfo[members.size()];
        Iterator m = members.entrySet().iterator();
        while (m.hasNext()) {
            ServerInfo info = new ServerInfo();
            Map.Entry entry = m.next();
            info.id = (String)entry.getKey();
            URL url = new URL((String)entry.getValue());
            info.address = new InetSocketAddress(url.getHost(), url.getPort());
            info.isUp = this.checkServerUp(info);
            if (!info.isUp) {
                this.downServers.add(info.id);
            }
            this.servers.put(info.id, info);
            this.serverSelectionList[this.getNextSelected()] = info;
        }
        Arrays.sort(this.serverSelectionList);
        SystemTimer.getTimer().schedule((TaskRunnable)this, new Date(System.currentTimeMillis() / 1000L * 1000L));
    }

    private int getNextSelected() {
        this.lastSelected = (this.lastSelected + 1) % this.serverSelectionList.length;
        return this.lastSelected;
    }

    boolean isUp(String serverId) {
        return ((ServerInfo)this.servers.get((Object)serverId)).isUp;
    }

    boolean checkServerUp(String serverId) {
        ServerInfo info = (ServerInfo)this.servers.get(serverId);
        info.isUp = this.checkServerUp(info);
        return info.isUp;
    }

    int getServerSelectionListSize() {
        return this.serverSelectionList.length;
    }

    String getServerSelection(int index) {
        return this.serverSelectionList[index].id;
    }

    public long getRunPeriod() {
        return this.period;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            boolean cleanRemoteSessions = false;
            Map map = this.servers;
            synchronized (map) {
                Iterator i = this.servers.values().iterator();
                while (i.hasNext()) {
                    ServerInfo info = (ServerInfo)i.next();
                    info.isUp = this.checkServerUp(info);
                    if (!info.isUp) {
                        this.downServers.add(info.id);
                        continue;
                    }
                    if (this.downServers.isEmpty() || !this.downServers.remove(info.id)) continue;
                    cleanRemoteSessions = true;
                }
            }
            if (cleanRemoteSessions) {
                this.ss.cleanUpRemoteSessions();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServerUp(ServerInfo info) {
        if (this.localServerId.equals(info.id)) {
            return true;
        }
        boolean result = false;
        Socket sock = new Socket();
        try {
            sock.connect(info.address, this.timeout);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    private class ServerInfo
    implements Comparable {
        String id;
        InetSocketAddress address;
        boolean isUp;

        private ServerInfo() {
        }

        public int compareTo(Object o) {
            return this.id.compareTo(((ServerInfo)o).id);
        }
    }
}

