/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.QuotaExhaustionAction;
import com.iplanet.dpro.session.service.SessionCount;
import com.iplanet.dpro.session.service.SessionService;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionConstraint {
    public static final int DESTROY_OLD_SESSION = 1;
    public static final int DENY_ACCESS = 2;
    private static final int DEFAULT_QUOTA = Integer.MAX_VALUE;
    private static final String AM_SESSION_SERVICE = "iPlanetAMSessionService";
    private static final String SESSION_QUOTA_ATTR_NAME = "iplanet-am-session-quota-limit";
    private static Debug debug = SessionService.sessionDebug;
    private static QuotaExhaustionAction quotaExhaustionAction = null;

    static SessionService getSS() {
        return SessionCount.getSS();
    }

    protected static boolean checkQuotaAndPerformAction(InternalSession is) {
        boolean reject = false;
        int sessionCount = -1;
        if (SessionCount.getDeploymentMode() == 2) {
            return false;
        }
        if (is.getIsSessionUpgrade()) {
            SessionCount.incrementSessionCount(is);
            return false;
        }
        int quota = SessionConstraint.getSessionQuota(is);
        Map sessions = null;
        try {
            sessions = SessionCount.getAllSessionsByUUID(is.getUUID());
        }
        catch (Exception e) {
            SessionConstraint.getSS();
            if (SessionService.denyLoginIfDBIsDown()) {
                if (debug.messageEnabled()) {
                    debug.message("SessionConstraint.checkQuotaAndPerformAction: denyLoginIfDBIsDown=true => The session repository is down and the login request will be rejected. ");
                }
                return true;
            }
            if (debug.messageEnabled()) {
                debug.message("SessionConstraint.checkQuotaAndPerformAction: denyLoginIfDBIsDown=false => The session repository is down and there will be no constraint checking.");
            }
            return false;
        }
        if (sessions != null) {
            sessionCount = sessions.size();
        }
        if (sessionCount >= quota) {
            reject = quotaExhaustionAction.action(is, sessions);
            if (debug.messageEnabled()) {
                debug.message("SessionConstraint.checkQuotaAndPerformAction: Session quota exhausted.");
            }
        } else {
            SessionCount.incrementSessionCount(is);
        }
        return reject;
    }

    private static int getSessionQuota(InternalSession is) {
        int quota;
        block3: {
            quota = SessionConstraint.getDefaultSessionQuota();
            try {
                AMIdentity iden = IdUtils.getIdentity(SessionCount.getAdminToken(), is.getUUID());
                Map serviceAttrs = iden.getServiceAttributesAscending(AM_SESSION_SERVICE);
                Set s = (Set)serviceAttrs.get(SESSION_QUOTA_ATTR_NAME);
                Iterator attrs = s.iterator();
                if (attrs.hasNext()) {
                    String attr = (String)attrs.next();
                    quota = Integer.valueOf(attr);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("Failed to get the session quota via the IDRepo interfaces, => Use the default value from the dynamic schema instead.", (Throwable)e);
            }
        }
        return quota;
    }

    private static int getDefaultSessionQuota() {
        int quota;
        block2: {
            quota = Integer.MAX_VALUE;
            try {
                ServiceSchemaManager ssm = new ServiceSchemaManager(AM_SESSION_SERVICE, SessionCount.getAdminToken());
                ServiceSchema schema = ssm.getDynamicSchema();
                Map attrs = schema.getAttributeDefaults();
                quota = CollectionHelper.getIntMapAttr((Map)attrs, (String)SESSION_QUOTA_ATTR_NAME, (String)String.valueOf(Integer.MAX_VALUE), (Debug)debug);
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Failed to get the default session quota setting. => Set user session quota to Integer.MAX_VALUE.", (Throwable)e);
            }
        }
        return quota;
    }

    static {
        SessionConstraint.getSS();
        quotaExhaustionAction = SessionService.getConstraintResultingBehavior() == 2 ? new DenyAccessAction() : new DestroyNextExpiringSessionAction();
    }

    private static class DestroyNextExpiringSessionAction
    implements QuotaExhaustionAction {
        private DestroyNextExpiringSessionAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean action(InternalSession is, Map sessions) {
            String nextExpiringSessionID = null;
            long smallestExpTime = Long.MAX_VALUE;
            Set sids = sessions.keySet();
            Map map = sessions;
            synchronized (map) {
                Iterator m = sids.iterator();
                while (m.hasNext()) {
                    String sid = (String)m.next();
                    long expirationTime = (Long)sessions.get(sid);
                    if (expirationTime >= smallestExpTime) continue;
                    smallestExpTime = expirationTime;
                    nextExpiringSessionID = sid;
                }
            }
            if (nextExpiringSessionID != null) {
                SessionID sessID = new SessionID(nextExpiringSessionID);
                try {
                    Session s = Session.getSession(sessID);
                    s.destroySession(s);
                }
                catch (SessionException e) {
                    if (debug.messageEnabled()) {
                        debug.message("Failed to destroy the next expiring session.", (Throwable)((Object)e));
                    }
                    return true;
                }
            }
            SessionCount.incrementSessionCount(is);
            return false;
        }
    }

    private static class DenyAccessAction
    implements QuotaExhaustionAction {
        private DenyAccessAction() {
        }

        public boolean action(InternalSession is, Map sessions) {
            return true;
        }
    }
}

