/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.services.util.I18n;
import com.iplanet.services.util.XMLException;
import com.sun.identity.shared.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    protected static I18n i18n = I18n.getInstance("amSDK");
    private static DocumentBuilderFactory dbFactory = null;
    private static String ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
    private static String VALUE_NODE = "Value";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document toDOMDocument(String xmlString, Debug debug) {
        try {
            if (dbFactory == null) {
                Class clazz = XMLUtils.class;
                synchronized (clazz) {
                    block16: {
                        if (dbFactory == null) {
                            try {
                                dbFactory = DocumentBuilderFactory.newInstance();
                                dbFactory.setValidating(false);
                                dbFactory.setNamespaceAware(true);
                            }
                            catch (Exception e) {
                                if (debug == null) break block16;
                                debug.error("XMLUtils.DocumentBuilder init failed", (Throwable)e);
                            }
                        }
                    }
                }
            }
            if (xmlString == null) {
                return null;
            }
            DocumentBuilder documentBuilder = null;
            DocumentBuilderFactory e = dbFactory;
            synchronized (e) {
                documentBuilder = dbFactory.newDocumentBuilder();
            }
            if (documentBuilder == null) {
                if (debug != null) {
                    debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            return documentBuilder.parse(is);
        }
        catch (Exception e) {
            if (debug != null && debug.warningEnabled()) {
                debug.warning("Can't parse the XML document:\n" + xmlString, (Throwable)e);
            }
            return null;
        }
    }

    public static Document getXMLDocument(String inputStr) throws XMLException, UnsupportedEncodingException {
        int idx = inputStr.indexOf("encoding=");
        String encoding = "UTF-8";
        if (idx != -1) {
            int idx2;
            int idx1 = inputStr.indexOf(34, idx);
            int n = idx2 = idx1 == -1 ? idx1 : inputStr.indexOf(34, idx1 + 1);
            if (idx1 != -1 && idx2 != -1) {
                encoding = inputStr.substring(idx1 + 1, idx2);
            }
        }
        byte[] barr = inputStr.getBytes(encoding);
        return XMLUtils.getXMLDocument(new ByteArrayInputStream(barr));
    }

    public static Document getXMLDocument(InputStream in) throws XMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(in);
            return doc;
        }
        catch (SAXParseException pe) {
            String msg = "\n" + pe.getMessage() + "\n";
            Object[] params = new Object[]{new Integer(pe.getLineNumber())};
            throw new XMLException(msg + i18n.getString("XMLUtils.parser_error", params));
        }
        catch (SAXException sax) {
            Object[] params = new Object[]{new String(sax.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.exception_message", params));
        }
        catch (ParserConfigurationException pc) {
            Object[] params = new Object[]{new String(pc.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.invalid_xml_document", params));
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{new String(ioe.getMessage())};
            throw new XMLException(i18n.getString("XMLUtils.invalid_input_stream", params));
        }
    }

    public static Node getRootNode(Document doc, String nodeName) {
        NodeList nodes = doc.getElementsByTagName(nodeName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return nodes.item(0);
    }

    public static Node getChildNode(Node parentNode, String childName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            return node;
        }
        return null;
    }

    public static Node getNamedChildNode(Node parentNode, String childNodeName, String attrName, String attrValue) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!childNodeName.equalsIgnoreCase(node.getNodeName()) || !XMLUtils.getNodeAttributeValue(node, attrName).equalsIgnoreCase(attrValue)) continue;
            return node;
        }
        return null;
    }

    public static Set getChildNodes(Node parentNode, String childName) {
        HashSet<Node> retVal = new HashSet<Node>();
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!node.getNodeName().equalsIgnoreCase(childName)) continue;
            retVal.add(node);
        }
        return retVal;
    }

    public static String getNodeAttributeValue(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        Node value = attrs.getNamedItem(attrName);
        if (value == null) {
            return null;
        }
        return value.getNodeValue();
    }

    public static Set getAttributeValuePair(Node node) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!n.getNodeName().equalsIgnoreCase(VALUE_NODE)) continue;
            retVal.add(XMLUtils.getValueOfValueNode(n));
        }
        return retVal;
    }

    public static String getValueOfValueNode(Node n) {
        NodeList textNodes = n.getChildNodes();
        StringBuffer value = new StringBuffer("");
        for (int j = 0; j < textNodes.getLength(); ++j) {
            Node textNode = textNodes.item(j);
            value.append(textNode.getNodeValue());
        }
        return value.toString().trim();
    }

    public static String escapeSpecialCharacters(String text) {
        char c;
        int i;
        String escapedText = text;
        StringBuffer sb = null;
        int len = 0;
        if (text != null) {
            len = text.length();
        }
        boolean specialCharacterFound = false;
        for (i = 0; i < len; ++i) {
            c = text.charAt(i);
            if (c != '&' && c != '<' && c != '>' && c != '\'' && c != '\"' && c != '\n') continue;
            specialCharacterFound = true;
            break;
        }
        if (specialCharacterFound) {
            sb = new StringBuffer();
            sb.append(text.substring(0, i));
            while (i < len) {
                c = text.charAt(i);
                switch (c) {
                    case '&': {
                        sb.append("&amp;");
                        break;
                    }
                    case '<': {
                        sb.append("&lt;");
                        break;
                    }
                    case '>': {
                        sb.append("&gt;");
                        break;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        break;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        break;
                    }
                    case '\n': {
                        sb.append("&#xD;");
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            escapedText = sb.toString();
        }
        return escapedText;
    }
}

