/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.User;
import java.security.Principal;
import netscape.ldap.util.DN;

public class PeopleContainer
extends PersistentObject {
    private static final Class _class = PeopleContainer.class;
    private static final String MAX_USER_ATTR_NAME = "nsMaxUsers";
    private static final String MAX_PEOPLECONTAINER_ATTR_NAME = "nsMaxPeopleContainers";
    private static final String BASIC_USER_SEARCH = "BasicUserSearch";
    private static final String BASIC_PEOPLECONTAINER_SEARCH = "BasicPeopleContainerSearch";
    static final String MULTIPLE_PEOPLE_CONTAINERS_SUPPORT = "MultiplePeopleContainersSupport";

    protected PeopleContainer() throws UMSException {
    }

    PeopleContainer(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    PeopleContainer(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public PeopleContainer(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void addUser(User user) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        super.addChild(user);
    }

    public void addChildPeopleContainer(PeopleContainer pc) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        super.addChild(pc);
    }

    public void removeUser(User user) throws AccessRightsException, UMSException {
        super.removeChild(user);
    }

    public void removeChildPeopleContainer(PeopleContainer pc) throws AccessRightsException, EntryNotFoundException, UMSException {
        super.removeChild(pc);
    }

    public long getUserCount() throws UMSException {
        SearchTemplate template = TemplateManager.getTemplateManager().getSearchTemplate(BASIC_USER_SEARCH, this.getParentGuid());
        SearchResults results = this.getChildren(template, null);
        long count = 0L;
        while (results.hasMoreElements()) {
            results.next();
            ++count;
        }
        return count;
    }

    public long getChildPeopleContainerCount() throws UMSException {
        SearchTemplate template = TemplateManager.getTemplateManager().getSearchTemplate(BASIC_PEOPLECONTAINER_SEARCH, this.getParentGuid());
        SearchResults results = this.getChildren(template, null);
        long count = 0L;
        while (results.hasMoreElements()) {
            results.next();
            ++count;
        }
        return count;
    }

    public void setMaxUserLimit(long limit) throws UMSException {
        String value = new Long(limit).toString();
        this.setAttribute(new Attr(MAX_USER_ATTR_NAME, value));
    }

    public void setMaxChildPeopleContainerLimit(long limit) throws UMSException {
        String value = new Long(limit).toString();
        this.setAttribute(new Attr(MAX_PEOPLECONTAINER_ATTR_NAME, value));
    }

    public long getMaxUserLimit() throws UMSException {
        String value = this.getAttribute(MAX_USER_ATTR_NAME).getValue();
        return new Long(value);
    }

    public long getMaxChildPeopleContainerLimit() throws UMSException {
        String value = this.getAttribute(MAX_PEOPLECONTAINER_ATTR_NAME).getValue();
        return new Long(value);
    }

    public boolean isMember(User user) throws UMSException {
        DN userdn = new DN(user.getDN());
        DN pcdn = new DN(this.getDN());
        return userdn.getParent().equals(pcdn);
    }

    public String getName() throws UMSException {
        return this.getAttribute(this.getNamingAttribute()).getValue();
    }
}

